/* This file is automatically generated by mkskel-sh - do not edit */

#include "config.h"

static char const TreeCCSkel_c_skel_c[] =
"/*\n"
" * treecc node allocation routines for C.\n"
" *\n"
" * Copyright (C) 2001  Southern Storm Software, Pty Ltd.\n"
" *\n"
" * This program is free software; you can redistribute it and/or modify\n"
" * it under the terms of the GNU General Public License as published by\n"
" * the Free Software Foundation; either version 2 of the License, or\n"
" * (at your option) any later version.\n"
" *\n"
" * This program is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
" * GNU General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU General Public License\n"
" * along with this program; if not, write to the Free Software\n"
" * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n"
" *\n"
" * As a special exception, when this file is copied by treecc into\n"
" * a treecc output file, you may use that output file without restriction.\n"
" */\n"
"\n"
"#include <stdlib.h>\n"
"\n"
"#ifndef YYNODESTATE_BLKSIZ\n"
"#define	YYNODESTATE_BLKSIZ	2048\n"
"#endif\n"
"\n"
"/*\n"
" * Types used by the allocation routines.\n"
" */\n"
"struct YYNODESTATE_block\n"
"{\n"
"	char data__[YYNODESTATE_BLKSIZ];\n"
"	struct YYNODESTATE_block *next__;\n"
"\n"
"};\n"
"struct YYNODESTATE_push\n"
"{\n"
"	struct YYNODESTATE_push *next__;\n"
"	struct YYNODESTATE_block *saved_block__;\n"
"	int saved_used__;\n"
"};\n"
"\n"
"/*\n"
" * The fixed global state to use for non-reentrant allocation.\n"
" */\n"
"#ifndef YYNODESTATE_REENTRANT\n"
"static YYNODESTATE fixed_state__;\n"
"#endif\n"
"\n"
"/*\n"
" * Some macro magic to determine the default alignment\n"
" * on this machine.  This will compile down to a constant.\n"
" */\n"
"#define	YYNODESTATE_ALIGN_CHECK_TYPE(type,name)	\\\n"
"	struct _YYNODESTATE_align_##name { \\\n"
"		char pad; \\\n"
"		type field; \\\n"
"	}\n"
"#define	YYNODESTATE_ALIGN_FOR_TYPE(type)	\\\n"
"	((unsigned)(&(((struct _YYNODESTATE_align_##type *)0)->field)))\n"
"#define	YYNODESTATE_ALIGN_MAX(a,b)	\\\n"
"	((a) > (b) ? (a) : (b))\n"
"#define	YYNODESTATE_ALIGN_MAX3(a,b,c) \\\n"
"	(YYNODESTATE_ALIGN_MAX((a), YYNODESTATE_ALIGN_MAX((b), (c))))\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(int, int);\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(long, long);\n"
"#if defined(WIN32) && !defined(__CYGWIN__)\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(__int64, long_long);\n"
"#else\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(long long, long_long);\n"
"#endif\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(void *, void_p);\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(float, float);\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(double, double);\n"
"#define	YYNODESTATE_ALIGNMENT	\\\n"
"	YYNODESTATE_ALIGN_MAX( \\\n"
"			YYNODESTATE_ALIGN_MAX3	\\\n"
"			(YYNODESTATE_ALIGN_FOR_TYPE(int), \\\n"
"		     YYNODESTATE_ALIGN_FOR_TYPE(long), \\\n"
"			 YYNODESTATE_ALIGN_FOR_TYPE(long_long)), \\\n"
"  	     YYNODESTATE_ALIGN_MAX3 \\\n"
"		 	(YYNODESTATE_ALIGN_FOR_TYPE(void_p), \\\n"
"			 YYNODESTATE_ALIGN_FOR_TYPE(float), \\\n"
"			 YYNODESTATE_ALIGN_FOR_TYPE(double)))\n"
"\n"
"/*\n"
" * Initialize the node allocation pool.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void yynodeinit(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"void yynodeinit()\n"
"{\n"
"	YYNODESTATE *state__ = &fixed_state__;\n"
"#endif\n"
"	state__->blocks__ = 0;\n"
"	state__->push_stack__ = 0;\n"
"	state__->used__ = 0;\n"
"}\n"
"\n"
"/*\n"
" * Allocate a block of memory.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void *yynodealloc(state__, size__)\n"
"YYNODESTATE *state__;\n"
"unsigned int size__;\n"
"{\n"
"#else\n"
"void *yynodealloc(size__)\n"
"unsigned int size__;\n"
"{\n"
"	YYNODESTATE *state__ = &fixed_state__;\n"
"#endif\n"
"	struct YYNODESTATE_block *block__;\n"
"	void *result__;\n"
"\n"
"	/* Round the size to the next alignment boundary */\n"
"	size__ = (size__ + YYNODESTATE_ALIGNMENT - 1) &\n"
"				~(YYNODESTATE_ALIGNMENT - 1);\n"
"\n"
"	/* Do we need to allocate a new block? */\n"
"	block__ = state__->blocks__;\n"
"	if(!block__ || (state__->used__ + size__) > YYNODESTATE_BLKSIZ)\n"
"	{\n"
"		if(size__ > YYNODESTATE_BLKSIZ)\n"
"		{\n"
"			/* The allocation is too big for the node pool */\n"
"			return (void *)0;\n"
"		}\n"
"		block__ = (struct YYNODESTATE_block *)\n"
"						malloc(sizeof(struct YYNODESTATE_block));\n"
"		if(!block__)\n"
"		{\n"
"			/* The system is out of memory.  The programmer can\n"
"			   supply the \"yynodefailed\" function to report the\n"
"			   out of memory state and/or abort the program */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"			yynodefailed(state__);\n"
"#else\n"
"			yynodefailed();\n"
"#endif\n"
"			return (void *)0;\n"
"		}\n"
"		block__->next__ = state__->blocks__;\n"
"		state__->blocks__ = block__;\n"
"		state__->used__ = 0;\n"
"	}\n"
"\n"
"	/* Allocate the memory and return it */\n"
"	result__ = (void *)(block__->data__ + state__->used__);\n"
"	state__->used__ += size__;\n"
"	return result__;\n"
"}\n"
"\n"
"/*\n"
" * Push the node allocation state.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"int yynodepush(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"int yynodepush()\n"
"{\n"
"	YYNODESTATE *state__ = &fixed_state__;\n"
"#endif\n"
"	struct YYNODESTATE_block *saved_block__;\n"
"	int saved_used__;\n"
"	struct YYNODESTATE_push *push_item__;\n"
"\n"
"	/* Save the current state of the node allocation pool */\n"
"	saved_block__ = state__->blocks__;\n"
"	saved_used__ = state__->used__;\n"
"\n"
"	/* Allocate space for a push item */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"	push_item__ = (struct YYNODESTATE_push *)\n"
"			yynodealloc(state__, sizeof(struct YYNODESTATE_push));\n"
"#else\n"
"	push_item__ = (struct YYNODESTATE_push *)\n"
"			yynodealloc(sizeof(struct YYNODESTATE_push));\n"
"#endif\n"
"	if(!push_item__)\n"
"	{\n"
"		return 0;\n"
"	}\n"
"\n"
"	/* Copy the saved information to the push item */\n"
"	push_item__->saved_block__ = saved_block__;\n"
"	push_item__->saved_used__ = saved_used__;\n"
"\n"
"	/* Add the push item to the push stack */\n"
"	push_item__->next__ = state__->push_stack__;\n"
"	state__->push_stack__ = push_item__;\n"
"	return 1;\n"
"}\n"
"\n"
"/*\n"
" * Pop the node allocation state.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void yynodepop(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"void yynodepop()\n"
"{\n"
"	YYNODESTATE *state__ = &fixed_state__;\n"
"#endif\n"
"	struct YYNODESTATE_push *push_item__;\n"
"	struct YYNODESTATE_block *saved_block__;\n"
"	struct YYNODESTATE_block *temp_block__;\n"
"\n"
"	/* Pop the top of the push stack */\n"
"	push_item__ = state__->push_stack__;\n"
"	if(push_item__ == 0)\n"
"	{\n"
"		saved_block__ = 0;\n"
"		state__->used__ = 0;\n"
"	}\n"
"	else\n"
"	{\n"
"		saved_block__ = push_item__->saved_block__;\n"
"		state__->used__ = push_item__->saved_used__;\n"
"		state__->push_stack__ = push_item__->next__;\n"
"	}\n"
"\n"
"	/* Free unnecessary blocks */\n"
"	while(state__->blocks__ != saved_block__)\n"
"	{\n"
"		temp_block__ = state__->blocks__;\n"
"		state__->blocks__ = temp_block__->next__;\n"
"		free(temp_block__);\n"
"	}\n"
"}\n"
"\n"
"/*\n"
" * Clear the node allocation pool completely.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void yynodeclear(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"void yynodeclear()\n"
"{\n"
"	YYNODESTATE *state__ = &fixed_state__;\n"
"#endif\n"
"	struct YYNODESTATE_block *temp_block__;\n"
"	while(state__->blocks__ != 0)\n"
"	{\n"
"		temp_block__ = state__->blocks__;\n"
"		state__->blocks__ = temp_block__->next__;\n"
"		free(temp_block__);\n"
"	}\n"
"	state__->push_stack__ = 0;\n"
"	state__->used__ = 0;\n"
"}\n"
;
static char const TreeCCSkel_c_skel_h[] =
"typedef struct\n"
"{\n"
"	struct YYNODESTATE_block *blocks__;\n"
"	struct YYNODESTATE_push *push_stack__;\n"
"	int used__;\n"
"\n"
"} YYNODESTATE;\n"
;
static char const TreeCCSkel_cpp_skel_cc[] =
"/*\n"
" * treecc node allocation routines for C++.\n"
" *\n"
" * Copyright (C) 2001  Southern Storm Software, Pty Ltd.\n"
" *\n"
" * This program is free software; you can redistribute it and/or modify\n"
" * it under the terms of the GNU General Public License as published by\n"
" * the Free Software Foundation; either version 2 of the License, or\n"
" * (at your option) any later version.\n"
" *\n"
" * This program is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
" * GNU General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU General Public License\n"
" * along with this program; if not, write to the Free Software\n"
" * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n"
" *\n"
" * As a special exception, when this file is copied by treecc into\n"
" * a treecc output file, you may use that output file without restriction.\n"
" */\n"
"\n"
"#ifndef YYNODESTATE_BLKSIZ\n"
"#define	YYNODESTATE_BLKSIZ	2048\n"
"#endif\n"
"\n"
"/*\n"
" * Types used by the allocation routines.\n"
" */\n"
"struct YYNODESTATE_block\n"
"{\n"
"	char data__[YYNODESTATE_BLKSIZ];\n"
"	struct YYNODESTATE_block *next__;\n"
"\n"
"};\n"
"struct YYNODESTATE_push\n"
"{\n"
"	struct YYNODESTATE_push *next__;\n"
"	struct YYNODESTATE_block *saved_block__;\n"
"	int saved_used__;\n"
"};\n"
"\n"
"/*\n"
" * Initialize the singleton instance.\n"
" */\n"
"#ifndef YYNODESTATE_REENTRANT\n"
"YYNODESTATE *YYNODESTATE::state__ = 0;\n"
"#endif\n"
"\n"
"/*\n"
" * Some macro magic to determine the default alignment\n"
" * on this machine.  This will compile down to a constant.\n"
" */\n"
"#define	YYNODESTATE_ALIGN_CHECK_TYPE(type,name)	\\\n"
"	struct _YYNODESTATE_align_##name { \\\n"
"		char pad; \\\n"
"		type field; \\\n"
"	}\n"
"#define	YYNODESTATE_ALIGN_FOR_TYPE(type)	\\\n"
"	((unsigned)(&(((struct _YYNODESTATE_align_##type *)0)->field)))\n"
"#define	YYNODESTATE_ALIGN_MAX(a,b)	\\\n"
"	((a) > (b) ? (a) : (b))\n"
"#define	YYNODESTATE_ALIGN_MAX3(a,b,c) \\\n"
"	(YYNODESTATE_ALIGN_MAX((a), YYNODESTATE_ALIGN_MAX((b), (c))))\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(int, int);\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(long, long);\n"
"#if defined(WIN32) && !defined(__CYGWIN__)\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(__int64, long_long);\n"
"#else\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(long long, long_long);\n"
"#endif\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(void *, void_p);\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(float, float);\n"
"YYNODESTATE_ALIGN_CHECK_TYPE(double, double);\n"
"#define	YYNODESTATE_ALIGNMENT	\\\n"
"	YYNODESTATE_ALIGN_MAX( \\\n"
"			YYNODESTATE_ALIGN_MAX3	\\\n"
"			(YYNODESTATE_ALIGN_FOR_TYPE(int), \\\n"
"		     YYNODESTATE_ALIGN_FOR_TYPE(long), \\\n"
"			 YYNODESTATE_ALIGN_FOR_TYPE(long_long)), \\\n"
"  	     YYNODESTATE_ALIGN_MAX3 \\\n"
"		 	(YYNODESTATE_ALIGN_FOR_TYPE(void_p), \\\n"
"			 YYNODESTATE_ALIGN_FOR_TYPE(float), \\\n"
"			 YYNODESTATE_ALIGN_FOR_TYPE(double)))\n"
"\n"
"/*\n"
" * Constructor for YYNODESTATE.\n"
" */\n"
"YYNODESTATE::YYNODESTATE()\n"
"{\n"
"	/* Initialize the allocation state */\n"
"	blocks__ = 0;\n"
"	push_stack__ = 0;\n"
"	used__ = 0;\n"
"\n"
"#ifndef YYNODESTATE_REENTRANT\n"
"	/* Register this object as the singleton instance */\n"
"	if(!state__)\n"
"	{\n"
"		state__ = this;\n"
"	}\n"
"#endif\n"
"}\n"
"\n"
"/*\n"
" * Destructor for YYNODESTATE.\n"
" */\n"
"YYNODESTATE::~YYNODESTATE()\n"
"{\n"
"	/* Free all node memory */\n"
"	clear();\n"
"\n"
"#ifndef YYNODESTATE_REENTRANT\n"
"	/* We are no longer the singleton instance */\n"
"	if(state__ == this)\n"
"	{\n"
"		state__ = 0;\n"
"	}\n"
"#endif\n"
"}\n"
"\n"
"#ifdef YYNODESTATE_USE_ALLOCATOR\n"
"\n"
"/*\n"
" * Allocate a block of memory.\n"
" */\n"
"void *YYNODESTATE::alloc(size_t size__)\n"
"{\n"
"	struct YYNODESTATE_block *block__;\n"
"	void *result__;\n"
"\n"
"	/* Round the size to the next alignment boundary */\n"
"	size__ = (size__ + YYNODESTATE_ALIGNMENT - 1) &\n"
"				~(YYNODESTATE_ALIGNMENT - 1);\n"
"\n"
"	/* Do we need to allocate a new block? */\n"
"	block__ = blocks__;\n"
"	if(!block__ || (used__ + size__) > YYNODESTATE_BLKSIZ)\n"
"	{\n"
"		if(size__ > YYNODESTATE_BLKSIZ)\n"
"		{\n"
"			/* The allocation is too big for the node pool */\n"
"			return (void *)0;\n"
"		}\n"
"		block__ = new YYNODESTATE_block;\n"
"		if(!block__)\n"
"		{\n"
"			/* The system is out of memory.  The programmer can\n"
"			   inherit the \"failed\" method to report the\n"
"			   out of memory state and/or abort the program */\n"
"			failed();\n"
"			return (void *)0;\n"
"		}\n"
"		block__->next__ = blocks__;\n"
"		blocks__ = block__;\n"
"		used__ = 0;\n"
"	}\n"
"\n"
"	/* Allocate the memory and return it */\n"
"	result__ = (void *)(block__->data__ + used__);\n"
"	used__ += size__;\n"
"	return result__;\n"
"}\n"
"\n"
"/*\n"
" * Deallocate a block of memory.\n"
" */\n"
"void YYNODESTATE::dealloc(void *ptr__, size_t size__)\n"
"{\n"
"	/* Nothing to do for this type of node allocator */\n"
"}\n"
"\n"
"/*\n"
" * Push the node allocation state.\n"
" */\n"
"int YYNODESTATE::push()\n"
"{\n"
"	struct YYNODESTATE_block *saved_block__;\n"
"	int saved_used__;\n"
"	struct YYNODESTATE_push *push_item__;\n"
"\n"
"	/* Save the current state of the node allocation pool */\n"
"	saved_block__ = blocks__;\n"
"	saved_used__ = used__;\n"
"\n"
"	/* Allocate space for a push item */\n"
"	push_item__ = (struct YYNODESTATE_push *)\n"
"			alloc(sizeof(struct YYNODESTATE_push));\n"
"	if(!push_item__)\n"
"	{\n"
"		return 0;\n"
"	}\n"
"\n"
"	/* Copy the saved information to the push item */\n"
"	push_item__->saved_block__ = saved_block__;\n"
"	push_item__->saved_used__ = saved_used__;\n"
"\n"
"	/* Add the push item to the push stack */\n"
"	push_item__->next__ = push_stack__;\n"
"	push_stack__ = push_item__;\n"
"	return 1;\n"
"}\n"
"\n"
"/*\n"
" * Pop the node allocation state.\n"
" */\n"
"void YYNODESTATE::pop()\n"
"{\n"
"	struct YYNODESTATE_push *push_item__;\n"
"	struct YYNODESTATE_block *saved_block__;\n"
"	struct YYNODESTATE_block *temp_block__;\n"
"\n"
"	/* Pop the top of the push stack */\n"
"	push_item__ = push_stack__;\n"
"	if(push_item__ == 0)\n"
"	{\n"
"		saved_block__ = 0;\n"
"		used__ = 0;\n"
"	}\n"
"	else\n"
"	{\n"
"		saved_block__ = push_item__->saved_block__;\n"
"		used__ = push_item__->saved_used__;\n"
"		push_stack__ = push_item__->next__;\n"
"	}\n"
"\n"
"	/* Free unnecessary blocks */\n"
"	while(blocks__ != saved_block__)\n"
"	{\n"
"		temp_block__ = blocks__;\n"
"		blocks__ = temp_block__->next__;\n"
"		delete temp_block__;\n"
"	}\n"
"}\n"
"\n"
"/*\n"
" * Clear the node allocation pool completely.\n"
" */\n"
"void YYNODESTATE::clear()\n"
"{\n"
"	struct YYNODESTATE_block *temp_block__;\n"
"	while(blocks__ != 0)\n"
"	{\n"
"		temp_block__ = blocks__;\n"
"		blocks__ = temp_block__->next__;\n"
"		delete temp_block__;\n"
"	}\n"
"	push_stack__ = 0;\n"
"	used__ = 0;\n"
"}\n"
"\n"
"#endif /* YYNODESTATE_USE_ALLOCATOR */\n"
"\n"
"/*\n"
" * Default implementation of functions which may be overridden.\n"
" */\n"
"void YYNODESTATE::failed()\n"
"{\n"
"}\n"
"\n"
"#ifdef YYNODESTATE_TRACK_LINES\n"
"\n"
"char *YYNODESTATE::currFilename()\n"
"{\n"
"	return (char *)0;\n"
"}\n"
"\n"
"long YYNODESTATE::currLinenum()\n"
"{\n"
"	return 0;\n"
"}\n"
"\n"
"#endif\n"
;
static char const TreeCCSkel_cpp_skel_h[] =
"private:\n"
"\n"
"	struct YYNODESTATE_block *blocks__;\n"
"	struct YYNODESTATE_push *push_stack__;\n"
"	int used__;\n"
;
static char const TreeCCSkel_c_gc_skel_h[] =
"typedef struct\n"
"{\n"
"	int dummy__;\n"
"\n"
"} YYNODESTATE;\n"
;
static char const TreeCCSkel_c_gc_skel_c[] =
"/*\n"
" * treecc node allocation routines for C.\n"
" *\n"
" * Copyright (C) 2003  Southern Storm Software, Pty Ltd.\n"
" *\n"
" * This program is free software; you can redistribute it and/or modify\n"
" * it under the terms of the GNU General Public License as published by\n"
" * the Free Software Foundation; either version 2 of the License, or\n"
" * (at your option) any later version.\n"
" *\n"
" * This program is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
" * GNU General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU General Public License\n"
" * along with this program; if not, write to the Free Software\n"
" * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n"
" *\n"
" * As a special exception, when this file is copied by treecc into\n"
" * a treecc output file, you may use that output file without restriction.\n"
" */\n"
"\n"
"#include <stdlib.h>\n"
"#include <gc.h>\n"
"\n"
"/*\n"
" * Initialize the node allocation pool.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void yynodeinit(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"void yynodeinit()\n"
"{\n"
"#endif\n"
"	GC_INIT();\n"
"	GC_init();\n"
"}\n"
"\n"
"/*\n"
" * Allocate a block of memory.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void *yynodealloc(state__, size__)\n"
"YYNODESTATE *state__;\n"
"unsigned int size__;\n"
"{\n"
"#else\n"
"void *yynodealloc(size__)\n"
"unsigned int size__;\n"
"{\n"
"#endif\n"
"	return (void *)GC_MALLOC((size_t)size__);\n"
"}\n"
"\n"
"/*\n"
" * Push the node allocation state.  Not used in the GC version.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"int yynodepush(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"int yynodepush()\n"
"{\n"
"#endif\n"
"	return 1;\n"
"}\n"
"\n"
"/*\n"
" * Pop the node allocation state.  Not used in the GC version.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void yynodepop(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"void yynodepop()\n"
"{\n"
"#endif\n"
"}\n"
"\n"
"/*\n"
" * Clear the node allocation pool completely.  Not used in the GC version.\n"
" */\n"
"#ifdef YYNODESTATE_REENTRANT\n"
"void yynodeclear(state__)\n"
"YYNODESTATE *state__;\n"
"{\n"
"#else\n"
"void yynodeclear()\n"
"{\n"
"#endif\n"
"}\n"
;
static char const TreeCCSkel_cpp_gc_skel_h[] =
"\n"
;
static char const TreeCCSkel_cpp_gc_skel_cc[] =
"/*\n"
" * treecc node allocation routines for C++.\n"
" *\n"
" * Copyright (C) 2003  Southern Storm Software, Pty Ltd.\n"
" *\n"
" * This program is free software; you can redistribute it and/or modify\n"
" * it under the terms of the GNU General Public License as published by\n"
" * the Free Software Foundation; either version 2 of the License, or\n"
" * (at your option) any later version.\n"
" *\n"
" * This program is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
" * GNU General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU General Public License\n"
" * along with this program; if not, write to the Free Software\n"
" * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n"
" *\n"
" * As a special exception, when this file is copied by treecc into\n"
" * a treecc output file, you may use that output file without restriction.\n"
" */\n"
"\n"
"#include <gc.h>\n"
"\n"
"/*\n"
" * Initialize the singleton instance.\n"
" */\n"
"#ifndef YYNODESTATE_REENTRANT\n"
"YYNODESTATE *YYNODESTATE::state__ = 0;\n"
"#endif\n"
"\n"
"/*\n"
" * Constructor for YYNODESTATE.\n"
" */\n"
"YYNODESTATE::YYNODESTATE()\n"
"{\n"
"	/* Initialize the garbage collector */\n"
"	GC_INIT();\n"
"	GC_init();\n"
"\n"
"#ifndef YYNODESTATE_REENTRANT\n"
"	/* Register this object as the singleton instance */\n"
"	if(!state__)\n"
"	{\n"
"		state__ = this;\n"
"	}\n"
"#endif\n"
"}\n"
"\n"
"/*\n"
" * Destructor for YYNODESTATE.\n"
" */\n"
"YYNODESTATE::~YYNODESTATE()\n"
"{\n"
"#ifndef YYNODESTATE_REENTRANT\n"
"	/* We are no longer the singleton instance */\n"
"	if(state__ == this)\n"
"	{\n"
"		state__ = 0;\n"
"	}\n"
"#endif\n"
"}\n"
"\n"
"#ifdef YYNODESTATE_USE_ALLOCATOR\n"
"\n"
"/*\n"
" * Allocate a block of memory.\n"
" */\n"
"void *YYNODESTATE::alloc(size_t size__)\n"
"{\n"
"	return (void *)GC_MALLOC((size_t)size__);\n"
"}\n"
"\n"
"/*\n"
" * Deallocate a block of memory.\n"
" */\n"
"void YYNODESTATE::dealloc(void *ptr__, size_t size__)\n"
"{\n"
"	/* Nothing to do for this type of node allocator */\n"
"}\n"
"\n"
"/*\n"
" * Push the node allocation state.\n"
" */\n"
"int YYNODESTATE::push()\n"
"{\n"
"	/* Not used with the garbage collector */\n"
"	return 1;\n"
"}\n"
"\n"
"/*\n"
" * Pop the node allocation state.\n"
" */\n"
"void YYNODESTATE::pop()\n"
"{\n"
"	/* Not used with the garbage collector */\n"
"}\n"
"\n"
"/*\n"
" * Clear the node allocation pool completely.\n"
" */\n"
"void YYNODESTATE::clear()\n"
"{\n"
"	/* Not used with the garbage collector */\n"
"}\n"
"\n"
"#endif /* YYNODESTATE_USE_ALLOCATOR */\n"
"\n"
"/*\n"
" * Default implementation of functions which may be overridden.\n"
" */\n"
"void YYNODESTATE::failed()\n"
"{\n"
"}\n"
"\n"
"#ifdef YYNODESTATE_TRACK_LINES\n"
"\n"
"char *YYNODESTATE::currFilename()\n"
"{\n"
"	return (char *)0;\n"
"}\n"
"\n"
"long YYNODESTATE::currLinenum()\n"
"{\n"
"	return 0;\n"
"}\n"
"\n"
"#endif\n"
;
const char * const TreeCCSkelFiles[] = {
    "c_skel.c", TreeCCSkel_c_skel_c,
    "c_skel.h", TreeCCSkel_c_skel_h,
    "cpp_skel.cc", TreeCCSkel_cpp_skel_cc,
    "cpp_skel.h", TreeCCSkel_cpp_skel_h,
    "c_gc_skel.h", TreeCCSkel_c_gc_skel_h,
    "c_gc_skel.c", TreeCCSkel_c_gc_skel_c,
    "cpp_gc_skel.h", TreeCCSkel_cpp_gc_skel_h,
    "cpp_gc_skel.cc", TreeCCSkel_cpp_gc_skel_cc,
    0
};
