/* setup_audio.c 
	vi:ts=3 sw=3:
 */
/* higher level interface to the raw metal */

/* $Id: setup_audio.c,v 5.5 1996/05/07 15:22:17 espie Exp espie $
 * $Log: setup_audio.c,v $
 * Revision 5.5  1996/05/07 15:22:17  espie
 * First use of watched_var protocol (oversample/frequency)
 *
 * Revision 5.4  1996/05/06 14:29:10  espie
 * *** empty log message ***
 *
 * Revision 5.3  1996/04/13 17:16:49  espie
 * *** empty log message ***
 *
 * Revision 5.2  1996/04/09 21:14:02  espie
 * *** empty log message ***
 *
 * Revision 5.1  1995/12/24 03:13:06  espie
 * *** empty log message ***
 *
 * Revision 5.0  1995/10/21 14:56:59  espie
 * New
 *
 * Revision 4.15  1995/09/17 23:27:27  espie
 * *** empty log message ***
 *
 * Revision 4.14  1995/09/03 13:40:04  espie
 * *** empty log message ***
 *
 * Revision 4.13  1995/05/11 12:26:22  espie
 * Corrected types.
 *
 * Revision 4.12  1995/02/21  21:13:16  espie
 * Cleaned up source. Moved minor pieces of code around.
 *
 * Revision 4.11  1995/02/21  17:54:32  espie
 * Internal problem: buggy RCS. Fixed logs.
 *
 * Revision 4.0  1994/01/11  17:55:28  espie
 * Use autoinit.
 * Suppressed multiple at_end.
 * Use new pref scheme.
 * Modified in a more consistent way.
 * Added check before closing for the sgi.
 * Added finetune.
 */



#include "defs.h"
#include "extern.h"
#include "tags.h"
#include "prefs.h"
#include "autoinit.h"
#include "notes.h"
#include "resample.h"
#include "watched_var.h"

ID("$Id: setup_audio.c,v 5.5 1996/05/07 15:22:17 espie Exp espie $")

LOCAL void init_audio(void);

LOCAL void (*INIT)(void) = init_audio;

LOCAL bool opened = FALSE;
LOCAL unsigned long ask_freq, real_freq;
LOCAL int stereo;


/* forward declaration */
LOCAL void do_close_audio(void);

LOCAL void init_audio(void)
   {
   at_end(do_close_audio);
   }

/* setup_audio(frequency, stereo):
 * try to avoid calling open_audio and other things
 * all the time
 */
void setup_audio(unsigned long f, int s)
   {
   INIT_ONCE;

   if (!opened)
      {
      ask_freq = f;
      stereo = s;
		if (get_pref_scalar(PREF_OUTPUT))
			real_freq = open_audio(f, s);
		else
			{
			real_freq = 22050;
			set_watched_scalar(FREQUENCY, real_freq);
			}
      opened = TRUE;
      }
   else
      {
      unsigned long new_freq;

      if (s != stereo || f != ask_freq)
         {
         ask_freq = f;
         stereo = s;
         close_audio();
			if (get_pref_scalar(PREF_OUTPUT))
				new_freq = open_audio(f, s);
			else
				{
				new_freq = 22050;
				set_watched_scalar(FREQUENCY, real_freq);
				}
         }
      else
         new_freq = real_freq;
      }
   }

LOCAL void do_close_audio(void)
   {
   if (opened && get_pref_scalar(PREF_OUTPUT))
      {
      close_audio();
      }
   opened = FALSE;
   }

