//	Copyright (C) 1999-2005 Core Technologies.
//
//	This file is part of tpasm.
//
//	tpasm is free software; you can redistribute it and/or modify
//	it under the terms of the tpasm LICENSE AGREEMENT.
//
//	tpasm is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	tpasm LICENSE AGREEMENT for more details.
//
//	You should have received a copy of the tpasm LICENSE AGREEMENT
//	along with tpasm; see the file "LICENSE.TXT".


// global variables

#include	"include.h"

unsigned int
	numAllocatedPointers;						// used to track memory leaks
const char
	*programName;								// name of this program (used during error reports)
const char
	*sourceFileName;							// name of the control file
const char
	*listFileName;
FILE
	*listFile;
const char
	*defaultProcessorName;						// which processor to use by default
bool
	infoOnly;									// set by command line options which report information and abort assembly

unsigned int
	includeDepth;								// keep track of number of includes deep
unsigned int
	passCount;									// remembers how many passed have been performed
unsigned int
	maxPasses;									// describes maximum number of passes the assembler will make before giving up
unsigned int
	numUnresolvedLabels,
	numModifiedLabels;
bool
	intermediatePass;							// true on everything but the last pass
unsigned int
	numBytesGenerated;							// number of bytes generated by assembly of a given line
char
	scope[MAX_STRING];							// keeps last non-local program label (so we can create absolute labels out of local ones)
unsigned int
	scopeCount;									// keeps count of number of references within this scope (allows macros to have their own local variable scope)
unsigned int
	scopeValue;									// based on scope-count, keeps the current scope value

unsigned int
	blockDepth;									// keep track of number of blocks deep

CONTEXT_RECORD
	*contextStack;								// keeps track of the assembly context stack (NULL means use default context)

TEXT_BLOCK
	*collectingBlock;							// pointer to block of text being collected currently, NULL if none

ALIAS_RECORD
	*aliasesHead;								// list of operand aliases

MACRO_RECORD
	*macrosHead;								// head of list of macros collected during assembly (the actual macro being built if in macro context)

SYM_TABLE
	*fileNameSymbols;							// collected list of all file names encountered during assembly

SYM_TABLE_NODE
	*currentFile,								// pointer to the current file being assembled
	*currentVirtualFile;						// pointer to the file which contained the line of the text which is currently being assembled (as in a macro expansion)

LABEL_RECORD
	*labelsHead;								// keeps track of all the labels which have been defined

unsigned int
	currentFileLine;							// tells which line of the current file is being assembled
unsigned int
	currentVirtualFileLine;						// tells which line of the virtual file contained the text currently being assembled

unsigned int
	errorCount,									// number of errors reported
	warningCount;								// number of warnings reported
bool
	displayWarnings,							// tells if warnings should be displayed
	displayDiagnostics;							// tells if diagnostics should be displayed

bool
	stopParsing;								// used to tell us to stop assembling (when end statement is encountered)
bool
	outputListing;								// true if listing is to be generated, false otherwise
bool
	outputListingExpansions;					// true if macro and repeat expansions should be present in the listing, false if not

SEGMENT_RECORD
	*currentSegment,							// tells which segment is currently being assembled into
	*segmentsHead,								// pointer to the head of the list of segments
	*segmentsTail;								// pointer to the tail of the list of segments
