/*
 * Copyright 2002 Christopher SEKIYA <wileyc@rezrov.net>
 * portions copyright 1997-2000 by Pawel Krawczyk <kravietz@ceti.pl>
 *
 * connect.c  Open connection to server.
 */

#include "tacshell.h"

#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int
tac_connect(u_int32_t server)
{
	struct sockaddr_in serv_addr;
	struct servent *s;
	int             fd;

	if (server == 0)
		return -1;

	bzero((char *) &serv_addr, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = server;

	s = getservbyname("tacacs", "tcp");
	if (s == NULL)
		serv_addr.sin_port = htons(49);
	else
		serv_addr.sin_port = s->s_port;

	if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		struct in_addr  in;
		bcopy(&server, &in.s_addr, sizeof(in.s_addr));
		return -1;
	}
	if (connect(fd, (struct sockaddr *) & serv_addr,
		    sizeof(serv_addr)) < 0) {
		struct in_addr  in;
		bcopy(&server, &in.s_addr, sizeof(in.s_addr));
		return -1;
	}
	return (fd);

}
