/*
 * Copyright 2002 Christopher SEKIYA <wileyc@rezrov.net>
 * portions copyright 1997-2000 by Pawel Krawczyk <kravietz@ceti.pl>
 *
 * authen_c.c  Send CONTINUE authentication request to the server.
 */

#include "tacshell.h"

int
tac_authen_continue_send(int fd, char *pass)
{
	struct tacacs_header header;	/* TACACS+ packet header */
	struct authen_cont *body;	/* message body */
	int             passwd_length;
	int             body_length;
	int             status;

	/* set header options */
	header.type = TAC_PLUS_AUTHEN;
	header.seq_no = sequence_number;
	sequence_number++;
	header.session_id = htonl(session_id);
	header.version = TAC_PLUS_VER_1;
	header.encryption = tac_encryption ? TAC_PLUS_ENCRYPTED : TAC_PLUS_CLEAR;

	/* get size of submitted data */
	passwd_length = strlen(pass);

	/* fill body length in header */
	body_length = TAC_AUTHEN_CONT_FIXED_FIELDS_SIZE + passwd_length;
	header.datalength = htonl(body_length);

	/* we can now write the header */
	status = write(fd, &header, TAC_PLUS_HDR_SIZE);
	if (status < 0 || status < TAC_PLUS_HDR_SIZE) {
		return -1;
	}
	body = malloc(TAC_AUTHEN_CONT_FIXED_FIELDS_SIZE + passwd_length);

	/* fill the body of message */
	body->flags = 0;
	body->user_msg_len = htons(passwd_length);
	body->user_data_len = 0;

	strncpy(((char *) body) + TAC_AUTHEN_CONT_FIXED_FIELDS_SIZE, pass, passwd_length);

	/* cheap consistancy check */
	if (TAC_AUTHEN_CONT_FIXED_FIELDS_SIZE +
	    ntohs(body->user_msg_len) +
	    ntohs(body->user_data_len) !=
	    ntohl(header.datalength)) {
		free(body);
		return -1;
	}
#if DEBUG
	fprintf(stderr, "transmitting packet:\n");
	fprintf(stderr, "\t%x %x\n", body->user_msg_len, body->user_data_len);
#endif

	/* encrypt the body */
	tac_crypt((unsigned char *) body, &header, body_length);

	status = write(fd, body, TAC_AUTHEN_CONT_FIXED_FIELDS_SIZE + passwd_length);
	free(body);

	if (status < 0 || status < (TAC_AUTHEN_CONT_FIXED_FIELDS_SIZE + passwd_length)) {
		fprintf(stderr, "tacshell: short body write during continue phase: %i of %i\n",
			status, (TAC_AUTHEN_CONT_FIXED_FIELDS_SIZE + passwd_length));
		return -1;
	}

	return 0;
}
