/* $Id: textfile.c,v 1.25 2004/06/23 03:44:58 jared Exp $ */

#include "config.h"

/*
 * dump the currently broken network devices/services to the filename
 * specified
 *
 * overwrite it if it exists, do not follow symlinks
 * use the umask specified for file creation
 * html = 0 (text) html = 1 (dump in html format)
 *
 */
void
dump_to_file(char *filename, int html)
{
	FILE *fh; /* filehandle for writing out status */
	
	char newfname[128], updated_at[128];

        time_t now;
        struct tm *ltm;

        now = time(NULL);
        ltm = localtime(&now);
        strftime(updated_at, 127,
	  parser_dateformat == NULL ? "%x %X" : parser_dateformat, ltm);
/*	snprintf(updated_at, 127, 
                "%d/%d/%d @ %02d:%02d:%02d\n",
                ltm->tm_mon + 1, 
                ltm->tm_mday, 
                ltm->tm_year + 1900, 
                ltm->tm_hour,
                ltm->tm_min, 
                ltm->tm_sec); */


	snprintf(newfname, 127, "%s%d",filename, getpid());
	
	if (filename == NULL)
	{
		print_err(1, "textfile.c:Error! dump_to_file called with filename == NULL\n");
		return;
	}

	/* Delete anything that might be in our way */
	if(unlink(newfname) == -1)
	{
		if (debug)
		{
			print_err(1, "textfile.c:dump_to_file:unlink newfilename");
		}
	}

	fh = fopen(newfname, "w");
	
	if (fh == NULL)
	{
		if (debug)
			perror("dump_to_file:fopen");
		return;
	}

	if (html == 1) /* html format */
	{
		fprintf(fh, "<HTML>\n<HEAD>\n");
		fprintf(fh, "<TITLE>sysmon %s Network Summary</TITLE>\n", SYSM_VERS);
                fprintf(fh, "<META HTTP-EQUIV=\"Refresh\" CONTENT=%d>\n",
			parser_html_refresh);
		fprintf(fh, "<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">\n");
		fprintf(fh, "</HEAD>\n");
		fprintf(fh, "<h2><a href=\"http://www.sysmon.org/\">sysmon</a> %s Network Summary</h2><p>\n", SYSM_VERS);
		if (paused)
		{
			fprintf(fh, "Monitoring disabled by user request<p>\n");
		}
		fprintf(fh, "\n<BODY BGCOLOR=\"#ffffff\">\n");
		fprintf(fh, "<TABLE BORDER=\"1\">\n");
		fprintf(fh, "<TR>\n");
                fprintf(fh,
			"<TD COLSPAN=12>Last Updated:<TT>%s</TT></TD>\n",
			updated_at);
                fprintf(fh, "<TR>\n");
		fprintf(fh, "<TD>HostName</TD>\n");
		fprintf(fh, "<TD>Description</td>\n");
		fprintf(fh, "<TD>Type</TD>\n");
		fprintf(fh, "<TD>Port</TD>\n");
		fprintf(fh, "<TD>Down N</TD>\n");
		fprintf(fh, "<TD>Up N</TD>\n");
		fprintf(fh, "<TD>Notified</TD>\n");
		fprintf(fh, "<TD>Status</TD>\n");
		fprintf(fh, "<TD>Time Up</TD>\n");
		fprintf(fh, "<TD>Time Failed</TD>\n");
		fprintf(fh, "<TD>Last Outage</TD>\n");
		fprintf(fh, "<TD>Uptime</TD>\n");
		fprintf(fh, "</TR>\n");

	} else { /* non html */
		fprintf(fh,"Network Summary     sysmon %s\n", SYSM_VERS);
	        fprintf(fh,"%-25s%-6s%-5s%-6s%-6s%-6s%-15s%s\n",
			 "Hostname", "Type", "Port", "DownN", "UpN",
			"Notified", "Stat", "Time Failed");
	}

	/* print the hosts that are down and stuff */
	walk_this_way(fh, currenthead, html, now);

	if ( html == 1) /* html end of stuff */
	{
		fprintf(fh, "</TABLE>\n");
		fprintf(fh, "\n</BODY>\n");
		fprintf(fh, "\n</HTML>\n");
	} else {  /* ascii trailer */
		/* not used */

	}

	fclose(fh); /* close the file handle -- don't leak it */

	chmod(newfname, 0444);

	rename(newfname, filename);

	return;
}

void	add_line(FILE *fh, struct hostinfo down, int html, time_t now)
{
        char *downdata = timedata(down.deathtime);
        char *updata = timedata(down.last_up);
        float value, tmp1, tmp2;
        char tmp[1024];

	if (html == 1)
	{
		if (down.lastcheck != SYSM_OK) 
		{
			if (!down.contacted)
			{
			   fprintf(fh, "<TR BGCOLOR=\"#%s\">\n", recentcolor);
			} else {
			   fprintf(fh, "<TR BGCOLOR=\"#%s\">\n", downcolor);
			}
		} else {
			fprintf(fh, "<TR BGCOLOR=\"#%s\">\n", upcolor);
		}
                tmp1 = down.totaldown;
                tmp2 = down.totalchecked;
		if (tmp2 != 0)
	                value = (100.0000-((tmp1/tmp2) * 100));
		else
			value = 100;
                if (value<0) value=0.000;
                snprintf(tmp, 1024, "%10.2f%%",value);

		fprintf(fh, 
"<TD>%s</TD><TD>%s</TD><TD>%s</TD><TD>%d</TD><TD>%ld</TD><TD>%ld</TD><TD>%s</TD><TD>%s</TD><TD>%s</TD><TD>%s</TD><TD>%s</TD><TD>%s</TD>\n", 
			down.hostname, down.message, type_to_name(down.type), 
			down.port, down.downct, down.upct,
			yes_no(down.contacted), errtostr(down.lastcheck),
			updata, downdata, str_difftime(down.last_up, now),tmp);
		fprintf(fh, "</TR>\n");
	} else { /* ascii */
		fprintf(fh,"%-25s%-6s%-5d%-5ld%-6ld%-6s%-15s%s\n",
		  down.hostname, type_to_name(down.type), down.port,
		  down.downct, down.upct, yes_no(down.contacted),
		  errtostr(down.lastcheck), 
		  downdata);
	}
	FREE(downdata);
	FREE(updata);
}

/* 
 * BUG: if parent is down, we display children
 */
void	walk_this_way(FILE *fh, struct all_elements_list *here, 
		int html, time_t now)
{
	struct all_elements_list *lochere;
	/* Walk element list, display down hosts unless showupalso
	 * is set, then we show all hosts */
	/* BUG: Need ability to sort */
	for (lochere=here;lochere!= NULL;lochere=lochere->next)
	{
		if (lochere->value->data->lastcheck != 0 ||showupalso)
		{
			add_line(fh, *(lochere->value->data), html, now);
		}

	}
}

