/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
#include <stdio.h>
#include <string.h>

int readline(FILE *file, char *buf, int bufsize);

#define MAX_LINES 256

class AddrString
{
	public:
		char 		addr[32];
		AddrString  *next;
	public:	
		AddrString(char *text);
};

AddrString::AddrString(char *text)
	: next(NULL)
{
	strncpy(addr, text, 32);
}

AddrString *AddrStringFindMatch(AddrString *list, char *text)
{
	while (list)
	{
		if (strcmp(list->addr, text))
			list = list->next;
		else
			return list;
	}
	return NULL;
}  // end AddrStringFindMatch()


int main(int argc, char *argv[])
{
	AddrString *head = NULL;
	
	if (argc < 2)
	{
		fprintf(stderr, "Usage: mdpWho logFile1 [logFile2 ...]\n");
		exit(-1);
	}
	for (int i=1; i< argc; i++)
	{
		FILE *inFile = fopen(argv[i], "r");
		if (!inFile)
		{
			perror("mdpWho: Error opening file:");
			exit(-1);
		}
		char buf[MAX_LINES];
		while (readline(inFile, buf, MAX_LINES))
		{
			if (!strncmp(buf, "MDP_REPORT", 10))
			{
				char *ptr = strchr(buf, '(');
				if (ptr) 
					ptr++;
				else
					break;
				char *ptr2 = strchr(ptr, ')');
				if (ptr2)
					*ptr2 = '\0';
				else
					break;
				ptr++;  // point to beginning of address string
				if (!AddrStringFindMatch(head, ptr))
				{
					AddrString *a = new AddrString(ptr);
					a->next = head;
					head = a;
					// Print out new find
					*ptr2 = ')';
					ptr = strchr(buf, ':');
					if (ptr)
					{
						ptr += 2;
						fprintf(stdout, "MDPv2 participant: %s\n", ptr);
						fflush(stdout);
					}
					else
					{
						// This should never happen
						fprintf(stderr, "This should never happen.\n");
						exit(-1);
					}
				}
			}
		}
		fclose(inFile);
	}
}


int readline(FILE *file, char *buf, int bufsize)
{
	bufsize -= 1;  // leave room for '\0'
	int len = 0;
	while (len < bufsize)
	{
		if (fread(buf, sizeof(char), 1, file))
		{
			len++;
			if ('\n' == *buf) break;
			buf++;
		}
		else
		{
			if (len)
				break;
			else
				return 0;
		}
	}	
	if (len >= bufsize) 
	{
		fprintf(stderr, "readline: Line too long!\n");
		// Advance to EOL or EOF
		char c;
		while(fread(&c, sizeof(char), 1, file))
			if ('\n' == c) break;
	}
	*buf = '\0';
	return 1;
}  // end readline()
