/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/

#ifndef _MDP
#define _MDP

#include <string.h>

#include "mdpApp.h"
#include "eventDispatcher.h"

#ifdef NETSCAPE_SUPPORT
#include "postProcess.h"
#endif // NETSCAPE_SUPPORT

//typedef void (*SignalHandlerFunc)(...);

class CmdMdpApp : public MdpApp
#ifdef USE_INHERITANCE
    , public ProtocolTimerOwner
#endif // USE_INHERITANCE
{    
    public:
    // Methods
        CmdMdpApp();
        ~CmdMdpApp();
        
        void StartTxIntervalTimer(double theDelay);     
        void StopTxIntervalTimer();
		
        void Run() {dispatcher.Run();}
        void OnExit();
        
        void SetPostProcessor(char* theCmd);
#ifdef NETSCAPE_SUPPORT
        void CheckForNetscape();
        void SetNetscape(bool value) {use_netscape = value;}
#endif  // NETSCAPE_SUPPORT 
        
        // Some static functions
        static void SignalHandler(int signum);
        
        static bool MdpTimerInstaller(MdpTimerInstallCmd    cmd, 
                                      double                delay,
                                      MdpTimerHandle        timerHandle, 
                                      MdpInstanceHandle     instanceHandle);
        
        static bool MdpSocketInstaller(MdpSocketInstallCmd  cmd,
                                       MdpSocketHandle      socketHandle,
                                       MdpInstanceHandle    instanceHandle);

    private:
    // Members
        EventDispatcher     dispatcher;
        ProtocolTimer       mdp_timer;
        MdpTimerHandle      mdp_timer_handle;
#ifdef NETSCAPE_SUPPORT
        Window              window_id;
        bool                use_netscape;
#endif  // NETSCAPE_SUPPORT
        ProtocolTimer       tx_interval_timer;
        int                 post_processor_id;

    // Methods
        void PostProcess(const char* path);
        void KillPostProcessor();
        
        bool OnTxIntervalTimeout();
        bool OnMdpTimeout();
        
        static void MdpSocketHandler(EventDispatcher::Descriptor descriptor, 
                                     EventDispatcher::EventType  eventType, 
                                     const void*                 userData);
};

#endif // _MDP
