#!/usr/bin/tclsh

# Runs ns simplemdp.tcl for Nack stats vs. group size

#set uniSizeList {10 20 50 100 150 200 250 300 350 400 500 600 700 800 900 1000}
#set multiSizeList {10 20 50 100 150 200 250 300 350 400 500 600 700 800 900 1000}
set uniSizeList {500}
set multiSizeList {}

set rate 32kb
set duration 92.0

foreach backoff {4} {
    #set fileName "sup4-$backoff.gp" // MDP no ad loss, correlated loss
    set fileName "uncorrLoss500-$backoff.gp"
    exec rm -f $fileName
    set outFile [open $fileName "w"]
    puts $outFile "#Backoff:$backoff loss:10% uncorrelated, all message types, no FEC"

    # Gnuplot header
    puts $outFile "set title 'Feedback Suppression Performance'"
    puts $outFile "set data style lines"
    puts $outFile "set xlabel 'Number of Receivers'"
    puts $outFile "set ylabel 'Feedback Suppression Factor'"
    puts $outFile "plot \\"
    puts $outFile "'-' using 1:2 \\"
    puts $outFile "'Receivers:%lf alpha:%lf' t 'Theoretical Multicast NACKs', \\"
    puts $outFile "'-' using 1:2 \\"
    puts $outFile "'Receivers:%lf alpha:%lf' t 'Theoretical Unicast NACKs', \\"
    puts $outFile "'-' using 1:(\$4) \\"
    puts $outFile "'Receivers:%lf Sent:%lf Suppressed:%lf alpha:%lf' t 'Measured Unicast NACKs', \\"
    puts $outFile "'-' using 1:(\$4) \\"
    puts $outFile "'Receivers:%lf Sent:%lf Suppressed:%lf alpha:%lf' t 'Measured Multicast NACKs'\n"

    puts "Computing theoretical results ..."
    # T = number of GRTT for NACK backoff timers ...
    set T $backoff
    # Theoretical Multicast NACK results
    puts $outFile "#Theoretical Multicast NACK Suppression Factor (EXPONENTIAL)"
    foreach numClient $uniSizeList {
        set lambda [expr log($numClient) + 1.0]
        set N [expr exp((1.2/(2.0 * $T)) * ($lambda))]
        set alpha [expr $N / $numClient]
        puts $outFile "Receivers:$numClient alpha:$alpha" 
    }  
    puts $outFile "e\n"
    # Theoretical Unicast NACK results
    puts $outFile "#Theoretical Unicast NACK Suppression Factor (EXPONENTIAL)"
    foreach numClient $uniSizeList {
        set lambda [expr log($numClient) + 1.0]
        set N [expr exp((1.2/(1.0 * $T)) * ($lambda))]
        set alpha [expr $N / $numClient]
        puts $outFile "Receivers:$numClient alpha:$alpha" 
    } 
    close $outFile


    # Measured Unicast NACK results
    set outFile [open $fileName "a"]
    puts $outFile "e\n"
    puts $outFile "#Measured Unicast NACK Suppression Factor (EXPONENTIAL)"
    close $outFile
    #set sizeList {10 100} 
    foreach numClient $uniSizeList {
        puts "Starting simulation run (groupSize:$numClient) ..."
        puts "   ns simplemdp.tcl numClient $numClient rate $rate duration $duration backoff $backoff unicastNacks"
        catch {eval exec ns simplemdp.tcl numClient $numClient rate $rate duration $duration backoff $backoff unicastNacks}
        puts "Sim complete"
        puts "   nc mdpLog.txt >> $fileName"        
        exec nc mdpLog.txt >> $fileName
    }


    # Measured Multicast NACK results
    set outFile [open $fileName "a"]
    puts $outFile "e\n"
    puts $outFile "#Measured Multicast NACK Suppression Factor (EXPONENTIAL)"
    close $outFile 
    foreach numClient $multiSizeList {
        puts "Starting simulation run (groupSize:$numClient) ..."
        puts "   ns simplemdp.tcl numClient $numClient rate $rate duration $duration backoff $backoff"
        catch {eval exec ns simplemdp.tcl numClient $numClient rate $rate duration $duration backoff $backoff}
        puts "   nc mdpLog.txt >> $fileName"        
        catch {eval exec nc mdpLog.txt >> $fileName}
    }
}
puts "Finished."
