#!/usr/bin/tclsh

source rmcc-5.tcl

#Test options#

set nam "false"
set red "true"
set ecn "true"
set mdpNum 1
set runTime 1200.0

#Setup up for random start/stop tcp
# Flows start randomly from 0 -> startSpread
set startSpread 800.0 
# TCP duration maxTime*0.1 -> maxTime if startStop is "on"
# if startStop is "off", flows last indefinitely  
set startStop "on"
set maxTime 600.0      
                      
    #Bottleneck setup
    set bottle2(TCPCount) 6
    set bottle2(Rate) 1Mb
    set bottle2(Delay) 1ms
    set bottle2(Qsize) 100
    lappend bottleList bottle2

#Run rmcc-5.tcl
RunRMCC5 $bottleList $runTime $mdpNum $red $ecn $nam $startSpread $startStop $maxTime


    

