#
proc SimpleMDP {numClient mdpRate bottleneckRate theDuration} {

# Create multicast enabled simulator ins__tance
set ns_ [new Simulator -multicast on]
$ns_ set-address-format expanded
$ns_ multicast

# Turn on full ns_/NAM tracing
set f [open out-mcast.tr w]
$ns_ trace-all $f
set nf [open out-mcast.nam w]
#$ns_ namtrace-all $nf

$ns_ color 0 red
$ns_ color 2 black
$ns_ color 1 blue

# Set up color mapping for MDPv2 packet types
$ns_ color 41 yellow
$ns_ color 42 blue
$ns_ color 43 darkgreen
$ns_ color 44 purple
$ns_ color 45 orange
$ns_ color 46 red
$ns_ color 47 black

# Create nodes (1 source, 1 bottleneck, 7 fanout minimum)
set maxNode [expr $numClient + 2]
if {$maxNode < 8} {
    set maxNode 8
}

puts "Creating nodes ..."
for {set i 0} {$i <= $maxNode} {incr i} {
    set n($i) [$ns_ node]
}

# Make 1 bottleneck link (Node 0 -> Node 1 link)
$ns_ duplex-link $n(0) $n(1) $bottleneckRate 10ms DropTail
$ns_ queue-limit $n(0) $n(1) 100
$ns_ duplex-link-op $n(0) $n(1) orient right
$ns_ duplex-link-op $n(0) $n(1) queuePos 0.5

puts "Creating links ..."
# Make fanout links
for {set i 2} {$i <= $maxNode} {incr i} {
    $ns_ duplex-link $n(1) $n($i) $bottleneckRate 10ms DropTail
    $ns_ queue-limit $n(1) $n($i) 100
	$ns_ duplex-link-op $n(1) $n($i) queuePos 0.5
}
    
### Start multicast configuration: 5 mproto options_
### CtrMcast   : centralized multicast
### DM         : static DVMRP (can't adapt to link up/down or node up/down)
### detailedDM : dens_e mode protocol that adapts to dynamics (recommended)
### dynamicDM  : dynamic DVMRP 
### pimDM      : PIM dens_e mode

### Uncomment following lines to change default
#DM set PruneTimeout 0.3               ;# default 0.5 (sec)
#dynamicDM set ReportRouteTimeout 0.5  ;# default 1 (sec)

set mproto CtrMcast
set mrthandle [$ns_ mrtproto $mproto  {}]
if {$mrthandle != ""} {
    $mrthandle set_c_rp [list $n(1)]
}
### End of multicast configuration

puts "Creating MDP agents ..."
    
#######################################  
# Create MDPv2 server and client Agents

# Server side agent (Node 0)
    set mdp_server(0) [new Agent/MDP]
    $ns_ attach-agent $n(0) $mdp_server(0)
    $mdp_server(0) ttl 32
    $mdp_server(0) txRate [bw_parse $mdpRate]
    $mdp_server(0) segmentSize 512
    $mdp_server(0) blockSize 20
    $mdp_server(0) numParity 20
    $mdp_server(0) autoParity 0
    $mdp_server(0) numRepeats -1
    $mdp_server(0) congestionControl off
    $mdp_server(0) sendLoss 50.0
    $mdp_server(0) debugLevel 2
    $mdp_server(0) logFile mdpLog.txt
    $mdp_server(0) initialGrtt 0.040

# Create $numClient MDP client agents
set k 2
for {set i 0} {$i < $numClient} {incr i} {
# Client side agent (Node k)
    set mdp_client($i) [new Agent/MDP]
    $ns_ attach-agent $n($k) $mdp_client($i)
    #$mdp_client($i) recvLoss 10.0
    $mdp_client($i) rxBufferSize 600000
    
    # Set 1 NACKing client, the rest are silent
    if {$i > 0} {
        $mdp_client($i) emcon on
    } else {
        $mdp_client($i) emcon off
    }
    
    
    incr k
    if {$k > $maxNode} {
        set k 2
    }
}

# Global MDPv2 settings
$mdp_server(0) debugLevel 2
#$mdp_server(0) messageTrace on
#$mdp_server(0) logFile mdpLog.txt
    
    
# Run a single MDPv2 group over the topology

# Determine base multicast address and pick group address
set mcastBase [expr 1 << [AddrParams set McastShift_]]
set group [expr $mcastBase+1]

puts "Starting simulation ..." 

# Start MDP server
$ns_ at 0.0  "$mdp_server(0) baseObject 100"
$ns_ at 0.0 "$mdp_server(0) start server $group"
$ns_ at 0.0 "$mdp_server(0) send 65535000"

# Start MDP clients
for {set i 0} {$i < $numClient} {incr i} {
    $ns_ at 0.0 "$mdp_client($i) start client $group"
    }

# Reset node colors
#for {set i 3} {$i < 10} {incr i} {
#    $ns_ at 15.0 "$n($i) color black"
#   }

$ns_ at $theDuration "finish $ns_ $f $nf"

proc finish {ns_ f nf} {
    $ns_ flush-trace
	close $f
	close $nf
    
$ns_ halt
delete $ns_

}

$ns_ run

}

# Run a set of trials with optional command-line parameters

#Usage: ns simplemdp.tcl <numClients> <mdpRate> <bottleneckRate> <duration>
if {4 == $argc} {
    set numClients [lindex $argv 0]
    set mdpRate [lindex $argv 1]
    set bottleneckRate [lindex $argv 2]
    set duration [lindex $argv 3]
} elseif {0 == $argc} {
    set numClients 7
    set mdpRate 64kb
    set bottleneckRate 64kb
    set duration 60.0
} else {
    puts "simplemdp: Error! Invalid command line syntax."
    puts "   Usage: \"ns mdpvstcp.tcl [numClients bottleneckRate duration]\""
    exit
}

puts "Running... (numClients:$numClients mdpRate:$mdpRate bottleneckRate:$bottleneckRate duration:$duration sec)"
SimpleMDP $numClients $mdpRate $bottleneckRate $duration 

