/*********************************************************************
 *
 * AUTHORIZATION TO USE AND DISTRIBUTE
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: 
 *
 * (1) source code distributions retain this paragraph in its entirety, 
 *  
 * (2) distributions including binary code include this paragraph in
 *     its entirety in the documentation or other materials provided 
 *     with the distribution, and 
 *
 * (3) all advertising materials mentioning features or use of this 
 *     software display the following acknowledgment:
 * 
 *      "This product includes software written and developed 
 *       by Brian Adamson and Joe Macker of the Naval Research 
 *       Laboratory (NRL)." 
 *         
 *  The name of NRL, the name(s) of NRL  employee(s), or any entity
 *  of the United States Government may not be used to endorse or
 *  promote  products derived from this software, nor does the 
 *  inclusion of the NRL written and developed software  directly or
 *  indirectly suggest NRL or United States  Government endorsement
 *  of this product.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ********************************************************************/
 
#ifndef _NS_MDP_AGENT
#define _NS_MDP_AGENT

#include "agent.h"
#include "timer-handler.h"
#include "mdpSimAgent.h"

class NsMdpAgent : public Agent, public TimerHandler, public MdpSimAgent
{
    public:
        NsMdpAgent();
        // ns Agent base class overrides
        int command(int argc, const char*const* argv); 
        void recv(Packet* p, Handler* h);
        
        // ns TimerHandler base class overrides  
        void expire(Event* e)
        {
            force_cancel();
            DoTimeout();
        }
        
        // Simulation socket Mgmt & I/O functions
        virtual bool OpenSocket(UdpSocket* theSocket, unsigned short* thePort)
        {
            mdp_socket = theSocket;
            *thePort = here_.port_;
            return ((here_.port_ < 0) ? false : true);
        }
        virtual void CloseSocket(UdpSocket* theSocket) {mdp_socket = NULL;}     
        virtual bool SendTo(UdpSocket* theSocket, 
                            SIMADDR theAddr, unsigned short thePort,
                            char* buffer, unsigned int len);
        virtual bool RecvFrom(UdpSocket* theSocket, 
                              char* buffer, unsigned int* buflen,
                              SIMADDR* theAddr, unsigned short* thePort) {}
        virtual bool JoinGroup(UdpSocket* theSocket, SIMADDR theGroup);
        virtual void LeaveGroup(UdpSocket* theSocket, SIMADDR theGroup);
        virtual void SetSocketTTL(UdpSocket* theSocket, unsigned char theTTL)
        {
            mcast_ttl = theTTL;
        }
        virtual void SetSocketLoopback(UdpSocket* theSocket, bool state)
        {
            mcast_loopback = state;
        }
        
        static nsaddr_t NsMdpAgent::MulticastAddrMask();
        double ClientGoodput();
        void ResetClientGoodput()
        {
            client_start_time = Scheduler::instance().clock();
            goodput_recvd_high = goodput_recvd_low = 0;   
        }
        
    private:
    // Members
        unsigned char mcast_ttl;
        bool          mcast_loopback;
        UdpSocket*    mdp_socket;
        bool          color_packets;
        static bool   useUdp;
        double        client_start_time;
        
    // Methods
        // Misc. simulator agent routines
        virtual unsigned long GetAgentId() {return here_.addr_;}
        
        
        // Simulation timer mgmt functions (for a single mdp system timer)
        virtual void InstallTimer(double delay) {resched(delay);}
        virtual void ModifyTimer(double delay) {resched(delay);}
        virtual void RemoveTimer() {force_cancel();}
       
};  // end class NsMdpAgent


#endif // _NS_MDP_AGENT
