/****************************************************/
/* Bibliotheque d'image 3d                          */
/* image_3d.c                                       */
/*                                                  */
/* Ecrit par : Daniel Lacroix (all rights reserved) */
/*                                                  */
/****************************************************/

#include <math.h>
#include "general.h"
#include "image.h"
#include "image_3d.h"

/* table des cosinus et sinus pour acceler */
int32 *cos_table = NULL;
int32 *sin_table = NULL;

/* quelques variables d'environnement utilises comme des parametres */
pix    *buf  = NULL;
int32  *zbuf = NULL;
uint32 *obj_buf = NULL;
uint32 current_obj = 0;
int32  current_width,current_height,current_width_mul_height;
int32  *x1,*x2;
int32  *z1,*z2;
uint8  *COLR1,*COLR2,*COLG1,*COLG2,*COLB1,*COLB2;
int32  *current_matrice;

/*********************************************************/
/* transforme le point psrc en pdst avec la matrice pmat */
/* il est possible d'utiliser le meme point pour pdst et */
/* psrc (il et alors ecrit sur lui meme).                */
void trans_pix(dot_3d *pdst, dot_3d *psrc, int32 *pmat)
{ int32 x,y,z;

  /* c'est le produit ligne colonne mais avec elimination des */
  /* multiplications par zero d'ou la forme 'bizarre'         */
  x = (pmat[12])>>MAT_SHL;
  y = (pmat[13])>>MAT_SHL;
  z = (pmat[14])>>MAT_SHL;
      
  if(psrc->x)
  {
    if(pmat[0]) x += (psrc->x*pmat[0])>>MAT_SHL;
    if(pmat[1]) y += (psrc->x*pmat[1])>>MAT_SHL;
    if(pmat[2]) z += (psrc->x*pmat[2])>>MAT_SHL;
  }
  if(psrc->y)
  {
    if(pmat[4]) x += (psrc->y*pmat[4])>>MAT_SHL;
    if(pmat[5]) y += (psrc->y*pmat[5])>>MAT_SHL;
    if(pmat[6]) z += (psrc->y*pmat[6])>>MAT_SHL;
  }
  if(psrc->z)
  {  
    if(pmat[8])  x += (psrc->z*pmat[ 8])>>MAT_SHL;
    if(pmat[9])  y += (psrc->z*pmat[ 9])>>MAT_SHL;
    if(pmat[10]) z += (psrc->z*pmat[10])>>MAT_SHL;
  }
  pdst->x = x;
  pdst->y = y;
  pdst->z = z;
}
/*********************************************************/

/**************************************************************************/
/* multipile la matrice p1 par p2, la matrice resultante est pdst         */
/* ATTENTION, pdst ne doit pas pointer sur les meme matrices que p1 et p2 */
void mul_mat(int32 *pdst, int32 *p1, int32 *p2)
{ int32 acc;

  /* premiere ligne */
  pdst[0] = ((p1[0]*p2[0])>>MAT_SHL)+((p1[1]*p2[4])>>MAT_SHL)+((p1[2]*p2[ 8])>>MAT_SHL)+((p1[3]*p2[12])>>MAT_SHL);
  pdst[1] = ((p1[0]*p2[1])>>MAT_SHL)+((p1[1]*p2[5])>>MAT_SHL)+((p1[2]*p2[ 9])>>MAT_SHL)+((p1[3]*p2[13])>>MAT_SHL);
  pdst[2] = ((p1[0]*p2[2])>>MAT_SHL)+((p1[1]*p2[6])>>MAT_SHL)+((p1[2]*p2[10])>>MAT_SHL)+((p1[3]*p2[14])>>MAT_SHL);
  pdst[3] = ((p1[0]*p2[3])>>MAT_SHL)+((p1[1]*p2[7])>>MAT_SHL)+((p1[2]*p2[11])>>MAT_SHL)+((p1[3]*p2[15])>>MAT_SHL);
  /* deuxieme ligne */
  pdst[4] = ((p1[4]*p2[0])>>MAT_SHL)+((p1[5]*p2[4])>>MAT_SHL)+((p1[6]*p2[ 8])>>MAT_SHL)+((p1[7]*p2[12])>>MAT_SHL);
  pdst[5] = ((p1[4]*p2[1])>>MAT_SHL)+((p1[5]*p2[5])>>MAT_SHL)+((p1[6]*p2[ 9])>>MAT_SHL)+((p1[7]*p2[13])>>MAT_SHL);
  pdst[6] = ((p1[4]*p2[2])>>MAT_SHL)+((p1[5]*p2[6])>>MAT_SHL)+((p1[6]*p2[10])>>MAT_SHL)+((p1[7]*p2[14])>>MAT_SHL);
  pdst[7] = ((p1[4]*p2[3])>>MAT_SHL)+((p1[5]*p2[7])>>MAT_SHL)+((p1[6]*p2[11])>>MAT_SHL)+((p1[7]*p2[15])>>MAT_SHL);
  /* troisieme ligne */
  pdst[8]  = ((p1[8]*p2[0])>>MAT_SHL)+((p1[9]*p2[4])>>MAT_SHL)+((p1[10]*p2[ 8])>>MAT_SHL)+((p1[11]*p2[12])>>MAT_SHL);
  pdst[9]  = ((p1[8]*p2[1])>>MAT_SHL)+((p1[9]*p2[5])>>MAT_SHL)+((p1[10]*p2[ 9])>>MAT_SHL)+((p1[11]*p2[13])>>MAT_SHL);
  pdst[10] = ((p1[8]*p2[2])>>MAT_SHL)+((p1[9]*p2[6])>>MAT_SHL)+((p1[10]*p2[10])>>MAT_SHL)+((p1[11]*p2[14])>>MAT_SHL);
  pdst[11] = ((p1[8]*p2[3])>>MAT_SHL)+((p1[9]*p2[7])>>MAT_SHL)+((p1[10]*p2[11])>>MAT_SHL)+((p1[11]*p2[15])>>MAT_SHL);
  /* quatrieme ligne */
  pdst[12] = ((p1[12]*p2[0])>>MAT_SHL)+((p1[13]*p2[4])>>MAT_SHL)+((p1[14]*p2[ 8])>>MAT_SHL)+((p1[15]*p2[12])>>MAT_SHL);
  pdst[13] = ((p1[12]*p2[1])>>MAT_SHL)+((p1[13]*p2[5])>>MAT_SHL)+((p1[14]*p2[ 9])>>MAT_SHL)+((p1[15]*p2[13])>>MAT_SHL);
  pdst[14] = ((p1[12]*p2[2])>>MAT_SHL)+((p1[13]*p2[6])>>MAT_SHL)+((p1[14]*p2[10])>>MAT_SHL)+((p1[15]*p2[14])>>MAT_SHL);
  pdst[15] = ((p1[12]*p2[3])>>MAT_SHL)+((p1[13]*p2[7])>>MAT_SHL)+((p1[14]*p2[11])>>MAT_SHL)+((p1[15]*p2[15])>>MAT_SHL);    
}
/**************************************************************************/

/**************************************************************/
/* calcul le vecteur normal pdst au plan forme de p1,p2 et p3 */
/* pdst est normalise a 2**NORMAL_SHL                         */
void normal(dot_3d *pdst, dot_3d *p1, dot_3d *p2, dot_3d *p3)
{ int32 lenght;

  /* c'est le calcul du 'Cross Product' */
  pdst->x = (p1->y - p2->y)*(p1->z - p3->z) - (p1->z - p2->z)*(p1->y - p3->y);
  pdst->y = -((p1->z - p2->z)*(p1->x - p3->x) - (p1->x - p2->x)*(p1->z - p3->z));
  pdst->z = (p1->x - p2->x)*(p1->y - p3->y) - (p1->y - p2->y)*(p1->x - p3->x);

  /* taille du vecteur normal */
  lenght = sqrt((pdst->x * pdst->x) + (pdst->y * pdst->y) + (pdst->z * pdst->z));

  /* on normalise la normal (taille egal a 1 << NORMAL_SHL) */
  pdst->x = (pdst->x << NORMAL_SHL) / lenght;
  pdst->y = (pdst->y << NORMAL_SHL) / lenght;
  pdst->z = (pdst->z << NORMAL_SHL) / lenght;
}
/**************************************************************/

/***************************************************************/
/* genere une matrice de translation dans pmat pour translater */
/* du vecteur (0,0,0) vers vecteur                             */
void move_mat(dot_3d *vecteur, int32 *pmat)
{
  pmat[ 0] = 1 << MAT_SHL; pmat[5] = 1 << MAT_SHL; pmat[10] = 1 << MAT_SHL;
  pmat[15] = 1 << MAT_SHL;
  pmat[12] = vecteur->x << MAT_SHL; pmat[13] = vecteur->y << MAT_SHL;
  pmat[14] = vecteur->z << MAT_SHL;
  /* tout le reste a 0 */
  pmat[1] = 0; pmat[2] = 0; pmat[3] = 0; pmat[4] = 0; pmat[6] = 0;
  pmat[7] = 0; pmat[8] = 0; pmat[9] = 0; pmat[11] = 0;
}
/***************************************************************/

/***************************************************************************/
/* genere une matrice de zoom de factor. factor = 1024 => aucun changement */
void zoom_mat(int32 factor, int32 *pmat)
{
  pmat[0] = factor; pmat[5] = factor; pmat[10] = factor;
  pmat[15] = 1 << MAT_SHL;
  /* tout le reste a 0 */
  pmat[1] = 0; pmat[2] = 0; pmat[3] = 0; pmat[4] = 0;
  pmat[6] = 0; pmat[7] = 0; pmat[8] = 0; pmat[9] = 0;
  pmat[11] = 0; pmat[12] = 0; pmat[13] = 0; pmat[14] = 0;
}
/***************************************************************************/

/*************************************************************/
/* genere une matrice de rotation autour de l'axe x          */
/* angle est compris entre 0 (0 degres) et 1023 (359 degres) */
void x_rot_mat(int32 angle, int32 *pmat)
{
  pmat[ 5] = cos_table[angle];
  pmat[ 6] = sin_table[angle];
  pmat[ 9] = -sin_table[angle];
  pmat[10] = cos_table[angle];
  pmat[ 0] = 1 << MAT_SHL; pmat[15] = 1 << MAT_SHL;
  /* tout le reste avec des 0 */
  pmat[ 1] = 0; pmat[ 2] = 0; pmat[ 3] = 0; pmat[ 4] = 0;
  pmat[ 7] = 0; pmat[ 8] = 0; pmat[11] = 0; pmat[12] = 0;
  pmat[13] = 0; pmat[14] = 0;
}
/*************************************************************/

/*************************************************************/
/* genere une matrice de rotation autour de l'axe y          */
/* angle est compris entre 0 (0 degres) et 1023 (359 degres) */
void y_rot_mat(int32 angle, int32 *pmat)
{
  pmat[ 0] = cos_table[angle];
  pmat[ 8] = sin_table[angle];
  pmat[ 2] = -sin_table[angle];
  pmat[10] = cos_table[angle];
  pmat[ 5] = 1 << MAT_SHL; pmat[15] = 1 << MAT_SHL;
  /* tout le reste avec des 0 */
  pmat[ 1] = 0; pmat[ 3] = 0; pmat[ 4] = 0; pmat[ 6] = 0;
  pmat[ 7] = 0; pmat[ 9] = 0; pmat[11] = 0; pmat[12] = 0;
  pmat[13] = 0; pmat[14] = 0;
}
/*************************************************************/

/*************************************************************/
/* genere une matrice de rotation autour de l'axe z          */
/* angle est compris entre 0 (0 degres) et 1023 (359 degres) */
void z_rot_mat(int32 angle, int32 *pmat)
{
  pmat[ 0] = cos_table[angle];
  pmat[ 1] = sin_table[angle];
  pmat[ 4] = -sin_table[angle];
  pmat[ 5] = cos_table[angle];
  pmat[10] = 1 << MAT_SHL; pmat[15] = 1 << MAT_SHL;
  /* tout le reste avec des 0 */
  pmat[ 2] = 0; pmat[ 3] = 0; pmat[ 6] = 0; pmat[ 7] = 0;
  pmat[ 8] = 0; pmat[ 9] = 0; pmat[11] = 0; pmat[12] = 0;
  pmat[13] = 0; pmat[14] = 0;  
}
/*************************************************************/

int32 XScale=256; /* distance en X de la focale */
int32 YScale=256; /* distance en Y de la focale */

void Tri3D2D(dot_3d *pix1,dot_3d *pix2,dot_3d *pix3,color *col1,color *col2,color *col3)
{
  color  tmp_col;
  dot_3d tmp_dot;
  uint8 Drap;

/*  printf("a trier ((%d,%d,%d),(%u,%u,%u)) ((%d,%d,%d),(%u,%u,%u))"\
         " ((%d,%d,%d),(%u,%u,%u))\n",pix1->x,pix1->y,pix1->z,
	 col1->r,col1->g,col1->b,
	 pix2->x,pix2->y,pix2->z,col2->r,col2->g,col2->b,
	 pix3->x,pix3->y,pix3->z,col3->r,col3->g,col3->b);*/

  pix1->x=(pix1->x<<8)/(XScale+pix1->z)+(current_width>>1);
  pix2->x=(pix2->x<<8)/(XScale+pix2->z)+(current_width>>1);
  pix3->x=(pix3->x<<8)/(XScale+pix3->z)+(current_width>>1);

  pix1->y=(pix1->y<<8)/(YScale+pix1->z)+(current_height>>1);
  pix2->y=(pix2->y<<8)/(YScale+pix2->z)+(current_height>>1);
  pix3->y=(pix3->y<<8)/(YScale+pix3->z)+(current_height>>1);

  Drap=1;
  while(Drap==1){
    Drap=0;
    if(pix1->y>pix2->y){
      memcpy(&tmp_dot, pix2, sizeof(dot_3d));
      memcpy(&tmp_col, col2, sizeof(color));

      memcpy(pix2, pix1, sizeof(dot_3d));
      memcpy(col2, col1, sizeof(color));

      memcpy(pix1, &tmp_dot, sizeof(dot_3d));
      memcpy(col1, &tmp_col, sizeof(color));
      Drap=1;
    }

    if(pix2->y>pix3->y){
      memcpy(&tmp_dot, pix2, sizeof(dot_3d));
      memcpy(&tmp_col, col2, sizeof(color));

      memcpy(pix2, pix3, sizeof(dot_3d));
      memcpy(col2, col3, sizeof(color));

      memcpy(pix3, &tmp_dot, sizeof(dot_3d));
      memcpy(col3, &tmp_col, sizeof(color));
      Drap=1;
    }
  }
}


/***************************/
/* reinitialise le zbuffer */
void clear_zbuf(image_3d *pimage_3d)
{ uint32 compt;
  /* place la valeur la plus eloigne possible dans tout le zbuffer */
  for(compt=0;compt<pimage_3d->the_image.width*pimage_3d->the_image.height;compt++)
    pimage_3d->zbuf[compt] = 0x7FFFFFFF;
}
/***************************/

/***************************/
/* reinitialise le obj_buf */
void clear_obj_buf(image_3d *pimage_3d)
{ uint32 compt;
  /* place la valeur la plus eloigne possible dans tout l'obj buffer */
  for(compt=0;compt<pimage_3d->the_image.width*pimage_3d->the_image.height;compt++)
    pimage_3d->obj_buf[compt] = -1;
}
/***************************/

/*****************************/
/* repaint le fond avec ppix */
void clear_img(image_3d *pimage_3d,pix ppix)
{ uint32 compt;
  
  /* place la valeur la plus eloigne possible dans tout l'obj buffer */
  for(compt=0;compt<pimage_3d->the_image.width*pimage_3d->the_image.height;compt++)
    pimage_3d->the_image.buf[compt] = ppix;
}
/*****************************/

/*
void polygone(dot_3d pix1,dot_3d pix2,dot_3d pix3,color col1,color col2,color col3)
{
  
}
*/

void line_3d(dot_3d pix1,dot_3d pix2,color col1,color col2)
{ int32 x,y,d,x1,y1,x2,y2,deltax,deltay;
  color tmp_col;

  /* converti les coordonnees 3D en 2D */
  x1=(pix1.x<<8)/(XScale+pix1.z)+(current_width>>1);
  x2=(pix2.x<<8)/(XScale+pix2.z)+(current_width>>1);

  y1=(pix1.y<<8)/(YScale+pix1.z)+(current_height>>1);
  y2=(pix2.y<<8)/(YScale+pix2.z)+(current_height>>1);

  /* tri pour que x1 <= x2 */
  if(x2 > x1)
  {
    x = x1; x1 = x2; x2 = x;
    y = y1; y1 = y2; y2 = y;
    tmp_col = col1; col1 = col2; col2 = tmp_col;
  }

  deltax = x2 - x1;
  deltay = y2 - y1;

  for(x = x1, y = y1, d = (deltay << 1) - deltax; x <= x2; x++)
  {
    /* Dessine un pixel si dans l'image */
    if((x >= 0) && (x < current_width) && (y >= 0) && (y < current_height))
    {
      buf[(y*current_width<<2)+x].r = 0x90;
      buf[(y*current_width<<2)+x].g = 0x78;
      buf[(y*current_width<<2)+x].b = 0xF0;
    }
    if(d < 0)
      d = d + (deltay << 1);
    else {
      d = d + ((deltay - deltax)<<1);
      y++;
    }
  }
}

void h_ligne_shade(int32 x1, int32 z1, uint8 colR1, uint8 colG1, uint8 colB1,
  int32 x2, int32 z2, uint8 colR2, uint8 colG2, uint8 colB2, int32 y);

void Triangle(dot_3d pix1,dot_3d pix2,dot_3d pix3,color col1,color col2,color col3)
{
  int32  deltay,yinc,save1,save2,save3;
  int32  deltax,stock;
  int32  deltaz,stockz;
  uint32 deltaR,stockR,deltaG,stockG,deltaB,stockB;

  if(current_matrice != NULL)
  {
    trans_pix(&pix1, &pix1, current_matrice);
    trans_pix(&pix2, &pix2, current_matrice);
    trans_pix(&pix3, &pix3, current_matrice);
  }
  Tri3D2D(&pix1,&pix2,&pix3,&col1,&col2,&col3);

  if(pix1.y != pix3.y){
    deltay = pix3.y - pix1.y;
    deltax = ((pix3.x - pix1.x)<<8)/deltay;

    deltaz = ((pix3.z - pix1.z)<<8)/deltay;

    deltaR = ((col3.r - col1.r)<<8)/deltay;
    deltaG = ((col3.g - col1.g)<<8)/deltay;
    deltaB = ((col3.b - col1.b)<<8)/deltay;
    stock  = pix1.x << 8;
    
    stockz = pix1.z << 8;

    stockR = ((uint32)col1.r)<<8;
    stockG = ((uint32)col1.g)<<8;
    stockB = ((uint32)col1.b)<<8;
    save1 = pix1.y; save2 = pix3.y;
    while(pix1.y < 0){
      stock  += deltax;
      stockz += deltaz;
      stockR += deltaR; stockG += deltaG; stockB += deltaB;
      pix1.y++;
    }
    if(pix3.y >= current_height) pix3.y = current_height - 1;
/*    if(pix3.y < 0) pix3.y = 0;*/
    for(yinc=pix1.y;yinc<=pix3.y;yinc++){

      x1[yinc] = stock  >> 8;
      z1[yinc] = stockz >> 8;
            
      COLR1[yinc] = (uint8)(stockR>>8); COLG1[yinc] = (uint8)(stockG>>8);
      COLB1[yinc] = (uint8)(stockB>>8);

      stock  += deltax;
      stockz += deltaz;
      stockR += deltaR; stockG += deltaG; stockB += deltaB;
    }
    pix1.y = save1; pix3.y = save2;
  }

  if(pix1.y != pix2.y){ 
    deltay = pix2.y - pix1.y;
    deltax = ((pix2.x - pix1.x)<<8)/deltay;

    deltaz = ((pix2.z - pix1.z)<<8)/deltay;

    deltaR = ((col2.r-col1.r)<<8)/deltay;
    deltaG = ((col2.g-col1.g)<<8)/deltay;
    deltaB = ((col2.b-col1.b)<<8)/deltay;
    stock  = pix1.x << 8;

    stockz = pix1.z << 8;

    stockR = ((uint32)col1.r)<<8;
    stockG = ((uint32)col1.g)<<8;
    stockB = ((uint32)col1.b)<<8;
    save1 = pix1.y; save2 = pix2.y;
    while(pix1.y < 0){
      stock  += deltax;
      stockz += deltaz;
      stockR += deltaR; stockG += deltaG; stockB += deltaB;
      pix1.y++;
    }
      
    if(pix2.y >= current_height) pix2.y = current_height - 1;
/*    if(pix2.y < 0) pix2.y = 0;*/
    
    for(yinc=pix1.y;yinc<=pix2.y;yinc++){

      x2[yinc] = stock >> 8;
      z2[yinc] = stockz >> 8;

      COLR2[yinc] = (uint8)(stockR>>8); COLG2[yinc] = (uint8)(stockG>>8);
      COLB2[yinc] = (uint8)(stockB>>8);

      stock  += deltax;
      stockz += deltaz;
      stockR += deltaR; stockG += deltaG; stockB += deltaB;
    }
    pix1.y = save1; pix2.y = save2;
  }

  if(pix2.y != pix3.y){ /* si la base est plate, on ne fait pas cela */
    deltay = pix3.y - pix2.y;
    deltax = ((pix3.x - pix2.x)<<8)/deltay;

    deltaz = ((pix3.z - pix2.z)<<8)/deltay;

    deltaR = ((col3.r-col2.r)<<8)/deltay;
    deltaG = ((col3.g-col2.g)<<8)/deltay;
    deltaB = ((col3.b-col2.b)<<8)/deltay;
    stock  = pix2.x << 8;

    stockz = pix2.z << 8;

    stockR = ((uint32)col2.r)<<8;
    stockG = ((uint32)col2.g)<<8;
    stockB = ((uint32)col2.b)<<8;
    save1  = pix2.y; save2 = pix3.y;

    while(pix2.y < 0){
      stock  += deltax;
      stockz += deltaz;
      stockR += deltaR; stockG += deltaG; stockB += deltaB;
      pix2.y++;
    }
      
    if(pix3.y >= current_height) pix3.y = current_height - 1;
/*    if(pix3.y < 0) pix3.y = 0;*/
    
    for(yinc=pix2.y;yinc<=pix3.y;yinc++){
      x2[yinc] = stock >> 8;
      z2[yinc] = stockz >> 8;

      COLR2[yinc] = (uint8)(stockR>>8); COLG2[yinc] = (uint8)(stockG>>8);
      COLB2[yinc] = (uint8)(stockB>>8);

      stock  += deltax;
      stockz += deltaz;
      stockR += deltaR; stockG += deltaG; stockB += deltaB;
    }
    pix2.y = save1; pix3.y = save2;
    
  } /* fin si la base n'est pas plate */

  if(pix3.y >= current_height) pix3.y = current_height-1;
  if(pix2.y >= current_height) pix2.y = current_height-1;
  if(pix1.y >= current_height) pix1.y = current_height-1;
  if(pix1.y < 0) pix1.y = 0;
/*  if(pix2.y < 0) pix2.y = 0;
  if(pix3.y < 0) pix3.y = 0;
*/
  /* affiche ce que l'on vient de calculer */
  for(yinc=pix1.y;yinc<=pix3.y;yinc++){
    if(x1[yinc]>x2[yinc])
      h_ligne_shade(x2[yinc],z2[yinc],COLR2[yinc],COLG2[yinc],COLB2[yinc],
        x1[yinc],z1[yinc],COLR1[yinc],COLG1[yinc],COLB1[yinc],yinc);
    else
      h_ligne_shade(x1[yinc],z1[yinc],COLR1[yinc],COLG1[yinc],COLB1[yinc],
        x2[yinc],z2[yinc],COLR2[yinc],COLG2[yinc],COLB2[yinc],yinc);
  }
}

/***********************************************************/
/* dessine une ligne horizontale                           */
/* y doit etre dans l'image et x1 doit etre inferieur a x2 */
/* cette procedure ce sert des variables d'environnement   */
void h_ligne_shade(
  int32 x1,int32 z1, uint8 colR1, uint8 colG1, uint8 colB1,
  int32 x2,int32 z2, uint8 colR2, uint8 colG2, uint8 colB2, int32 y)
{
  uint32 deltaR,deltaG,deltaB,colR,colG,colB,col;
  uint32 YLigne;
  uint32 ZBufOff;
  int32  deltaZ,Z;
  int32  xinc,deltax;

  /* si la ligne et totalement hors image, on ne la dessine pas */
  if((x2<0) || (x1>=current_width)) return;
    
  YLigne  = (uint32)y * (uint32)current_width;
  ZBufOff = YLigne + x1;
    
  if(x1==x2) /* si la ligne ne fait qu'un point */
  {
    if(z1 < zbuf[ZBufOff])
    {
      zbuf[ZBufOff] = z1;
      obj_buf[ZBufOff] = current_obj;
      buf[YLigne+x1].r = (colR1>>1)+(colR2>>1);
      buf[YLigne+x1].g = (colG1>>1)+(colG2>>1);
      buf[YLigne+x1].b = (colB1>>1)+(colB2>>1);
    }
    
  } else if(x1 == x2-1) { /* si la ligne ne fait que deux points */
    if((x1 >= 0) && (x1 < current_width) && (z1 < zbuf[ZBufOff]))
    {
      zbuf[ZBufOff] = z1;
      obj_buf[ZBufOff] = current_obj;      
      buf[YLigne+x1].r = colR1;
      buf[YLigne+x1].g = colG1;
      buf[YLigne+x1].b = colB1;
    }

    if((x2 >= 0) && (x2 < current_width) && (z2 < zbuf[ZBufOff+1]))
    {
      zbuf[ZBufOff+1] = z2;
      obj_buf[ZBufOff+1] = current_obj;      
      buf[YLigne+x1].r = colR2;
      buf[YLigne+x1].g = colG2;
      buf[YLigne+x1].b = colB2;       
    }

  } else { /* si la ligne fait plus de deux points */
    /* technique par calcul de pas, inexacte mais rapide */
    /* A AMELIORER ICI PAR LA SUITE */

    deltax = x2 - x1;

    deltaZ = ((z2 - z1) << 10) / deltax;

    deltaR = ((colR2 - colR1) << 10) / deltax;
    deltaG = ((colG2 - colG1) << 10) / deltax;
    deltaB = ((colB2 - colB1) << 10) / deltax;

    Z = z1 << 10;

    colR = ((uint32)colR1) << 10;
    colG = ((uint32)colG1) << 10;
    colB = ((uint32)colB1) << 10;
    
    while(x1 < 0){ /* tantque x1 or ecran */
      Z    += deltaZ;
      colR += deltaR;
      colG += deltaG;
      colB += deltaB;
      x1++;
    }
    
    if(x2 >= current_width) x2 = current_width - 1; /* si x2 or ecran */
    
    for(xinc=x1;xinc<x2;xinc++){

      if(( Z >> 10) < zbuf[ZBufOff]){
        zbuf[ZBufOff] = Z >> 10;
        obj_buf[ZBufOff] = current_obj;
      
        buf[YLigne+xinc].r = (uint8)(colR>>10);
        buf[YLigne+xinc].g = (uint8)(colG>>10);
        buf[YLigne+xinc].b = (uint8)(colB>>10);
      }

      ZBufOff++;
      Z    += deltaZ;
      colR += deltaR;
      colG += deltaG;
      colB += deltaB;
    }
 }
}
/***********************************************************/

void DrawObj(uint32 NbFace,dot_3d *PtrVert,face *PtrFace,dot_3d *Normal)
{ uint32 xinc;

  for(xinc=0;xinc<NbFace;xinc++)
   Triangle(PtrVert[PtrFace[xinc].pt1]
           ,PtrVert[PtrFace[xinc].pt2]
           ,PtrVert[PtrFace[xinc].pt3]
           ,PtrFace[xinc].col1,PtrFace[xinc].col2,PtrFace[xinc].col3);
}

/* un tetraedre pour tester le moteur 3D */
dot_3d test_dot[4]  = {0,60,0,    -40,-40,0,    40,-40,0,    0,0,60};
face   test_face[4] = {
   0,1,2,0,    {255,0,0},    {0,255,0},    {0,0,255},
   0,1,3,0,    {255,255,0},  {255,0,255},  {128,128,128},
   0,2,3,0,    {255,255,0},  {255,0,255},  {28,28,28},
   1,2,3,0,    {255,255,0},  {255,0,255},  {128,128,128}};
   
obj_3d test_obj = {
  /* numero d'identifiant de l'objet (utilise dans obj_buf) */
  1,
  /* nombre de polygone de cet objet */
  4,
  /* definition de tout les polygones */
  test_face,
  /* definition de tout les points (utilise dans les polygones) */
  test_dot,
  /* vecteur normaux (utilise dans les polygones) */
  NULL,
  /* transformation a appliquer sur l'objet (null si aucune) */
  NULL
};

/************************/
/* recalcule l'image 3d */
void image_3d_render(image_3d *pimage_3d)
{ obj_list *list_pos;
  int32 vmat[16];

  /* reinitialisation du zbuffer */
  clear_zbuf(pimage_3d);
  /* reinitialisation du buffer objets */
  clear_obj_buf(pimage_3d);
  /* repaint le fond */
  clear_img(pimage_3d,pimage_3d->background);

  /* mise en place de variable d'environnement */
  buf  = pimage_3d->the_image.buf;
  zbuf = pimage_3d->zbuf;
  obj_buf = pimage_3d->obj_buf;
  current_width  = pimage_3d->the_image.width;
  current_height = pimage_3d->the_image.height;
  current_width_mul_height = current_width * current_height;
  x1 = pimage_3d->x1; x2 = pimage_3d->x2;
  z1 = pimage_3d->z1; z2 = pimage_3d->z2;  
  COLR1 = pimage_3d->COLR1; COLR2 = pimage_3d->COLR2;
  COLG1 = pimage_3d->COLG1; COLG2 = pimage_3d->COLG2;  
  COLB1 = pimage_3d->COLB1; COLB2 = pimage_3d->COLB2;    

  list_pos = pimage_3d->list.next;
  while(list_pos != NULL)
  {
    /* calcul de la matrice de transformation pour cet objet */
    if(pimage_3d->global_mat != NULL)
    {
      if(list_pos->obj->obj_mat != NULL)
      {
        mul_mat(vmat, list_pos->obj->obj_mat, pimage_3d->global_mat);
        current_matrice = vmat;
      } else { current_matrice = pimage_3d->global_mat; }
    } else {
      if(list_pos->obj->obj_mat != NULL) 
        current_matrice = list_pos->obj->obj_mat;
      else current_matrice =  NULL;
    }
    /* identifiant de l'objet pour l'obj_buf */
    current_obj = list_pos->obj->id;
    /* on dessine l'objet */
    DrawObj(list_pos->obj->nb_face, list_pos->obj->dot, list_pos->obj->face,
      list_pos->obj->normal);
    /* passe a l'objet suivant */
    list_pos = list_pos->next;
  }
}
/************************/

/******************************************/
/* rempli les tables de cosinus et sinus  */
void init_cos_sin(void)
{ int32  pos;

  if((sin_table=(int32 *)malloc(sizeof(int32)*1280)) == NULL)
  { perror("malloc failed\n"); exit(1); }
  cos_table = &sin_table[256];
  for(pos = 0; pos < 1280; pos++)
  { sin_table[pos] = sin((pos*2.0*M_PI)/1024.0) * 1024.0; }
}
/******************************************/

/******************************/
/* cree une nouvelle image 3d */
image_3d *image_3d_new(int32 width, int32 height)
{ image_3d *vimage_3d;
  
  if(sin_table == NULL) init_cos_sin();
  
  /* allocation de la structure elle meme */ 
  if((vimage_3d=(image_3d *)malloc(sizeof(image_3d))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  vimage_3d->the_image.width = width; vimage_3d->the_image.height = height;
  /* allocation du buffer ou dessiner l'image */
  if((vimage_3d->the_image.buf=(pix *)malloc(width*height*sizeof(pix))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  /* allocation du zbuffer correspondant a l'image */  
  if((vimage_3d->zbuf=(int32 *)malloc(width*height*sizeof(int32))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  /* allocation du buffer d'objects correspondant a l'image */
  if((vimage_3d->obj_buf=(uint32 *)malloc(width*height*sizeof(uint32))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  /* les buffers qui suivent sont pour faire les calculs */
  if((vimage_3d->x1=(int32 *)malloc(height*sizeof(int32))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->x2=(int32 *)malloc(height*sizeof(int32))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->z1=(int32 *)malloc(height*sizeof(int32))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->z2=(int32 *)malloc(height*sizeof(int32))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->COLR1=(uint8 *)malloc(height*sizeof(uint8))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->COLR2=(uint8 *)malloc(height*sizeof(uint8))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->COLG1=(uint8 *)malloc(height*sizeof(uint8))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->COLG2=(uint8 *)malloc(height*sizeof(uint8))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->COLB1=(uint8 *)malloc(height*sizeof(uint8))) == NULL)
  { perror("malloc failed\n"); exit(1); }
  if((vimage_3d->COLB2=(uint8 *)malloc(height*sizeof(uint8))) == NULL)
  { perror("malloc failed\n"); exit(1); }

  /* pas d'objet au debut */
  vimage_3d->list.next = NULL;
  /* pas de transformation global au debut */
  vimage_3d->global_mat = NULL;
  /* par defaut le fond est noir */
  vimage_3d->background.r = 0; vimage_3d->background.g = 0; 
  vimage_3d->background.b = 0; vimage_3d->background.p = 0;

  /* pour tester */
  image_3d_prepend_obj(vimage_3d, &test_obj);
  
  return(vimage_3d);
}
/******************************/

/***********************/
/* libere une image_3d */
void image_3d_free(image_3d *pimage_3d)
{ obj_list *list_pos,*list_pos_last;

  free(pimage_3d->the_image.buf);
  free(pimage_3d->zbuf);
  free(pimage_3d->obj_buf);
  free(pimage_3d->x1); free(pimage_3d->x2);
  free(pimage_3d->z1); free(pimage_3d->z2);
  free(pimage_3d->COLR1); free(pimage_3d->COLR2);
  free(pimage_3d->COLG1); free(pimage_3d->COLG2);
  free(pimage_3d->COLB1); free(pimage_3d->COLB2);
  /* libere la liste des objets */
  list_pos = pimage_3d->list.next;
  while(list_pos != NULL)
  {
    list_pos_last = list_pos;
    list_pos = list_pos->next;
    free(list_pos_last);
  }
  
  free(pimage_3d);
}
/***********************/

/****************************************/
/* choisi le type de pixel pour le fond */
void image_3d_set_bg_ext(image_3d *pimage_3d, uint8 r, uint8 g, uint8 b, uint8 p)
{ pix vpix;

  vpix.r = r; vpix.g = g; vpix.b = b; vpix.p = p;
  image_3d_set_bg(pimage_3d, vpix);
}
void image_3d_set_bg(image_3d *pimage_3d, pix ppix)
{ pimage_3d->background = ppix; }
/****************************************/

/************************************************************************/
/* choisi la matrice de transformation qui s'applique a tout les objets */
/* la matrice n'est pas recopie, toute modification de l'original et    */
/* donc repercute. Sa deallocation et aussi a la charge de l'appelant   */
void image_3d_set_global_mat(image_3d *pimage_3d, int32 *pmat)
{ pimage_3d->global_mat = pmat; }
/************************************************************************/

/*********************************************************************/
/* ajoute un objet 3d a l'image 3d, l'objet n'est pas recopie, toute */
/* modification sur l'original et donc repercute. L'objet et donc    */
/* sa deallocation sont a la charge de l'appelant.                   */
void image_3d_prepend_obj(image_3d *pimage_3d, obj_3d *obj)
{ obj_list *list_new;

  if((list_new = (obj_list *)malloc(sizeof(obj_list))) == NULL)
  { perror("malloc failed\n"); exit(1); }

  list_new->obj  = obj;
  list_new->next = pimage_3d->list.next;
  pimage_3d->list.next = list_new;
}
/*********************************************************************/
