#!/usr/bin/env python
"""Installs properties using distutils

Run:
	python setup.py install
to install the packages from the source archive.
"""

if __name__ == "__main__":
	import os, sys, string
	try:
		import py2exe
	except ImportError:
		pass
	from distutils.command.install_data import install_data
	from distutils.sysconfig import *
	from distutils.core import setup

	def isPackage( filename ):
		return os.path.isdir(filename) and os.path.isfile( os.path.join(filename,'__init__.py'))
	def packagesFor( filename, basePackage="" ):
		"""Find all packages in filename"""
		set = {}
		for item in os.listdir(filename):
			dir = os.path.join(filename, item)
			if isPackage( dir ):
				if basePackage:
					moduleName = basePackage+'.'+item
				else:
					moduleName = item
				set[ moduleName] = dir
				set.update( packagesFor( dir, moduleName))
		return set
	def npFilesFor( dirname ):
		"""Return all non-python-file filenames in dir"""
		result = []
		allResults = []
		for name in os.listdir(dirname):
			path = os.path.join( dirname, name )
			if os.path.isfile( path) and os.path.splitext( name )[1] not in ('.py','.pyc','.pyo'):
				result.append( path )
			elif os.path.isdir( path ) and name.lower() !='cvs':
				allResults.extend( npFilesFor(path))
		if result:
			allResults.append( (dirname, result))
		return allResults
	def scriptFilesFor( dirname ):
		result = []
		allResults = []
		for name in os.listdir(dirname):
			path = os.path.join( dirname, name )
			if os.path.isfile( path) and os.path.splitext( name )[1] == '.py':
				result.append( path )
			elif os.path.isdir( path ) and name.lower() !='cvs':
				allResults.extend( npFilesFor(path))
		if result:
			allResults.append( (dirname, result))
		return allResults
	def notHTML( dirset ):
		newset = []
		for directory, files in dirset:
			if directory == os.path.join('pytable','doc','pydoc'):
				newFiles = []
				for file in files:
					if not os.path.splitext(file)[1].lower() == '.html':
						newFiles.append( file )
				if newFiles:
					newset.append( (directory,newFiles))
			else:
				newset.append( (directory,files))
		return newset
	

	##############
	## Following is from Pete Shinners,
	## apparently it will work around the reported bug on
	## some unix machines where the data files are copied
	## to weird locations if the user's configuration options
	## were entered during the wrong phase of the moon :) .
	from distutils.command.install_data import install_data
	class smart_install_data(install_data):
		def run(self):
			#need to change self.install_dir to the library dir
			install_cmd = self.get_finalized_command('install')
			self.install_dir = getattr(install_cmd, 'install_lib')
			return install_data.run(self)
	##############
	
	packages = packagesFor( "." )
	dataFiles = (
		notHTML(npFilesFor( 'pytable')) +
		scriptFilesFor( os.path.join('pytable','tests')) +
		scriptFilesFor( os.path.join('pytable','examples')) +
		notHTML(npFilesFor( os.path.join('pytable','doc'))) +
		scriptFilesFor( os.path.join('pytable','doc', 'pydoc'))
	)
	from distutils.sysconfig import *
	from distutils.core import setup

	from sys import hexversion
	if hexversion >= 0x2030000:
		# work around distutils complaints under Python 2.2.x
		extraArguments = {
			'classifiers': [
				"""License :: OSI Approved :: BSD License""",
				"""Programming Language :: Python""",
				"""Topic :: Software Development :: Libraries :: Python Modules""",
				"""Intended Audience :: Developers""",
				"""Operating System :: OS Independent""",
				"""Topic :: Database""",
			],
			'download_url': "https://sourceforge.net/project/showfiles.php?group_id=87033",
			'keywords': 'database,postgresql,mysql,db-api,object-relational mapper,basicproperty,property,descriptor,schema,query,sql',
			'long_description' : """BasicProperty-based RDBMS Wrapper

PyTable provides a schema-based mechanism for constructing
database-based applications.  Included is a fairly elegant
SQLQuery object which makes creation of complex SQL in response
to application requirements somewhat easier, as well as
classes allowing the modelling of database schemas.

Can read MySQL and PostgreSQL schemas from live databases.
Can build databases from schemas.
Does not attempt to abstract away differences in SQL syntax.
Provides optional object-oriented row-wrappers with
BasicProperty properties defining fields.
""",
			'platforms': ['Any'],
		}
	else:
		extraArguments = {
		}

	setup (
		name = "pytable",
		version = "0.8.3a",
		description = "BasicProperty-based RDBMS Wrapper",
		author = "Mike C. Fletcher",
		author_email = "mcfletch@users.sourceforge.net",
		url = "http://pytable.sourceforge.net/",
		license = "BSD-style, see license.txt for details",

		package_dir = packages,

		packages = packages.keys(),
		data_files = dataFiles,
		cmdclass = {'install_data':smart_install_data},
		**extraArguments
	)
	
