/*
   Copyright (c) 2000 MicroSource

   This source file and all accompanying files are the exclusive property
   of the author Paul Carapetis and MicroSource, and no modifications are
   to be performed on said source without expressed permission from the
   author or an authorised representative of MicroSource, unless the
   purpose of such modifications is to effect a successful compile on your
   platform.

   This source is only to be distributed in its complete form and only with
   all of the following files included:

        INSTALL
        README
        ibmchars.uu
        license.doc
        newargs.txt
        pcps.man
        register.doc

        makefile
        define.h
        pcps.c
        pcps.h
        struct.h
        unix.c
        unix.h
        valargs.h

   The utility "PCPS" is a SHAREWARE product and you, as the user, agree
   that the source will be removed from your filesystem once the utility
   has been successfully compiled and is found to be functional.  Any
   changes to the source that were required for a successful compile must
   be returned to the author for inclusion in the main source control.

   The utility may be trialed for the period of time mentioned in the file
   license.doc, but must either be registered or destroyed within said
   trial time.  The cost and method of registration is detailed in the file
   license.doc.

Author:  Paul Carapetis  Internet: Paul_Carapetis@iname.com
Company: MicroSource     Snail:    10 Denise Court
                                   Narre Warren
                                   Australia  3805

*/
#ifndef PCPS_DEFI
# define PCPS_DEFI

/*****************************************************************************/
/*    The all important version :-)                                          */
/*****************************************************************************/

#define VERS  "8.40"           /* Update this when source is updated */

/* make sure that one of __TURBOC__, UNIX, MSVC32 or MSC is defined */
#ifndef UNIX
# ifndef __TURBOC__
#  ifndef MSVC32
#   define MSC
  /* for family mode */
#   define INCL_VIO
#   define INCL_DOS
#  endif
# endif
#endif

/*****************************************************************************/
/* OK, here follows a lot of ugly #ifdef's to handle different flavours of   */
/* MSDOS, OS/2, Windows and UNIX versions.                                   */
/*****************************************************************************/


#ifndef UNIX

#include <dos.h>
#include <io.h>
#include <conio.h>
#include <sys\\types.h>
#include <sys\\stat.h>

#define PD '\\'           /* path delimiter */

#else                     /* UNIX */

/* all headers common to all platforms */
#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <signal.h>

#define PD '/'

/* now we get messy trying to work out who needs what :-) */

# ifdef SUNOS
# include <sys/unistd.h>
# else
# include <unistd.h>
# endif

# if defined (SUN386i) || defined (ULTRIX)
# include <sys/file.h>
# endif

# ifdef LINUX
# include <bsd/signal.h>
# endif

#endif

/* some basic differences between Turbo-c and MSC family */
/* now add 32bit for Win95 & NT */
/* also unix */
#ifdef __TURBOC__
/* Turbo-C DOS only mode */

#include <alloc.h>
#include <dir.h>
#define MAX_PATH MAXPATH
#define MODE " DOS  Mode "
#define HFREE(x) farfree((char far *)x)
 typedef unsigned char BOOL;

#else 
# ifdef MSC
/* MSC family mode */

# include <os2.h>
# include <malloc.h>
# define MAX_PATH _MAX_PATH
# define MODE "Family Mode"
# define HFREE(x) hfree(x)

# else
#  ifdef MSVC32
/* 32 bit MSVC mode */

#  include <malloc.h>
#  include <windows.h>

#  define MODE " W32  mode "
#  define HFREE(x) free(x)
#  define PROGNAME "PCPS32"

#  else /* UNIX */

#  ifndef NEXT                 /* NeXT has malloc stuff in stdlib */
#   include <malloc.h>
#  endif
#  include <limits.h>
#  define MAX_PATH MAXPATHLEN
#  define MODE " Unix Mode "
#  define HFREE(x) free(x)
#  define PIPESTR  "printer "
  typedef unsigned char BOOL;
#  endif
# endif
#endif

/*****************************************************************************/
/*                         Global Declarations                               */
/*****************************************************************************/

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef ERROR
#define ERROR 1
#endif

#define DEFDATE (char)1
#define USDATE  (char)2
#define EURDATE (char)3

#define CTLD 0x04
#define CTLZ 0x1a
#define COLON (char)':'
#define COMMA (char)','
#define ELAN  (char)'-'
#define DOLLAR (char)'$'

#define CR 0x0d
#define LF 0x0a
#define FF 0x0c
#define TAB 0x09
#define SPACE (char)0x20

#define HIGHCHAR (char)0x7f

#define TEMPFILE "TEMP_PS.$$$"
#define BACKTEXTCHARS 40
#define TMSZ 256
#define SMLBUF 140

#define ANNOY "IF YOU FIND THIS PRODUCT USEFUL, PLEASE REGISTER IT."
#define COPYRIGHT "(c) 2000 MicroSource"

#define EVENPAGES 0 /* for -a and -z argument */
#define ODDPAGES  1

#define TOP       0 /* for -h argument */
#define BOTTOM    1

#define HELP      1 /* for MyExit() */
#define NOHELP    0

#define SP        "%%Page:"

#define SPAGE     "--SP"     /* for -i to temp file */
#define EPAGE     "--EP\n"     /* for -i to temp file */

#define HEADER   0  /* for Font[3][30] */
#define NORMAL   1  /* for Font[3][30] */
#define ENHANCED 2  /* for Font[3][30] */

#define IBMF      "IBMPCFont"
#define CB        "Courier-Bold"

/* char re-encoding strings */
#define ISOARRAY  "ISOLatin1Encoding"
#define ISOFUNC   "NewEncode"
#define EUROARRAY "European"
#define EUROFUNC  "ReEncodeSmall"

/* enhaced font styles - index into each element of FontList struct */
#define BOLD       0
#define ITALIC     1
#define BOLDITALIC 2

/* modes (-mo) */

#define M_NONE     0    /* no mode */
#define M_MAN      1    /* man page */
#define M_MAIL     2    /* mail msg */
#define M_CPLUS    3    /* C/C++ comments */
#define M_4GL      4    /* 4GL comments */
#define M_SHELL    5    /* Shell/PERL comments */
#define M_PASC     6    /* Pascal comments */
#define M_FORT     7    /* Fortran comments */

/* MACROS */

#define SHOW        if(!bNoDisplay) fprintf
#define OUTLINE(X)  if(*X){bblinedone?SLine(X):BorWLine(X);bblinedone=TRUE;}


/*****************************************************************************/
/*    Define some paper and margin sizes and paper structures                */
/*    All units are 1/72 of inch multiplied by 20 as we scale .05            */
/*****************************************************************************/

#define A0 "a0"
#define A0_H          67360L   /* height of A0 paper                 - 46.80" */
#define A0_W          47600L   /* width of A0 paper                  - 33.11" */
#define A0_2UP        ".7"     /* scale for 2-up */
#define A1 "a1"
#define A1_H          47600L   /* height of A1 paper                 - 33.11" */
#define A1_W          33680L   /* width of A1 paper                  - 23.39" */
#define A1_2UP        ".7"     /* scale for 2-up */
#define A2 "a2"
#define A2_H          33680L   /* height of A2 paper                 - 23.39" */
#define A2_W          23800L   /* width of A2 paper                  - 16.54" */
#define A2_2UP        ".7"     /* scale for 2-up */
#define A3 "a3"
#define A3_H          23800L   /* height of A3 paper                 - 16.54" */
#define A3_W          16840L   /* width of A3 paper                  - 11.69" */
#define A3_2UP        ".7"     /* scale for 2-up */
#define A4 "a4"
#define A4_H          16840L   /* height of A4 paper                 - 11.69" */
#define A4_W          11840L   /* width of A4 paper                  -  8.22" */
#define A4_2UP        ".7"     /* scale for 2-up */
#define LT "letter"
#define LT_H          15840L   /* height of letter paper (US)        - 11.00" */
#define LT_W          12240L   /* width of letter paper (US)         -  8.50" */
/* Losing rhs of box in -up2 - try making it slightly smaller */
/*#define LT_2UP        ".65" */   /* scale for 2-up */
#define LT_2UP        ".61"    /* scale for 2-up */
#define LG "legal"
#define LG_H          20160L   /* height of legal paper              - 14.00" */
#define LG_W          12240L   /* width of legal paper               -  8.50" */
#define LG_2UP        ".61"    /* scale for 2-up */
#define EX "executive"
#define EX_H          15120L   /* height of executive paper          - 10.50" */
#define EX_W          10440L   /* width of executive paper           -  7.25" */
#define EX_2UP        ".69"    /* scale for 2-up */
#define CO "com10envelope"
#define CO_H          13680L   /* height of com10 envelope           -  9.50" */
#define CO_W           5940L   /* width of com10 envelope            - 4.125" */
#define CO_2UP        ".43"    /* scale for 2-up */
#define MO "monarcenvelope"
#define MO_H          10800L   /* height of monarch envelope         -  7.50" */
#define MO_W           5580L   /* width of monarch envelope          - 3.875" */
#define MO_2UP        ".52"    /* scale for 2-up */
#define DL "dlenvelope"
#define DL_H          12472L   /* height of DL envelope              - 220mm  */
#define DL_W           6236L   /* width of DL envelope               - 110mm  */
#define DL_2UP        ".50"    /* scale for 2-up */

#define ALL_4UP       ".49"    /* just a little less than .5 */

#define NUMPAPERSIZES 11

/* the following three defines are for a LaserWriter II NTX */
#define LR_MIN_MARG   300      /* min margin for Left and Right edge -  0.21" */
#define TB_MIN_MARG   300      /* min margin for Top and Bottom edge -  0.21" */
#define MAX_PR_LINE   11660    /* maximum printable line width       -  8.10" */

#define NUMBFONTS 36

#endif /* PCPS_DEFI */
