#include <fstream>
#include <algorithm>
#include "ordTop.h"
#include "validate.h"

using namespace ord;
using namespace std;

#define LIM_ELT_TST(code, base) { \
    outStream() << "Test " << #code << "\n" ;\
    (base).listElts(count,doTest); \
    (base).descend(3,8) ;}

void Validate::limitEltExitCodeTest()
{
    bool doTest = true ;
    int count = 10 ;

    const Ordinal& dda = admisLevelFunctional(Ordinal::three,zero,
        NULL,Ordinal::five);
    LIM_ELT_TST(DDA,dda);

    const Ordinal& la = admisLevelFunctional(Ordinal::three,omega,
        createParameters(&one,&(psi(omega,omega)),&zero,&zero));
    LIM_ELT_TST(LA,la);

    const Ordinal& la2 = admisLevelFunctional(Ordinal::three,omega,
        createParameters(&one,&omega1CK,&zero,&zero));
    LIM_ELT_TST(LA-2,la2);

    const Ordinal& lb = admisLevelFunctional(Ordinal::three,omega^omega);
    LIM_ELT_TST(LB,lb);
    
    const Ordinal& eddc = admisLevelFunctional(omega^omega,zero,NULL,
        zero,omega);
    LIM_ELT_TST(EDDC,eddc);

    const Ordinal& lc = admisLevelFunctional(psi(omega^omega,omega),zero);
    LIM_ELT_TST(LC,lc);

    const Ordinal& psiwtwcwpw = psi(omega^omega,omega)+Ordinal::five;
    const Ordinal& cllm = admisLevelFunctional(psi(omega^omega,omega),zero,
        createParameters(&psiwtwcwpw),zero,psi(omega^omega,omega));
    LIM_ELT_TST(CLLM,cllm);

    const Ordinal& psiwcwp2 = admisLevelFunctional(psi(omega^omega,omega),zero,
        createParameters (&psi(omega^omega,Ordinal::five)),zero,
        psi(omega^omega,Ordinal::five)) + psi(omega,omega)+Ordinal::one;
    const Ordinal &dlt = psi(omega^(psi(omega,omega)+one),omega) ;
    const Ordinal& cllm2 = admisLevelFunctional(dlt,zero,
        createParameters(&psiwcwp2),zero,dlt) ;
    LIM_ELT_TST(CLLM-1,cllm2);

    const Ordinal & paramDelt = *new Ordinal(10000);
    const Ordinal & param = admisLevelFunctional(paramDelt,zero,NULL,zero,
        paramDelt)+Ordinal::five ;

    const Ordinal& cllm3 = admisLevelFunctional(omega,zero,
        createParameters(&param),zero,omega);
    LIM_ELT_TST(CLLM-2,cllm3);


    const Ordinal& cklm = admisLevelFunctional(psi(omega^omega,omega),zero,
        createParameters(&psiwtwcwpw),zero,
        psi(omega,omega)+ Ordinal::five);
    LIM_ELT_TST(CKLM,cklm);

    const Ordinal& psiwcwp1 = psi(omega,omega)+Ordinal::one;
    const Ordinal& cklm1 = admisLevelFunctional(psi(omega^omega,omega),zero,
        createParameters(&psiwcwp1),zero,psi(omega,omega)+Ordinal::one);
    LIM_ELT_TST(CKLM-1,cklm1);
   
        
}

void Validate::limitEltExitCodeTest1()
{
    bool doTest = true ;
    int count = 10 ;

    const Ordinal cksc = admisLevelFunctional(one,zero,createParameters(&one),zero,
        one);
    LIM_ELT_TST(CKSC,cksc);

    const Ordinal cksc1 = admisLevelFunctional(Ordinal::three,zero,
        createParameters(&one),zero, Ordinal::two);
    LIM_ELT_TST(CKSC-1,cksc1);

    const Ordinal cksc2 = admisLevelFunctional(one,zero,createParameters(&Ordinal::two),
        zero, Ordinal::one);
    LIM_ELT_TST(CKSC-2,cksc2);

    const Ordinal cksc3 = admisLevelFunctional(Ordinal::five,zero,
        createParameters(&one),zero, Ordinal::five);
    LIM_ELT_TST(CKSC,cksc);

    const Ordinal& psiwcwp1 = psi(omega,omega)+Ordinal::one;

    const Ordinal& cklm1 = admisLevelFunctional(psi(omega^omega,omega),zero,
        createParameters(&psiwcwp1),zero,psi(omega,omega)+Ordinal::one);
    const Ordinal& bpm = cklm1+Ordinal::four ;
    const Ordinal& cksc4 = admisLevelFunctional(psi(omega,omega)+one,zero,
        createParameters(&bpm),zero,psi(omega,omega)+Ordinal::one);
    LIM_ELT_TST(CKSC-4,cksc4);
}
void Validate::limitEltExitCodeTest2()
{
    bool doTest = true ;
    int count = 10 ;

    const Ordinal & ka = admisLevelFunctional(one,zero,
        createParameters(&one,&zero, &zero),zero,one);
    LIM_ELT_TST(KA,ka);

    const Ordinal & ka1 = admisLevelFunctional(one,zero,
        createParameters(&omega,&one, &zero),zero,one);
    LIM_ELT_TST(KA-1,ka1);

    const Ordinal & ka2 = admisLevelFunctional(one,Ordinal::three,
        createParameters(&one),zero,one);
    LIM_ELT_TST(KA-2,ka2);

    const Ordinal & ka3 = admisLevelFunctional(one,Ordinal::three,
        createParameters(&Ordinal::five),zero,one);
    LIM_ELT_TST(KA-3,ka2);

    const Ordinal & ka4 = admisLevelFunctional(one,omega,
        createParameters(&Ordinal::five),zero,one);
    LIM_ELT_TST(KA-4,ka4);

    
    const Ordinal & kc = admisLevelFunctional(omega,one);
    LIM_ELT_TST(KA-5,kc)

    const Ordinal & kc1 = admisLevelFunctional(omega,Ordinal::five);
    LIM_ELT_TST(KA-6,kc1)

    const Ordinal & kc2 = admisLevelFunctional(omega,
        psi(omega,omega)+Ordinal::five);
    LIM_ELT_TST(KA-7,kc2)

    const Ordinal& twelve = *  new Ordinal(12);
    const Ordinal&w12p1 = admisLevelFunctional(twelve,omega) + one;
    const Ordinal& ka8 = admisLevelFunctional(omega,w12p1,NULL,zero,omega);

    LIM_ELT_TST(KA-8,ka8);



    const Ordinal& five = Ordinal::five ;

    const Ordinal & keaa = admisLevelFunctional(five,zero,NULL,zero,five);
    LIM_ELT_TST(KEA,keaa);

    const Ordinal & kea1a = admisLevelFunctional(one,zero,NULL,zero,one);
    LIM_ELT_TST(KEA-1,kea1a);

    const Ordinal & kea2a = admisLevelFunctional(five,zero,NULL,zero,one);
    LIM_ELT_TST(KEA-2,kea2a);

    const Ordinal& kea = admisLevelFunctional(one,zero,NULL,zero,one);
    LIM_ELT_TST(KEA-3,kea);
    
    const Ordinal& kea1 = admisLevelFunctional(Ordinal::two,zero,NULL,zero,
        Ordinal::two);
    LIM_ELT_TST(KEA-4,kea1);
    
    const Ordinal& kea2 = admisLevelFunctional(omega+Ordinal::two,zero,NULL,
        zero,Ordinal::two);
    LIM_ELT_TST(KEA-5,kea2);

    const Ordinal& ke = admisLevelFunctional(one,zero);
    LIM_ELT_TST(KE,ke);

    const Ordinal& ke1 = admisLevelFunctional(omega+one,zero);
    LIM_ELT_TST(KE-1,ke1);

    const Ordinal& ke2 = admisLevelFunctional(five,zero);
    LIM_ELT_TST(KE-2,ke2);



}

void Validate::limitEltExitCodeTest3()
{
    bool doTest = true ;
    int count = 10 ;

}


void Validate::drillDownExitCodeTest()
{
    bool doTest = true ;
    int count = 10 ;

    const Ordinal& ddl = admisLevelFunctional(omega+one,zero,NULL,
        omega1CK,omega);
    LIM_ELT_TST(DDL,ddl);

    const Ordinal& ddko = admisLevelFunctional(one,zero,NULL,one);
    LIM_ELT_TST(DDKO,ddko);

    const Ordinal& ddko1 = admisLevelFunctional(one,zero,NULL,one.one);
    LIM_ELT_TST(DDKO-1,ddko1);

    const Ordinal& ddo = admisLevelFunctional(omega+Ordinal::three,
        zero,NULL,one,one);
    LIM_ELT_TST(DDO,ddo);

    const Ordinal& ddga = admisLevelFunctional(one,
        zero,NULL,(omega^omega)+one,one);
    LIM_ELT_TST(DDGA,ddga);

    const Ordinal& ddga1 = admisLevelFunctional(one,
        zero,NULL,(omega^omega)+one);
    LIM_ELT_TST(DDGA-1,ddga1);

    assert(ddga==ddga1);

    const Ordinal& ddgb = admisLevelFunctional(Ordinal::four,
        zero,NULL,(omega^omega)+one);
    LIM_ELT_TST(DDGB,ddgb);

    const Ordinal& ddgb1 = admisLevelFunctional(Ordinal::four,
        zero,NULL,(omega^omega)+one,Ordinal::three);
    LIM_ELT_TST(DDGB-1,ddgb1);


}



void Validate::embedExitCodeTest()
{
    bool doTest = true ;
    int count = 10 ;

    const Ordinal& twelve = * new Ordinal(12);
    const Ordinal&w12 = admisLevelFunctional(twelve,omega) ;
    const Ordinal&w12p1 = w12 + one;

    const Ordinal&edeq = admisLevelFunctional(omega,zero,NULL,zero,omega);
    LIM_ELT_TST(EDEQ,edeq);

    const Ordinal& edeq1 = admisLevelFunctional(omega1CK,zero,NULL,zero,
        omega1CK);
    LIM_ELT_TST(EDEQ-1,edeq1);

    const Ordinal& edab = admisLevelFunctional(omega1CK,zero,NULL,zero,
        omega);
    LIM_ELT_TST(EDAB,edab);

    const Ordinal& edab1 = admisLevelFunctional(w12,zero,NULL,zero,
        omega);
    LIM_ELT_TST(EDAB-1,edab1);

    const Ordinal& edab2 = admisLevelFunctional((omega^omega)+omega,zero,
        NULL,zero, omega);
    LIM_ELT_TST(EDAB-2,edab2);


    const Ordinal& edab3 = admisLevelFunctional(psi(omega,omega)+omega,zero,
        NULL,zero, psi(omega,omega));
    LIM_ELT_TST(EDAB-3,edab3);

    const Ordinal& edab4 = admisLevelFunctional(w12,zero,
        NULL,zero, psi(omega,omega));
    LIM_ELT_TST(EDAB-4,edab4);

    const Ordinal& edac = admisLevelFunctional(omega+twelve,zero,NULL,zero,
        omega);
    LIM_ELT_TST(EDAC,edac);

    const Ordinal& edad = admisLevelFunctional(omega*2,zero,NULL,zero,
        omega+twelve);
    LIM_ELT_TST(EDAD,edad);

    const Ordinal& edeo = admisLevelFunctional(one,zero,NULL,zero,
        one);
    LIM_ELT_TST(EDEO,edeo);

    const Ordinal& edee = admisLevelFunctional(omega+twelve,zero,NULL,zero,
        omega+twelve);
    LIM_ELT_TST(EDEE,edee);

    const Ordinal& edef = admisLevelFunctional(twelve,zero,NULL,zero,
        one);
    LIM_ELT_TST(EDEF,edef);

    const Ordinal& edeg = admisLevelFunctional(twelve,zero,NULL,zero,
        Ordinal::three);
    LIM_ELT_TST(EDEG,edeg);
}


#define OS outStream() <<
#define OT .normalForm() << "\n" 

void Validate::fixedPointTest()
{
    OS (omega^psi(1,0)) OT ;
    OS (omega^psi(1,1)) OT ;
    OS (omega^psi(omega1CK,0)) OT ;
    OS (omega^psi(omega1CK,1)) OT ;
    OS psi(psi(2,0),0) OT ;
    OS psi(psi(2,0),7) OT ;
    OS psi(finiteFunctional(1,2,0),0) OT ;
    OS psi(finiteFunctional(1,2,1),0) OT ;
    OS psi(finiteFunctional(1,2,0),1000) OT ;
    OS psi(finiteFunctional(1,2,1),99) OT ;
    OS finiteFunctional(finiteFunctional(1,2,1),0,0,0) OT ;
    OS finiteFunctional(finiteFunctional(1,2,1),0,3,0) OT ;
    OS psi(12,omega1CK) OT ;
    OS psi(12,psi(1,3)) OT ;
    OS psi(12,psi(12,0)) OT ;
    OS psi(12,psi(12,1)) OT ;
    OS iterativeFunctional(iterativeFunctional(omega,1,2,1),0,0,0) OT ;
    OS iterativeFunctional(5,iterativeFunctional(omega)) OT ;
    OS iterativeFunctional(5,iterativeFunctional(omega),0) OT ;
    OS iterativeFunctional(5,iterativeFunctional(omega),0,0,0) OT ;
    OS iterativeFunctional(5,iterativeFunctional(omega+1),0,0,0) OT ;
    OS iterativeFunctional(5,iterativeFunctional(omega+1)+1,0,0,0) OT ;

}

