
#include <fstream>
#include <algorithm>
#include "ordTop.h"
#include "validate.h"

using namespace ord;
using namespace std;


static string macName(const char * base)
{
	string ret = " = " ;
	ret += base ;
	ret += " ORDLIM" ;
	return ret ;
}




#define OLIMCK(name) name.out(macName(#name)); name.listOrdElts(params,ftst)
#define LISTELTS(ord,doTest) Validate::listElts(ord,doTest,__LINE__)
#define DLISTELTS(count,doTest) listElts(count,doTest,__LINE__)



void Validate::collapseTest()
{
    bool doTest = true ;
    bool ftst = doTest ;
    int count = 5 ;
    const Ordinal &a1 = omega1CK.limitElement(1);
    const Ordinal &a2 = omega1CK.limitElement(2);
    a1.DLISTELTS(count,doTest);
    a2.DLISTELTS(count,doTest);

    const Ordinal& w2CK = admisLevelFunctional(Ordinal::two,zero);
    
    const Ordinal &btrm = w2CK+psi(one,omega);
    const Ordinal & bgb = admisLevelFunctional(btrm,zero);


    const Ordinal & tst2 = admisLevelFunctional(Ordinal::two,zero) ;
    const Ordinal& n2 = admisLevelFunctional(Ordinal::three,zero,NULL,w2CK);
    const Ordinal n1_n2 = admisLevelFunctional(Ordinal::four,zero,NULL,n2);
    const Ordinal n1_n2_l3=n1_n2.limitElement(3);




    const Ordinal * bases[] = {
        &(admisLevelFunctional(Ordinal::two,zero,NULL,omega1CK)),
        &(admisLevelFunctional(Ordinal::three,zero,NULL,w2CK)),
        
        &bgb,
        &btrm,
        &n2,
        &n1_n2,
        NULL
    };

       


    const Ordinal twelve(12);
    const Ordinal& omegap3 = omega+ 3 ;
	const Ordinal& bpsi = (psi(twelve,omega));
	const Ordinal& va = finiteFunctional(bpsi,eps0,omegap3) ;




  	const Ordinal * const params[] = {
	&omega,&eps0,&psi(omega,eps0),&va,NULL};


     n1_n2_l3.DLISTELTS(count,doTest);
    n1_n2_l3.limitElement(7).DLISTELTS(count,doTest);
    OLIMCK(n1_n2_l3);
    OLIMCK(n1_n2_l3.limitElement(4));


    for (const Ordinal * const * b = bases; *b ; b++) {
        const Ordinal & ba = ** b ;
        ba.DLISTELTS(count,doTest);
        ba.limitElement(2).DLISTELTS(count,doTest);
        ba.limitElement(3).DLISTELTS(count,doTest);
        OLIMCK(ba);
        OLIMCK(ba.limitElement(9));

    }

    const Ordinal * plist[] = {
        &eps0,
        &omega,
        &Ordinal::three,
        NULL
    };

    const Ordinal & cxl2 = admisLevelFunctional(Ordinal::two,eps0,plist,NULL);
    const Ordinal & l2cxl2 = admisLevelFunctional(Ordinal::three,
        zero,NULL,cxl2);
    cxl2.DLISTELTS(count,doTest);
    l2cxl2.DLISTELTS(count,doTest);
    OLIMCK(cxl2);
    OLIMCK(l2cxl2);
    cxl2.DLISTELTS(count,doTest);
    l2cxl2.DLISTELTS(count,doTest);
    l2cxl2.DLISTELTS(count,doTest);

    const Ordinal wlev = admisLevelFunctional(omega+one,zero); 
    const Ordinal wlevc = admisLevelFunctional(wlev+one,zero,NULL,omega+one);
    wlevc.DLISTELTS(count,doTest);
    OLIMCK(wlev);
    OLIMCK(wlevc);


    const Ordinal & lev2 = admisLevelFunctional(Ordinal::two,zero,NULL,omega1CK);
    const Ordinal & lev3 = admisLevelFunctional(Ordinal::three,zero,NULL,lev2);
    const Ordinal & lev4 = admisLevelFunctional(Ordinal::four,zero,NULL,lev3);
    const Ordinal & lev5 =  admisLevelFunctional(Ordinal::five,zero,NULL,lev4);
   
    lev5.DLISTELTS(count,doTest);

    const Ordinal &l2 =  admisLevelFunctional(Ordinal::two,zero);
    const Ordinal &l3 =  admisLevelFunctional(Ordinal::three,zero);
    const Ordinal &l4 =  admisLevelFunctional(Ordinal::four,zero);
    const Ordinal &l5 =  admisLevelFunctional(Ordinal::five,zero);

    const Ordinal &ll2 =  admisLevelFunctional(Ordinal::two,zero,NULL,omega1CK);
    const Ordinal &ll3 =  admisLevelFunctional(Ordinal::three,zero,NULL,l2);
    const Ordinal &ll4 =  admisLevelFunctional(Ordinal::four,zero,NULL,l3);
    const Ordinal &ll5 =  admisLevelFunctional(Ordinal::five,zero,NULL,l4);

    const Ordinal &dll2 =  admisLevelFunctional(Ordinal::three,zero,NULL,ll2);
    const Ordinal &dll3 =  admisLevelFunctional(Ordinal::four,zero,NULL,ll3);
    const Ordinal &dll4 =  admisLevelFunctional(Ordinal::five,zero,NULL,ll4);
    const Ordinal &dll5 =  admisLevelFunctional(Ordinal::six,zero,NULL,ll5);

    const Ordinal * ords[] = {
        &l2, &l3, &l4, &l5, 
        &ll2, &ll3, &ll4, &ll5, 
        &dll2, &dll3, &dll4, &dll5, 
        NULL
    };
    for (const Ordinal * const * b = ords; *b ; b++) {
        const Ordinal & ba = ** b ;
        ba.DLISTELTS(count,doTest);
        ba.limitElement(2).DLISTELTS(count,doTest);
        ba.limitElement(3).DLISTELTS(count,doTest);
        OLIMCK(ba);
        OLIMCK(ba.limitElement(9));

    }
    static const int numTerms = 10 ;
    const Ordinal * prev = NULL ;
    for (int i = 0 ; i < numTerms ; i++) {
        int n = i + 2 ;
        const Ordinal*kappa  = new Ordinal(n);
        prev = &(admisLevelFunctional(*kappa,zero,NULL,(prev?*prev:zero)));
        outStream() << prev->normalForm() << " NF\n" ;
        prev->DLISTELTS(count,doTest);
        prev->limitElement(2).DLISTELTS(count,doTest);
        prev->limitElement(3).DLISTELTS(count,doTest);
        OLIMCK((*prev));
        OLIMCK(prev->limitElement(9));

    }
    
}


void Validate::nestedCollapseTest()
{
    bool doTest = true ;
    bool ftst = doTest ;
    int count = 10 ;

    const Ordinal&op1 = omega+one ;

    const Ordinal& b1 = admisLevelFunctional(psi(omega,0),zero);
    const Ordinal& b2 = admisLevelFunctional(b1+one,zero,NULL,op1);
    b2.descend(3,10);
    exit(0);

    const Ordinal twelve(12);
    const Ordinal& omegap3 = omega+ 3 ;
	const Ordinal& bpsi = (psi(twelve,omega));
	const Ordinal& va = finiteFunctional(bpsi,eps0,omegap3) ;

    const Ordinal * const params[] = {
	&omega,&eps0,&psi(omega,eps0),&va,NULL};

    admisLevelFunctional(omega,zero,NULL,twelve).DLISTELTS(count,doTest);

    const Ordinal & bg = admisLevelFunctional(iterativeFunctional(one,
        zero,psi(one,(omega))),zero);

    const Ordinal &bga=admisLevelFunctional(bg,zero,NULL,eps0);

    bg.DLISTELTS(count,doTest);
    OLIMCK(bg);
    bga.DLISTELTS(count,doTest);
    OLIMCK(bga);

    const Ordinal * bgx = &(bg.limitElement(5));
    const Ordinal * bgax = &(bga.limitElement(5));


    for (int i = 0 ; i < 4;i++) {
        bgx->DLISTELTS(count,doTest);
        OLIMCK((*bgx));
        bgax->DLISTELTS(count,doTest);
        OLIMCK((*bgax));

        bgx = &(bgx->limitElement(4));
        bgax = &(bgax->limitElement(4));
    }



}


void Validate::nestedCollapseTest2()
{
    bool doTest = true ;
    bool ftst = doTest ;
    int count = 10 ;

    const Ordinal&op1 = omega+one ;

    const Ordinal& b1 = admisLevelFunctional(psi(omega,zero),zero);
    const Ordinal& b2 = admisLevelFunctional(b1+Ordinal::three,zero,NULL,op1);
    b2.descend(3,10);
    
}

static void erBreak()
{
}

void Validate::nestedCollapseTest3()
{
    bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;
    int dix=3;
    int dli=6 ;


    const Ordinal& omega = Ordinal::omega ;
    const Ordinal& zero = Ordinal::zero ;
    const Ordinal& one = Ordinal::one ;
    const Ordinal& eleven = * new Ordinal(11);

    const Ordinal& a = admisLevelFunctional(Ordinal::two,zero,NULL,zero,
        Ordinal::two);
    a.listElts(count,doTest);
    a.descend(dix,dli);

    const Ordinal & twelve = * new Ordinal(12);
    const Ordinal& b = admisLevelFunctional(twelve,zero,NULL,zero,twelve);
    b.listElts(count,doTest);
    b.descend(dix,dli);

    
    const Ordinal& c = admisLevelFunctional(omega,zero,NULL,zero,
       Ordinal::three);
    c.listElts(count,doTest);
    c.descend(dix,dli);


    
    const Ordinal& d = admisLevelFunctional(omega,zero,NULL,zero,
        omega);
    d.listElts(count,doTest);
    d.descend(dix,dli);

    
    
    


    const Ordinal& epsWtW = psi(one,omega^omega) ;
    const Ordinal& gamma12 = finiteFunctional(one,zero,twelve);

    const Ordinal& e = admisLevelFunctional(gamma12,zero,NULL,zero,
        epsWtW);
    e.listElts(count,doTest);
    e.descend(dix,dli);

    const Ordinal& f = admisLevelFunctional(gamma12,zero,NULL,zero,
        epsWtW+one);
    f.listElts(count,doTest);
    f.descend(dix,dli);

    const Ordinal& g = admisLevelFunctional(gamma12+one,zero,NULL,zero,
        epsWtW);
    g.listElts(count,doTest);
    g.descend(dix,dli);

    
    
    
    


    const Ordinal& h = admisLevelFunctional(Ordinal::three,zero,NULL,zero,
        Ordinal::two);
    h.listElts(count,doTest);
    h.descend(dix,dli);

    const Ordinal& wtw = omega^omega ;
    const Ordinal& nine = * new Ordinal(9);

    const Ordinal& i = admisLevelFunctional(wtw,zero,NULL,zero,nine);
    i.listElts(count,doTest);
    i.descend(dix,dli);

    const Ordinal& j = admisLevelFunctional(wtw+one,zero,NULL,zero,nine);
    j.listElts(count,doTest);
    j.descend(dix,dli);

    const Ordinal& k = admisLevelFunctional(Ordinal::four,zero,NULL,zero,
        Ordinal::two);
    k.listElts(count,doTest);
    k.descend(dix,dli);


    const Ordinal& l = admisLevelFunctional(one,zero,NULL,zero,
        one);
    l.listElts(count,doTest);
    l.descend(dix,dli);
    for (int i = 0 ; i < 10 ; i++) outStream() <<
        l.limitElement(i+1).normalForm() << "\n";

    for (int i = 0 ; i < 10 ; i++) outStream() <<
        l.limitElement(i+1).texNormalForm() << "\n";

    const Ordinal & ddb = admisLevelFunctional(wtw+Ordinal::one,zero,NULL,zero,
        wtw);
    
    ddb.listElts(count,doTest);
    ddb.descend(dix,dli);

    const Ordinal& cklm =  admisLevelFunctional(wtw,zero,createParameters(&twelve),
        zero,wtw);
    cklm.listElts(count,doTest);
    cklm.descend(dix,dli);
        
    const Ordinal&xg = iterativeFunctional(wtw,createParameters(&Ordinal::four));
    const Ordinal& cklm1 =  admisLevelFunctional(xg,zero,createParameters(&twelve),
        zero,wtw);
    cklm1.listElts(count,doTest);
    cklm1.descend(dix,dli);

    {
        const Ordinal& ddIndex = psi(omega,omega);
        const Ordinal& ddParam = ddIndex^(ddIndex+1);
        const Ordinal& t1 = admisLevelFunctional(omega1CK,zero,NULL,zero,omega);
        t1.listElts(count,doTest);
        t1.descend(3,10);
        const Ordinal& t2 = t1.limitOrd(omega);
        t2.listElts(count,doTest);
        t2.descend(3,10);

        
        const Ordinal & t3 = admisLevelFunctional((omega^omega)+one,
            zero,NULL, ddIndex,omega);


        t3.descend(3,15);

        const Ordinal & ww = admisLevelFunctional(omega,zero);

        const Ordinal & w1 = admisLevelFunctional(one,zero);
        const Ordinal & w3 = admisLevelFunctional(Ordinal::three,zero);

        const Ordinal& a = admisLevelFunctional(w1+one,zero,NULL,one,ddIndex);
        const Ordinal& b = admisLevelFunctional(w3+one,zero,NULL,one,ddIndex);
        outStream() << "b = " << b.normalForm() << "\n" ;
        const Ordinal& c = admisLevelFunctional(b+one,zero,NULL,Ordinal::three,
            w3);
        outStream() << "c = " << c.normalForm() << "\n" ;
        const Ordinal& d = admisLevelFunctional(omega+ddIndex+twelve,zero,NULL,
            one,ddIndex);
        const Ordinal& e = admisLevelFunctional(omega+ddParam+one,zero,NULL,d,
            ddParam);
        const Ordinal& g=admisLevelFunctional(ww+eleven,zero,NULL,one,ddIndex);
        const Ordinal& h=admisLevelFunctional(
            ddIndex+(omega^omega)+omega+Ordinal::three, zero,NULL, one,ddIndex);

        const Ordinal *ords[] = {
            &a, &b, &c, &d, &e, &g, &h,
            NULL
        };

        int i = 0 ;
        for (const Ordinal ** b = ords; *b ; b++) {
            char name[2] ;
            name[0]  = 'a'+(i++);
            name[1]='\0' ;
            outStream() << name << " = " << (*b)->normalForm() << "\n" ;
        }








        i = 0 ;
        for (const Ordinal ** b = ords; *b ; b++) {
            char name[2] ;
            name[0]  = 'a'+i++;
            name[1]='\0' ;
            for (int j= 0; j <10; j++) outStream() << name << " " ;
            outStream() << "\n" ;
            (*b)->listElts(count,doTest);
            (*b)->descend(3,8);
        }
    }
}

#define EXC_TST(name,ord) { const Ordinal& name = ord ; \
    outStream() << "Test " << #name << "\n" ;\
    name.listElts(count,doTest);\
    name.descend(3,8); }

void Validate::exitCodeTest()
{

    bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;
    const Ordinal& twelve = * new Ordinal(12);
    const Ordinal& seven = * new Ordinal(7);
    const Ordinal& wtw = omega^omega ;

    const Ordinal & hxx = admisLevelFunctional(Ordinal::five,wtw,
        createParameters(&Ordinal::four),zero,Ordinal::three);
    EXC_TST(HXX,hxx);

    const Ordinal & ka = admisLevelFunctional(twelve,Ordinal::zero,
        createParameters(&Ordinal::one,&Ordinal::one),Ordinal::zero,
        Ordinal::three);
    EXC_TST(KA,ka);

    const Ordinal & ka1 = admisLevelFunctional(twelve,Ordinal::zero,
        createParameters(&Ordinal::one,&Ordinal::four),Ordinal::zero,
        Ordinal::three);
    EXC_TST(KA,ka1);

    const Ordinal & ka2 = admisLevelFunctional(twelve,Ordinal::zero,
        createParameters(&Ordinal::omega,&Ordinal::four),Ordinal::zero,
        Ordinal::three);
    EXC_TST(KA,ka2);

    const Ordinal & ka3 = admisLevelFunctional(twelve,Ordinal::zero,
        createParameters(&Ordinal::omega,&Ordinal::four),Ordinal::zero,
        Ordinal::three);
    EXC_TST(KA,ka3);

    const Ordinal & kc = admisLevelFunctional(twelve,seven,
        NULL,Ordinal::zero,Ordinal::three);
    EXC_TST(KC,kc);

    const Ordinal & kd = admisLevelFunctional(twelve,wtw,
        NULL,Ordinal::zero,Ordinal::three);
    EXC_TST(KD,kd);
}


void Validate::transitionTest()
{
    bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;

    const Ordinal& eps0Pw = eps0 + omega ;
    const Ordinal& bg =
        admisLevelFunctional(eps0,omega,createParameters(&Ordinal::one));
    const Ordinal * params[] = {
        &Ordinal::omega,
        &eps0,
        &eps0Pw,
        &omega1CK,
        &bg,
        NULL
    };


#define THE_TESTS(ord) {\
    ord.listElts(); \
    ord.descend(3,count); \
    ord.listOrdElts(params,doTest); }


#define TRANS_TEST(ord) {outStream() << "Transition test at line " << \
    __LINE__ << " for " << ord.normalForm() << "\n" ; \
    const Ordinal& o = ord ; \
    THE_TESTS(o) ; const Ordinal & o2 = o.limitElement(4); THE_TESTS(o2);}




    const Ordinal& ts1 = admisLevelFunctional(Ordinal::one,zero,NULL,
        zero,Ordinal::one);
    TRANS_TEST(ts1);


    const Ordinal& ts2 = admisLevelFunctional(Ordinal::two,zero,NULL,
        zero,Ordinal::two);
    TRANS_TEST(ts2);
    
    
    

    const Ordinal& ts4 = admisLevelFunctional(Ordinal::four,zero,NULL,
        zero,Ordinal::four);
    TRANS_TEST(ts4) ;
    
    
    

    const Ordinal& tsw = admisLevelFunctional(omega,zero,NULL,
        zero,Ordinal::four);
    TRANS_TEST(tsw);
    
    
    


    const Ordinal& tsww = admisLevelFunctional(omega,zero,NULL,
        zero,Ordinal::omega);
    TRANS_TEST(tsww);


    const Ordinal& tswck = admisLevelFunctional(omega1CK,zero,NULL,
        zero,omega1CK);
    TRANS_TEST(tswck);



}





#define LIM_ORD_TST(code, base, arg) { \
    outStream() << "Test " << #code << "\n" ;\
    const Ordinal& le = (base).limitOrd(arg) ; \
    assert((base).compare(le)>0); \
    assert(le.compare((base).limitElement(999)<0)); \
    le.listElts(count,doTest);\
    le.descend(3,4); \
    for (int i = 0 ; const Ordinal *ord = params[i]; i++) {\
        if (base.limitType().compare(ord->maxLimitType())>0) { \
            const Ordinal &le = base.limitOrd(*ord);\
            le.listElts(5,doTest);\
            le.descend(3,4); \
        }\
    }\
}




void Validate::limitOrdExitCodeTest()
{
    bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;
    const Ordinal & twelve = * new Ordinal(12);
    const Ordinal& eps0Pw = eps0 + omega ;
    const Ordinal& eps012 = eps0Pw + twelve ;
    const Ordinal& bg =
        admisLevelFunctional(eps0,omega,createParameters(&Ordinal::one));
    const Ordinal& bgp = bg + eps012 ;
    const Ordinal * params[] = {
        &Ordinal::omega,
        &eps0,
        &eps012,
        &eps0Pw,
        &omega1CK,
        &bg,
        &bgp,
        NULL
    };

    const Ordinal & ten = * new Ordinal(10);
    const Ordinal & eleven = * new Ordinal(11);
    const Ordinal & w_eleven = admisLevelFunctional(eleven,zero);
    
    const Ordinal & w_twelve = admisLevelFunctional(twelve,zero);
    const Ordinal & fifteen = * new Ordinal(15);
    const Ordinal & thirty = * new Ordinal(30);
    const Ordinal & p1 = admisLevelFunctional(eleven,zero,createParameters(
    &Ordinal::one));
    const Ordinal & loe = admisLevelFunctional(thirty,zero,createParameters(
     &w_twelve));





    const Ordinal& lod = admisLevelFunctional(Ordinal::three,zero,NULL,
    admisLevelFunctional(Ordinal::two,admisLevelFunctional(
    Ordinal::two,zero)));
    LIM_ORD_TST(LOD,lod,omega*4);


    LIM_ORD_TST(LOE,loe,p1);

    const Ordinal & lof = admisLevelFunctional(fifteen,zero,
        createParameters(&w_twelve,&twelve));
    LIM_ORD_TST(LOF,lof,p1);

    const Ordinal & loed = admisLevelFunctional(fifteen,w_twelve,
        createParameters(&fifteen));
    LIM_ORD_TST(LOED,loed,p1);

    const Ordinal &p2 = w_eleven + twelve ;
    const Ordinal & loee = admisLevelFunctional(fifteen,w_twelve);
    LIM_ORD_TST(LOEE,loee,p2);
    
    const Ordinal & a1 = admisLevelFunctional(twelve,w_eleven);
    const Ordinal & loef = admisLevelFunctional(a1,zero);
    const Ordinal & p3 = admisLevelFunctional(ten,zero);
    LIM_ORD_TST(LOEF,loef,p3);


}

void Validate::limitOrdExitCodeTest1()
{
    bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;

    const Ordinal & twelve = * new Ordinal(12);
    const Ordinal& eps0Pw = eps0 + omega ;
    const Ordinal& eps012 = eps0Pw + twelve ;
    const Ordinal& bg =
        admisLevelFunctional(eps0,omega,createParameters(&Ordinal::one));
    const Ordinal& bgp = bg + eps012 ;
    const Ordinal * params[] = {
        &Ordinal::omega,
        &eps0,
        &eps012,
        &eps0Pw,
        &omega1CK,
        &bg,
        &bgp,
        NULL
    };

    const Ordinal & ten = * new Ordinal(10);
    const Ordinal & eleven = * new Ordinal(11);
    const Ordinal & w_eleven = admisLevelFunctional(eleven,zero);
    
    const Ordinal & w_twelve = admisLevelFunctional(twelve,zero);
    const Ordinal & fifteen = * new Ordinal(15);
    const Ordinal & thirty = * new Ordinal(30);
    const Ordinal & p1 = admisLevelFunctional(eleven,zero,createParameters(
    &Ordinal::one));
    const Ordinal & loe = admisLevelFunctional(thirty,zero,createParameters(
     &w_twelve));



   
    const Ordinal& loeg = admisLevelFunctional(omega1CK,zero,NULL,zero,
        omega1CK);
    const Ordinal p4 = psi(omega,omega);
    LIM_ORD_TST(LOEG,loeg,p4);


    const Ordinal & loeh = admisLevelFunctional(omega1CK,zero,NULL,zero,omega);
    LIM_ORD_TST(LOEH,loeh,p4);
}


void Validate::limitOrdExitCodeTest2()
{
     bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;

    const Ordinal & twelve = * new Ordinal(12);
    const Ordinal& eps0Pw = eps0 + omega ;
    const Ordinal& eps012 = eps0Pw + twelve ;
    const Ordinal& bg =
        admisLevelFunctional(eps0,omega,createParameters(&Ordinal::one));
    const Ordinal& bgp = bg + eps012 ;
    const Ordinal * params[] = {
        &Ordinal::omega,
        &eps0,
        &eps012,
        &eps0Pw,
        &omega1CK,
        &bg,
        &bgp,
        NULL
    };

    const Ordinal & ten = * new Ordinal(10);
    const Ordinal & eleven = * new Ordinal(11);
    const Ordinal & w_eleven = admisLevelFunctional(eleven,zero);
    
    const Ordinal & w_twelve = admisLevelFunctional(twelve,zero);
    const Ordinal & fifteen = * new Ordinal(15);
    const Ordinal & thirty = * new Ordinal(30);
    const Ordinal & p1 = admisLevelFunctional(eleven,zero,createParameters(
    &Ordinal::one));
    const Ordinal & loe = admisLevelFunctional(thirty,zero,createParameters(
     &w_twelve));



   
    const Ordinal& loeg = admisLevelFunctional(omega1CK,zero,NULL,zero,
        omega1CK);
    const Ordinal p4 = psi(omega,omega);

    
    const Ordinal & epsPar = psi(1,omega^omega^omega);
    const Ordinal& leohA = admisLevelFunctional(omega1CK,zero) +
        admisLevelFunctional(epsPar,zero) + w_twelve ;
    const Ordinal& leohB = admisLevelFunctional(omega1CK,zero) +
        admisLevelFunctional(epsPar,zero) + twelve ;

    const Ordinal &loeh2 = admisLevelFunctional(leohA,zero,NULL,zero,
        leohB);
    LIM_ORD_TST(LOEH,loeh2,p4);

}


void Validate::limitOrdExitCodeTest3()
{
        bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;

    const Ordinal & twelve = * new Ordinal(12);
    const Ordinal& eps0Pw = eps0 + omega ;
    const Ordinal& eps012 = eps0Pw + twelve ;
    const Ordinal& bg =
        admisLevelFunctional(eps0,omega,createParameters(&Ordinal::one));
    const Ordinal& bgp = bg + eps012 ;
    const Ordinal * params[] = {
        &Ordinal::omega,
        &eps0,
        &eps012,
        &eps0Pw,
        &omega1CK,
        &bg,
        &bgp,
        NULL
    };

    const Ordinal & ten = * new Ordinal(10);
    const Ordinal & eleven = * new Ordinal(11);
    const Ordinal & w_eleven = admisLevelFunctional(eleven,zero);
    
    const Ordinal & w_twelve = admisLevelFunctional(twelve,zero);
    const Ordinal & fifteen = * new Ordinal(15);
    const Ordinal & thirty = * new Ordinal(30);
    const Ordinal & p1 = admisLevelFunctional(eleven,zero,createParameters(
    &Ordinal::one));
    const Ordinal & loe = admisLevelFunctional(thirty,zero,createParameters(
     &w_twelve));



   
    const Ordinal& loeg = admisLevelFunctional(omega1CK,zero,NULL,zero,
        omega1CK);
    const Ordinal p4 = psi(omega,omega);

    
    const Ordinal & epsPar = psi(1,omega^omega^omega);
    const Ordinal& leohA = admisLevelFunctional(omega1CK,zero) +
        admisLevelFunctional(epsPar,zero) + w_twelve ;
    const Ordinal& leohB = admisLevelFunctional(omega1CK,zero) +
        admisLevelFunctional(epsPar,zero) + twelve ;

    const Ordinal &loeh2 = admisLevelFunctional(leohA,zero,NULL,zero,
        leohB);
     const Ordinal & p6 =  admisLevelFunctional(Ordinal::three,zero) + eps0+
        omega +fifteen;
    const Ordinal & loi = admisLevelFunctional(twelve,zero,NULL,zero,
        Ordinal::five);
    LIM_ORD_TST(LOI,loi,p6);

}


void Validate::exitCodeTest2()
{

    bool doTest = true ;
    bool ftst = doTest ;
    int count = 8 ;
    const Ordinal& twelve = * new Ordinal(12);
    const Ordinal& seven = * new Ordinal(7);
    const Ordinal& wtw = omega^omega ;
    const Ordinal& ww = omega*omega ;

    const Ordinal & kea = admisLevelFunctional(twelve,Ordinal::zero,
        NULL,Ordinal::zero,Ordinal::three);
    EXC_TST(KEA,kea);

    const Ordinal & ke = admisLevelFunctional(twelve,Ordinal::zero,
        NULL,Ordinal::three,Ordinal::zero);
    EXC_TST(KE,ke);

    const Ordinal & ddl = admisLevelFunctional(twelve,Ordinal::zero,
        NULL,wtw,Ordinal::zero);
    EXC_TST(DDL,ddl);

    const Ordinal & ddko = admisLevelFunctional(Ordinal::one,Ordinal::zero,
        NULL,Ordinal::one,Ordinal::zero);
    EXC_TST(DDKO,ddko);

    const Ordinal & ddga = admisLevelFunctional(Ordinal::one,Ordinal::zero,
        NULL,Ordinal::three,Ordinal::zero);
    EXC_TST(DDGA,ddga);

    const Ordinal & ddgb = admisLevelFunctional(twelve,Ordinal::zero,
        NULL,Ordinal::three,Ordinal::zero);
    EXC_TST(DDGB,ddgb);

    const Ordinal & edeq = admisLevelFunctional(wtw,Ordinal::zero,
        NULL,Ordinal::zero,wtw);
    EXC_TST(EDEQ,edeq);

    const Ordinal & edab = admisLevelFunctional(wtw,Ordinal::zero,
        NULL,Ordinal::zero,ww);
    EXC_TST(EDAB,edab);

    const Ordinal & edac = admisLevelFunctional(wtw+5,Ordinal::zero,
        NULL,Ordinal::zero,ww);
    EXC_TST(EDAC,edac);

    const Ordinal & edad = admisLevelFunctional(wtw,Ordinal::zero,
        NULL,Ordinal::zero,ww+5);
    EXC_TST(EDAD,edad);

    const Ordinal & edeo = admisLevelFunctional(Ordinal::one,Ordinal::zero,
        NULL,Ordinal::zero,Ordinal::one);
    EXC_TST(EDEO,edeo);

    const Ordinal & edee = admisLevelFunctional(Ordinal::one,Ordinal::zero,
        NULL,Ordinal::zero,Ordinal::one);
    EXC_TST(EDEE,edee);

    const Ordinal & edef = admisLevelFunctional(Ordinal::four,Ordinal::zero,
        NULL,Ordinal::zero,Ordinal::one);
    EXC_TST(EDEF,edef);

    const Ordinal & edeg = admisLevelFunctional(Ordinal::four,Ordinal::zero,
        NULL,Ordinal::zero,Ordinal::two);
    EXC_TST(EDEG,edeg);

    const Ordinal & edeg1 = admisLevelFunctional(Ordinal::omega + Ordinal::four,Ordinal::zero,
        NULL,Ordinal::zero,Ordinal::two);
    EXC_TST(EDEG1,edeg1);

}

void Validate::cmpExitCodeTest()
{


    outStream() << "Start AdmisnormalElement::compare tests\n\n" ;

#define LC(a,b)  outStream() << "Doing " << #b << "\n"; \
    bool a = b ; outStream() << #b << " = " << a << "\n";

#define CMP_TST(str,aa,bb,eqf) { Validate::outCompareExit= true ; \
    outStream() << "Test " << #str << "\n" ; \
    const Ordinal& ax = aa ; const Ordinal &bx =bb ; \
    LC(agb,ax>bx) ; LC(aeb, ax==bx) ; LC(alb, ax < bx) ; \
    LC(bga, bx>ax) ; LC(bea, bx==ax) ; LC(bla, bx < ax) ; \
    outStream() << "Test " << #str << " summary \na = " << ax.normalForm() << "\n" \
        << "b = " << bx.normalForm() << "\na>b " << agb << ", a==b " << aeb \
        << ". a<b " << alb << ", b>a " << bga << ", b==a " << bea << \
        ". b<a " << bla << "\n" ; \
    if (eqf) assert (aeb && bea && !alb && ! bla & !agb & !bga) ; \
    else assert(!aeb && !bea && agb && bla && !bga && !alb); \
    Validate::outCompareExit= false ;}

    const Ordinal &a = admisLevelFunctional(Ordinal::one,Ordinal::zero);
    const Ordinal &b = Ordinal::one ;

    CMP_TST(A2,a,b,false);



    const Ordinal &aA3 = admisLevelFunctional(Ordinal::three,Ordinal::zero) +
        admisLevelFunctional(Ordinal::two,Ordinal::zero) + (omega^omega) ;
    const Ordinal &bA3 = omega^(aA3+one) ;
    const Ordinal &cA3 = admisLevelFunctional(Ordinal::three,Ordinal::zero) +
        admisLevelFunctional(Ordinal::one,Ordinal::zero) ;

    CMP_TST(A3,bA3,cA3,false);




    const Ordinal& aA4 = admisLevelFunctional(Ordinal::three,Ordinal::zero);
    const Ordinal& bA4 = omega^(
        admisLevelFunctional(Ordinal::two,Ordinal::zero) +
        admisLevelFunctional(Ordinal::one,Ordinal::zero) + omega);
    CMP_TST(A4,aA4,bA4,false);

    const Ordinal& aA5a = admisLevelFunctional(omega,omega,createParameters(&one))+one;
    const Ordinal& aA5 = admisLevelFunctional(one,zero,createParameters(&aA5a));
    const Ordinal& bA5 = admisLevelFunctional(omega,omega);
    CMP_TST(A5,aA5,bA5,false);

    outStream()<<"Test A1 to be added in future expansion, it is not accessible now.\n";

    const Ordinal& aB = admisLevelFunctional(Ordinal::four,zero,NULL,zero,Ordinal::four);
    const Ordinal& bB = admisLevelFunctional(omega,omega,NULL,zero,Ordinal::three);
    CMP_TST(B,aB,bB,false);

    const Ordinal& w3=admisLevelFunctional(Ordinal::three,omega);
    const Ordinal& aB1 =admisLevelFunctional(Ordinal::four,zero);
    const Ordinal& bB1 =admisLevelFunctional(Ordinal::three,w3);
    CMP_TST(B1,aB1,bB1,false);

    const Ordinal& aB1A =admisLevelFunctional(Ordinal::four,zero,NULL,
        zero,Ordinal::three);
    const Ordinal& bB1A =admisLevelFunctional(Ordinal::three,w3,NULL,zero,
        Ordinal::three);
    CMP_TST(B1A,aB1A,bB1A,false);

    const Ordinal& B2a = admisLevelFunctional(Ordinal::four,zero,NULL,omega^omega+one);
    const Ordinal& B2b = admisLevelFunctional(Ordinal::four,zero,NULL,omega^omega);
    CMP_TST(B2,B2a,B2b,false);
    
    const Ordinal& B3a = admisLevelFunctional(Ordinal::four,zero,NULL,zero,
        Ordinal::four);
    const Ordinal& B3b = admisLevelFunctional(Ordinal::four,zero,NULL,omega^omega+one);
    CMP_TST(B3&B4,B3a,B3b,false);

    const Ordinal& A6a = admisLevelFunctional(Ordinal::four,B3a+Ordinal::two);
    const Ordinal& A6b = admisLevelFunctional(Ordinal::four,B3a+one);
    CMP_TST(A6,A6a,A6b,false);

    const Ordinal& twelve = * new Ordinal(12);
    

   
    const Ordinal& Ra = admisLevelFunctional(Ordinal::four,B3a+Ordinal::two,
        createParameters(new Ordinal(B2a+one),new Ordinal(B2a+twelve),
            new Ordinal(B2a+Ordinal::two)));
    const Ordinal& Rb = admisLevelFunctional(Ordinal::four,B3a+Ordinal::two,
        createParameters(new Ordinal(B2a+one),new Ordinal(B2a+twelve),
            new Ordinal(B2a+one)));
    CMP_TST(R,Ra,Rb,false);
    
    const Ordinal& Sa = Ra*Ordinal::four ;
    const Ordinal& Sb = Ra*Ordinal::three ;
    CMP_TST(S,Sa,Sb,false);
    CMP_TST(S-2,Sa,Sa,true);
}


