
#include <fstream>
#include <algorithm>
#include "ordTop.h"
#include "validate.h"

using namespace ord;
using namespace std;

static string macName(const char * base)
{
	string ret = " = " ;
	ret += base ;
	ret += " ORDLIM" ;
	return ret ;
}




#define OLIMCK(name) name.out(macName(#name)); name.listOrdElts(params,ftst)
#define LISTELTS(ord,doTest) Validate::listElts(ord,doTest,__LINE__)
#define DLISTELTS(count,doTest) listElts(count,doTest,__LINE__)





static void admisExpTest(const Ordinal& base)
{
	outStream() << "admisExpTest(" << base.normalForm() << ")\n" ;
	const Ordinal &omb = base ;
	omb.out("omb");
	const Ordinal &a = (omega^omb)*3 ;
	const Ordinal &b = (omega^omb)*2 + omega ;
	const Ordinal &c = (omega^omb)*2 + Ordinal::two ;
	
	
	
	
	bool agb = a> b ;
	bool bgc = b > c ;

	const Ordinal& atb = a^b ;
	const Ordinal& btc = b * c ;
	const Ordinal& atbpc = atb^c ;
	const Ordinal& atbpatc = a^btc ;
	bool sm = atbpc == atbpatc ;



	const Ordinal& ep = omb * b ;
	ep.out("ep");
	(omega^ep).out("omega^ep");

	const Ordinal& ep2 = omb * btc ;
	ep2.out("ep2");
	(omega^ep2).out("omega^ep2");
	const Ordinal& ep3 = ep * c ;
	ep3.out("ep3");

	
	

	outStream() << ":" << !agb << ":" <<  !bgc << ":" << !sm << "\n" ;
	outStream() << " a = " << a.normalForm() << "\n" ;
	outStream() << " b = " << b.normalForm() << "\n" ;
	outStream() << " c = " << c.normalForm() << "\n" ;
	outStream() << " a^b = " << atb.normalForm() << "\n" ;
	outStream() << " b*c = " << btc.normalForm() << "\n" ;
	outStream() << " (a^b)^c = " << atbpc.normalForm() << "\n" ;
	outStream() << " a^(b*c) = "   << atbpatc.normalForm() << "\n" ;

	

	Ordinal::powerCheck(a,b,c);
}

void listOrds(const Ordinal& ord, const Ordinal ords[])
{
	outStream() << "limitOrds for "
		<< ord.normalForm() << "\n" ;
	for (int i = 0 ; !ords[i].isZero() ; i++) {
        if (ord.limitType().compare(ords[i].maxLimitType())<=0) {
            outStream() << "Skipping " << ords[i].normalForm() << 
                " because maxLimitType is too big.\n" ;
            continue ;
        }
		const Ordinal& le = ord.limitOrd(ords[i]);
		outStream() << "arg = " << ords[i].normalForm() << " = " ;
		le.describel(outStream());
		
	}
	outStream() << "End limitOrds\n\n" ;
}




void Validate::admisTest()
{
	const int count = 10 ;
	bool ftst = true ;

	const Ordinal& bg1 = admisLevelFunctional(eps0,omega);
	
	(bg1 + one).DLISTELTS(count,ftst);
	(bg1 + omega).DLISTELTS(count,ftst);
	(bg1 + omega1CK).DLISTELTS(count,ftst);
	(bg1 + admisLevelFunctional(omega,omega,createParameters(&one))).
		DLISTELTS(count,ftst);
	(bg1 + admisLevelFunctional(omega,omega,createParameters(&omega))).
		DLISTELTS(count,ftst);
    const Ordinal&bg2 =  bg1 + admisLevelFunctional(omega,one,NULL);
	
    outDbgStream() << bg2.normalForm() << " BG2++++++\n" ;
	bg2.DLISTELTS(count,ftst);
	(bg1 + admisLevelFunctional(omega,one,NULL)).DLISTELTS(count,ftst);
	
	(bg1 + admisLevelFunctional(omega,omega,NULL)).DLISTELTS(count,ftst);
	

	
	const Ordinal twelve(12);
	
	admisLevelFunctional(omega,zero,createParameters(&Ordinal::two)).
		DLISTELTS(count,ftst);
	

	const Ordinal& bga = admisLevelFunctional(omega,zero,
        createParameters(&omega1CK));



	const Ordinal& admis1 = admisLevelFunctional(one,zero,
		createParameters(&one));
	const Ordinal& admis2 = admisLevelFunctional(one,zero,
		createParameters(&twelve));
	(admis2*admis1).out("aq2a1");
	admis1.DLISTELTS(count,ftst);	
	admis2.DLISTELTS(count,ftst);	
	admisLevelFunctional(one,zero,createParameters(&omega)).
		DLISTELTS(count,ftst);	
	admisLevelFunctional(omega,zero,createParameters(&one)).
		DLISTELTS(count,ftst);	
	const Ordinal  thousand(1000);
	const Ordinal  eight(8);
	
	const Ordinal& omegap3 = omega+ 3 ;
	const Ordinal& bpsi = (psi(twelve,omega));
	const Ordinal& va = finiteFunctional(bpsi,eps0,omegap3) ;

	const Ordinal& rt =
		(admisLevelFunctional(omega,zero,createParameters(&omega1CK))).
			limitOrd(eps0) ;
	rt.out("rt");
	
	const Ordinal * const params[] = {
		&omega,&eps0,&psi(omega,eps0),&va,NULL};
	OLIMCK(admisLevelFunctional(Ordinal::two,zero,createParameters(&one)));
	OLIMCK(admisLevelFunctional(omega,zero,createParameters(&omega1CK)));
	OLIMCK(admisLevelFunctional(omega,zero,NULL));
	admisLevelFunctional(omega,zero,NULL).listOrdElts(params,ftst);
	OLIMCK(admisLevelFunctional(omega,zero,createParameters(&one)));
	OLIMCK(admisLevelFunctional(one,zero,createParameters(&omega)));
	OLIMCK(admisLevelFunctional(one,zero,createParameters(&Ordinal::two)));
	OLIMCK(admisLevelFunctional(one,one,createParameters(&Ordinal::two)));
	OLIMCK(admisLevelFunctional(one,Ordinal::two,
		createParameters(&Ordinal::two)));
	

	const Ordinal& axx = admisLevelFunctional(one,zero,
		createParameters(&omega1CK));
	axx.out("axx");

	
	axx.DLISTELTS(count,true);
	axx.limitOrd(omega) ;
	
	OLIMCK(admisLevelFunctional(one,zero,createParameters(&one)));
	OLIMCK(admisLevelFunctional(one,zero,createParameters(&Ordinal::two)));

	axx.listOrdElts(params,ftst);

	OLIMCK(admisLevelFunctional(one,omega1CK,NULL));
	OLIMCK(admisLevelFunctional(Ordinal::two,omega1CK,NULL));
	
	
	(finiteFunctional(omega,zero,zero,zero)*(eps0+omega)).DLISTELTS(count,ftst);
	(psi(2,zero)*(eps0+omega)).DLISTELTS(count,ftst);
	(omega1CK*(eps0+omega)).DLISTELTS(count,ftst);
	const Ordinal &bxb = omega*2 ;
	const Ordinal &cxc = omega + Ordinal::two;
	
	const Ordinal& prod = bxb*cxc ;
	
	Ordinal::powerCheck((omega)*3,(omega)*2 , 
		(omega) + Ordinal::two);
	Ordinal::powerCheck((omega*omega)*3,(omega)*2 , 
		(omega) + Ordinal::two);
	outStream() << "OK\n" ;
	Ordinal::powerCheck((omega^omega)*3,(omega^omega)*2 + omega,
		(omega^omega)*2 + Ordinal::two);
	Ordinal::powerCheck((omega^omega)*6,omega*omega*omega+omega,Ordinal::two);
	Ordinal::powerCheck(omega^omega,omega,Ordinal::two);
	Ordinal::powerCheck(omega*omega,omega,Ordinal::two);
	Ordinal::powerCheck(omega,Ordinal::three,Ordinal::two);
	
	admisExpTest(omega);
	admisExpTest(omega*6);

		
	((omega^(eps0*6))*3).DLISTELTS(count,ftst);

	(eps0^(eps0*3)).DLISTELTS(count,ftst);

	const Ordinal &omb = admisLevelFunctional(one,zero)*6 ;
	const Ordinal &ax = (omega^omb)*3 ;
	const Ordinal &bx = (omega^omb)*2 + omega ;
	const Ordinal &cx = (omega^omb)*2 + Ordinal::two ;
	ax.out("ax");
	bx.out("bx");
	cx.out("cx");
	
	bool agb = ax> bx ;
	bool bgc = bx > cx ;
	outStream() << "agb = " << agb << ", bgc = " << bgc << "\n" ;
	
	
	admisExpTest(eps0*6);
	admisExpTest(omb);


	OLIMCK(admisLevelFunctional(one,Ordinal::two,createParameters(&one)));
	OLIMCK(admisLevelFunctional(one,Ordinal::two,createParameters(&one,&zero)));
	admisLevelFunctional(one,Ordinal::two,createParameters(&Ordinal::two,
		&zero)).DLISTELTS(count,ftst);
	admisLevelFunctional(one,zero,NULL).DLISTELTS(count,ftst);
	admisLevelFunctional(one,zero,createParameters(&one)).DLISTELTS(count,ftst);
	admisLevelFunctional(one,zero,createParameters(&one,
		&zero)).DLISTELTS(count,ftst);

	
	
	admisLevelFunctional(omega,omega1CK,NULL).limitOrd(eps0).out();
	admisLevelFunctional(omega+one,zero,NULL).limitOrd(eps0).out();
	iterativeFunctional(omega,omega).limitOrd(Ordinal::five).out();
	eps0.limitType().out("eps0.limitType");
	eps0.maxLimitType().out("eps0.maxLimitType");
	
	omega1CK.limitOrd(omega^omega).DLISTELTS(count,ftst);
	
	omega1CK.limitOrd(eps0).DLISTELTS(count,ftst);
	iterativeFunctional(omega1CK+omega^omega).DLISTELTS(count,ftst);
	admisLevelFunctional(one,zero,createParameters(&one)).DLISTELTS(count,ftst);
	
	iterativeFunctional(Ordinal::two,NULL).DLISTELTS(count,ftst);
	admisLevelFunctional(eps0,Ordinal::two,NULL).DLISTELTS(count,ftst);
	
	
	
	const Ordinal&as1 = admisLevelFunctional(one,Ordinal::two,NULL);
	const Ordinal&as2 = admisLevelFunctional(one,one,NULL);
	as1.DLISTELTS(count,ftst);
	as2.DLISTELTS(count,ftst);
	(as1*as2).DLISTELTS(count,ftst);
	(as1^as2).DLISTELTS(count,ftst);
	
	
	const Ordinal&a = admisLevelFunctional(eps0,omega,NULL);
	const Ordinal&b = admisLevelFunctional(eps0,one,NULL);
	const Ordinal& six= * new Ordinal(6);
	((omega1CK*omega)^(omega*4)).DLISTELTS(count,ftst);
	((omega1CK*3)^(omega+6)).DLISTELTS(count,ftst);
	((omega1CK*omega)^omega).DLISTELTS(count,ftst);
	((omega1CK*3)^omega).DLISTELTS(count,ftst);
	(omega1CK^omega1CK).DLISTELTS(count,ftst);
	
	(omega1CK*eps0).DLISTELTS(count,ftst);
	(omega1CK*omega).DLISTELTS(count,ftst);
	(omega1CK*3).DLISTELTS(count,ftst);
	(omega1CK*omega1CK).DLISTELTS(count,ftst);
	admisLevelFunctional(one,zero,createParameters(&one)).DLISTELTS(count,ftst);
	admisLevelFunctional(Ordinal::two,zero,createParameters(&one)).
		DLISTELTS(count,ftst);
	admisLevelFunctional(eps0,zero,NULL).DLISTELTS(count,ftst);
	admisLevelFunctional(eps0,omega,NULL).DLISTELTS(count,ftst);
	
	((omega1CK*3)^six).DLISTELTS(count,ftst);
	(omega1CK*(omega1CK*3)).DLISTELTS(count,ftst);
	(omega1CK*(eps0+omega)).DLISTELTS(count,ftst);


	const Ordinal& a5x = admisLevelFunctional(one,zero,
		createParameters(new Ordinal(5),&omega1CK));
	a5x.out("a5x");
	
	a5x.listOrdElts(params,ftst);
	

	bool fftst = true ; 
	omega1CK.listOrdElts(params,fftst);
	
	const Ordinal& ptst0 = admisLevelFunctional(Ordinal::two,zero,NULL)+one;
	ptst0.listOrdElts(params,ftst);
	ptst0.listElts();
	
    outStream() << "xk1\n";
	const Ordinal& ptst1 = admisLevelFunctional(omega,omega1CK,NULL)+one;
	ptst1.listOrdElts(params,ftst);
	ptst1.listElts();
    outStream() << "xk2\n";

	const Ordinal& ptst2 = admisLevelFunctional(omega1CK,zero,NULL)+one;
	ptst2.listOrdElts(params,ftst);
	ptst2.listElts();
    outStream() << "xk3\n";
	
	const Ordinal& tst0 = admisLevelFunctional(Ordinal::two,zero,NULL);
	tst0.listOrdElts(params,fftst);
	tst0.listElts();
    outStream() << "xk4\n";

	const Ordinal& tst1 = admisLevelFunctional(omega,omega1CK,NULL);
	tst1.listOrdElts(params,ftst);
	tst1.listElts();
    outStream() << "xk5\n";

	const Ordinal& tst2 = admisLevelFunctional(omega1CK,zero,NULL);
	tst2.listOrdElts(params,fftst);
	tst2.listElts();

    outStream() << "xk6\n";

}



void admisFollow(const Ordinal & ord, int n, int limit=100)
{
	const Ordinal val(n);
	const Ordinal * const indicies[] = { &val, &omega, &omega1CK,NULL};

	const Ordinal * tord = &ord ;

	outStream() << "\nadmisF entry\n" ;
	const Ordinal * prev = NULL ;
	int count = 0 ; 
	while (true && (count++ < limit)) {
		tord->out( " admisF") ;
		tord->maxLimitType().out(" maxLimitType") ;
		
		if (prev) if(prev->compare(*tord)<=0) {
			ord.out("ord");
			tord->out("tord");
			prev->out("prev");
			assert(0);
		}
		if (tord->maxLimitType().compare(
			CantorNormalElement::integerLimitType)<=0) break ;
		
		prev = tord ;
		tord=&(tord->limit(indicies)) ;
	
	}
	outStream() << count << " admisF exit\n\n" ;

		
	
}

void Validate::admisTest2()
{
    const Ordinal& tst1 = admisLevelFunctional(one,zero);
    tst1.descendFull(5,10,1);
    tst1.descendFull(5,10,2);
    tst1.descendFull(5,10,3);
    const Ordinal& tst2 = tst1.limitOrd(eps0+1);
    tst2.descendFull(5,10,1);
    tst2.descendFull(5,10,2);
    tst2.descendFull(5,10,3);

}


static void play1(const Ordinal& num)
{
	const OrdinalImpl * prev = NULL ;
	const Ordinal * curr = &(admisLevelFunctional(one,zero,createParameters(
		&num))) ;
	while (!prev || prev->compare(curr->getImpl()) > 0) {
		prev = &(curr->getImpl()) ;
		curr = &(curr->limitOrd(Ordinal::two)) ;
		curr->out("curr") ;
	}

}


void Validate::playTest()
{
	bool ftst = true ;
	int count = 10 ;

	(omega1CK*4).limitOrd(omega).out("(omega1CK*4).limitOrd(omega)");
	outStream() << omega1CK.isOne() << " omega1CK.isOne()\n" ;
	
	const Ordinal& dumxx = admisLevelFunctional(one,zero,
		createParameters(&Ordinal::five,&omega1CK)).limitOrd(omega);
	
	dumxx.out("not 1") ;
	const Ordinal & der2 = admisLevelFunctional(omega,Ordinal::one);
	der2.out("der2");
	der2.limitElement(1).out("der2 le(1)");
	

	const Ordinal & der1 = admisLevelFunctional(eps0,omega);
	der1.out("der1");
	der1.limitElement(1).out("der1 le(1)");

	const Ordinal&seg2=admisLevelFunctional(one,zero,createParameters(&one));
		
	seg2.out("seg2");
	const Ordinal & seg3 = seg2.limitElement(1);
	seg3.out("seg3");
	const Ordinal& seg1 = admisLevelFunctional(one,zero,createParameters(&one));
	seg1.out("seg1") ;
	const Ordinal& seg1_1 = seg1.limitElement(1);
	
	seg1_1.out("seg1") ;
    

	 const Ordinal&axex2 =
		admisLevelFunctional(one,zero,createParameters(&eps0, &one));
		
	axex2.out("axex2");
	axex2.limitElement(1).out("axex2 le(1)");
	axex2.limitElement(2).out("axex2 le(2)");
	axex2.limitElement(3).out("axex2 le(3)");


	 const Ordinal&axex =
		admisLevelFunctional(one,zero,createParameters(&eps0, &one));
		
	axex.out("axex");
	axex.limitElement(1).out("axex le(1)");
	axex.limitElement(2).out("axex le(2)");
	axex.limitElement(3).out("axex le(3)");

	


	 const Ordinal&axdx =
		admisLevelFunctional(one,zero,createParameters(&one, &one));
		
	axdx.out("axdx");
	axdx.limitElement(1).out("axdx le(1)");
	axdx.limitElement(2).out("axdx le(2)");
	axdx.limitElement(3).out("axdx le(3)");
	

	finiteFunctional(omega1CK,zero,zero).out("affp");

	const Ordinal& fftlo = finiteFunctional(omega1CK, Ordinal::one,zero);

	fftlo.limitOrd(omega).out("fftlo.limitOrd(omega)");
	
	fftlo.limitOrd(Ordinal::two).out("fftlo.limitOrd(2)");
	
	fftlo.limitOrd(Ordinal::one).out("fftlo.limitOrd(1)");

	const Ordinal& om1sq = (omega1CK*omega1CK);
	om1sq.out("om1cK^2");


	om1sq.limitOrd(Ordinal::two).out("l2");
	om1sq.limitOrd(omega).out("lw");

	const Ordinal tx = omega*5 ;
	
	tx.limitElement(9).out("le9");
	
	
	

	const Ordinal& db1 = AdmisLevOrdinal(one,zero,NULL, Ordinal::two);
	db1.DLISTELTS(count,ftst);

	const Ordinal& dbw = AdmisLevOrdinal(one,zero,NULL,Ordinal::omega);
	dbw.DLISTELTS(count,ftst);

	
	
	

	const Ordinal& dbe = AdmisLevOrdinal(one,zero,NULL,eps0);
	dbe.DLISTELTS(count,ftst);

	const Ordinal& lmdd = AdmisLevOrdinal(one,zero,NULL,omega) ;
	const Ordinal * const indicies[] = { &one, &omega, &omega1CK};
	lmdd.limit(indicies).out("lmdd lm ind");

	admisFollow(lmdd,1);
	lmdd.DLISTELTS(count,ftst);


	const Ordinal& omegat2 = omega*2 ;
	const Ordinal& omegat21 = omegat2.limitElement(1);
	omegat21.out("omegat2");
	
	
	const Ordinal& zxx = admisLevelFunctional(one,zero);
	zxx.out("zxx");
	const Ordinal& zxxt2 = zxx*Ordinal::two ;
	const Ordinal& zxxt21 = zxxt2.limitElement(1);
	zxxt21.out("zxxt21");
	const Ordinal& zxx1 = zxx.limitElement(1);
	zxx1.out("zxx1");
	const Ordinal& zxx1t2 = zxx1*Ordinal::two ;
	zxx1t2.out("zxx1t2");
	const Ordinal& zxx1t21 = zxx1t2.limitElement(1);
	zxx1t21.out("zxx1t21");
	const Ordinal& zxx11 = zxx1.limitElement(1);
	zxx11.out("zxx11");
	const Ordinal& zx = omega ^ (zxx*Ordinal::two) ;
	zx.out() ;

	const Ordinal& zx1 = zx.limitElement(1);
	zx1.out("zx1");

	const Ordinal& zx11 = zx1.limitElement(1);
	zx11.out("zx11");
	
	const Ordinal& z=admisLevelFunctional(one,zero,NULL,one);
	z.DLISTELTS(count,ftst);

	const Ordinal& z2 = admisLevelFunctional(Ordinal::two,zero,NULL,
		one);
	z2.DLISTELTS(count,ftst);

	const Ordinal& z3 = admisLevelFunctional(one,zero,NULL,
		Ordinal::three);
	z3.DLISTELTS(count,ftst);

	const Ordinal& fl = admisLevelFunctional(omega,zero,NULL);
	
	fl.DLISTELTS(count,ftst);
	
	
	fl.limitOrd(Ordinal::six).out();

	omega1CK.limitOrd(omega).out();

	(omega^omega).limitOrd(zero).out("w+1.l(0)");
	(omega^omega).limitOrd(one).out("w+1.l(1)");
	(omega^omega).limitOrd(Ordinal::two).out("w+1.l(2)");
	(omega^omega).limitOrd(Ordinal::three).out("w+1.l(3)");

	const Ordinal& omega1CKp1 = omega1CK+one ;

    

	omega1CKp1.limitType().out("lt");

	const Ordinal& adt1 =
		admisLevelFunctional(one,zero,createParameters(&omega1CKp1)) ;

	adt1.out("adt1");

	adt1.limitType().out("lt");
	(omega+one).limitType().out("lt");
	omega1CK.limitType().out("lt");
	zero.limitType().out("lt");

	const Ordinal * adParams[] = {&one,&Ordinal::two,&omega,&eps0,NULL};



	
	const Ordinal * const  ordLst1[] =
		{&Ordinal::one,&Ordinal::two,&omega,NULL} ;

	const Ordinal * const  ordLst2[] =
		{&eps0,&Ordinal::two,&omega,&one,NULL} ;

	const Ordinal& adx1 =
		admisLevelFunctional(omega,Ordinal::two,ordLst1);
	adx1.out("adms1");
	outStream() << adx1.texNormalForm() << " tex adms1\n" ;


	

	
	

	
	const Ordinal&aw=admisLevelFunctional(1,zero,createParameters(&one));
	
	aw.DLISTELTS(count,true);

	const Ordinal&ax=admisLevelFunctional(1,zero,createParameters(&omega1CK));
	ax.DLISTELTS(count,true);

	const Ordinal &tw = omega1CK^omega1CK ;
	
	const Ordinal& ord = admisLevelFunctional(one,zero,
		createParameters(&tw));
	psi(omega1CK+1,0).maxLimitType().out(" psi(omega1CK+1,0).maxLimitType()");

	const Ordinal& tstx = iterativeFunctional(omega1CK+1);
	tstx.out(" tstx");

	tstx.maxLimitType().out(" tstx.maxLimitType()");

	admisFollow(ord,1);
	admisFollow(ord,2);
	outStream() << "start ord+1\n" ;
	const Ordinal ordP1 = ord + Ordinal::one ;
	ordP1.out("ordP1");
	
	admisFollow(ord+1,2);
	outStream() << "end ord+1\n" ;
	
	
	
	
	
	omega.limitType().out(" w_lim_T");
	(omega1CK).limitType().out(" w_1_lim_T");
	(omega1CK*2).limitType().out(" w_1*2_lim_T");
	(omega1CK*2+12).limitType().out(" w_1*2+12_lim_T");

	const Ordinal op[] = {Ordinal::two,omega,eps0,omega1CK,
		AdmisLevOrdinal(one,Ordinal::two,NULL),
		zero
	};

	listOrds(admisLevelFunctional(omega1CK+1,omega1CK+1),op);

	iterativeFunctional(one,NULL).DLISTELTS(count,ftst);
	admisLevelFunctional(one,Ordinal::two,NULL).DLISTELTS(count,ftst);
	admisLevelFunctional(one,omega,NULL).DLISTELTS(count,ftst);
	admisLevelFunctional(one,one,NULL).DLISTELTS(count,ftst);
	admisLevelFunctional(one,one,createParameters(&one)).DLISTELTS(count,ftst);
	(omega1CK^2).DLISTELTS(count,ftst);
	(omega1CK*2).DLISTELTS(count,ftst);
	listOrds((omega1CK*2),op);

	iterativeFunctional(omega1CK+1,createParameters(&one)).
		DLISTELTS(count,ftst);
	const Ordinal& omx = admisLevelFunctional(one,zero,createParameters(&one)) ;
	const Ordinal&omxp1 = omx + 1 ;
	const Ordinal& omy = iterativeFunctional(omx,
		createParameters(&omxp1));

	omx.limitType().out(" omx lt");
	omxp1.limitType().out(" omxp1 lt");
	omy.limitType().out(" omy lt");

	outStream() << (omega+one).limitType().normalForm() << " w+1 lt\n" ;
	outStream() << (eps0+one).limitType().normalForm() << " epso+1 lt\n" ;
	outStream() << (finiteFunctional(omega,omega,zero)+one).limitType().
		normalForm() << " ff+1 lt\n" ;
	outStream() << (iterativeFunctional(omega,omega)+one).limitType()
		.normalForm() << " if+1 lt\n" ;
	outStream() << (admisLevelFunctional(omega,omega)+one).limitType().
		normalForm() << " admis +1 lt\n" ;
    
	ord.DLISTELTS( count,ftst);

	const Ordinal& aty = admisLevelFunctional(one,zero,createParameters(&one));
	const Ordinal& atx = aty.limitElement(1) ;
	outStream() << atx.normalForm() << " : " << atx.texNormalForm() << "\n" ;

	aty.DLISTELTS(count,true);
	atx.DLISTELTS(count,true);

	
	const Ordinal& ptst = omega+1 ;
	ptst.DLISTELTS(count,ftst);
	((omega*omega).plus_1()).DLISTELTS(count,ftst);
	(omega.plus_1()).DLISTELTS(count,ftst);
	admisLevelFunctional(one,one).DLISTELTS(count,ftst);
	

	iterativeFunctional(one).DLISTELTS(count,ftst);

	listOrds(admisLevelFunctional(one,zero),op);
	listOrds(admisLevelFunctional(one,one),op);

	
	omega1CK.limitOrd(omega);
	
	
	const Ordinal ten(10);
	const Ordinal * const params[] = {
		&zero,&one,&ten,&omega,&eps0,NULL};

	admisLevelFunctional(one,zero,createParameters(&one)).listOrdElts(params,
		true);


	
	(omega1CK*omega).limitType().out() << (omega1CK*omega).getImpl().getFirstTerm()->codeLevel << "\n" ;
	(omega1CK*omega1CK).limitType().out() << (omega1CK*omega1CK).getImpl().getFirstTerm()->codeLevel << "\n" ;

 
	
	(omega1CK*omega).listElts();
	const Ordinal & aa = (omega^(omega^(omega^(omega1CK)))) ;
	const OrdinalImpl& aal = aa.limitType() ;
	outStream() << aal.normalForm() << " aal\n" ;
	aa.listElts();

	const Ordinal & bb = omega^(omega^((eps0+1)^omega1CK+1)) ;
	const OrdinalImpl& bbl = bb.limitType() ;
	outStream() << bbl.normalForm() << " bbl\n" ;
	bb.listElts();


	(omega^omega1CK).listElts();
	(omega^(omega1CK+Ordinal::one)).listElts();
	const AdmisLevOrdinal admis1(Ordinal::one,Ordinal::zero,Ordinal::one);
	outStream() << (omega^omega1CK).normalForm() << "\n" ;
	outStream() << iterativeFunctional(omega1CK).normalForm() << "\n" ;
	admis1.listElts();
	
	outStream() << (eps0+1).getImpl().subtract(1).normalForm()<<" eps0 +1-1\n";

	(omega^(omega1CK+1)).DLISTELTS(count,ftst);
	const Ordinal& psia = psi(Ordinal::two,zero);
	const Ordinal& psib = psi(one,psia);
	LISTELTS(psib,true);
	const Ordinal& psic = psi(one,psi(Ordinal::two,zero));
	LISTELTS(psic,true);
	(psi(one,psi(Ordinal::two,zero))).DLISTELTS(count,ftst);

	LISTELTS(psi(psi(psi(psi(one,psi(eps0,eps0)),zero),one),zero),true);
	LISTELTS(psi(one,psi(Ordinal::two,zero)),true);
	(omega^eps0).DLISTELTS(count,ftst);
	(eps0*eps0).DLISTELTS(count,ftst);
	(psi(7,omega1CK+omega+12)*psi(4,omega1CK*omega+6)).DLISTELTS(count,ftst);
	LISTELTS(psi(Ordinal::one,eps0),ftst);
	LISTELTS(psi(Ordinal::one,omega1CK),ftst);
	LISTELTS(psi(Ordinal::one,omega1CK+8),ftst);
	const Ordinal& epsa = psi(1,0)^psi(1,0) ; 
	epsa.DLISTELTS(count,ftst);
	const Ordinal& epsb = psi(1,0)^epsa ;
	epsb.DLISTELTS(count,ftst);
	const Ordinal& epsc = psi(1,0)^epsb ;
	epsc.DLISTELTS(count,ftst);
	(eps0^eps0).DLISTELTS(count,ftst);
	(eps0^eps0).DLISTELTS(count,ftst);
	(eps0^(eps0^eps0)).DLISTELTS(count,ftst);
	(eps0^(eps0^(eps0^eps0))).DLISTELTS(count,ftst);

	LISTELTS(psi(one,psi(Ordinal::two,zero)),true);


	(omega1CK^(omega1CK^(omega1CK^omega1CK))).describel(outStream());
	(omega1CK^(omega1CK^omega1CK)).describel(outStream());

	const Ordinal& epst = psi(omega1CK+Ordinal::one,0);
	LISTELTS(epst,ftst);
	
	const Ordinal& epst2 = psi(omega1CK,0);
	LISTELTS(epst2,ftst);
	
	(omega1CK^omega1CK).describel(outStream());

	(omega^(omega^omega1CK)).describel(outStream());



	
	bool admisFull = false ; 
	const AdmisLevOrdinal limTsta(one,Ordinal::two,NULL);
	LISTELTS(limTsta,admisFull);
	listOrds(limTsta,op);

	const AdmisLevOrdinal limTst1(one,omega,NULL);
	LISTELTS(limTst1,admisFull);
	listOrds(limTst1,op);

	const AdmisLevOrdinal limTst2(one,limTst1,NULL);
	LISTELTS(limTst2,admisFull);
	listOrds(limTst2,op);


	const IterFuncOrdinal lim1(omega,omega,one);
	const AdmisLevOrdinal limTst3(one,lim1,NULL);
	LISTELTS(limTst3,ftst);
	listOrds(limTst3,op);


	const Ordinal& sTst = omega + 3 ;
	LISTELTS(sTst,admisFull);
	LISTELTS(omega*omega + omega *3,ftst);

	(omega1CK^omega).describel(outStream());
	(omega1CK*omega1CK).describel(outStream());
	(eps0*eps0).describel(outStream());

	psi(1,0).describel(outStream());
	psi(omega,0).describel(outStream());
	LISTELTS(psi(1,omega),ftst);
	LISTELTS(FiniteFuncOrdinal(Ordinal::one,zero),ftst);
	LISTELTS(FiniteFuncOrdinal(Ordinal::two,zero),ftst);
	(omega1CK*omega1CK).describel(outStream());
	
	LISTELTS((omega1CK*omega1CK),ftst);
	
	(omega1CK^omega1CK).describel(outStream());
	Ordinal & tst = * new AdmisLevOrdinal(omega,one,NULL);
	outStream() << tst.getIndexCK().normalForm() << " gIxCK\n" ;
	AdmisLevOrdinal(one,one,NULL).describel(outStream());
	AdmisLevOrdinal ck1(one,zero,Ordinal::one);
	ck1.describel(outStream());
	AdmisLevOrdinal ck(one,zero,NULL);
	(ck^omega).describel(outStream());
	outStream() << (ck^omega).texNormalForm() << " ck^wTeX\n" ;
	outStream() << (omega^ck).texNormalForm() << " w^ckTeX\n" ;
	outStream() << ck.texNormalForm() << " ckTeX\n" ;
	AdmisLevOrdinal oneTwo(one,Ordinal::one,Ordinal::two);
	oneTwo.describel(outStream());
	outStream() << oneTwo.normalForm() << " oneTwo\n" ;
	outStream() << oneTwo.texNormalForm() << " oneTwoTeX\n" ;
	AdmisLevOrdinal(one,Ordinal::one,Ordinal::two).describel(outStream());
	(AdmisLevOrdinal(one,Ordinal::one,Ordinal::two)*omega).describel(outStream());
	AdmisLevOrdinal(one,Ordinal::one).describel(outStream());


}

void Validate::descendTest()
{
	const Ordinal& tst1 = admisLevelFunctional(one,zero,
			createParameters(&Ordinal::one));
	const Ordinal * prev = &tst1 ;
    const int lim = 1000 ;
    int i = 0 ;
	while (i++ < lim) {
		const Ordinal* nxt = NULL ;
		

	if (prev->limitType().compare(CantorNormalElement::integerLimitType)<0) {
			nxt = &(prev->limitElement(1)) ;
			outStream() << "N:" ;
		} else
		if (prev->limitType().compare(CantorNormalElement::recOrdLimitType)<0) {
			nxt = &(prev->limitElement(2)) ;
			outStream() << "I:" ;
		} else {
			nxt = &(prev->limitOrd(omega));
			outStream() << "O" ;
		}
		nxt->out("LENGTH") ;
		assert(prev->compare(*nxt)>0) ;
		assert(nxt->compare(*prev)<0) ;
		if (nxt->compare(omega)<0) break ;
		prev = nxt ;
	}
}


