%{


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ordinal.h"
using namespace ord;
#include <list>
#include "intfc.h"
#include "parse.tab.h"

extern YYSTYPE yylval;
extern bool inContinue ;
void ParseSemantics::yy_flush_bison_buffer()
{YY_FLUSH_BUFFER; BEGIN(0);}
    


#define YY_INPUT(buf,result,max_size) pS->readline(buf,result,max_size)

%}
%option noyywrap
delim         [ \t]
whitesp       {delim}+
string        \"[^\\"\n]*["]
name          [A-Za-z][_A-Za-z0-9]*
number        [0-9]+
continue      \\{delim}*\n
comment      \%.*
ccomment     \/\/.*
bad         .
%%
{number}  { sscanf(yytext, "%d", &yylval.Int); return NUMBER;}
{string}  {yylval.name = new string(yytext) ; return STRING ;}
{name}    {yylval.name = new string(yytext) ; return NAME ;}
"+"       { return PLUS; }
"-"       { return MINUS; }
"*"       { return ASTERISK; }
"^"       { return EXP; }
"("       { return LPAREN; }
")"       { return RPAREN; }
"{"       { return LBRACKET; }
"}"       { return RBRACKET; }
"["       { return LSQBRACKET; }
"]"       { return RSQBRACKET; }
"="       { return ASSIGN; }
","       { return COMMA ;}
"."       { return DOT ;}
"<"     return LESS ;
">"     return GTR ;
"=="     return EQUAL ;
"<="     return LEQ ;
">="     return GEQ ;
"psi_{"     return ITER_BEGIN;
"omega_{"     return OMEGA_BEGIN;
"w_{"     return OMEGA_BEGIN;
"\n"      { inContinue = false ; return NEWLINE ;}
{whitesp} { }
{comment} {}
{ccomment} {}
{continue} {inContinue = true ;}
{bad}       {yylval.Int = yytext[0]; return BAD;}

