#include "ordTop.h"
#include "intfc.h"
#include "validate.h"

using namespace ord ;
using namespace std ;


bool ord::interactiveMode = false ;

#define CmpCheck if(parserState && parserState->runChecks) cmpCheck


const OrdinalImpl& Ordinal::getIndexCK() const
{
	return getImpl().getIndexCK();
}

const Ordinal& Ordinal::limitMaxEmbed(const OrdinalImpl & lim) const
{
    if (isFinite() || (getMaxEmbedIndex().compare(lim) < 0)) return *this ;
    return getImpl().limitMaxEmbed(lim);
}

const Ordinal& Ordinal::getMaxEmbedIndex() const
{
    return getImpl().getMaxEmbedIndex();
}

Ordinal::Ordinal(unsigned long n):ord(*new OrdinalImpl(n))
{
	commonInit();
}

Ordinal::Ordinal(Int n):ord(*new OrdinalImpl(n))
{
	commonInit();
}



Ordinal::Ordinal(const Ordinal& op):ord(op.getImpl())
{
	commonInit();
}


Ordinal::Ordinal(const char * name,const NormalFormTerm&  trms):
	ord(*new OrdinalImpl(name,trms))
{
	commonInit();
}

Ordinal::Ordinal(const OrdinalImpl& impl):ord(impl)
{
	commonInit();
}


Ordinal::~Ordinal()
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::dtrOrd) ;
	if (dbg) outDbgStream() << "Elim ord " << ord.assignedNameString <<  " : " << ord.id <<
		 ", refCnt = " << ord.refCount << "\n" ;
	ord.dereference();
}


const OrdinalImpl& Ordinal::getImpl() const 
{
	return ord;
}

bool Ordinal::isOmegaSuccessor() const
{
    return getImpl().isOmegaSuccessor();
}

bool Ordinal::hasFiniteTerm() const 
{
	return getImpl().hasFiniteTerm;
}

bool Ordinal::isLimit() const 
{
	return getImpl().isLimit();
}

const OrdinalImpl& Ordinal::limitType() const 
{
	return getImpl().limitType();
}

const OrdinalImpl& Ordinal::maxLimitType(const Ordinal& embIx) const 
{
	return getImpl().maxLimitType(embIx);
}


const OrdinalImpl& Ordinal::maxLimitType() const 
{
	return getImpl().maxLimitType();
}

int  Ordinal::psuedoCodeLevel() const
{
	
	return ord.psuedoCodeLevel();
}




int Ordinal::compare(const Ordinal& o) const

{
	return getImpl().compare(o.getImpl());
}


ostream& Ordinal::out(const string  cmt) const 
{
	return ord.out(cmt);
}

const Ordinal& Ordinal::limit(const Ordinal * const * const ords) const
{
	return * new Ordinal(getImpl().limit(ords));
}

const Ordinal& Ordinal::limit(const Int n, const Ordinal& ord) const
{
	return * new Ordinal(getImpl().limit(n,ord));

}

const Ordinal& Ordinal::limitElement(Int n) const 

{
    assert(isLimit());
	return * new Ordinal(getImpl().limitElement(n));
}

const Ordinal& Ordinal::limitOrd(const Ordinal & arg) const 
{
    assert(limitType().compare(arg.maxLimitType())>0);
	return * new Ordinal(ord.limitOrd(arg.getImpl()));
}




const string& Ordinal::assignedName() const 
{
	return getImpl().assignedName();
}

const string Ordinal::normalForm() const 
{
	return getImpl().normalForm();
}

const string Ordinal::texNormalForm() const 
{
	return getImpl().texNormalForm();
}

const string Ordinal::psiNormalForm() const 
{
	return getImpl().psiNormalForm();
}



bool Ordinal::isZero() const 
{
	return getImpl().isZero();
}

bool Ordinal::isOne() const 
{
	return getImpl().isOne();
}

bool Ordinal::isFinite() const 
{
	return getImpl().isFinite();
}


void Ordinal::describe(ostream&out) const 
{
	getImpl().describe(out);
}

void Ordinal::descr(const char * comment) const 
{
	getImpl().descr(comment);
}

void Ordinal::describel(ostream&out) const 
{
	getImpl().describel(out);
}

void Ordinal::commonInit()
{
	ord.reference();
    
}

const Ordinal& Ordinal::plus_1() const
{
	return * new Ordinal(ord.plus_1());
}

const Ordinal& Ordinal::limPlus_1() const
{
	return * new Ordinal(ord.limPlus_1());
}



const Ordinal Ordinal::operator+(const Ordinal&op) const
{
	const OrdinalImpl& result = ord.addLoc(op.getImpl());

	return result ;
}

const Ordinal Ordinal::operator*(const Ordinal&op) const 
{
	const OrdinalImpl& result =  ord.multLoc(op.getImpl());

	return result ;
}


const Ordinal Ordinal::operator^(const Ordinal&op) const
{
	const OrdinalImpl& result =  ord.powerLoc(op.getImpl());

	return result ;
}

const char * Ordinal::sect = "\\subsection" ;
const char * Ordinal::subSect = "\\subsubsection" ;


static string::size_type findN(string& str, char c, int nskip)
{
	assert (nskip > 0);
	string::size_type plusP = str.find(c);
	for (int i = 1 ; i < nskip ; i++) plusP = str.find(c,plusP+1);
	return plusP ;
}
	


static void outExpExamp(ostream& outStream)
{
	outStream << "\n\n\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|l|l|l|}\\hline\n" ;
	outStream << "Expression & Cantor Normal Form& \\Cpp{} code" <<
		"\\\\\\hline\\hline\n" ;
	const Ordinal four(4);
	outStream << "&& {\\tt Ordinal four(4);}\\\\\n" ;
	outStream << "$4^{\\omega^7+3}$ &$";
	outStream << (four^((omega^7)+3)).texNormalForm();
	outStream << "$& {\\tt  four$\\wedge$((omega$\\wedge$7)+3)}\\\\\n" ;
	outStream << "\\hline\n" ;
	const Ordinal five(5);
	outStream << "&& {\\tt five$\\wedge$}\\\\\n" ;
	outStream << "$5^{\\omega^7+\\omega+3}$ &$";
	outStream << (five^((omega^7)+omega+3)).texNormalForm();
	outStream << "$& {\\tt((omega$\\wedge$7)+omega+3)}\\\\\n" ;
	outStream << "\\hline\n" ;
	outStream << "$(\\omega+1)^4$&$" ;
	outStream << ((omega+1)^4).texNormalForm() ;
	outStream << "$&{\\tt (omega+1)$\\wedge$4}\\\\\\hline\n" ;

	string fullExp = ((omega*omega+omega+3)^(omega*omega+omega+1)).
		texNormalForm();
	string::size_type plusP = findN(fullExp,'+',6);
	outStream << "&$" << fullExp.substr(0,plusP+1) << "$&\n" <<
		"{\\tt ((omega$\\wedge$2)+omega+3)$\\wedge$}\\\\\n" ;
	outStream << "$(\\omega^2+\\omega +3)^{\\omega^2+\\omega+1} $&$\n" 
		
		<< fullExp.substr(plusP+2) <<
		"$&{\\tt ((omega$\\wedge$2)+omega+1)}" <<
		"\\\\\\hline\n" ;
	string fullExp2 = ((omega*omega+omega+3)^(omega*omega+omega+2)).
		texNormalForm() ;
	plusP = findN(fullExp2,'+',6);
	outStream << "&$" << fullExp2.substr(0,plusP+1) << "$&\n" <<
		"{\\tt ((omega$\\wedge$2)+omega+3)$\\wedge$}\\\\\n" ;
	outStream << "$(\\omega^2+\\omega +3)^{\\omega^2+\\omega+2} $&$\n" <<
		
		fullExp2.substr(plusP+2) <<
		"$&{\\tt ((omega$\\wedge$2)+omega+2)}" <<
		"\\\\\\hline\n" ;
	outStream << "\\end{tabular}\n" ;
	outStream << "\\caption{\\Cpp{} {\\tt Ordinal} exponentiation examples}\n";
    outStream <<
        "\\mindex{examples {\\tt Ordinal} exponentiation \\Cpp{} code}\n";
        "\\mindex{{\\tt Ordinal} exponentiation \\Cpp{} code examples}\n";
	outStream << "\\label{TabExpExamples}\n" ;
	outStream << "\\end{table}\n\n" ;


}



static void outTabOrdArith(ostream& outStream)
{

	outStream << "\n\n\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|l|l|l|}\\hline\n" ;
	outStream << "Expression & Cantor Normal Form& \\Cpp{} code" <<
		"\\\\\\hline\\hline\n" ;

	outStream << "$(\\omega 4+12) \\omega$ &$" << 
		((omega*4+12)*omega).texNormalForm();
	outStream << "$& {\\tt (omega*4+12)*omega}\\\\\\hline\n" ;

	outStream << "$\\omega (\\omega  4+12)$ &$" << 
		(omega*(omega*4+12)).texNormalForm();
	outStream << "$& {\\tt omega*(omega*4+12)}\\\\\\hline\n" ;

	outStream << "$\\omega^{\\omega  (\\omega+3)}$ &$" << 
		(omega ^ (omega*(omega+3))).texNormalForm();
	outStream <<
		"$& {\\tt omega$\\wedge$(omega*(omega+3))}\\\\\\hline\n" ;

	outStream << "$(\\omega+4) {(\\omega+5)}$ &$" << 
		((omega +4)*(omega+5)).texNormalForm();
	outStream << "$& {\\tt (omega+4)*(omega+5)}\\\\\\hline\n" ;

	outStream << "$(\\omega+2)^{(\\omega+2)}$ &$" << 
		((omega +2) ^ (omega+2)).texNormalForm();
	outStream << "$& {\\tt (omega+2)$\\wedge$(omega+2)}\\\\\\hline\n" ;

	string fullExp = ((omega +3) ^ (omega+3)).texNormalForm();
	outStream << "%%" << fullExp << "\n" ;
	
	string::size_type plusP = findN(fullExp,'+',4);
	outStream << "&$" << fullExp.substr(0,plusP+1) << "$&\\\\\n" ;

	outStream << "$(\\omega+3)^{(\\omega+3)}$ &\n$" << 
		fullExp.substr(plusP+2) ;
	outStream << "$&\n {\\tt (omega+3)$\\wedge$(omega+3)}\\\\\\hline\n" ;

	outStream << "\\end{tabular}\n" ;
	outStream << "\\caption{Ordinal arithmetic examples}\n";
	outStream << "\\mindex{ordinal arithmetic examples}\n";
	outStream << "\\label{TabOrdArith}\n" ;
	outStream << "\\end{table}\n\n" ;
}

static struct ExampParams {
	const char * fname ;
	const char * caption ;
	const char * label ;
	const char * oper ;
} exampParams[] =  {{"tabMult","multiply","Mult","\\times"},
					{"tabPow","exponential","Power","^"}};


void Ordinal::arithExamp(const Ordinal* const * aa,  const char * cls,
	Ordinal::ExampType type)
{
	ExampParams * params ;
	switch (type) {
case multType:
case powerType:
		params = exampParams+type ;
		break ;
default:
		assert(0);
	}
	string fname = params->fname ;
	fname += cls ;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);

	outStream << "\n\n\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|c|c|c|}\\hline\n" ;
	outStream << "$\\alpha$ & $\\beta$ & $\\alpha" << params->oper <<
		"\\beta$" << "\\\\\\hline\\hline\n" ;
	const Ordinal * const * b = aa  ;
	const Ordinal * const * a = aa  ;
	while (*a) {
		
		switch (type) {
case multType:
			multiplyTableLine(**a,**b,outStream);
			break ;
case powerType:
			powerTableLine(**a,**b,outStream);
			break ;
			assert(0);
		}
		b++ ;
		if (!*b) {
			a++ ;
			
			
			b = aa ;
		}
	}
	outStream << "\\hline\\end{tabular}\n" ;
	outStream << "\\caption{{\\tt " << cls << "} " << params->caption
		<< " examples}\n";
    outStream << "\\mindex{examples {\\tt " << cls << "} " << params->caption
        << "}\n" ;
    outStream << "\\mindex{{\\tt " << cls << "} " << params->caption
        << " examples}\n" ;
	outStream << "\\label{Tab" << cls << params->label << "}\n" ;
	outStream << "\\end{table}\n\n" ;
	OutStream::streamManager.pop();
}



void Ordinal::multiplyTableLine(const Ordinal& a, const Ordinal& b,
	ostream & out)
{
	out << "$" << a.texNormalForm() << "$&$" << b.texNormalForm() << "$&$" <<
		(a*b).texNormalForm() << "$\\\\ \n" ;

}

void Ordinal::powerTableLine(const Ordinal& a, const Ordinal& b, ostream & out)
{
	
	const Ordinal& atb = a^b ;
	
	out << "$" << a.texNormalForm() << "$&$" << b.texNormalForm() << "$&$" <<
		atb.texNormalForm() << "$\\\\ \n" ;

}

void Ordinal::texTableLimitElt(const Ordinal::TexTableParameters& params)
{
	const Ordinal & ord = *(params.ord) ;
	ostream & outStream = params.outStream ;
	const Int * indicies = params.indicies ;
	
	outStream << "$" << ord.texNormalForm() << "$" ;
	int index = 0 ;
	Int ix ;
	const OrdinalImpl * prev = NULL ;
	while ((ix = indicies[index++])>-1) {
		const Ordinal & le = ord.limitElement(ix);
		outStream << " & $" << le.texNormalForm() << "$" ;
		assert(ord.isSuccessor() || ord.compare(le)>0);
		if (prev) assert(le.getImpl().compare(*prev)>0);
		prev = &(le.getImpl());
	}
	outStream << "\\\\ \\hline\n" ;

}

static string stringType(const OrdinalImpl& ord)
{
	string ordstr = "$" ;
	ordstr += ord.texNormalForm() ;
	ordstr +="$" ;
	string ret ;
	ret += ordstr ;
	if (ord.compare(CantorNormalElement::nullLimitType)==0) {
		ret = "nullLimitType (" ;
		ret += ordstr ;
		ret += ")" ;
	} else if (ord.compare(CantorNormalElement::integerLimitType)==0) {
		ret = "integerLimitType (" ;
		ret += ordstr ;
		ret += ")" ;
	} else if (ord.compare(CantorNormalElement::recOrdLimitType)==0) {
		ret = "recOrdLimitType (" ;
		ret += ordstr ;
		ret += ")" ;
	} 
	return ret ;
}

void Ordinal::limitTypeTable(const Ordinal * const * ords,
	string ordinalClass,  int part, const char * size)
{
	string fname = "tabLimType" ;
	fname += ordinalClass ;
	if (part) fname += OrdinalImpl::itoa(part) ;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);


	outStream << "\\begin{table}\\centering\n" ;
	if (size) outStream << size << "\n" ;
	outStream << "\\begin{tabular}{|l|r|r|}\\hline\n" ;
	outStream << "{\\tt " << ordinalClass  <<
		"} &{\\tt limitType }&{\\tt  maxLimitType }\\\\\\hline\\hline\n" ;

	while (*ords) {
		outStream <<  "$ " << (*ords)->texNormalForm() << " $& " ;
		outStream << stringType((*ords)->limitType()) << " & " ;
		outStream << stringType((*ords)->maxLimitType()) << "\\\\\\hline\n" ;

			
		ords++;
	}

	outStream << "\\end{tabular}\n" ;
	outStream<<"\\caption{{\\tt " << ordinalClass <<
		" limitType} and {\\tt maxLimitType} examples";
	if (part > 0) outStream << " part " << part ;
	outStream << ".}\n";
    outStream << "\\mindex{examples {\\tt " << ordinalClass <<
        "::limitType}}\n" ;
    outStream << "\\mindex{examples {\\tt " << ordinalClass <<
        "::maxLimitType}}\n" ;
    outStream << "\\mindex{{\\tt " << ordinalClass <<
        "::limitType} examples}\n" ;
    outStream << "\\mindex{{\\tt " << ordinalClass <<
        "::maxLimitType} examples}\n" ;
	outStream << "\\label{Tab" << ordinalClass << "LimTypeExamp";
	if (part>0) outStream << part ;
	outStream << "}\n" ;
	outStream << "\\end{table}\n\n" ;

	OutStream::streamManager.pop();
}



void Ordinal::limitElementTable(const Ordinal * const * ords,
	const Int * indicies, string ordinalClass,  int part, const char * size)
{
	string fname = "tabLimElt" ;
	fname += ordinalClass ;
	if (part) fname += OrdinalImpl::itoa(part) ;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);

	TexTableParameters params(outStream) ;
	params.indicies = indicies ;

	outStream << "\\begin{table}\\centering\n" ;
	if (size) outStream << size << "\n" ;
	outStream << "\\begin{tabular}{|l|" ;
	Int ix ;
	int index = 0 ;
	while ((ix = indicies[index++])> -1) outStream << "l|" ;
	int colCount = index-1;
	outStream << "}\\hline\n" ;
	outStream << "{\\tt " << ordinalClass  << "} & \\multicolumn{" <<
		colCount << "}{c|}\n" ;
	outStream << "{\\tt limitElement}\\\\\\hline\\hline\n$\\omega$\n" ;
	index = 0 ;
	while ((ix = indicies[index++])>-1) outStream << " & " << ix << "\n" ;
	outStream << "\\\\\\hline\\hline\n" ;

	while (*ords) {
		params.ord = *ords ;
		if (params.ord->isLimit()) texTableLimitElt(params);
		ords++;
	}

	outStream << "\\end{tabular}\n" ;
	outStream<<"\\caption{\\MIndex{{\\tt " << ordinalClass <<
		"::limitElement} examples}";
	if (part > 0) outStream << " part " << part ;
	outStream << ".}\n\\mindex{examples {\\tt " <<
       ordinalClass << "::limitElement}}\n" ;
	outStream << "\\mindex{{\\tt " <<
       ordinalClass << "::limitElement} examples}\n" ;
	outStream << "\\label{Tab" << ordinalClass << "LimEltExamp";
	if (part>0) outStream << part ;
	outStream << "}\n" ;
	outStream << "\\end{table}\n\n" ;

	OutStream::streamManager.pop();
}




void Ordinal::limitElementTable(const Ordinal * ords, const Int * indicies,
	string ordinalClass)
{
	string fname = "tabLimElt" ;
	fname += ordinalClass ;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);

	TexTableParameters params(outStream) ;
	params.indicies = indicies ;

	outStream << "\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|l|" ;
	Int ix ;
	int index = 0 ;
	while ((ix = indicies[index++])> -1) outStream << "c|" ;
	int colCount = index-1;
	outStream << "}\\hline\n" ;
	outStream << "{\\tt " << ordinalClass  << "} & \\multicolumn{" <<
		colCount << "}{c|}\n" ;
	outStream << "{\\tt limitElement}\\\\\\hline\\hline\n$\\omega$\n" ;
	index = 0 ;
	while ((ix = indicies[index++])>-1) outStream << " & " << ix << "\n" ;
	outStream << "\\\\\\hline\\hline\n" ;

	while (!(ords->isZero())) {
		params.ord = ords ;
		texTableLimitElt(params);
		ords++;
	}

	outStream << "\\end{tabular}\n" ;
	outStream<<"\\caption{{\\tt " << ordinalClass <<
		"::limitElement} examples.}\n";
    outStream << "\\mindex{examples {\\tt " << ordinalClass <<
        "::limitElement}}\n";
    outStream << "\\mindex{{\\tt " << ordinalClass <<
        "::limitElement} examples}\n";
	outStream << "\\label{Tab" << ordinalClass << "LimEltExamp}\n" ;
	outStream << "\\end{table}\n\n" ;

	OutStream::streamManager.pop();
}

void Ordinal::texTableLimitOrd(const Ordinal::OrdTexTableParameters& params)
{
	const Ordinal & ord = *(params.ord) ;
	ostream & outStream = params.outStream ;
	const Ordinal * const * indicies = params.indicies ;
	
	outStream << "$" << ord.texNormalForm() << "$" ;
	int index = 0 ;
	const Ordinal * ix ;
	const OrdinalImpl * prev = NULL ;
    const Ordinal &limT = ord.limitType();
	while ((ix = indicies[index++])!= NULL) {
        if (limT.compare(ix->maxLimitType())<=0) {
            outStream << " & {\\tt limType} too large ";
        } else {
		    const Ordinal & le = ord.limitOrd(*ix);
		    outStream << " & $" << le.texNormalForm() << "$" ;
		    assert(ord.compare(le)>=0);
		    if (prev) assert(le.getImpl().compare(*prev)>=0);
		    prev = &(le.getImpl());
        }
	}
	outStream << "\\\\ \\hline\n" ;

}


void Ordinal::limitOrdTable(const Ordinal * const * ords,
	const Ordinal * const * indicies, string ordinalClass)
{
	string fname = "tabLimOrd" ;
	fname += ordinalClass ;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);

	OrdTexTableParameters params(outStream) ;
	params.indicies = indicies ;

	outStream << "\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|l|" ;
	const Ordinal * ix ;
	int index = 0 ;
	while ((ix = indicies[index++])!= NULL) outStream << "l|" ;
	int colCount = index-1;
	outStream << "}\\hline\n" ;
	outStream << "{\\tt " << ordinalClass  << "} & \\multicolumn{" <<
		colCount << "}{c|}\n" ;
	outStream << "{\\tt limitOrd}\\\\\\hline\\hline\nparameter" ;
	index = 0 ;
	while ((ix = indicies[index++])!=NULL)
		outStream << " & $" << ix->texNormalForm() << "$\n" ;
	outStream << "\\\\\\hline\\hline\n" ;

	while (*ords) {
		params.ord = *ords ;
		texTableLimitOrd(params);
		ords++;
	}

	outStream << "\\end{tabular}\n" ;
	outStream<<
        "\\caption{{\\tt " << ordinalClass << "::limitOrd} examples.}\n";
    outStream << "\\mindex{{\\tt " << ordinalClass << "::limitOrd} examples}\n";
    outStream << "\\mindex{examples {\\tt " << ordinalClass << "::limitOrd}}\n";

	outStream << "\\label{Tab" << ordinalClass << "LimOrdExamp}\n" ;
	outStream << "\\end{table}\n\n" ;

	OutStream::streamManager.pop();
}



static void ordExamp()
{
	string tname = "tabOrdBaseCppExamp" ;
	string fname = tname;
	fname += ".tex" ;
	ofstream outStream(fname.c_str());
	OutStream::streamManager.push(outStream);

#define CPP_EXAMP(str) outStream << "{\\tt " << "\\verb#" << #str <<"#" \
	<< "}&$" << (str).texNormalForm()  << "$\\\\  \n"

#define cp createParameters	

	outStream << "\\begin{table}\\centering\n" ;
	outStream << "\\begin{tabular}{|l|l|}\\hline\n" ;

	outStream << "\\Cpp{} code& Ordinal\\\\ \\hline \\hline\n" ;
	CPP_EXAMP(omega+12);
	CPP_EXAMP(omega*3);
	CPP_EXAMP(omega*3 + 12);
	CPP_EXAMP(omega^5);
	CPP_EXAMP(omega^(omega^12));
	CPP_EXAMP((omega^(omega^12)*6) + (omega^omega)*8 +12);


	
	outStream << "\\hline\n" ;
	outStream << "\\end{tabular}\n" ;
	outStream<<"\\caption{\\MIndex{{\\tt Ordinal} \\Cpp{} code examples}}\n";
    outStream << "\\mindex{C{\\tt ++ Ordinal} code examples}\n" ;
	outStream << "\\label{TabOrdBaseCppExamp}\n" ;
	outStream << "\\end{table}\n\n" ;

	OutStream::streamManager.pop();
#undef cp
#undef CPP_EXAMP
}





void Ordinal::texDocument()
{
	 ordExamp();
	const Ordinal & o1 = omega+1;
	const Ordinal & o2 = omega+2;
	const Ordinal & o3 = omega^3;
	const Ordinal & o4 = ((omega^3)*2)+2;
	const Ordinal & o5e = (omega^4) +3;
	const Ordinal & o5 = ((omega^4) +(omega^3))+omega*7 +3;
	const Ordinal & o6 = (omega^omega)*3 ;
	const Ordinal * am[] = { &o1, &o2, &o3, &o4, &o5, &o6, NULL};
	const Ordinal * ame[] = { &o1, &o2, &o3, &o4, &o5e, &o6, NULL};


	arithExamp(am,"Ordinal",Ordinal::multType);
	arithExamp(ame,"Ordinal",Ordinal::powerType);
	static const string omg = omega.texNormalForm();
	{
		const Int indicies[] = {1,2,10,100,786,-1};
		const Ordinal ordAry[] = {omega*8,omega^2,omega^3,omega^omega,
			(omega^omega)*(omega*omega),
			(omega^(omega^(omega^omega))),
			zero};
		const Ordinal om8 = omega*8 ;
		
		const Ordinal * ords[] = {&zero,&om8};
		ofstream outStream("ordBaseLim.tex");
		OutStream::streamManager.push(outStream);

		
		limitElementTable(ordAry,indicies,"Ordinal");

		
	}
	{
		ofstream outStream("ordArithBase.tex");
		OutStream::streamManager.push(outStream);
		outTabOrdArith(outStream);
		OutStream::streamManager.pop();
	}
	{
		ofstream outStream("expExamp.tex");
		OutStream::streamManager.push(outStream);
		outExpExamp(outStream) ;
		OutStream::streamManager.pop();
	}

}


void Ordinal::cmpCheck(const Ordinal& a, const Ordinal& b)
{
	bool dbg = false ;
	if (dbg) outStream() << a.normalForm() << " : " << b.normalForm() <<
		" cmpCheck.1\n" ;
	bool hasFinite = a.hasFiniteTerm() || a.isZero();
	bool bHasFinite = b.hasFiniteTerm() || b.isZero();
	bool t1 = a > b ;
	
	bool t2 = b < a ;
	
	bool t3 = a == b ;
	
	const char * result = "FAILED: " ;
    
	if (t1 && t2 && !t3) {
		result = "PASSED: " ;
		return ;
	}
	if (hasFinite) if (!t1 && !t2 && t3) {
		result = "PASSED: " ;
		return ;
	}
	
	if (a.limitType().compare(b.maxLimitType())<=0) if (!t1 && !t2 && t3) {
		result = "PASSED: " ;
		return ;
	}


	outStream() << result << a.normalForm() << " ::\n" << b.normalForm() <<
		" -- " << t1 << ":" << t2 << ":" << t3 << "\n" ;
	if (true) {
		a.out("a");
		b.out("b");
 		OrdinalImpl::debugControl.setCompare(true);
		bool t1 = a > b ;
		outStream() << "a > b = " << t1 << "\n";
		bool t2 = b < a ;
		outStream() << "b < a = " << t2 << "\n" ;
		bool t3 = a == b ;
		outStream() << "a == b = " << t3 << "\n" ;
 		OrdinalImpl::debugControl.pop();
	}
	assert(0);
}


const Ordinal * Ordinal::descend(int index, int limit) const
{
	int count = 0 ;
	const Ordinal * tmp = this;
	outStream() << "Descending " << ord.normalForm() << ", index = " << index
		<< "\n" ;
	if (!isLimit()) return this ;
	while(count++ < limit) {
		const Ordinal&  cur = *tmp ;
        if (!cur.isLimit()) continue ;
		const Ordinal& elt = cur.limitElement(index) ;
		outStream() << "level " << count << " = " << elt.normalForm() << "\n";
		CmpCheck(ord,elt);
		CmpCheck(cur,elt);
		tmp = &elt; 
		if (elt.hasFiniteTerm()) break ;
	}
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	return tmp ;

}




const Ordinal * Ordinal::descendFull(int index, int limit, int sel) const
{
	int count = 0 ;
	const Ordinal * tmp = this;
    if (sel < 1) sel = 1 ;
    if (sel > index) sel = index ;
	outStream() << "Descending full " << ord.normalForm() << ", index = "
        << index << ", sel = " << sel << "\n" ;
	
	while(count++ < limit) {
		outStream() << "\nlevel " << count  << "\n" ;
		const Ordinal  cur = *tmp ;
        for (int i = 1; i <=index ; i ++) {
		    const Ordinal& elt = cur.limitElement(i) ;
            outStream() << "le(" << i << ") = " << elt.normalForm() << "\n";
		    CmpCheck(ord,elt);
		    CmpCheck(cur,elt);
		    if (i==sel) tmp = &elt; 
        }
	    if (tmp->hasFiniteTerm()) {
            outStream() << tmp->normalForm() << " has finite term.\n" ;
            break ;
        }
	}
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	return tmp ;

}


void Ordinal::listEltsTex(int lim, bool doTest, int line) const
{
    listEltsCore(lim,true,doTest,line);
}

void Ordinal::listElts(int lim, bool doTest, int line) const
{
    listEltsCore(lim,false,doTest,line);
}

void Ordinal::listiEltsTex(int lim, bool doTest, int line) const
{
    listEltsCore(lim+1,true,doTest,line,1);
}

void Ordinal::listiElts(int lim, bool doTest, int line) const
{
    listEltsCore(lim+1,false,doTest,line,1);
}


string Ordinal::normalFormOpt(bool texFlag) const
{
    if (texFlag) return texNormalForm();
    return normalForm();
}


void Ordinal::listEltsCore(int lim, bool texFlag, bool doTest, int line, int start) const
{
	outStream() << (start?"\n" : "\nFirst ") << (lim - start) <<
        " limitElements for " << normalFormOpt(texFlag) << "\n" ;
    if (Validate::validationTest) outStream() << "limitType = " <<
        limitType().normalFormOpt(texFlag) << "\nmaxLT = " <<
        maxLimitType().normalFormOpt(texFlag) << "\nlimitInfo = " <<
        CantorNormalElement::limInfoName(getImpl().getLimitInfo()) << "\n" ;
	if (isZero()) {
		outStream() << "Empty listing for zero.\n" ;
		return ;
	}
	const OrdinalImpl * prev = NULL ;
    if (!ord.isLimit()) {
        outStream() << "listElts skipping non limit ordinal "
            << ord.normalForm() << ".\n";
        return ;
    }
	for (int i = start ; i < lim ; i++) {
		const Ordinal& le = ord.limitElement(i) ;
		outStream() << "le(" << i << ") = " << le.normalFormOpt(texFlag) << "\n" ;
		bool abortError = false ;
		if (doTest)  if (isLimit()) abortError = compare(le) <= 0;
		else  abortError = compare(le) < 0;
		if (abortError) {
			debugControl.setCompare();
			compare(le);
			debugControl.pop();
			assert(0);
		}
		if (true) {
			if (doTest && prev) {
				int diff = le.compare(*prev) ;
				
				if ((!isLimit() & (diff <0)) || (isLimit() && (diff <= 0))) {
					outStream() << "BAD DIFF = " << diff <<  " for "
						<< le.normalFormOpt(texFlag) << " :: " <<
                        prev->normalFormOpt(texFlag) << "\n" ;
					assert(0);
				}
			}
			
			prev = &(le.getImpl()) ;
		}
        if (doTest && (i == (lim-1))) {
            if (limitType().compare(CantorNormalElement::integerLimitType)>0) {
                const Ordinal& lo = limitOrd(omega) ;
                outStream() << "lo(omega) = " << lo.normalForm() << "\n" ;
                assert(lo.compare(le)>0);
                assert(compare(lo)>0);
            }
        }
	}
	if (doTest)limitElementTest(3);
	outStream() << "End limitElements\n\n" ;
}

void Ordinal::listOrdElts(const Ordinal * const ords[], bool doTest) const
{
	
	outStream() << "\nOrdLimitElements for "
		<< ord.normalForm() << "\n" ;
    if (Validate::validationTest) outStream() << "limitType = " <<
        limitType().normalForm() << "\nmaxLT = " <<
        maxLimitType().normalForm() << "\nlimitInfo = " <<
        CantorNormalElement::limInfoName(getImpl().getLimitInfo()) << "\n" ;
	const OrdinalImpl * prev = NULL ;
	int limit = 0 ;
	for (int i = 0 ; ords[i]; i++) {
		limit = i +1 ;
		const Ordinal& ord = *(ords[i]) ;
		if (limitType().compare(ord.maxLimitType())<=0) {
            outStream() << "Skipping " << ord.normalForm() << 
                ". MaxLimitType is too big.\n" ;
            continue ;
        }

		const Ordinal& le = limitOrd(ord) ;
		outStream() << "ole(" << ord.normalForm() << ") = "
			<< le.normalForm() << "\n" ;
		int diff = compare(le);
		int typeDiff = ord.maxLimitType().compare(limitType());
		if (typeDiff<0) assert(diff >=0) ;
		else assert (diff >= 0) ; 
		if (true) {
			if (prev)  {
				
				int pdiff = le.compare(*prev);
				if (doTest) if (typeDiff<0) assert(pdiff>0) ;
				else assert(pdiff>= 0) ;
			}
			prev = &(le.getImpl()) ;
		}
	}
	listElts(limit*2,doTest);
	
	if (doTest)limitOrdTest(ords);
	outStream() << "End limitElements\n\n" ;
}



void Ordinal::powerCheck(const Ordinal& a, const Ordinal& b, const Ordinal& c)
{
	bool dbg = false ;
	bool agb = a>b;
	bool bgc = b>c;
	
	if (dbg) outStream() << "powerCheck:\na = " << a.normalForm() <<
		"\nb = " << b.normalForm() << "\nc = " << c.normalForm() << "\n\n" ;

    

	Ordinal atb = a^b ;
	Ordinal btc = b * c ;
	Ordinal atbpc = atb^c ;
	Ordinal atbpatc = a^btc ;

	bool sm = atbpc == atbpatc ;
	if (!agb || !bgc || !sm) {
		outStream() << ":" << !agb << ":" <<  !bgc << ":" << !sm << "\n" ;
		outStream() << " a = " << a.normalForm() << "\n" ;
		outStream() << " b = " << b.normalForm() << "\n" ;
		outStream() << " c = " << c.normalForm() << "\n" ;
		outStream() << " a^b = " << atb.normalForm() << "\n" ;
		outStream() << " b*c = " << btc.normalForm() << "\n" ;
		outStream() << " (a^b)^c = " << atbpc.normalForm() << "\n" ;
		outStream() << " a^(b*c) = "   << atbpatc.normalForm() << "\n" ;
		if (!agb) {
			debugControl.setCompare();
			bool result = a> b ;
			outStream() << "agb = " << result << "\n" ;
			debugControl.pop();
		}
		if (!bgc) {
			debugControl.setCompare();
			bool result = b> c ;
			outStream() << "bgc = " << result << "\n" ;
			debugControl.pop();
		}
		assert(0);
        
	}

	if (true) {
		atb.descr("^ck a^b");
		(b*a).descr("^ck b*a");
		(c*a).descr("^ck c*a");
		btc.descr("^ck b*c");
		atbpc.descr("^ck atbpc");
		(btc*a).descr("^ck btc*a") ;
		atbpatc.descr("^ck atbpatc");
	}
}

void Ordinal::multCheck(const Ordinal& a, const Ordinal& b, const Ordinal& c)
{
	bool agb = a>b;
	bool bgc = b>c;
	
	
	Ordinal atb = a*b ;
	
	
	Ordinal atc = a*c ;
	Ordinal bpc = b + c ;
	Ordinal atbpc = a * bpc;
	Ordinal atbpatc = atb+atc ;
	bool sm = atbpc == atbpatc ;
	if (!agb || !bgc || !sm) {
		outStream() << " a = " << a.normalForm() << "\n" ;
		outStream() << " b = " << b.normalForm() << "\n" ;
		outStream() << " c = " << c.normalForm() << "\n" ;
		outStream() << " atb = " << atb.normalForm() << "\n" ;
		outStream() << " atc = " << atc.normalForm() << "\n" ;
		outStream() << " bpc = " << bpc.normalForm() << "\n" ;
		outStream() << " atbpc = " << atbpc.normalForm() << "\n" ;
		outStream() << " atbpatc = "   << atbpatc.normalForm() << "\n" ;
		assert(0);
	}
	if (true) {
		atb.descr("*CK atb");
		(b*a).descr("*CK b*a");
		atc.descr("*CK atc");
		(c*a).descr("*CK c*a");
		bpc.descr("*CK bpc");
		atbpc.descr("*CK atbpc");
		(bpc*a).descr("*CK bpc*a");
		atbpatc.descr("*CK atbpatc");

	}


}



void Ordinal::multCheck(const Ordinal& a, const Ordinal& b, const Ordinal& c,
	const Ordinal &d)
{
	bool agb = a>b;
	bool bgc = b>c;
	bool cgd = c>d;
	
	
	if (!agb || !bgc || !cgd ) {

        debugControl.setCompare();
	    outStream() <<  "Debug a>b\n" ;
        bool b1 = a>b;

	    outStream() << "Debug b>c\n" ;
        bool b2 = b>c;

	    outStream() << "Debug c>d\n" ;
        bool b3 = c>d;
		debugControl.pop();

		outStream() << agb << " : " << bgc << " : " << cgd << "\n" ;
		outStream() << " a = " << a.normalForm() << "\n" ;
		outStream() << " b = " << b.normalForm() << "\n" ;
		outStream() << " c = " << c.normalForm() << "\n" ;
		outStream() << " d = " << d.normalForm() << "\n" ;
		assert(0);
	}

	multCheck(a,b,c);
	multCheck(a,b,d);
	multCheck(a,c,d);
	multCheck(b,c,d);


	Ordinal::powerCheck(a,b,c);
	Ordinal::powerCheck(a,b,d);
	Ordinal::powerCheck(a,c,d);
	Ordinal::powerCheck(b,c,d);

}

void Ordinal::limitElementTest( int limit, int desLim) const 
{
	const Ordinal& ord = *this ;
	if (!ord.isLimit()) return ;
	outStream() << "\n\nBEGIN LimitElement test for " << ord.normalForm()<<"\n";
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	const OrdinalImpl* prev = 0 ;
	for (int i = 1 ; i < limit; i++) {
		const Ordinal& tmp = ord.limitElement(i) ;
		outStream() << ord.normalForm() << ".limitElement( I = " << i << ") = "
			<<tmp.normalForm() <<"\n";
		if (prev) {
			int diff = tmp.getImpl().compare(*prev);
			bool diffErr = false ;
			if (ord.isLimit()) diffErr = diff <= 0;
			else diffErr = (diff <0) ;
			if (diffErr) {
				ord.out(" ord");
				tmp.out(" tmp");
				prev->out(" prev");
				assert(0);
			}
		}
		prev = &(tmp.getImpl());
		CmpCheck(ord,tmp);
		if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
		bool isLimit = ! tmp.hasFiniteTerm() ;
		const OrdinalImpl* prev2 = 0 ;
		for (int j = 0 ; j < limit ; j++) {
            if (!tmp.isLimit()) continue ;
			const OrdinalImpl * cur = &(tmp.getImpl().limitElement(j)) ;
			const Ordinal& tmp2 = *cur ;
			outStream() << tmp.normalForm() << ".limitElement(J = " << j <<
				") = " << tmp2.normalForm() << "\n";
			CmpCheck(ord,tmp2);
			CmpCheck(tmp,tmp2);
			if (j> 0) {
				bool doTest = isLimit || (j <= ord.getImpl().getFiniteTerm()) ;
				if (doTest && prev2) {
					CmpCheck(tmp2,*prev2);
					
					if (isLimit && prev2)
					
						multCheck(ord,tmp,tmp2,*prev2);
					
				}
			}
			prev2 = cur;
		
		}
		if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	}
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	
	descend(limit,desLim);
	
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	
	outStream() << "END LimitElement test for " << ord.normalForm() << "\n\n" ;

}

void Ordinal::limitOrdTest(const Ordinal * const ords[], int desLim) const 
{
	const Ordinal& ord = *this ;
	if (ord.isZero()) return ;
	outStream() << "\n\nBEGIN LimitOrd test for " << ord.normalForm()<<"\n";
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	const OrdinalImpl* prev = 0 ;
	int limit = 0 ;
	for (int i = 0 ; ords[i]; i++) {
		const Ordinal& ordP = *(ords[i]) ;
		int typeDiff = ordP.maxLimitType().compare(limitType());
        if (ord.limitType().compare(ordP.maxLimitType())<=0) {
            outStream() << "limitOrdTest skipping " << ordP.normalForm()
                << " because MaxLimitType is too big.\n" ;
            continue ;
        }
		const Ordinal& tmp = ord.limitOrd(ordP) ;
		outStream() << ord.normalForm() << ".limitOrd(" 
			<< ordP.normalForm() << ") = "
			<<tmp.normalForm() <<"\n";
		if (prev) {
			
			
			int pdiff = tmp.compare(*prev);
			if (typeDiff<0) assert(pdiff>0) ;
			else assert(pdiff>= 0) ;

		}
		prev = &(tmp.getImpl());
		CmpCheck(ord,tmp);
		if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
		
		bool isLimit = ! tmp.hasFiniteTerm() ;
		for (int j = 0 ; ords[j]; j++) {
			const Ordinal& ordQ = *(ords[j]) ;
			int type2Diff = ordQ.maxLimitType().compare(ordP.limitType());
            if (ordP.limitType().compare(ordQ.maxLimitType())<=0) {
                outStream() << "limitOrdTest skipping " << ordP.normalForm()
                     << ".limitOrd(" << ordQ.normalForm()
                     << ") because MaxLimitType is too big.\n" ;
                 continue ;
            }
			const OrdinalImpl * cur  = &(ordP.limitOrd(ordQ).getImpl()) ;

			const Ordinal& tmp2 = *cur ;

			outStream() << tmp.normalForm() << ".limitORd( " << 
				ordQ.normalForm() << ") = " << tmp2.normalForm() << "\n";
			CmpCheck(ord,tmp2);
			CmpCheck(tmp,tmp2);
			
			if (j> 0) {
				bool doTest = isLimit || (j <= ord.getImpl().getFiniteTerm()) ;
				bool equ =  false ;
				if (doTest) {
					if (!equ) CmpCheck(tmp2,*prev);
					else outStream() << tmp2.normalForm() << ", i = " << i << 
						", j = " << j << " EQUAL\n" ;
					const Ordinal& oprev = *prev;
					if (!equ) if (isLimit && (typeDiff<0)  && (type2Diff < 0))
						multCheck(ord,tmp,tmp2,oprev);
				}
			}
			prev = cur;
		
		}
		if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	}
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	
	descend(3,desLim);
	
	if (Validate::useDeleteUnref) OrdinalImpl::deleteUnref();
	
	outStream() << "END LimitElement test for " << ord.normalForm() << "\n\n" ;

}


static void limitElementComboTest(const Ordinal& a, const Ordinal &b, const Ordinal& c)
{
	static const int count = 3 ;
	const Ordinal ** list = new const Ordinal *[count] ;
	int i = 0 ;
	list[i++] = &a ;
	list[i++] = &b ;
	list[i++] = &c ;

	for (int i = 0 ; i < count ; i++) {
		const Ordinal& x = *(list[i]) ;
		x.limitElementTest();
		for (int j = 0 ; j < count ; j++) {
			const Ordinal& y = *(list[j]) ;
			const Ordinal xpy = x+y;
			const Ordinal xty = x*y;
			const Ordinal xey = x^y;
			const Ordinal z1 = xpy * xpy ;
			const Ordinal z2 = xpy^xpy ;
			y.limitElementTest();
			xpy.limitElementTest();
			xty.limitElementTest();
			xey.limitElementTest();
			z1.limitElementTest();
			z2.limitElementTest();
			
		}

	}
}

OutStream::OutStream():currentStream(&cerr),debugStream(0)
{
}

ostream& ord::outStream()
{
    if (ord::pS->out) return *(ord::pS->out) ;
	return OutStream::streamManager.outStream();
}

ostream& ord::outDbgStream()
{
    if (ord::pS->out) return *(ord::pS->out) ;
	return OutStream::streamManager.outDbgStream();
}

const Ordinal& ord::expFunctional(const Ordinal&exponent, Int factor)
{
    if (factor==0) return Ordinal::zero ;
    assert(factor>0);
    return * new Ordinal( OrdinalImpl::expFunctional(
        exponent.getImpl(),factor));
}



const Ordinal& ord::psi(const Ordinal&a, const Ordinal&b)
{
	bool dbg = false ;
	if (dbg) outStream() << "creating psi(" << a.normalForm() << ", " <<
			b.normalForm() << ")\n" ;
	if (a.isZero()) return
		*new Ordinal(CantorNormalElement::createExpOrdinal(b.getImpl()));

    
    int acmpb = a.compare(b);
    if ((acmpb == -1) || (acmpb ==1) && b.isZero()) {
        const Ordinal * params[3]  ;
        params[2]=NULL ;
        params[0]= &a;
        params[1]= &b ;
        int ix = 0 ;
        if (acmpb == -1) ix = 1 ;
        
        if (FiniteFuncOrdinal::fixedPoint(ix,params)) return *(params[ix]) ;
    }
	int aPcl = a.getImpl().psuedoCodeLevel();
    

	const Ordinal * ret = new FiniteFuncOrdinal(a,b);
	if (dbg) outStream() << "created psi = " << ret->normalForm() << "\n" ;
	return *ret ;
}


const Ordinal& ord::finiteFunctionalTest(const Ordinal* const * params,
	bool& fixedPointCreate)
{
	fixedPointCreate = false ;
	if (!params) return Ordinal::one ;
	int size = 0 ;
	for (;params[size];size++);
	if (!size) return Ordinal::zero ;
	if (size == 1) return psi(Ordinal::zero,*(params[0]));
	if (size == 2) return psi(*(params[0]),*(params[1]));

	int leastNz=0 ;
	while ((leastNz< size) && params[leastNz]->isZero()) leastNz++;
	
	size -= leastNz ;
	if (!size) return Ordinal::one ;
	if (size == 1) return psi(Ordinal::zero,*(params[0]));
	if (size == 2) return psi(*(params[0]),*(params[1]));

	int maxIndex = -1 ;
	for (int index = 0 ; index < size; index++) {
		if (params[index]->getImpl().psuedoCodeLevel() ==
			CantorNormalElement::cantorCodeLevel) continue ;
		if (maxIndex < 0) maxIndex = index ;
		else if (params[maxIndex]->compare(params[index]<0)) maxIndex = index ;
	}
	if (maxIndex >= 0) {
		bool maxPredNz = false ;
	
		for (int i = size-1; i> maxIndex; i--) if (!params[i]->isZero()) {
			maxPredNz = true;
			 break;
		}
		if (!maxPredNz)
		if (FiniteFuncOrdinal::fixedPoint( maxIndex,params)) {
			fixedPointCreate = true ;
			return * (params[maxIndex]);
		}
	}

	return * new FiniteFuncOrdinal(params);
	
}

const Ordinal& ord::finiteFunctional(const Ordinal* const * params)
{
	bool dummy ;
	return finiteFunctionalTest(params,dummy);
}

const Ordinal& ord::finiteFunctional(const Ordinal& ord1, const Ordinal&ord2,
	const Ordinal& ord3)
{
	return finiteFunctional(createParameters(
		&ord1,&ord2,&ord3));
}

const Ordinal& ord::finiteFunctional(const Ordinal& ord1, const Ordinal&ord2,
	const Ordinal& ord3, const Ordinal&ord4)
{
	return finiteFunctional(createParameters(
		&ord1,&ord2,&ord3,&ord4));

}

const Ordinal& ord::finiteFunctional(const Ordinal& ord1, const Ordinal&ord2,
	const Ordinal& ord3, const Ordinal&ord4, const Ordinal&ord5)
{
	return finiteFunctional(createParameters(
		&ord1,&ord2,&ord3,&ord4,&ord5));

}

static const Ordinal* const * const removeLeadingZeros(
		const Ordinal* const * const params)
{
	const Ordinal* const *  nParams = params ;
	if (params) {
		int firstNz = 0 ;
		while (params[firstNz] && params[firstNz]->isZero()) firstNz++ ;
		if (firstNz > 0) {
			if (!params[firstNz]) return NULL ;
			int size = firstNz ;
			while (params[++size]) ;
			int newSize = size - firstNz ;
			const Ordinal ** newParams = new const Ordinal *[newSize] ;
			newParams[newSize] = 0 ;
			for (int i = 0 ; i < newSize;i++) newParams[i] = params[i+firstNz];
			nParams = newParams ;
		}
	}
	return nParams ;
}

static const Ordinal* const * const adjustParams(const Ordinal& iter,
	const Ordinal* const * const paramsIn, const Embeddings& embed,
    bool& maxPredNz, int& maxIndex )
{
	
	const Ordinal* const * const params = removeLeadingZeros(paramsIn);
	maxPredNz = false ;
	
	
	maxIndex = FiniteFuncOrdinal::maxIndexPosUndefined;
	int size = 0 ;
	if (params) for (;params[size];size++);
	int leastNz=0 ;
	while ((leastNz< size) && params[leastNz]->isZero()) leastNz++;
	size -= leastNz ;
	if (size) {
		for (int index = 0 ; index < size; index++) {
			
			if (maxIndex < 0) maxIndex = index ;
			else if (params[maxIndex]->getImpl().compare(embed,embed,
                params[index]->getImpl())<0) {
				maxIndex = index ;
			}
		}
		if (maxIndex > IterFuncOrdinal::iterMaxParam)
			if (params[maxIndex]->getImpl().compare(embed,embed,iter.getImpl())<0) {
				maxPredNz = true ;
				maxIndex=IterFuncOrdinal::iterMaxParam ;
			}
	} else if (!iter.isZero()) 	maxIndex=IterFuncOrdinal::iterMaxParam ;
	
	if (maxIndex > IterFuncOrdinal::iterMaxParam )
		for (int i = size-1; i> maxIndex; i--) if (!params[i]->isZero()) {
			maxPredNz = true;
			break;
		}
	
	return params ;
}

const Ordinal& ord::iterativeFunctional(const Ordinal& iter,
	const Ordinal* const * params)
{

	if (iter.isZero()) return finiteFunctional(params);
	bool maxPredNz = false ;
	int maxIndex = FiniteFuncOrdinal::maxIndexPosUndefined  ;
	params = adjustParams(iter,params,Embeddings::embedNone,maxPredNz,maxIndex);
	if (!maxPredNz && IterFuncOrdinal::fixedPoint(iter,maxIndex,params)) {
		
		if (maxIndex == IterFuncOrdinal::iterMaxParam) return iter ;
		return *(params[maxIndex]);
	} else return * new IterFuncOrdinal(iter,params);

}

const Ordinal& ord::iterativeFunctional(const Ordinal& iter,
	const Ordinal& ord1)
{

	return iterativeFunctional(iter,createParameters(
		&ord1));


}

const Ordinal& ord::iterativeFunctional(const Ordinal& iter,
	const Ordinal& ord1, const Ordinal&ord2)
{

	return iterativeFunctional(iter,createParameters(
		&ord1,&ord2));

}

const Ordinal& ord::iterativeFunctional(const Ordinal& iter,
	const Ordinal& ord1, const Ordinal&ord2, const Ordinal& ord3)
{

	return iterativeFunctional(iter,createParameters(
		&ord1,&ord2,&ord3));


}

const Ordinal& ord::iterativeFunctional(const Ordinal& iter,
	const Ordinal& ord1, const Ordinal&ord2, const Ordinal& ord3,
	const Ordinal&ord4)
{

	return iterativeFunctional(iter,createParameters(
		&ord1,&ord2,&ord3,&ord4));

}

const Ordinal& ord::admisLevelFunctional(const Ordinal& levCK,
		const Ordinal& iter, const Ordinal* const * params,
		const Ordinal& drillDown, const Ordinal& embOrd)
{
    Embeddings & embed = * new Embeddings(embOrd,
        embOrd.isZero()? Embeddings::none:Embeddings::paramRestrict);
    return admisLevelFunctional(levCK, iter, params, drillDown, embed);
}


const Ordinal& ord::admisLevelFunctional(const Ordinal& levCK,
		const Ordinal& iter, const Ordinal* const * params,
		const Ordinal& drillDown, const class Embeddings& embedIn)
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
    bool dd = !drillDown.isZero();
    const Embeddings * embedSet = &embedIn ;
    if (embedIn.isParamRestrict() && dd && (levCK.compare(embedIn.embedIndex)
        ==0)) embedSet = &Embeddings::embedNone ; 
    const Embeddings& embed = *embedSet ;
	if (levCK.isZero() && embed.type == Embeddings::none)
        return iterativeFunctional(iter,params);
    int size=0 ;
    if (params) {
        for (int i = 0 ; params[i]; size = ++i);
    }
    if (!AdmisNormalElement::validAdmisNormalElement(levCK,iter,params,
        drillDown,embed)) {
        if (interactiveMode) {
            outStream() << "Result set to 0.\n" ;
            return Ordinal::zero ;
        }
        assert(0);
    }
    const Ordinal* ret = NULL ;
	bool maxPredNz = false ;
	int maxIndex = FiniteFuncOrdinal::maxIndexPosUndefined  ;
	params = adjustParams(iter,params,embedIn,maxPredNz,maxIndex);
	if (maxIndex == FiniteFuncOrdinal::maxIndexPosUndefined) {
		ret = new AdmisLevOrdinal(levCK,zero,NULL,drillDown,embed);
	} else {
	    assert(!iter.isZero() ||
		(maxIndex > FiniteFuncOrdinal::maxIndexPosUndefined )) ;
        if  (!maxPredNz && AdmisLevOrdinal::fixedPoint(levCK.getImpl(),iter,
			maxIndex,params,embedIn)) {
		    if (maxIndex == IterFuncOrdinal::iterMaxParam) ret = &iter ;
		    else  ret =  (params[maxIndex]);
	    } else {
            ret = new AdmisLevOrdinal(levCK,iter,params,drillDown,embed);
        }
        if (embed.type == Embeddings::paramRestrict) {
            const CantorNormalElement * elt = ret->getImpl().getFirstTerm();
            assert(elt &&
                elt->codeLevel >= AdmisNormalElement::admisCodeLevel);
            const AdmisNormalElement &aelt = 
                *(const AdmisNormalElement *)elt;
            const AdmisLevOrdinalImpl & admisRet =
                (const AdmisLevOrdinalImpl&) ret->getImpl();
            if (aelt.embeddings.type != Embeddings::paramRestrict ||
                (aelt.embeddings.type == Embeddings::paramRestrict &&
                (aelt.embeddings.embedIndex.compare(embed.embedIndex))
                >0)) {
                    ret = new Ordinal(admisRet.addEmbeddings(embed));
            }
        }
    }
    assert(ret);
    if (dbg) {
       outStream() << "admisLevFunc: getMaxEmbed = " <<
             ret->getMaxEmbedIndex().normalForm() << "\n" ;
        const CantorNormalElement * elt = ret->getImpl().getFirstTerm();
        if (elt) outStream() << "elt getMaxEmbed = " <<
        elt->getMaxEmbedIndex().normalForm() << "\n" ;
    }

    return *ret;
}



const Ordinal* const * const  ord::createParameters(
	const Ordinal * ord1, const Ordinal * ord2, const Ordinal * ord3,
	const Ordinal * ord4, const Ordinal * ord5,
	const Ordinal * ord6, const Ordinal * ord7,
	const Ordinal * ord8, const Ordinal * ord9)

{
	static const int maxParam = 9 ;
	const Ordinal * params[maxParam] ;
	int i = 0 ;
	params[i++] = ord1 ;
	params[i++] = ord2 ;
	params[i++] = ord3 ;
	params[i++] = ord4 ;
	params[i++] = ord5 ;
	params[i++] = ord6 ;
	params[i++] = ord7 ;
	params[i++] = ord8 ;
	params[i++] = ord9 ;
	assert(i=maxParam);
	int size ;
	for (size = 0 ; (size < i) && params[size] ; size++) ;
	assert(size > 0);
	const Ordinal**  retParams = new const Ordinal* [size+1] ;
	retParams[size] = NULL ;
	for (int i = 0 ; i < size; i++) retParams[i] =
		new Ordinal(params[i]->getImpl()) ;
	
	return retParams ;

}



const Ordinal* const * const ord::replace1Parameter(
		const Ordinal* const * const base,
		int ix1, const Ordinal& ord1)
{
	assert(ix1>=0);
	int count = 0 ;
	while(base[count++]) ;
	assert(ix1<count);
	int newSize = count ;
	if ((ix1 == 0) && ord1.isZero()) newSize -- ;
	if (newSize < 1) return NULL ;
	int offset = count - newSize ;
	const Ordinal ** result = new const Ordinal *[newSize] ;
	for (int i = 0 ; i < newSize ; i++) {
		if ((i + offset) == ix1) result[i] = &ord1 ;
		else result[i] = base[i+offset] ;
	}
	return result ;


	
}

const Ordinal* const * const ord::replace2Parameters(
		const Ordinal* const * const base,
		int ix1, const Ordinal& ord1, int ix2, const Ordinal& ord2)
{
	assert(ix2>ix1) ;
	assert(ix1>=0) ;
	int count = 0 ;
	while(base[count++]) ;
	assert(ix2<count);
	int newSize = count ;
	if ((ix1 == 0) && ord1.isZero()) {
		newSize -- ;
		if ((ix2 == 1) && ord2.isZero()) newSize-- ;
	}
	if (newSize < 1) return NULL ;
	int offset = count - newSize ;
	const Ordinal ** result = new const Ordinal *[newSize] ;
	for (int i = 0 ; i < newSize ; i++) {
		if ((i + offset) == ix1) result[i] = &ord1 ;
		else if ((i + offset) == ix2) result[i] = &ord2 ;
		else result[i] = base[i+offset] ;
	}
	return result ;
}



const Ordinal** ord::createParamArray(Int n, int& nint)
{
	assert(n.fits_slong_p());
	nint = n.get_si();
    assert(nint>0) ;
	const Ordinal** params = new const Ordinal * [nint+1] ;
	params[nint] = NULL ;
	for (int i = 0 ; i < nint ; i++) params[i] = &Ordinal::zero ;
	return params ;
}





