#include "ordTop.h"

#include <iomanip>
#include <fstream>

using namespace ord ;


void DebugControl::updateFlags(DebugControlParam& param, bool addFlag)
{
	if (addFlag) param.flags |= currentLevel->flags ;
	push(*(currentLevel = &param)) ;
}

void OrdinalImpl::deleteUnref()
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::refList) ;
	list<OrdinalImpl *>::iterator ordImp ;
	if (dbg) outDbgStream() << "Cleaning up unreferenced OrdinalImp\n" ;
   for(ordImp=urefImp.begin(); ordImp != urefImp.end(); ordImp++  ) {
		if (dbg) outDbgStream() << (*ordImp)->id << " : " <<
			(*ordImp)->assignedNameString <<
			", refCnt = " << (*ordImp)->refCnt() << "\n" ;
			(*ordImp)->clearInDeleteList(); ;
		if ((*ordImp)->refCnt() == 0) if ((*ordImp)->id > 1) {
			delete *ordImp ;
		}
		
	}
	urefImp.erase(urefImp.begin(),urefImp.end());
}


void OrdSubs::OrdSub::push(OrdSub * sub)
{
	sub->stack = this ;
	sub->next = next ;
	next = NULL ;

}

OrdSubs::OrdSub * OrdSubs::OrdSub::pop()
{
	if (stack) stack->next = next ;
	return stack ;
}

bool CantorNormalElement::isOne() const 
{
	return factor ==1 && exponent.isZero();
}


const Ordinal& CantorNormalElement::getMaxEmbedIndex() const
{
    return exponent.getMaxEmbedIndex();
}

const CantorNormalElement& CantorNormalElement::limitMaxEmbed(
            const OrdinalImpl&lim) const
{
    if (exponent.isFinite() || (exponent.getMaxEmbedIndex().compare(lim)<0))
        return *this;
    return * new CantorNormalElement(exponent.limitMaxEmbed(lim).getImpl(),
        factor);
}



bool CantorNormalElement::isOmega() const
{
    if (codeLevel > cantorCodeLevel) return false ;
    if (factor != 1) return false ;
    return exponent.isOne();

}


static void breakCheck(){}


const InterpNormalElement *  OrdSubs::getOrdSub(const OrdinalImpl& ix) const 
{

	return NULL ;
}


string OrdinalImpl::itoa(Int num)
{
    	stringstream converter;
    	converter << num;
    	return converter.str();
}

Int OrdinalImpl::getInt() const
{
	if (!terms) return 0 ;
	if (!terms->term.exponent.isZero()) return -1 ;
	return terms->term.factor ;
}

int OrdinalImpl::get_int() const
{
    Int v = getInt();
    if (!v.fits_sint_p()) return -1 ;
    return v.get_si();
}

void CantorNormalElement::commonInit()
{
    theLimitType = theMaxLimitType = theEmbedLimitType =
        theMaxEmbedLimitType = NULL ;
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::ctrElt) ;
	assert(factor>0);
	exponent.reference();
	if (dbg) {
		outDbgStream().fill('0');
		outDbgStream() << setw(7) << id <<  " Made CantorNormalElement\n" ;
		outDbgStream().fill(' ');
	}
}



void CantorNormalElement::outOperands(char  oper, const CantorNormalElement& b)
	const
{
	return outOperands(oper, *this,b);
}


static void outChar(char c, int count = 4)
{
	char ar[2] ;
	ar[0] = c ;
	ar[1] = '\0' ;
	for (int i = 0 ; i < count ; i++) outDbgStream() << ar ;
}




void CantorNormalElement::outOperands(char  oper, const CantorNormalElement& a, 
	const CantorNormalElement& b) 
{
	const char * doing = 0 ;
	if (oper == '+') doing = "Elt Adding" ;
	if (oper == '*') doing = "Elt Multiplying" ;
	if (oper == '^') doing = "Elt Exponentiating" ;
	assert(doing != NULL);
	
	outDbgStream() << doing << " : [" << a.normalForm() << "] " ;
	outChar(oper);
	outDbgStream() << " [" << b.normalForm() << "]::" ;
	outDbgStream() << "\n" ;

}

CantorNormalElement::CantorNormalElement(int n, const OrdinalImpl& one):
	codeLevel(cantorCodeLevel),termValue(NULL),
	factor(n),
	theLimitTypeInfo(unknownLimit),
	exponent(OrdinalImpl::zero),refCount(0),id(count++)
{
	commonInit();
}

CantorNormalElement::CantorNormalElement(const Parameters * params, Int fac):
	parameters(params),termValue(NULL),
	codeLevel(params->codeLevel),
	exponent(*(params->exponent)),
	theLimitTypeInfo(unknownLimit),
	factor(fac),refCount(0),id(count++)
{
	commonInit();

}

CantorNormalElement::CantorNormalElement(const CantorNormalElement&elt):
	codeLevel(elt.codeLevel),termValue(NULL),
	factor(elt.factor),exponent(elt.exponent),
	theLimitTypeInfo(unknownLimit),
	refCount(0),id(count++)
{
	commonInit();
	cerr << "Bad to copy\n" ;
	assert(0);
	exit(1);
}

CantorNormalElement::CantorNormalElement(const OrdinalImpl& expon, Int f):
	codeLevel(cantorCodeLevel),termValue(NULL),
	factor(f),
	exponent(expon),
	theLimitTypeInfo(unknownLimit),
	refCount(0),id(count++)
{
	commonInit();
}

CantorNormalElement::CantorNormalElement(const OrdinalImpl& expon, Int f,
	int codeLev):termValue(NULL),
	codeLevel(codeLev),
	factor(f),exponent(expon),
	theLimitTypeInfo(unknownLimit),
	refCount(0),id(count++)
{
	commonInit();
}


CantorNormalElement::~CantorNormalElement()
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::dtrElt) ;
	if (dbg) {
		outDbgStream().fill('0');
		outDbgStream() << setw(7) << id << " Removing CantorNormalElement\n" ;
		outDbgStream().fill(' ');
	}
	exponent.dereference();
}


const OrdinalImpl& CantorNormalElement::getCompareIndexCK(bool ign) const
{
    
    return getMaxParameter().getCompareIndexCK(ign);
}
	
const OrdinalImpl& CantorNormalElement::maxLimitType() const
{
    return maxLimitType(Ordinal::zero);
}

const OrdinalImpl& CantorNormalElement::maxLimitType(const Ordinal& embIx)
    const
{
	if (embIx.isZero()) if (theMaxLimitType) return *theMaxLimitType ;

	const OrdinalImpl * maxRet = &nullLimitType ;
	if (!isFinite()) {
	 	maxRet = &integerLimitType ;
		if (!exponent.isFinite()) maxRet = &(exponent.maxLimitType(embIx));
	}
    if (embIx.isZero()) {
	    ((CantorNormalElement *)this)->theMaxLimitType= maxRet;
	    return *theMaxLimitType ;
    }
    if (!embIx.isZero()) maxRet = &(AdmisNormalElement::boundedLimitType(
        embIx,*maxRet));
    return *maxRet ;
}

const OrdinalImpl& CantorNormalElement::limitInfo(
	LimitTypeInfo& typeInfo) const 
{

	assert(!theLimitType);
	typeInfo = unknownLimit ;
	const OrdinalImpl * type = NULL ;
	
	if (exponent.isZero()) {
		typeInfo = finiteLimit ;
		type = &nullLimitType ;
	} else if (!exponent.isLimit()) {
		typeInfo = paramSucc ;
		type = &integerLimitType ;
	} else {
		typeInfo = paramLimit ;
		type = &(exponent.limitType());
	}
	
	
	

	CantorNormalElement * setThis = (CantorNormalElement *)this;
	setThis->theLimitType = type ;
	setThis->theLimitTypeInfo = typeInfo ;
	
	return *theLimitType ;

}


const OrdinalImpl& CantorNormalElement::limitType() const
{
	if (theLimitType) return *theLimitType ;
	LimitTypeInfo typeInfo;
	return limitInfo(typeInfo) ;

}

CantorNormalElement::LimitTypeInfo CantorNormalElement::getLimitInfo() const
{
    if (theLimitType == NULL) limitType();
    return theLimitTypeInfo ;
}

static const OrdinalImpl& returning(bool dbg, const char *id,
	const OrdinalImpl& ret, const Int& n,  const CantorNormalElement& from)
{
	if (!dbg) return ret ;
	outDbgStream() << "CantorNormalElement::limitElement at " << id << ", ret = "
		 << ret.normalForm() << " from " << from.normalForm() << ", n = "
		<< n << "\n" ;
	return ret;
}

#define RETURN3(id,x) return returning(dbg, id, x, n, *this)

const OrdinalImpl& CantorNormalElement::fixedPointCheck(const OrdinalImpl& exp,
	const Int& fact)
{
	
	
	const CantorNormalElement * expFirstTerm = exp.getFirstTerm();
	
	
	if (exp.psuedoCodeLevel() > cantorCodeLevel) {
		if (fact > 1) return exp.multLoc(fact);
		else return exp ;
	}
	return * new OrdinalImpl(* new CantorNormalElement(exp,fact));
}


const OrdinalImpl& CantorNormalElement::addFactorPart(const OrdinalImpl& r)
	const 
{
	const OrdinalImpl * ret = &r ;
	if (factor>1) {
		const OrdinalImpl& toAdd = getCopy(factor-1).termToOrdinal();
		ret = &(toAdd.addLoc(r)) ;
	}
	return *ret ;

}

const OrdinalImpl& CantorNormalElement::limitElement(Int n)const
{
	assert(codeLevel==cantorCodeLevel);
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
    
	if (dbg) outDbgStream() << "CantorNormalElement::limitElement(" << n
		<< "), factor = " << factor << ", exp = " << exponent.normalForm()
		<< "\n" ;
	const OrdinalImpl * trailingTerm = NULL ;
	if (exponent.hasFiniteTerm) {
		if (exponent.compare(one)==0) trailingTerm = new OrdinalImpl(n);
		else {
			const OrdinalImpl& expSubOne = exponent.subtract(1) ;
				
			trailingTerm = &(fixedPointCheck(expSubOne,n));
			
			if (dbg) trailingTerm->out("trailingTerm");
			
		}
	} else {
		if (factor > 1) {
			const CantorNormalElement& addElt = getCopy(1);
			trailingTerm = &(addElt.limitElement(n)) ;
		} else {
			const OrdinalImpl* newExp =  &(exponent.limitElement(n)) ;
			
			const CantorNormalElement * expFirstTerm = newExp->getFirstTerm();
			
			if (expFirstTerm && (expFirstTerm->codeLevel > cantorCodeLevel) &&
				(expFirstTerm->factor == 1) && !newExp->getSecondTerm()) {
				trailingTerm = newExp ;
				
			} else {
                trailingTerm = &(fixedPointCheck(*newExp,1));
			}
		}
	}
	assert(trailingTerm);
	if (dbg) trailingTerm->out("trailingTerm before");
	if (factor > 1) {
		OrdinalImpl* addFactor = new OrdinalImpl(getCopy(factor-1));
		trailingTerm = &(addFactor->addLoc(*trailingTerm)) ;
	}
	if (dbg) trailingTerm->out("trailingTerm");
	RETURN3("C", * trailingTerm);
}

const OrdinalImpl& CantorNormalElement::getImpl(const Ordinal& ord)
{
	return ord.getImpl();
}

const OrdinalImpl& CantorNormalElement::createOrdinal(const OrdinalImpl& ord)
{
	return *new OrdinalImpl(ord);

}

const OrdinalImpl& CantorNormalElement::createOrdinal(Int n)
{
	return * new OrdinalImpl(n);
}


const OrdinalImpl & CantorNormalElement::createOrdinal(const string& name,
	const NormalFormTerm& t) 
{
	return * new const OrdinalImpl(name,t);
}

static bool requiresParenthesis(string & str)
{
    const char * special = "+*^" ;
    int length = str.length();
    const char * dat = str.data();
    const char * ptr = dat ;
    while ((ptr < (dat+length)) && isspace(*ptr)) ptr++;
    if (ptr < (dat+length) && *ptr == '(') {
        ptr = dat+length -1 ;
        while((ptr >= dat) && isspace(*ptr)) ptr-- ;
        if ((ptr >= dat) && *ptr == ')') return false ;
    }
    for (ptr = dat; ptr < dat+length; ptr++) 
        for (const char * ck = special ; *ck ; ck++)
            if (*ck == *ptr) return true;
    return false ;
}


void CantorNormalElement::normalFormName(string& base) const
{
	
	OrdinalImpl::debugControl.clearAll();
	int cmpOne = exponent.compare(OrdinalImpl::one);
	OrdinalImpl::debugControl.pop();
	if (cmpOne < 0) {
		base += factor.get_str();
		return ;
	}
	bool oneFactor = factor == 1 ;
	if (!cmpOne) {
		if (oneFactor) {
			base += "w" ;
			return ;
		}
		base += "( w*" ;
		base += factor.get_str();
		base += ")" ;
		return ;
	}
	if (!oneFactor) base += "(" ;
	base += "( w^" ;
    string expStr = exponent.normalForm();
    bool rParen = requiresParenthesis(expStr) ;
    if (rParen) base += "( " ;
    base += expStr ;
    if (rParen) base += " )" ;
    base += " )" ;
	if (!oneFactor) {
		base += "*" ;
		base += factor.get_str();
		base += " )" ;
	}
}



void CantorNormalElement::psiNormalForm(string& base) const
{
    if (exponent.compare(eps0)>=0) base = FiniteFuncNormalElement::notBasic();
    else texNormalForm(base);
}

void CantorNormalElement::texNormalForm(string& base) const
{
	
	OrdinalImpl::debugControl.clearAll();
	int cmpOne = exponent.compare(OrdinalImpl::one);
	OrdinalImpl::debugControl.pop();
	if (cmpOne < 0) {
		base += factor.get_str();
		return ;
	}
	bool oneFactor = factor == 1 ;
	if (!cmpOne) {
		if (oneFactor) {
			base += "\\omega{}" ;
			return ;
		}
		base += "\\omega{} " ;
		base += factor.get_str();
		
		return ;
	}
	
	base += "\\omega{}^{" ;
	base += exponent.texNormalForm();
	base += "}" ;
	if (!oneFactor) {
		base += " " ;
		base += factor.get_str();
		
	}
}


int CantorNormalElement::compare(const CantorNormalElement& trm,
    bool ignoreFactor) const
{
	
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult,0) ;
	if (dbg) outDbgStream() << "CantorNormalElement::compare(" << normalForm() <<
		", " << trm.normalForm() << ")\n" ;
	
	
    assert(codeLevel == cantorCodeLevel);
	if (trm.codeLevel>cantorCodeLevel) return -trm.compare(*this);
	int diff = exponent.compare(trm.exponent);
	if (diff) return diff ;
	if (!ignoreFactor) diff = cmp(factor,trm.factor) ;
	if (dbg) outDbgStream() << "CantorNormalElement::compare(" << normalForm() <<
		", " << trm.normalForm() << ") ignf = " << ignoreFactor << ", diff = "
		<< diff << "\n" ;
	return diff ;
}

int CantorNormalElement::parameterCompare(const Embeddings& context,
    const Embeddings& paramContext, const CantorNormalElement &trm) const
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
    if (dbg) outStream() << "parameterCompare(" << context.embedIndex.normalForm()
        << ":" << context.type << ",\n" << paramContext.embedIndex.normalForm()
        << ":" << paramContext.type << ",\n" << trm.normalForm() << ")\n" ;
   if (trm.compare(paramContext,context,getMaxParameter(),true) <= 0) return 1;
   if (compare(context,paramContext,trm.getMaxParameter(),true) <= 0) return -1 ;
   return 0 ;
}
    



int CantorNormalElement::compare(const Embeddings& context,
    const Embeddings& paramContext,
    const CantorNormalElement& trm, bool ignoreFactor) const
{
	
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult,0) ;
	if (dbg) outDbgStream() << "CantorNormalElement::compare(" << normalForm() <<
		", " << trm.normalForm() << ")\n" ;
	
	
	if (trm.codeLevel>cantorCodeLevel) return -trm.compare(paramContext,
        context,*this);
	int diff = exponent.compare(context,paramContext,trm.exponent);
	if (diff) return diff ;
	if (!ignoreFactor) diff = cmp(factor,trm.factor) ;
	if (dbg) outDbgStream() << "CantorNormalElement::compare(" << normalForm() <<
		", " << trm.normalForm() << ") ignf = " << ignoreFactor << ", diff = "
		<< diff << "\n" ;
	return diff ;
}

int CantorNormalElement::compare(const OrdinalImpl& ord) const
{
    return compare(Embeddings::embedNone, Embeddings::embedNone,ord);
}

int CantorNormalElement::compare(const Embeddings& embedIx,
    const Embeddings& termEmbedIx, const OrdinalImpl& ord) const
{
    const NormalFormTerm * trms = ord.terms ;
    if (!trms) return 1 ;
    int diff = compare(embedIx,termEmbedIx,trms->term);
    if (diff) return diff ;
    if (trms->next) return -1 ;
    return 0 ;


}


const CantorNormalElement& CantorNormalElement::addFactors(
			const CantorNormalElement& toAdd) const
{
	return *new CantorNormalElement(exponent, factor+toAdd.factor);
}

bool CantorNormalElement::isFinite() const
{
	
	if (!isIntOrCantorLevel()) return false ;
	return exponent.compare(OrdinalImpl::zero) == 0;
}

const OrdinalImpl&  CantorNormalElement::getDDindexVal() const
{
    return OrdinalImpl::zero ;
}

const CantorNormalElement& CantorNormalElement::multiply(
		const CantorNormalElement& op) const 
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult) ;
	if (dbg) outOperands('*',op);
	if (op.codeLevel>cantorCodeLevel) return op.multiplyBy(*this);
	bool opFinite = op.isFinite();
	bool opOne = op.factor == 1 ;
	if (opFinite) {
		if (opOne) return *this ;
		return getCopy(factor*op.factor);
	}
	if (isFinite()) {
		if (factor == 1) return op ;
		if (opFinite) {
			return * new CantorNormalElement(OrdinalImpl::zero,
				factor * op.factor);
		} else return op ;
	}
	const OrdinalImpl& sum = exponent.addLoc(op.exponent) ;
	return * new CantorNormalElement(sum,op.factor);
}

const CantorNormalElement& CantorNormalElement::multiply(const Int& fac) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult) ;
	if (dbg) outStream() << normalForm()<<" Multiply factor = "<<fac << "\n" ;
	return * new CantorNormalElement(exponent,fac*factor) ;

}

const OrdinalImpl& CantorNormalElement::getOrdinalCopy(const Int fac) const
{
	return getCopy(fac).termToOrdinal();
	
}


const CantorNormalElement& CantorNormalElement::getCopy(const Int fac) const
{
	
	assert(codeLevel == cantorCodeLevel);
	if (fac == factor) return *this ;
	return * new const CantorNormalElement(exponent,fac);
}

const NormalFormTerm * CantorNormalElement::getOrdinalTerm(
	const OrdinalImpl& ord)
{
	return ord.terms ;

}


void CantorNormalElement::describe(ostream&out) const
{
	out << "CantorNormalElement(" ; exponent.describe(outDbgStream());
	out << ", " << factor <<  "), id = "  << id << " " ;
}


const OrdinalImpl& CantorNormalElement::toPower(
	const CantorNormalElement& elt) const
{
	assert(codeLevel==cantorCodeLevel);
	if (elt.codeLevel>cantorCodeLevel) return elt.powerOf(*this);
	const OrdinalImpl& expProd = exponent.multLoc(*new OrdinalImpl(elt)) ;
	NormalFormTerm* expTerm = NormalFormTerm::create(expProd) ;
	const OrdinalImpl* ret = new OrdinalImpl("^temp",*expTerm) ;
	return *ret ;
}


const OrdinalImpl& CantorNormalElement::termToOrdinal() const 
{

	if (!termValue) ((CantorNormalElement*)this)->termValue =
		new OrdinalImpl(*this);
		

	return * termValue ;
}


const OrdinalImpl& CantorNormalElement::createExpOrdinal(
		const OrdinalImpl& ord, Int factor)
{
	bool dbg = false ; 
	const OrdinalImpl * ret = NULL ;

    ret = &(fixedPointCheck(ord,factor));
    
	if (dbg) {
		outStream() << " gst = " <<
			(void *) ord.getSecondTerm()
			<< ", XXftf = " << ord.getFirstTerm()->factor << "\n" ;
		outStream() << "createExp(" << ord.normalForm() << ") = " <<
			ret->normalForm() << "\n" ;
		if (!ord.isZero()) outStream() <<  
			"ft.cl = " << ord.getFirstTerm()->codeLevel << "\n" ;
	}
	return * ret ;
}


bool CantorNormalElement::expTerm() const
{
	if (codeLevel > cantorCodeLevel) return false ;
	if (exponent.isZero()) return false ;
	const NormalFormTerm& firstTerm = *(exponent.terms) ;
	if (firstTerm.next) return true ;
	if (firstTerm.term.factor > 1) return true ;
	return firstTerm.term.expTerm();
}

ostream& CantorNormalElement::out(const string cmt) const
{

	ostream& ret = outStream();
	ret << normalForm() << " " << cmt << " elt\n" ;
	
	
	return ret ;

}





NormalFormTerm::NormalFormTerm(CantorNormalElement& trm):next(0),term(trm)
{
	term.reference();
}


NormalFormTerm::~NormalFormTerm()
{
	term.dereference() ;
	if (next) delete next ;
}


void NormalFormTerm::describe(ostream&out) const
{
	out << "NormalFormTerm begin\n" ; int i = 0 ;
	for (const NormalFormTerm *tmp = this; tmp; tmp=tmp->next,i++) {
		outDbgStream() << i << " : " ;
		tmp->term.describel(outDbgStream());
	}
	outDbgStream() << "NormalFormTerm end\n"; 
}



NormalFormTerm * NormalFormTerm::create(const OrdinalImpl & exponent,
	Int factor)
{
	CantorNormalElement * term = new CantorNormalElement(exponent,factor);
	return new NormalFormTerm(*term) ;

}

const Int& NormalFormTerm::getFiniteTerm() const
{
	if (next) return next->getFiniteTerm();
	if (term.exponent.compare(OrdinalImpl::zero))
		return OrdinalImpl::zeroInt ;
	return term.factor;
}


void NormalFormTerm::normalFormName(string& base) const
{
	
	if (!base.empty()) base += " + " ;
	term.normalFormName(base) ;
	if (next) next->normalFormName(base) ;
}

int NormalFormTerm::compare(const Embeddings& context,
    const Embeddings& paramContext,
    const NormalFormTerm& trm, bool ignoreFactor) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
	
	if (dbg) outDbgStream() << "NFT compare(" << normalForm() << ", " <<
			trm.normalForm()  << "), ignfac = " << ignoreFactor << " start\n" ;
	
	
	int diff =  term.compare(context,paramContext,trm.term,ignoreFactor);
	if (dbg) outDbgStream() <<  "diff = " << diff << " :: NFT cmp(" << normalForm()
			<< ", " << trm.normalForm() << ")\n" ;
	if (diff) return diff ;
	if (next) {
		if (trm.next) return next->compare(context,paramContext,*(trm.next));
		else return 1; 
	} else if (trm.next) return -1 ; else return 0 ;
}

int NormalFormTerm::compare(const NormalFormTerm& trm, bool ignoreFactor) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
	
	if (dbg) outDbgStream() << "NFT compare(" << normalForm() << ", " <<
			trm.normalForm()  << "), ignfac = " << ignoreFactor << " start\n" ;
	
	
	int diff =  term.compare(trm.term,ignoreFactor);
	if (dbg) outDbgStream() <<  "diff = " << diff << " :: NFT cmp(" << normalForm()
			<< ", " << trm.normalForm() << ")\n" ;
	if (diff) return diff ;
	if (next) {
		if (trm.next) return next->compare(*(trm.next));
		else return 1; 
	} else if (trm.next) return -1 ; else return 0 ;
}

int NormalFormTerm::compare(const OrdinalImpl& ord) const
{
	return compare(*(ord.terms)) ;
}

int NormalFormTerm::compare(const Ordinal& ord) const
{
	return compare(ord.getImpl());
}

void NormalFormTerm::add(const NormalFormTerm*& sum) const
{
	if (sum == NULL) sum = new const NormalFormTerm(term);
	else {
		sum->append(term);
		
	}
	if (next) next->add(sum);
}


void NormalFormTerm::add(const NormalFormTerm*& sum,
	const NormalFormTerm&  toAddRef) const
{
    bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::add) ;
	const NormalFormTerm * toAdd = &toAddRef ;
	int diff = term.compare(toAddRef.term,true);
    if (dbg) outStream() << "NormalFormTerm:add - compare ignf" <<
            term.normalForm() << " :: " << toAddRef.term.normalForm() <<
            ", result " << diff << "\n" ;
	const NormalFormTerm * thisTerm = NULL ;

	if (!diff) {
		const CantorNormalElement& addTerms = term.addFactors(toAddRef.term);
		thisTerm = new const NormalFormTerm(addTerms);
		toAdd = toAddRef.next ;
	} else  if (diff < 0) {
		toAddRef.add(sum);
		return ;
	} else thisTerm = new const NormalFormTerm(term);
	assert(thisTerm);
	if (sum == NULL) sum = thisTerm ; else sum->append(*thisTerm);
	if (next && (diff > 0)) {
		if (toAdd)  next->add(sum,*(toAdd));
		else next->add(sum);
		return ;
	} else if (toAdd) toAdd->add(sum);
}

const Int& NormalFormTerm::getFiniteFac() const 
{
	if (term.isFinite()) return term.getFactor() ;
	assert(next);
	return next->getFiniteFac();
}
			
void NormalFormTerm::multiply(const NormalFormTerm*& prod,
	const NormalFormTerm&  op,
	const NormalFormTerm * finiteProd) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult) ;
	if (dbg) {
		outStream() << "NormalFormTerm multiply " << normalForm() <<
			" * " << op.normalForm() << "\n";
		if (prod) outStream() << "prod = " << prod->normalForm() << " " ;
		if (finiteProd) outStream() << "finiteProd = " <<
			finiteProd->normalForm() ;
		if (prod || finiteProd) outStream() << "\n" ;
	}
	const CantorNormalElement& eltProd = term.multiply(op.term);
	const CantorNormalElement * finiteProdTerm = NULL ;
	if (finiteProd != NULL) finiteProdTerm = &(finiteProd->term) ;
	if (finiteProdTerm) {
		int diff = eltProd.compare(*finiteProdTerm,true);
		if (diff < 1) {
			const Int& finiteFac = op.getFiniteFac();
			const CantorNormalElement* toAdd = 0;
			if (!diff) {
				Int sum = eltProd.getFactor() +
					finiteFac * finiteProdTerm->getFactor();
				toAdd = &(finiteProdTerm->getCopy(sum));
			}
			if (!prod) prod = new NormalFormTerm(*toAdd);
			else prod->append(*toAdd);
			eltProd.deleteIfNotReferenced();
			const NormalFormTerm* nextFiniteProd = finiteProd->next ;
			if (next == NULL) return ;
			nextFiniteProd->add(prod) ;
			return ;
		}
	}

	if (!prod) prod = new NormalFormTerm(eltProd);
	else {
		if (prod->term.compare(eltProd,true)== 0) {
			const CantorNormalElement& sumFactor =
				prod->term.addFactors(eltProd);
			prod = prod->replaceLast(sumFactor);
		} else prod->append(eltProd) ;
	}
	if (op.next) multiply(prod,*(op.next),finiteProd); 
	else if (finiteProd) finiteProd->add(prod);
}

void NormalFormTerm::multiply(const NormalFormTerm& prod, const Int& fac) const
{
	if (fac == 1) {
		prod.append(term);
		
	}
	else prod.append(term.multiply(fac));
	if (next) next->multiply(*(prod.next), fac);
}

const OrdinalImpl * NormalFormTerm::takePowerOf(const CantorNormalElement & trm)
	const
{
	
	const OrdinalImpl * ret = &(trm.toPower(term));
	
	
	if (next) return &(ret->multLoc(*(next->takePowerOf(trm))));
	return ret ;
}


void NormalFormTerm::psiNormalForm(string& s) const
{
	
	if (!s.empty()) s += " + " ;
    string termStr = term.psiNormalForm();
    if (FiniteFuncNormalElement::isNotBasic(termStr)) {
        s = termStr ;
        return ;
    }
	s += termStr ;
	if (next) next->psiNormalForm(s);
	

}

void NormalFormTerm::texNormalForm(string& s) const
{
	
	if (!s.empty()) s += " + " ;
	s += term.texNormalForm();
	if (next) next->texNormalForm(s);
	

}


void  NormalFormTerm::normalForm(string&s) const
{
	
	if (!s.empty()) s += " + " ;
	s += term.normalForm();
	if (next) next->normalForm(s);
	

}
 
string  NormalFormTerm::normalForm() const
{
	string ret ;
	normalForm(ret);
	return ret ;
}

void NormalFormTerm::concatenate(const NormalFormTerm *& concatTo,
	const NormalFormTerm& concatFrom) 
{
	bool dbg = debugControl.check(DebugControlParam::limit,0) ;
    
    if (!concatTo) concatTo = new NormalFormTerm(concatFrom.term);
	else concatTo->append( *new NormalFormTerm(concatFrom.term));
    if (dbg) outDbgStream() << "NormalFormTerm::concatenate concatTo(2) = " <<
           concatTo->normalForm() << "\n" ;

	if (concatFrom.next) {
        concatenate(concatTo,*(concatFrom.next)); 
        
    }
}


const OrdinalImpl& NormalFormTerm::limitElement(Int n,
	const NormalFormTerm *terms) const
{
	bool dbg = debugControl.check(DebugControlParam::limit,0) ;
	if (dbg) {
		outDbgStream() << "NormalFormTerm::limitElement(" << n << ","  ;
		if (terms) outDbgStream() << terms->normalForm() << ")\n" ;
		else outDbgStream() <<  "NULL)\n" ;
	}
	const NormalFormTerm * finalTerms = NULL;
	bool lastTerm = (next == NULL) ;
	if (term.isFinite()) {
		lastTerm = true ;
		Int newFac = n ;
		if (n >= term.factor) newFac = term.factor ;
		assert(n>0);
		if (newFac>0) {
            finalTerms =  new NormalFormTerm(
			    *new const CantorNormalElement(OrdinalImpl::zero, newFac));
            if (dbg) outDbgStream() << "finalTerms = " << 
                finalTerms->normalForm() << "\n" ;

        }
	} else { 
		bool limP1 = false ;
		if (!lastTerm) if (next->term.isFinite()) if (next->term.factor == 1)
			limP1= true ;
		if (limP1) if (n==1) {
			finalTerms =  new NormalFormTerm(term);
            if (dbg) outDbgStream() << "finalTerms = " <<
                finalTerms->normalForm() << "\n" ;

			lastTerm = true ;
		}
		if (lastTerm && !finalTerms) {
			if (dbg) outDbgStream() << "term = " << term.normalForm() << "\n" ;
        if (dbg && finalTerms) outDbgStream() << "finalTerms = " << finalTerms->normalForm()
            << "\n" ;
			const OrdinalImpl& toAppend = term.limitElement(n);
            
			assert(toAppend.terms != NULL);
            if (dbg) if (!finalTerms) outDbgStream() << "finalTerms = NULL\n";
            else outDbgStream() << "finalTerms = " << finalTerms->normalForm()
                    << "\n" ;
            if (dbg) outDbgStream() << "toAppend.terms = " <<
                toAppend.terms->normalForm() << "\n";
			concatenate(finalTerms,*(toAppend.terms)) ;
             if (dbg) {
                assert(finalTerms);
                outDbgStream() << "finalTerms = " << finalTerms->normalForm()
                    << "\n" ;
            }
		}
	}
	if (lastTerm && finalTerms) {
        if (dbg) outDbgStream() << "finalTerms = " << finalTerms->normalForm()
            << "\n" ;
        if (dbg) if (terms) outDbgStream() << "terms = " << terms->normalForm()
            << "\n" ;
                else outDbgStream() << "terms = NULL\n" ;

		
		if (!terms) terms = finalTerms ;
		else terms->append(*finalTerms);
        if (dbg) outDbgStream() << "terms = " << terms->normalForm()
            << "\n" ;
		const OrdinalImpl& ret = *new OrdinalImpl("limit elt",*terms);
        if (dbg) outDbgStream() << "NormalFormTerm::limitElement returning " <<
            ret.normalForm() << "\n" ;
		return ret ;
	}
		
	if (!terms) terms = new const NormalFormTerm(term);
	else terms->append(term);
	if (!next) return OrdinalImpl::zero ;
	return next->limitElement(n,terms);
}


bool NormalFormTerm::hasFiniteTerm() const
{
	if (next) return next->hasFiniteTerm();
	return term.isFinite() ;
}

const NormalFormTerm * NormalFormTerm::listCopySubtractOmega() const
{
    if ((term.codeLevel == CantorNormalElement::cantorCodeLevel)
        && (term.exponent.isOne())) {
        assert(term.factor > 1) ; 
        const CantorNormalElement * newTerm = new CantorNormalElement(
            OrdinalImpl::one,term.factor-1);
        return new NormalFormTerm(*newTerm);
    }
    
	NormalFormTerm * copy = new NormalFormTerm(term);
    assert(next) ; 
	if (next) {
        const CantorNormalElement & elt = next->term ;
        if (elt.codeLevel == CantorNormalElement::cantorCodeLevel &&
            elt.exponent.isOne()) if (elt.factor==1) return copy ;

        ((NormalFormTerm *)copy)->next = next->listCopySubtractOmega();
    }
	return copy ;
}

const NormalFormTerm * NormalFormTerm::listCopyOff(Int& off) const
{
	NormalFormTerm * copy = NULL ;
	if (!isFinite())  copy = new NormalFormTerm(term);
	if (next) {
		if ((!(next->isFinite())) || (next->term.factor > off))
			((NormalFormTerm *)copy)->next = next->listCopyOff(off);
		return copy ;
	} else {
		if (isFinite()) {
			if (term.factor <= off) return NULL;
			return new NormalFormTerm(term.getCopy(term.factor - off));
		}
	}
	return copy ;
}

void NormalFormTerm::prodInfiniteTerms(const OrdinalImpl*& ord) const
{
	if (isFinite()) return ;
	const OrdinalImpl * termOrd = new OrdinalImpl(term);
	ord = &(ord->multLoc(*termOrd));
	if (next) next->prodInfiniteTerms(ord) ;
}

const NormalFormTerm * NormalFormTerm::listCopy() const
{
	 NormalFormTerm * copy = new NormalFormTerm(term);
	if (next) ((NormalFormTerm *)copy)->next = next->listCopy();
	return copy; 
}

const NormalFormTerm * NormalFormTerm::replaceLast(
	const CantorNormalElement& elt) const
{
	const NormalFormTerm * nextToLast = 0 ;
	const NormalFormTerm * curr = this ;
	while (curr->next) {nextToLast = curr ; curr = curr->next;}
	const NormalFormTerm * newTerm = new NormalFormTerm(elt);
	if (nextToLast) {
		delete nextToLast->next ;
		((NormalFormTerm *)nextToLast)->next = newTerm ;
		return this ;
	}
	delete this ;
	return newTerm ;

}

int OrdinalImpl::getHighestCodeLevel() const
{
    const CantorNormalElement * firstTerm = getFirstTerm();
    if (!firstTerm) return 0 ;
    return firstTerm->codeLevel ;

}

OrdinalImpl::OrdinalImpl(const OrdinalImpl& copyFrom, Int off):
	lastTerm(NULL),
	refCount(0),maxEmbedIndex(NULL),
	terms(off==0?copyFrom.terms->listCopy():copyFrom.terms->listCopyOff(off)),
	hasFiniteTerm(terms?terms->hasFiniteTerm():false),id(idCount++),
	termCount(terms?terms->countTerms():0),
	assignedNameString(copyFrom.assignedNameString)
{
	commonInit("copyFrom");
}



OrdinalImpl::OrdinalImpl(unsigned long n):lastTerm(NULL),
	
	refCount(0),maxEmbedIndex(NULL),
	termCount(terms?terms->countTerms():0),
	terms(0),hasFiniteTerm(n!=0),id(idCount++)
{
	assignedNameString = itoa(n);
	if (n!=0) terms = NormalFormTerm::create(zero,n);
	commonInit("ulong");
}

OrdinalImpl::OrdinalImpl(const NormalFormTerm * trms, const string& name):
    lastTerm(NULL),
    terms(trms),maxEmbedIndex(NULL),
	refCount(0), termCount(terms?terms->countTerms():0),
	hasFiniteTerm(terms?terms->hasFiniteTerm():false),id(idCount++),
	assignedNameString(name)
{
    commonInit("from terms");
}


void OrdinalImpl::commonInit(const char *from)
{
	bool dbg = false;

    theLimitType = theMaxLimitType = theEmbedLimitType =
        theMaxEmbedLimitType = NULL ;
    
	inDeleteList = noRef();
	if (dbg) outDbgStream() << "OrdinalImpl Id: " << id << "\n" ;
	if (dbg || DBG(idOrd)) {
		outDbgStream().fill('0');
		outDbgStream() << "Created: " << setw(7)  << id << " " << from << " : " ;
		outDbgStream().fill(' ') ; 
		if ((id >1) && !dbg) outDbgStream() << normalForm() << "\n";
		if ((id<2)||!dbg) outDbgStream() << "\n" ;;
	}
	if (id <2) return ;
	if (dbg) {
		describel(outDbgStream());
		if (terms) terms->describel(outDbgStream());
	}
}

OrdinalImpl::OrdinalImpl(Int n):lastTerm(NULL),
	
	refCount(0),maxEmbedIndex(NULL),
	termCount(terms?terms->countTerms():0),
	terms(0),hasFiniteTerm(n!=0),id(idCount++) 
{
	assignedNameString = itoa(n);
	if (n!=0) terms = NormalFormTerm::create(zero,n);
	commonInit("Int");
}

const Ordinal& OrdinalImpl::getMaxEmbedIndex() const
{
    if (maxEmbedIndex) return *maxEmbedIndex ;
    const Ordinal * mxEmbedIndex = &Ordinal::zero ;
    const NormalFormTerm *trm = terms ;
    while (trm) {
       const Ordinal& ord = trm->term.getMaxEmbedIndex();
       if (ord.compare(*mxEmbedIndex)>0) mxEmbedIndex = &ord ;
       trm=trm->next ;
    }
    ((OrdinalImpl *)this)->maxEmbedIndex= mxEmbedIndex ;
    return *maxEmbedIndex ;
}


const Ordinal& OrdinalImpl::limitMaxEmbed(const OrdinalImpl & lim) const
{
    if (isFinite() || (getMaxEmbedIndex().compare(lim) < 0))
        return *new Ordinal(*this) ;
    const NormalFormTerm *retTrm = NULL ;
    const NormalFormTerm *trm = terms ;
    assert(trm);
    while (trm) {
        if (retTrm) retTrm->append(
            *new NormalFormTerm(trm->term.limitMaxEmbed(lim)));
        else retTrm = new NormalFormTerm(trm->term.limitMaxEmbed(lim));
        trm=trm->next ;
    }
    const Ordinal& ret = * new Ordinal("lmMxEmbed",*retTrm);
    assert(compare(ret)<=0);
    return ret ;

}



OrdinalImpl::OrdinalImpl(int n1, int n2):
	lastTerm(NULL),maxEmbedIndex(NULL),
	assignedNameString("1"),id(idCount++),
	terms(new const NormalFormTerm(*new CantorNormalElement(n1,*this))),
	termCount(terms?terms->countTerms():0),
	hasFiniteTerm(true)
{
	assert((n1 == n2) && (n1 == 1));
}


OrdinalImpl::~OrdinalImpl()
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::dtrOrd) ;
	if (dbg)  outDbgStream() << "~OrdinalImpl Id: "  << id << "\n" ;
	if (dbg || DBG(idOrd)) {
		outDbgStream().fill('0');
		outDbgStream() << "Deleting: " << setw(7)  << id << "\n" ;
		outDbgStream().fill(' ');
	}
	
	if (terms) delete terms ;
	
}

const CantorNormalElement * OrdinalImpl::getLastTerm() const
{
	if (!lastTerm && terms) {
		NormalFormTerm * nextTerm = (NormalFormTerm *) terms ;
		while(nextTerm->next) nextTerm = (NormalFormTerm *) nextTerm->next ;
		((OrdinalImpl *) this)->lastTerm= &(nextTerm->term);
	}
	return lastTerm ;
}

bool OrdinalImpl::isOmega() const
{
    if (terms->next) return false ;
    if (!terms) return false ;
    return terms->term.isOmega();

}


bool OrdinalImpl::isOmegaSuccessor() const
{
    const CantorNormalElement * last = getLastTerm();
    if (!last) return false ;
    if (last->codeLevel > CantorNormalElement::cantorCodeLevel) return false ;
    return last->exponent.compare(OrdinalImpl::one)==0 ;
}

const AdmisLevOrdinal* OrdinalImpl::getAdmissibleBase() const
{
    const CantorNormalElement * first = getFirstTerm();
    if (!first) return NULL ;
    if (first->codeLevel < AdmisNormalElement::admisCodeLevel) return NULL ;
    AdmisNormalElement& elt = (AdmisNormalElement&) *first ;
    return &(elt.getAdmissibleBase());
}

int OrdinalImpl::getFTcodeLevel() const
{
    const CantorNormalElement * first = getFirstTerm();
    if (!first) return CantorNormalElement::cantorCodeLevel ;
    return first->codeLevel ;
    
}




const OrdinalImpl& OrdinalImpl::subtractOmega() const
{
    assert(isOmegaSuccessor());
    if (compare(OrdinalImpl::omega) <=0) return OrdinalImpl::zero ;
    const NormalFormTerm * copy = terms->listCopySubtractOmega();
    return * new OrdinalImpl(copy, assignedNameString);
}

void OrdinalImpl::dereference() const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::drfOrd) ;
	if (dbg) outDbgStream() << "Dereference OrdinalImpl " << id << " : " << assignedNameString << "\n" ;
	((OrdinalImpl *) this)->refCount-- ;
	if (refCount < 1) if (!inDeleteList && (id > 1)) delete this ;
}


string OrdinalImpl::normalFormOpt(bool texFlag) const
{
    if (texFlag) return texNormalForm();
    return normalForm();
}



void OrdinalImpl::psiNormalForm(string& str) const 
{
	
	if (terms == NULL) {
		str += "0" ;
		return ;
	}
	terms->psiNormalForm(str);
}

void OrdinalImpl::texNormalForm(string& str) const 
{
	
	if (terms == NULL) {
		str += "0" ;
		return ;
	}
	terms->texNormalForm(str);
}

void OrdinalImpl::normalFormName() const 
{
	
	if (terms == NULL) {
		((OrdinalImpl *)this)->normalFormString = "0" ;
		return ;
	}
	assert(terms);
	assert(normalFormString.empty()) ;
	terms->normalFormName(((OrdinalImpl *)this)->normalFormString);
}

int OrdinalImpl::compare(const OrdinalImpl& ord) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
	if (dbg) outDbgStream() << "OrdinalImpl::compare(e)(" << normalForm() <<
		", " << ord.normalForm() << ")\n";
	if (!terms) return ord.terms == NULL ? 0:-1 ;
	if (!ord.terms) return 1 ;
	int ret = terms->compare(*(ord.terms)) ;
	if (dbg) outDbgStream() << "OrdinalImpl::compare(x)(" << normalForm() <<
		", " << ord.normalForm() << ") returning " << ret << "\n" ;
	return ret ;
}

int OrdinalImpl::compare(const Embeddings& context,
    const Embeddings& paramContext,const OrdinalImpl& ord) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::compare,0) ;
	if (dbg) outDbgStream() << "OrdinalImpl::compare(emb e)(" << normalForm() <<
		", " << ord.normalForm() << ")\n";
	if (!terms) return ord.terms == NULL ? 0:-1 ;
	if (!ord.terms) return 1 ;
	int ret = terms->compare(context,paramContext,*(ord.terms)) ;
	if (dbg) outDbgStream() << "OrdinalImpl::compare(emb x)(" << normalForm() <<
		", " << ord.normalForm() << ") returning " << ret << "\n" ;
	return ret ;
}


int OrdinalImpl::compare(const Ordinal& ord) const
{
	return compare(ord.getImpl());
}


void OrdinalImpl::outOperands(char  oper, const OrdinalImpl& b) const
{
	return outOperands(oper, *this,b);
}

void OrdinalImpl::outOperands(char  oper, const OrdinalImpl& a, 
	const OrdinalImpl& b) 
{
	const char * doing = 0 ;
	if (oper == '+') doing = "Adding" ;
	if (oper == '*') doing = "Multiplying" ;
	if (oper == '^') doing = "Exponentiating" ;
	assert(doing != NULL);
	
	outDbgStream() << doing << " : [" << a.normalForm() << "] " ;
	outChar(oper);
	outDbgStream() << " [" << b.normalForm() << "]\n" ;
	
}

const OrdinalImpl& OrdinalImpl::addLoc(const int n) const
{
    assert(n > -1);
    switch (n) {
case 0: return *this;
case 1: return addLoc(one);
case 2: return addLoc(two);
case 3: return addLoc(three);
case 4: return addLoc(four);
case 5: return addLoc(five);
case 6: return addLoc(six);
    }
    OrdinalImpl * toAdd = new OrdinalImpl(n);
    return addLoc(*toAdd);
}

const OrdinalImpl& OrdinalImpl::addLoc(const OrdinalImpl&op) const
{
	
	if (!terms) return  op ;
	if (!op.terms) return *this ;
	const NormalFormTerm * sumTerm  = NULL ;

	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::add);
		

	if (dbg) outOperands('+',op);
	terms->add(sumTerm,*(op.terms));
	assert(sumTerm);
	const OrdinalImpl& ret = * new OrdinalImpl(exprName(*this,"+",op),*sumTerm);
	if (dbg) {
		outDbgStream() << "OrdinalImpl add result  " ;
		ret.out();
		
		
		
		
	} 
	return ret ;

}


const OrdinalImpl& OrdinalImpl::multLoc(const OrdinalImpl&op) const
{
	
	
	
	//
	//
	
	
	
	
	
	
	
	//

	if (!terms) return *this ;
	if (!op.terms) return op ;
	if (compare(one)==0) return op ;
	if (op.compare(one)==0) return * this;

	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::mult) ;

	const NormalFormTerm * prodTerm  = NULL ;
	const NormalFormTerm * finiteProdTerm = NULL ;
	if (dbg) outOperands('*',op);
	if (op.hasFiniteTerm) if (terms->next) finiteProdTerm = terms->next;
	terms->multiply(prodTerm,*(op.terms),finiteProdTerm);
	assert(prodTerm);
	OrdinalImpl &ret = * new OrdinalImpl(exprName(*this,"*",op),*prodTerm);
	if (dbg) {
		outDbgStream() << "OrdinalImpl multiply result" ;
		ret.out();
		
		
	}
	return ret ;

}


static bool doInitTable(int leadingBitTableSize, int * leadingBitTable)
{
	for (int i = 0 ; i < leadingBitTableSize;i++) {
		int leading = 0 ;
		int check = i ;
		while (check) check >>= 1 , leading++ ;
		leadingBitTable[i]=leading ;
	}
	return true ;

}


const OrdinalImpl& OrdinalImpl::finitePowerLoc(const Int& n) const
{
	return finitePowerLoc(ulongFromInt(n)) ;
}


const OrdinalImpl& OrdinalImpl::finitePowerLoc(unsigned long expon) const
{
	if (this->compare(zero)==0) return zero ;
	if (expon == 1) return *this ;
	const int maxBits = 12 ; 
	const int leadingBitTableSize = (1 << (maxBits/2)) ;
	const int maxValue = (1 << maxBits) -1 ;
	Ordinal ** componets[maxBits] ;
	static int leadingBitTable [leadingBitTableSize] ;
	static bool initTable = true ;
	if (initTable) initTable = ! doInitTable(leadingBitTableSize,leadingBitTable);
	if (expon > maxValue) {
		cerr << "Arbitrary exponent size limit, " << maxValue <<
			", exceeded by exponent value " << expon << ".\n" ;
        if (interactiveMode) {
            outStream() << "Value set to 0.\n";
            return OrdinalImpl::zero ;
        }
		assert(0);
	}
	const OrdinalImpl * productTable[maxBits] ;
	int leadingBit = leadingBitTable[expon >> (maxBits/2)] ;
	if (leadingBit) leadingBit += (maxBits/2) ;
	else leadingBit = leadingBitTable[expon] ;
	assert(leadingBit) ;
	productTable[0] = this ;
	 for (int i = 1 ; i < leadingBit ; i++) {
			productTable[i] = &(productTable[i-1]->multLoc(*productTable[i-1])) ;
			
	}
	int index = 0 ;
	int exponc = expon ;
	
	const OrdinalImpl* temp = 0 ;
	for (;exponc;exponc>>=1,index++) if (exponc&1) if (temp) {
		const OrdinalImpl& t = temp->multLoc(*productTable[index]) ;
		temp = &t ;
		
		
	} else temp = productTable[index] ;
	
	return *temp ;
}


unsigned long int OrdinalImpl::ulongFromInt(const Int& in)
{
	assert(in.fits_ulong_p());
	return in.get_ui() ;

}

Int OrdinalImpl::intExp(const Int& a , const Int& b)
{

	
	
	mpz_t result ;;
	mpz_init(result);
	mpz_pow_ui(result,a.get_mpz_t(),ulongFromInt(b));
	
	return (Int) result ;
}




const OrdinalImpl& OrdinalImpl::powerLoc(const OrdinalImpl&op) const
{
	bool finite = isFinite();
	int compareOne = compare(one) ;
	if (finite) {
		if (compareOne < 0) return zero ; 
		if (compareOne == 0) return one ; 
	}
	bool opFinite = op.isFinite();
	if (opFinite) {
		int opCompareOne = op.compare(one) ;
		if (opCompareOne < 0) return one ; 
		if (opCompareOne == 0) return *this ; 
	} 

	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::expon) ;

	string resultName = exprName(*this,"^",op);
	if (dbg) outOperands('^',op);
	const NormalFormTerm * newTerms = NULL ;
	if (finite) {
		if (opFinite) { 
			newTerms = NormalFormTerm::create(zero,intExp(
				terms->term.getFactor(), op.terms->term.getFactor()));
		} else { 
			const OrdinalImpl * prod = &one ;
			op.terms->prodInfiniteTerms(prod);
			if (op.hasFiniteTerm) {
				Int finiteOpTerm = op.getFiniteTerm();
				Int finiteThisTerm = getFiniteTerm();
				OrdinalImpl * finiteTerm = 
					new OrdinalImpl(intExp(finiteThisTerm,finiteOpTerm));
				prod = &(prod->multLoc(*finiteTerm));
			}
			return * prod ;
			
			
		}
	} else { 
		if (opFinite) {
				
				
				
				const OrdinalImpl& ret = finitePowerLoc(op.terms->term.factor) ;
				((OrdinalImpl&) ret).assignedNameString = resultName;
				return ret ;
		}
		
		
		
		const OrdinalImpl * infiniteTerms = &op ;
		if (op.hasFiniteTerm) infiniteTerms = &(op.makeInfiniteTermCopy());
		const OrdinalImpl * ret = infiniteTerms->terms->takePowerOf(terms->term);
		
		
		
		if (op.hasFiniteTerm) ret = &(ret->multLoc(
			this->finitePowerLoc(op.terms->getFiniteFac())));
		((OrdinalImpl*) ret)->assignedNameString = resultName;
		return *ret;
	}

	assert(newTerms);
	return * new OrdinalImpl(resultName,*newTerms);
}


const OrdinalImpl& OrdinalImpl::getInfiniteTerms() const
{
	if (!terms || isFinite()) return zero ;
	return * new OrdinalImpl("infiniteTerms",terms->getInfiniteTerms());


}


static const OrdinalImpl& returningo(bool dbg, const char *id,
	const OrdinalImpl& r,
	const OrdinalImpl& ord, const CantorNormalElement& elt)
{
	if (!dbg) {
		
		return r ;
	}
	outDbgStream() << "Ordinal -Ole limit returning at " << id << ", val = "
		<< r.normalForm() << ", " << ord.normalForm() << " limit elt of "
		<< elt.normalForm() << "\n" ;
	return r;
}


#define RETURNO(id,x) return &(returningo(dbg, id, x, ord, *this))






const OrdinalImpl& OrdinalImpl::expFunctional(const OrdinalImpl &exponent,
    Int factor)
{
    if (factor==0) return OrdinalImpl::zero ;
    assert(factor>0) ;
    const NormalFormTerm * terms = exponent.terms ;
    assert(terms);
    if ((terms->next == NULL) && (terms->term.factor == 1) &&
       (terms->term.codeLevel > CantorNormalElement::cantorCodeLevel))
       return exponent ;
    
    return CantorNormalElement::fixedPointCheck(exponent,factor);
}

void OrdinalImpl::termsCopy(NormalFormTerm *& termsIn, Int lastFactor) const
{
    if (!terms) return ;
    const NormalFormTerm * trms = terms ;
    while (trms) {
        const CantorNormalElement * elt = &(trms->term) ;
        if (!trms->next) elt =
            new CantorNormalElement(elt->exponent,
                lastFactor > 0 ? lastFactor:elt->factor) ;
        if (!termsIn) termsIn = new NormalFormTerm(*elt);
        else termsIn->append(*elt);
        trms = trms->next ;
    }
}


#define RETURNOA(id,x) return returningo(dbg, id, x, ord, *this)

const OrdinalImpl& CantorNormalElement::limitOrd(const OrdinalImpl & ord) const
{
    
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;


    const CantorNormalElement *expLast = exponent.getLastTerm();
    assert(expLast);
    Int expFactor = expLast->factor ;
    if (expFactor == 1) RETURNOA("B", OrdinalImpl::expFunctional(
        exponent.limitOrd(ord),factor));

    const OrdinalImpl * offset = NULL ;
    if (factor > 1) offset =
        
        &(fixedPointCheck(exponent,factor-1));

    NormalFormTerm * termsExp = NULL ;
    exponent.termsCopy(termsExp,expFactor-1);
    const OrdinalImpl* base = new OrdinalImpl("limitOrdTmp",*termsExp);
    const OrdinalImpl& toAdd = expLast->limitOrd(ord) ;
    base = &(base->addLoc(toAdd)) ;


    const OrdinalImpl& root = OrdinalImpl::expFunctional(*base);
    if (offset) offset= &(offset->addLoc(root));
    else offset = &root ;
    RETURNOA("C",*offset);
}


const OrdinalImpl& OrdinalImpl::limit(const Ordinal * const * const ords) const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
	dbg=true ;
	if (isFinite()) return * this ;
	if (isSuccessor()) {
		const OrdinalImpl& ret =  getInfiniteTerms();
		if (dbg) outStream() << ret.normalForm() << " infTerms\n" ;
		return ret ;
	}
	const OrdinalImpl& limT = limitType() ;
	const Ordinal * const * ordp = NULL ;
	for (const Ordinal * const * ordc = ords; *ordc;ordc++) {
		if ((*ordc)->maxLimitType().compare(limT) >= 0) break ;
		if (ordp) if ((*ordp)->maxLimitType().
			compare((*ordc)->maxLimitType())>0) {
			outStream() << (*ordp)->maxLimitType().normalForm() << " : " <<
				(*ordc)->maxLimitType().normalForm() << "\n" ;
			assert(0);
		}
		ordp=ordc;
	}
	if (!ordp) return *this ;
	outStream() << "limitType = " << limT.normalForm() << "\n" ;
	return limitOrd((**ordp).getImpl());

}


const OrdinalImpl& OrdinalImpl::limit(const Int n, const Ordinal& ord) const
{
	if (isFinite()) return * this ;
	if (isSuccessor()) return getInfiniteTerms();
	if (limitType().compare(ord.maxLimitType())>0)
			return limitOrd(ord.getImpl());
	
	if (limitType().compare(CantorNormalElement::integerLimitType)==0)
		return limitElement(n);
	else return zero ;

}


const OrdinalImpl& OrdinalImpl::limitElement(Int n) const
{
	if (isZero()) return zero ;
	if (n < 1) return zero ;
	return terms->limitElement(n);
	
}

const OrdinalImpl& OrdinalImpl::limitOrd(const OrdinalImpl& arg)
	const
{
	bool dbg = OrdinalImpl::debugControl.check(DebugControlParam::limit,0) ;
	
	if (!arg.terms) return OrdinalImpl::zero ;
	if (arg.compare(OrdinalImpl::omega)<0) return 
		limitElement(arg.getFirstTerm()->factor);

	if (dbg) {
		arg.maxLimitType().out("arg.maxLimitType");
		limitType().out("OrdinalImpl::LimitOrd - this->limitType");
	}
    assert(arg.maxLimitType().compare(limitType())<0) ;

	const CantorNormalElement * last = getLastTerm();
	const OrdinalImpl& resultTail = last->limitOrd(arg);

	const NormalFormTerm * result = NULL ;
	const NormalFormTerm * current = terms ;
	while (current->next) {
		const NormalFormTerm * resultTerm = new NormalFormTerm(current->term );
		if (result) result->append(*resultTerm);
		else result = resultTerm ;
		current = current->next ;
	}
	assert(current);
	if (!result)  return resultTail ;
	const OrdinalImpl& base =
		CantorNormalElement::createOrdinal("limitOrd", *result);
	return base.addLoc(resultTail);

	
}




string OrdinalImpl::exprName(const OrdinalImpl& a, const char *oper,
		const OrdinalImpl&b) const
{
	string retName = "(" ;
	retName += a.assignedNameString;
	retName +=  oper ;
	retName += b.assignedNameString;
	retName += ")" ;
	return retName ;

}

const OrdinalImpl& OrdinalImpl::addLoc(const Ordinal& op) const 
{
	return addLoc(op.getImpl());
}

ostream& OrdinalImpl::out(const string cmt ) const
{

	ostream& ret = outStream();
	const string empty = "" ;
	const string& str = normalForm();
	const string * add = &cmt ;
	if (!cmt.compare("LENGTH")) {
		add = &empty ;
		ret << str.length() << ":" ;
	}
			
	ret << str <<  " " << *add << "\n" ;
	
	
	return ret ;

}



const OrdinalImpl& OrdinalImpl::subtract(const Int& offset) const 
{
	assert(offset > 0) ;
	if (offset < 1) return *this ;
	if (!hasFiniteTerm) return *this;
	OrdinalImpl * ret = new OrdinalImpl(*this,offset);
	return * ret ;	
	
}

int OrdinalImpl::psuedoCodeLevel() const 
{
	if (isZero() || getSecondTerm() || (getFirstTerm()->factor>1))
		return CantorNormalElement::cantorCodeLevel ;
	return getFirstTerm()->codeLevel ;
	
}

void OrdinalImpl::descr(const char * comment) const 
{
	outStream() << normalForm() << " " << comment << "\n" ;
}


string CantorNormalElement::limInfoName(LimitTypeInfo inf)
{
#define LISWE(name) case name: return #name ;
    switch (inf) {
            LISWE(unknownLimit);
            LISWE(zeroLimit);
            LISWE(finiteLimit);        
            LISWE(drillDownLimit);     
            LISWE(drillDownSucc); 
            LISWE(paramLimit);         
            LISWE(paramNxtLimit);      
			LISWE(paramSucc);     
            LISWE(iterLimit);          
            LISWE(iterNxtLimit);       
            LISWE(iterSucc);          
            LISWE(indexCKlimit);       
            LISWE(indexCKsuccParam);       
            LISWE(indexCKsuccIter);       
            LISWE(indexCKsucc);       
            LISWE(indexCKlimitParam);       
            LISWE(indexCKlimitIter);       
        default:
            assert(false);
    }
    assert(false);
}

CantorNormalElement::LimitTypeInfo OrdinalImpl::getLimitInfo() const
{
    const CantorNormalElement * ftrm = getFirstTerm();
    if (ftrm == NULL) return CantorNormalElement::zeroLimit ;
    return ftrm->getLimitInfo();
}


const OrdinalImpl& OrdinalImpl::limitType() const
{
    if (theLimitType) return * theLimitType ;
	if (!terms) return CantorNormalElement::nullLimitType ;
	const CantorNormalElement * last = getLastTerm();
	assert(last) ;
	((OrdinalImpl *)this)->theLimitType = &(last->limitType());
    if (theLimitType) return *theLimitType ;
}

const OrdinalImpl& OrdinalImpl::getMaxParameter() const
{
	if (!terms) return zero ;
	return  terms->term.getMaxParameter();

}

const OrdinalImpl&  OrdinalImpl::getDDindexVal() const
{
    if (!terms) return zero ;
	return  getFirstTerm()->getDDindexVal();
}


const OrdinalImpl& OrdinalImpl::getCompareIndexCK(bool ign) const
{
    if (!terms) return zero ;
	return  getFirstTerm()->getCompareIndexCK(ign);

}


const OrdinalImpl& OrdinalImpl::maxLimitType() const
{
    return maxLimitType(Ordinal::zero);
}

const OrdinalImpl& OrdinalImpl::maxLimitType(const Ordinal&embIx) const
{
	if (!terms) return CantorNormalElement::nullLimitType ;
	return terms->term.maxLimitType(embIx); 
}

const OrdinalImpl& OrdinalImpl::indexCKlimitType() const 
{
    if (isFinite()) return addLoc(1);
    return *this ;
}


Embeddings::Embeddings(const Ordinal& ddIx,Type typ):
     embedIndex(ddIx),
        type(ddIx.isZero() &&(typ==paramRestrict)?none:typ),
            embedIndexMo(ddIx.isSuccessor()?
     *new Ordinal(ddIx.getImpl().subtract(1)):ddIx)
{
}

bool Embeddings::isParamRestrict() const
{
    if ((type != paramRestrict) || embedIndex.isZero())
        return false; return true ;
}


string Embeddings::normalForm() const
{
    string typeName ;
    switch (type) {
case none:
        typeName = "none" ;
        break;
case paramRestrict:
        typeName = "paramRestrict" ;
        break ;
default:
        assert(0);
    }
    string ret = "Emb( " ;
    ret += embedIndex.normalForm();
    ret += ", " ;
    ret += typeName ;
    ret += ")" ;
    return ret ;

}






