#include "finitefuncOrd.h"

using namespace std ;
	
namespace ord {

	class IterFuncNormalElement : public FiniteFuncNormalElement {
        static const Ordinal& theIterClassLimit ;
		protected:
		
		virtual const OrdinalImpl & createVirtualOrdImpl(const Ordinal & lev,
			const Ordinal * const * const parames=NULL) const ;
		virtual const Ordinal & createVirtualOrd(const Ordinal & lev,
			const Ordinal * const * const parames=NULL) const ;

		virtual const OrdinalImpl & createVirtualOrdImpl(
			const Ordinal * const * const parames) const ;
		virtual const Ordinal & createVirtualOrd(
			const Ordinal * const * const parames) const ;

		class IterFuncParameters : public FiniteFuncParameters {
		public:
			const Ordinal& functionLevel ;
			IterFuncParameters(const Ordinal& iter,
				const Ordinal * const * const parames=NULL,
                const Embeddings& embed = Embeddings::embedNone,
				int level = iterFuncCodeLevel);
			virtual ~IterFuncParameters(){}

		};

	public:
		const OrdinalImpl& functionLevel ;
		const Ordinal& functionLevelO ;
		IterFuncNormalElement(const Ordinal& iter,
			const Ordinal* const * const params, Int fac=1,
			int level=iterFuncCodeLevel);
		IterFuncNormalElement(const IterFuncParameters* prma, Int fac=1);

		static const int iterFuncCodeLevel = finiteFuncCodeLevel + 1 ;

		virtual void normalFormName(string& base) const ;
		virtual void texNormalForm(string& str) const ;
        virtual void psiNormalForm(string& str) const ;
        void psiNormalFormKernel(string& str) const ;
        const Ordinal& classLimit() const {return theIterClassLimit;}

        void iterFuncDebug(const char * where) const ;


		virtual const CantorNormalElement& getCopy(const Int fac=1) const;

		const OrdinalImpl* limitOrdCom(const OrdinalImpl & ord) const ;
		virtual const OrdinalImpl& limitOrd(const OrdinalImpl & ord) const ;
		virtual const OrdinalImpl& limitElement(Int n) const ;
		const OrdinalImpl& limitElementCom(Int n) const ;
		virtual const CantorNormalElement & addFactors(
			const CantorNormalElement& toAdd) const ;

		virtual int compare(const CantorNormalElement& trm,
			bool ignoreFactor = false) const ;

		virtual int compare(const Embeddings& context,
            const Embeddings& paramContext, const CantorNormalElement& trm,
			bool ignoreFactor = false) const ;
        //
		

		
		const OrdinalImpl& limitInfo(CantorNormalElement::LimitTypeInfo& info)
			const ;
		virtual const OrdinalImpl& limitType() const;
       	virtual const OrdinalImpl& maxLimitType() const ;
		virtual const OrdinalImpl& maxLimitType(const Ordinal& context) const ;

        virtual const CantorNormalElement& limitMaxEmbed(const OrdinalImpl&lim) const ;



	};


	class IterFuncOrdinalImpl: public FiniteFuncOrdinalImpl {
		friend class IterFuncNormalElement ;
		friend class IterFuncOrdinal ;
		static const NormalFormTerm& createTerms(const Ordinal& iter,
			const Ordinal* const * const params)  ;
	protected:
		static string makeName(const Ordinal& iter,
			const Ordinal* const * const params)  ;
		static string makeTexName(const Ordinal& iter,
			const Ordinal* const * const params)  ;
	public:
		IterFuncOrdinalImpl(const Ordinal& iter,
			const Ordinal* const * const params=0):
				FiniteFuncOrdinalImpl(makeName(iter, params),
					createTerms(iter, params)){}

		IterFuncOrdinalImpl(const IterFuncNormalElement& elt):
			FiniteFuncOrdinalImpl(elt){}

		IterFuncOrdinalImpl(const string& name,const NormalFormTerm&  trms):
			FiniteFuncOrdinalImpl(name,trms){}

			
		virtual ~IterFuncOrdinalImpl(){}

	};

	class IterFuncOrdinal : public FiniteFuncOrdinal {
	public:
		IterFuncOrdinal (const Ordinal& ord1, const Ordinal&ord2):
			FiniteFuncOrdinal(*new IterFuncOrdinalImpl(ord1,
				createParameters(&ord2))){}
				
		IterFuncOrdinal (const Ordinal& ord1, const Ordinal&ord2,
			const Ordinal& ord3):FiniteFuncOrdinal(
			*new IterFuncOrdinalImpl(ord1,createParameters(&ord2,&ord3))){}

		IterFuncOrdinal (const Ordinal& ord1, const Ordinal&ord2,
			const Ordinal& ord3, const Ordinal&ord4):FiniteFuncOrdinal(
			*new IterFuncOrdinalImpl(ord1,
			createParameters(&ord2,&ord3,&ord4))){}

		IterFuncOrdinal (const Ordinal& iter,
				const Ordinal* const * const params):
			FiniteFuncOrdinal(*new IterFuncOrdinalImpl(iter,params)){}

		IterFuncOrdinal(const IterFuncOrdinalImpl& ord):
			FiniteFuncOrdinal(ord){}
		virtual ~IterFuncOrdinal(){}


		enum {iterMaxParam = -1};
		static bool fixedPoint(const Ordinal& iter, int ix,
			const Ordinal* const * const params);
		
		static void texDocument() ;


	};


	


}
