/*
 *  texspec.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  texspec.h   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifndef TEXSPEC_DOT_H
#define TEXSPEC_DOT_H
struct TeXWordTranslate {
	const char * TeXName; // includes `\'
	const char * TranslateTo;
	int IsMath ;
};

class DoTeXWordTranslate {
	enum {MaxWordSize = 32} ; // crude way to create a local conatant
	const TeXWordTranslate * TheTranslations ;
	int RecursiveCall ;

	char word[MaxWordSize+1] ;
	int Count  ; // size of contents of word

	const char * DoTranslate(const char * Input, const char * Start,
		const char * Translation);
	int FindMacroWord(const char * Ptr) ;
public:
	DoTeXWordTranslate(TeXWordTranslate * translations);
	char * Translate(const char * Input);
	const char * IsTeXMacro(const char * word);
	int IsMathTeXMacro(const char * word);
	const char * CheckTranslate(const char * word, int ReturnWord=0);
};

extern DoTeXWordTranslate TheTeXWordTranslator ;
char * TeXString(const char * String);

#endif /* #ifdef TEXSPEC_DOT_H */
