/*
 * Get canonical name of the host
 */

#ifndef lint
char rcsid[] = "@(#)netname.c,v 1.23 2011/12/08 03:52:09 kim Exp";
#endif

#include <unistd.h>
#ifdef __GLIBC__
#include <ctype.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/utsname.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <err.h>
#ifdef ultrix
#include <sys/svcinfo.h>
#endif

#ifdef __GLIBC__
void check_nonstandard_address(char *host)
{
  char *endptr;
  int (*f)(int);

  if (strstr(host, "0x") == host) {
    endptr = host + 2;
    f = isxdigit;
  } else {
    endptr = host;
    f = isdigit;
  }
  for (; (*f)((unsigned char) *endptr); endptr++)
    continue;
  if (*endptr == '\0') {
    errx(2, "%s: hostname cannot be all numeric", host);
  }
}
#endif

void usage(FILE *stream, char *me)
{
  fprintf(stream, "Usage:\t%s [-adn46] [host | address]\n", me);
  fprintf(stream, "\t%s -v\n", me);
}

int main(int argc, char **argv)
{
  char *host = NULL, h[NI_MAXHOST], p[NI_MAXHOST], *progname;
  struct utsname name;
  struct addrinfo hints, *res = NULL, *rp;
  struct sockaddr *sp;
  struct sockaddr_in sa;
  struct sockaddr_in6 sa6;
  int a = 0, c, d = 0, e, n = 0, len = 0;
  unsigned char buf[sizeof(struct in6_addr)];
#ifdef ultrix
  struct svcinfo *svcinfo;
#endif
  extern int optind;

  if ((progname = strrchr(argv[0], '/')) != NULL)
    progname++;
  else
    progname = argv[0];

  while ((c = getopt(argc, argv, "46adhnv")) != EOF)
    switch (c) {
    case '4':
      if (n == 6)
	n = 1;
      else
	n = 4;
      break;
    case '6':
      if (n == 4)
	n = 1;
      else
	n = 6;
      break;
    case 'a':
      a = 1;
      break;
    case 'd':
      d = 1;
      break;
    case 'n':
      n = 1;
      break;
    case 'v':
      fprintf(stdout,
	      "%s version 2.2 (Copyright (c) 1995-2011 Kimmo Suominen)\n%s\n",
	      progname, rcsid);
      /* FALLTHROUGH */
    case 'h':
      usage(stdout, progname);
      exit(0);
    default:
      usage(stderr, progname);
      exit(1);
    }

  switch (argc - optind) {
  case 0:
    if (uname(&name) == -1) {
      err(2, "uname");
    }
    host = name.nodename;
    break;
  case 1:
    host = argv[optind];
#ifdef __GLIBC__
    check_nonstandard_address(host);
#endif
    e = inet_pton(AF_INET6, host, buf);
    switch (e) {
      case 0:
	e = inet_pton(AF_INET, host, buf);
	switch (e) {
	  case 0:
	    break;
	  case 1:
	    memset(&sa, 0, sizeof(sa));
	    sa.sin_family = AF_INET;
#ifdef BSD4_4
	    sa.sin_len = sizeof(sa);
#endif
	    memcpy(&(sa.sin_addr), buf, sizeof(sa.sin_addr));
	    len = sizeof(sa);
	    sp = (struct sockaddr *)&sa;
	    break;
	  default:
	    err(2, "inet_pton(AF_INET)");
	}
	break;
      case 1:
	memset(&sa6, 0, sizeof(sa6));
	sa6.sin6_family = AF_INET6;
#ifdef BSD4_4
	sa6.sin6_len = sizeof(sa6);
#endif
	memcpy(&(sa6.sin6_addr), buf, sizeof(sa6.sin6_addr));
	len = sizeof(sa6);
	sp = (struct sockaddr *)&sa6;
	break;
      default:
	err(2, "inet_pton(AF_INET6)");
    }
    if (len) {
      memset(h, 0, sizeof(h));
      e = getnameinfo(sp, len, h, NI_MAXHOST, NULL, 0, NI_NAMEREQD);
      if (e) {
	errx(2, "%s: %s", host, gai_strerror(e));
      }
      if (*h == '\0') {
	errx(2, "Address %s points to an empty name", host);
      }
      host = h;
    }
    break;
  default:
    usage(stderr, progname);
    exit(1);
  }

#ifdef ultrix
  /* On ultrix, force use of the DNS resolver instead of the hosts file */
  if ((svcinfo = getsvc()) != NULL) {
    if (svcinfo->svcpath[SVC_HOSTS][0] == SVC_LOCAL) {
      int i;

      for (i = 0; i < SVC_PATHSIZE - 1; i++)
        svcinfo->svcpath[SVC_HOSTS][i] = svcinfo->svcpath[SVC_HOSTS][i + 1];
    }
  }
#endif

  memset(&hints, 0, sizeof(hints));
  hints.ai_family = AF_UNSPEC;
  hints.ai_flags = AI_CANONNAME;

  /*
   * Without the socktype hint, the returned list will have
   * an entry for each possible socktype for each address.
   */

  hints.ai_socktype = SOCK_STREAM;

  e = getaddrinfo(host, NULL, &hints, &res);
  if (e) {
    errx(2, "%s: %s", host, gai_strerror(e));
  }

  if (d && (host = strchr(res->ai_canonname, '.')) != NULL)
    host++;
  else
    host = res->ai_canonname;

  if ((a && !d) || n) {
    if (a)
      printf("Canonical hostname is %s\n", host);
    for (rp = res; rp != NULL; rp = rp->ai_next) {
      memset(h, 0, sizeof(h));
      memset(p, 0, sizeof(p));

      switch (rp->ai_addr->sa_family) {
	case AF_INET:
	  if (n == 6)
	    continue;
	  inet_ntop(AF_INET,
		    &(((struct sockaddr_in *)rp->ai_addr)->sin_addr),
		    p, NI_MAXHOST);
	  break;
	case AF_INET6:
	  if (n == 4)
	    continue;
	  inet_ntop(AF_INET6,
		    &(((struct sockaddr_in6 *)rp->ai_addr)->sin6_addr),
		    p, NI_MAXHOST);
	  break;
	default:
	  if (n)
	    continue;
	  strncpy(p, "<unprintable>", NI_MAXHOST);
	  break;
      }

      if (n)
	printf("%s\n", p);
      else {
	e = getnameinfo(rp->ai_addr, rp->ai_addrlen,
			h, NI_MAXHOST, NULL, 0, 0);
	if (e) {
	  warnx("%s: address %s: %s", host, p, gai_strerror(e));
	}
	if (*h != '\0')
	  printf("Address %s points to %s\n", p, h);
      }
    }
  } else {
    printf("%s\n", host);
  }

  freeaddrinfo(res);
  return(0);
}
