/* mcap.h

   Definitions for the modemcap file... */

/*
 * Copyright (c) 1995 RadioMail Corporation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of RadioMail Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY RADIOMAIL CORPORATION AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * RADIOMAIL CORPORATION OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software was written for RadioMail Corporation by Ted Lemon
 * under a contract with Vixie Enterprises, and is based on an earlier
 * design by Paul Vixie.
 */

#ifndef _PATH_MODEMCAP
#define	_PATH_MODEMCAP	"/etc/modemcap"
#endif

struct modemcap {
  /* Strings... */
  char	       *name;		/* Name of modem capability string... */
  char         *init_string;	/* is: Modem Init string... */
  char	      **init_vector;	/* ... exploded Modem Init string... */
  char	       *parity;		/* pa: Parity (even, odd, none)... */
  char	       *program;	/* lp: Login program... */
  char	       *luser;		/* lu: Login user... */
  char	       *banner;		/* ba: Login banner... */
  char	       *connect_addr;	/* ca: TCP connect address... */
  char	       *connect_port;	/* cp: TCP port to connect to... */
  char	       *factory_defaults; /* fd: Reset modem to factory defaults... */
  char         *ppp_prog;	/* Call this instead of login prog if incoming
				   PPP frame detected. */

  /* Lists of strings... */
  struct list  *devices;	/* dv: Tty device... */
  char	      **device_vector;	/* Devices arranged in an array... */
  int		device_count;	/* Number of devices... */

  /* Booleans... */
  unsigned char fc_rts_cts;	/* hf: Flow control: RTS/CTS... */
  unsigned char fc_xon_xoff;	/* sf: Flow control: XON/XOFF... */
  unsigned char match_speed;	/* ms: Match modem CONNECT speed... */
  unsigned char reset_dtr;	/* zm: Reset modem with DTR... */
  unsigned char do_login;	/* dl: Login program doesn't do utmp, etc. */
  unsigned char clumpp;		/* cp: $MB1200 (e.g.) is one AT command... */
  unsigned char slow_modem;	/* sm: Entire modem command must be slow... */
  unsigned char raw_tty;	/* rt: Leave tty in raw mode... */
  unsigned char skip_init;	/* si: Skip modem initialization in mpoold. */
  unsigned char defer_init;	/* di: Defer modem initialization in mpoold. */
  unsigned char busy_out;	/* bo: Busy out modem prior to init. */
  unsigned char logstderr;	/* ls: log child stderr. */

  /* Numbers... */
  unsigned	tx_speed;	/* os: Modem transmit speed (fixed)... */
  unsigned	rx_speed;	/* is: Modem receive speed (fixed)... */
  unsigned	bits;		/* bt: Bits per character... */
  unsigned	ibuf_size;	/* bs: Input buffer size for AT cmds... */
  unsigned	msdelay;	/* dm: Delay between chars in cmd mode. */
};

/* List of strings... */
struct list {
  struct list *next;
  char *value;
};

extern struct modemcap modemcap;
