PACKAGE = mkcdtoc
VERSION = 1.0
BUGSTO = lostclus@ua.fm

PREFIX=/usr/local
BINDIR=$(PREFIX)/bin
DATADIR=$(PREFIX)/share
MANDIR=$(PREFIX)/man
DESTDIR=
PERL=/usr/bin/perl

SEDDEPS = $(TOP_DIR)/include.mak
SEDCMDS = 's|@PACKAGE@|$(PACKAGE)|g; s|@VERSION@|$(VERSION)|g; \
          s|@BUGSTO@|$(BUGSTO)|g; \
          s|@PERL@|$(PERL)|g; \
	  s|@PLUGINDIR@|$(DATADIR)/$(PACKAGE)/plugins|g'
DIST_DIR = $(TOP_DIR)/.dist
DIST_PREFIX = /$(PACKAGE)-$(VERSION)

all: all-recursive

all-recursive:
	for i in $(SUBDIRS); do $(MAKE) -C $$i all || exit $$?; done

clean: clean-recursive

clean-recursive:
	for i in $(SUBDIRS); do $(MAKE) -C $$i clean || exit $$?; done

install: install-recursive

install-recursive:
	for i in $(SUBDIRS); do $(MAKE) -C $$i install || exit $$?; done

uninstall: uninstall-recursive

uninstall-recursive:
	for i in $(SUBDIRS); do $(MAKE) -C $$i uninstall || exit $$?; done

dist: $(DIST_FILES) dist-recursive
	mkdir -p $(DIST_DIR)$(DIST_PREFIX)
	cp -a $(DIST_FILES) $(DIST_DIR)$(DIST_PREFIX)

dist-recursive:
	for i in $(SUBDIRS); do $(MAKE) -C $$i \
	  DIST_PREFIX=$(DIST_PREFIX)/$$i dist || exit $$?; done

dist-bzip2: dist
	tar -C $(DIST_DIR) -cjf $(PACKAGE)-$(VERSION).tar.bz2 .
	rm -rf $(DIST_DIR)

dist-zip: dist
	zipfile=`pwd`/$(PACKAGE)-$(VERSION).zip; \
	rm -f "$$zipfile"; \
	cd $(DIST_DIR) && zip -r "$$zipfile" *
	rm -rf $(DIST_DIR)

dist-ctan: dist
	zipfile=`pwd`/$(PACKAGE)-$(VERSION)-ctan.zip; \
	rm -f "$$zipfile"; \
	cd $(DIST_DIR)$(DIST_PREFIX) && zip -r "$$zipfile" *
	rm -rf $(DIST_DIR)

.PHONY: all all-recursive clean clean-recursive \
	dist dist-recursive dist-bzip2
