/* TECO for Ultrix   Copyright 1986 Matt Fichtenbaum						*/
/* This program and its components belong to GenRad Inc, Concord MA 01742	*/
/* They may be copied if this copyright notice is included					*/

/* te_rdcmd.c  read in the command string  6/4/87 */
/* version for multiple buffers  04/13/89 10.22								*/
/* add function keys  12/13/90  14.06 */
/* add Q~ registers  11/27/91  09.29 */

#include "te_defs.h"

int ccount;				/* count of chars read in */

int read_cmdstr()
{
	unsigned short c;	/* temporary character */
	int i;				/* temporary */
	unsigned short do_func_keys();

	goto prompt;

  restart:					/* prompt again: new line */
	if (!eisw && !inp_noterm) crlf();		/* if input not from a file */
  prompt:					/* issue prompt */
	if (!eisw && !inp_noterm)
	{
		reset_ctlo();		/* reset any ^O */
		type_char('*');
	}
	ccount = 0;
	lastc = ' ';

reline:					/* continue reading */
	for (;;)			/* loop to read command string chars */
	{
		if (!eisw && !inp_noterm)		/* if terminal input */
		{
			if ((c = gettty()) == DEL)		/* process rubout */
			{
				if (!ccount) goto restart;		/* if at beginning, ignore */
				--ccount;						/* decrement char count */
				backc(&cmdstr);					/* back up the command-string pointer */
/* look at the character just deleted */
				if (((c = cmdstr.p->ch[cmdstr.c]) < ' ') && (c != ESC))		/* control chars: set c to char erased */
				{
					if (c == LF) vt(VT_LINEUP);		/* line up */

					else if ((c == CR) || (c == TAB))
					{
						i = find_lasteol();			/* back up to previous line */
						type_char(CR);				/* erase current line */
						vt(VT_EEOL);
						if (i == ccount) type_char('*');		/* if this was line with prompt, retype the prompt */
						for (; (t_qp.p != cmdstr.p) || (t_qp.c != cmdstr.c); fwdc(&t_qp))
							type_char(t_qp.p->ch[t_qp.c]);		/* retype line: stop before deleted position */
					}

					else
					{
						vt(VT_BS2);				/* erase ordinary ctrl chars */
						char_count -= 2;
					}
				}
				else
				{
					vt(VT_BS1);				/* erase printing chars */
					char_count--;
				}
				lastc = ' ';		/* disable dangerous last chars */
				continue;
			}					/* end 'rubout' processing */

			else if (c == CTL('U'))			/* process "erase current line" */
			{
				type_char(CR);				/* erase line */
				vt(VT_EEOL);
				if ((ccount -= find_lasteol()) <= 0) goto prompt;	/* back up to last eol: if beginning, restart */
				cmdstr.p = t_qp.p;			/* put command pointer back to this point */
				cmdstr.c = t_qp.c;
				lastc = ' ';
				continue;				/* and read it again */
			}

			else			/* not a rubout or ^U */
			{
				if (c >= 0400)		/* function key - execute if enabled, exit if 2 ESCs found */
				{
					if ((ez_val & EZ_FKEYS) != 0 && do_func_keys(c) > 0) break;
				}
				else if (!ccount)		/* if at beginning of line */
				{
					if (c == '*')		/* save old command string */
					{
						type_char('*');		/* echo character */
						c = gettty();		/* read reg spec */
						if (c >= 0400)		/* if a function key */
						{
							i = c - 0400 + EXTALPHQREGS;	/* find corresponding register */
							if (ez_val & EZ_FKEYS) qreg[i].v = 16;		/* if func keys enabled, set "exec" bit */
						}
						else				/* not a function key */
						{
							type_char(c);	/* echo */
							if (c == '`' || c == '~')	/* extended register? */
						{
								i = (c == '~') ? NEXTQREGS/2 : 0;
								type_char(c = gettty());	/* read & echo one more */
								if (isdigit(c)) i += EXTQREGS + c - '0';
								else if (isalpha(mapch_l[c])) i += EXTQREGS + 10 + c - 'a';
								else ERROR(E_IQN);
						}
							else i = getqspec(0, c);
						}
						free_blist(qreg[i].f);		/* return its previous contents */
						qreg[i].f = cbuf.f;			/* put the old command string in its place */
						if (qreg[i].f)
						{
							qreg[i].f->b = (struct buffcell *) &qreg[i];
							qreg[i].f->usecount = 1;
						}
						qreg[i].z = cbuf.z;
						cbuf.f = (struct buffcell *) (cbuf.z = 0);		/* no old command string */
						err = 0;					/* no previous error */
						goto restart;
					}
					else if ((c == '?') && (err))	/* echo previous command string up to error */
					{
						type_char('?');			/* echo ? */
						for (aa.p = cptr.p; aa.p->b->b != NULL; aa.p = aa.p->b);	/* find beginning */
						for (aa.c = 0; (aa.p != cptr.p) || (aa.c < cptr.c); fwdc(&aa)) type_char(aa.p->ch[aa.c]);
						type_char('?');				/* a final ? */
						err = 0;				/* reset error switch */
						goto restart;
					}
					else if ((c == LF) || (c == CTL('H')))	/* line feed, backspace */
					{
						pbuff->dot += lines( (c == LF) ? 1 : -1);	/* pointer up or down one line */
						window(WIN_LINE);			/* display one line */
						goto restart;
					}
					else if ((c == CTL('W')) && (WN_scroll != 0))	/* immediate window redisplay */
					{
						window(WIN_REDRAW);		/* redraw full window */
						window(WIN_REFR);
						goto restart;
					}
					else					/* first real command on a line */
					{
						make_buffer(&cbuf);	/* start a command string if need be */
						cmdstr.p = cbuf.f;	/* set cmdstr to point to start of command string */
						cmdstr.c = 0;
						cbuf.z = 0;			/* no chars in command string now */
						err = 0;			/* clear last error flag */
					}
				}	/* end of "if first char on line" */				


/* check ^G-something */

				if (lastc == CTL('G'))
				{
					if (c == CTL('G'))
					{
						cbuf.z = ccount;	/* save count for possible "save in q-reg" */
						goto restart;
					}
					if ((c == '*') || (c == ' '))
					{
						backc(&cmdstr);		/* remove the previous ^G from buffer */
						--ccount;
						crlf();
						retype_cmdstr(c);	/* retype appropriate part of command string */
						lastc = ' ';
						continue;
					}			/* end of ^G* and ^G<sp> processing */
				}			/* end of "last char was ^G" */
			}			/* end of "not rubout or ^U */
		}			/* end of "if !eisw" */

		else			/* if input from indirect file or redirected std input */
		{
			if (!ccount)	/* first command? */
			{
				if (!cbuf.f)	/* start a command string if need be */
				{
					cbuf.f = get_bcell();
					cbuf.f->b = (struct buffcell *) &cbuf;
				}
				cmdstr.p = cbuf.f;		/* point cmdstr to start of command string */
				cbuf.z = cmdstr.c = 0;
			}

			c = (eisw) ? getc(eisw) : gettty() ;	/* get char */
			if (eisw && (c == (unsigned short) EOF))			/* if this is end of the indirect command file */
			{
				fclose(eisw);				/* close the input file */
				eisw = 0;					/* reset the switch */
				lastc = ' ';
				continue;					/* and go read more chars */
			}
			else if (c==(unsigned short) EOF) 
			{
				return 1;
			}
			else
		
			{
				if ((c == LF) && (lastc != CR) && !(ez_val & EZ_CRLF))	/* LF: store implied CR first */
				{
					cmdstr.p->ch[cmdstr.c] = CR;
					++ccount;
					fwdcx(&cmdstr);
				}
			}
		}			/* end of "if redirected std in or eisw" */


/* store character in command string */

			if (c < 0200)			/* don't store special characters */
			{
				cmdstr.p->ch[cmdstr.c] = c;		/* store the character */
				++ccount;						/* keep count of chars */
				if (!eisw && !inp_noterm) type_char(c);		/* echo the character */
				fwdcx(&cmdstr);					/* next char pos'n; extend command string if nec */
			}

			if ((c == ESC) && (lastc == ESC)) break;	/* stop on 2nd ESC */
			if ((c == CTL('C')) && (lastc == CTL('C'))) return(-1);	/* immediate exit */
			lastc = c;								/* keep track of last char */
		}					/* end of read-char loop */

	cbuf.z = ccount;		/* indicate number of chars in command string */
	if (!eisw && !inp_noterm) crlf();		/* final new-line */
	return(0);
}					/* end of read_cmdstr() */

/* back up to find most recent CR or LF in entered command string */
/* return number of chars backed up */

int find_lasteol()
{
	int i;

	for (i = 0, t_qp.p = cmdstr.p, t_qp.c = cmdstr.c; (backc(&t_qp)) ; i++)	/* look for beg. of line */
	{
		if ((t_qp.p->ch[t_qp.c] == CR) || (t_qp.p->ch[t_qp.c] == LF))
		{
			fwdc(&t_qp);	/* stop short of previous eol */
			break;
		}
	}
	char_count = 0;				/* reset tab count */
	return(i);
}



/* retype command string: entirely (arg = '*') or most recent line (arg = ' ') */

retype_cmdstr(c)
	char c;
{
	int i;

	if (!inp_noterm)	/* if input is really from terminal */
	{
		if (c == ' ')		/* look for beginning of this line */
			i = ccount - find_lasteol();	/* to last eol, and count char's backed up */
		else
		{
			t_qp.p = cbuf.f;	/* retype whole command string */
			i = t_qp.c = 0;
		}
		if (!i) type_char('*');	/* if from beginning, retype prompt */
		for (; i < ccount; i++)		/* type command string from starting point */
		{
			type_char(t_qp.p->ch[t_qp.c]);
			fwdc(&t_qp);
		}
	}
}
/* process function keys */
/* called with key code; func. keys have 0400 bit set */

#define IMMED_ENABLE 0x10
#define IMMED_INSERT 0x20
#define IMMED_BEGIN 0x40
#define IMMED_CHAIN 0x80

static struct qh saved_command;
static struct qp saved_cmd_ptr;

static unsigned short do_func_keys(c)
	unsigned short c;
{
	unsigned short i, n;			/* temporaries */
	struct qh *header_p;			/* pointer to register's header */
	struct qp pointer;				/* q-pointer to register being copied */
	unsigned char last_c = ' ', this_c;		/* char's used in copying command string */

	header_p = &qreg[(c & 0xff) + EXTALPHQREGS];		/* point to corresp q-reg header */
func_key_chain:
	if ((header_p->v & IMMED_ENABLE) && (ccount == 0 || !(header_p->v & IMMED_BEGIN)))
	{										/* if func. keys are enabled */
		if (header_p->v & IMMED_INSERT)
		{									/* copy register text to command string */
			pointer.p = header_p->f;		/* initialize pointer */
			pointer.c = 0;
			if (ccount == 0)				/* if this is the start of a string... */
			{
				make_buffer(&cbuf);			/* start a command string if need be */
				cmdstr.p = cbuf.f;			/* set cmdstr to point to start of command string */
				cmdstr.c = 0;
				cbuf.z = 0;					/* no chars in command string now */
			}
			for (n = 0; n < header_p->z; n++)		/* copy characters */
			{
				this_c = cmdstr.p->ch[cmdstr.c] = pointer.p->ch[pointer.c];		/* copy */
				fwdc(&pointer);				/* increment pointers */
				fwdcx(&cmdstr);
				++ccount;					/* lengthen command string */
				type_char(this_c);			/* echo */
				if (this_c == ESC && last_c == ESC) return(1);		/* 2 ESCs found - exit */
				last_c = this_c;
			}
		}
		else								/* execute? */
		{
			saved_command = cbuf;			/* save current command string in progress */
			saved_cmd_ptr = cmdstr;			/* save current pointer */
			cbuf.f = get_bcell();			/* make a new buffer */
			cbuf.f->b = (struct buffcell *) &cbuf.f;
			cbuf.f->ch[0] = 'm';			/* make up a macro call */
			cbuf.f->ch[1] = '`';
			cbuf.f->ch[2] = 'a'+ (c & 0xff);
			cbuf.f->ch[4] = cbuf.f->ch[3] = ESC;
			cbuf.z = 5;

			exec_cmdstr();					/* execute */

			free_blist(cbuf.f);				/* flush temp. command string */
			cmdstr = saved_cmd_ptr;			/* restore */
			cbuf = saved_command;
			saved_command.f = 0;			/* set to "no command string saved" */

			window(WIN_REFR);				/* refresh display */
			if (header_p->v & IMMED_CHAIN)	/* chain to Q`0? */
			{
				header_p = &qreg[EXTQREGS];		/* yes, point to that header */
				goto func_key_chain;		/* and do it again */
			}
		}
	}
	return(0);				/* normal return */
}
