/*
 * Stuff common to both GutenPalm and makeztxt
 */

#ifndef GUTENPALM_COMMON_H
#define GUTENPALM_COMMON_H


/* Padding is no good */
#if defined(__GNUC__) && defined(__UNIX__)
#  pragma pack(2)
#endif

/*  The default creator is GutenPalm 'GPlm'  */
#define GPLM_CREATOR_ID         "GPlm"
/*  Databases of type 'zTXT'  */
#define ZTXT_TYPE_ID            "zTXT"
/*  Size of one database record  */
#define RECORD_SIZE             8192
/*  Allow largest WBIT size for data.  Lower with command line options
    in makeztxt  */
#define MAXWBITS                15
/* Max length for a bookmark/annotation title */
#define MAX_BMRK_LENGTH         20

/* Option masks for storedPrefs */
#define INVERTTEXT_OPTION       0x0001
#define FULLSCREEN_OPTION       0x0002
#define ROTATE0_OPTION          0x0010
#define ROTATE90_OPTION         0x0020
#define ROTATE180_OPTION        0x0040
#define ROTATE270_OPTION        0x0080
#define FONTSTD_OPTION          0x0100
#define FONTLRG_OPTION          0x0200
#define FONTBLD_OPTION          0x0400
#define FONTLRGBLD_OPTION       0x0800
#define FONTHK40_OPTION         0x1000


typedef struct zTXT_record0Type {
  UInt16        version;                /* zTXT format revision             */
  UInt16        numRecords;             /* Number of data records           */
  UInt32        size;                   /* Size in bytes of compressed data */
  UInt16        recordSize;             /* Size of a single data record     */
  UInt16        numBookmarks;           /* Number of bookmarks in DB        */
  UInt16        bookmarkRecord;         /* Record containing bookmarks      */
  UInt16        numAnnotations;         /* Number of annotation records     */
  UInt16        annotationRecord;       /* Record # of annotation index     */
  UInt8         randomAccess;           /* 1 if compressed w/Z_FULL_FLUSH   */
  UInt16        storedPrefs;            /* Per zTXT prefs (see docs)        */
  UInt8         padding[0x20 - 21];     /* Pad to a size of 0x20 bytes      */
} zTXT_record0;

#endif
