-- sqlite-test.lua
-- 2003-Feb-28 e doug.currie@alum.mit.edu
--
-- dofile "../mods/sqlite/test.lua"

if (LUA_LIBPATH==nil)
then LUA_LIBPATH="D:/misc/lua-5.0-beta/mods/"
end

repeat -- to hide var bindings and enable break...

local ok
local str
local msg
local sql
local db
local dbname
local i
local err
local len

print"=============================="
print"Testing LuaSqlite"
print(os.date"%Y-%b-%d %H:%M:%S")

-- open binary module

ok,str=module.load"sqlite"
if (not ok)
then do print ("Error on module.load: ", str) break end 
end

print(string.format("Sqlite version: %s", sqlite.version()))
print(string.format("Sqlite encoding: %s", sqlite.encoding()))

print("Here are the first 25 sqlite error strings...")
for i = 0, 25
do print(string.format("%2d %s",i,sqlite.error_string(i)))
end

print(string.format("sqlite.OK = %d gives string: %s",
                          sqlite.OK, sqlite.error_string(sqlite.OK)))
print(string.format("sqlite.ERROR = %d gives string: %s",
                          sqlite.ERROR, sqlite.error_string(sqlite.ERROR)))
print(string.format("sqlite.BUSY = %d gives string: %s",
                          sqlite.BUSY, sqlite.error_string(sqlite.BUSY)))
print(string.format("sqlite.MISUSE = %d gives string: %s",
                          sqlite.MISUSE, sqlite.error_string(sqlite.MISUSE)))
print(string.format("sqlite.ROW = %d gives string: %s",
                          sqlite.ROW, sqlite.error_string(sqlite.ROW)))
print(string.format("sqlite.DONE = %d gives string: %s",
                          sqlite.DONE, sqlite.error_string(sqlite.DONE)))

print"=============================="

-- open database

dbname=os.date"%Y%b%d%H%M%S.db"
print("Opening: ", dbname)
db,msg=sqlite.open(dbname)
if (db==nil)
then do print ("Error on db open: ", msg) break end
end

sql="create table bar(a integer primary key, b integer, c text)"
err,len=sqlite.compile(db,sql)
if (err ~= sqlite.OK)
then do print("Error, compile create returned: ", sqlite.error_string(err))
           break
	end
end

if (len ~= string.len(sql))
then print("Error, compile create length: ", len, "~=", string.len(sql))
end

err=sqlite.step(db)
if (err ~= sqlite.DONE )
then print("Error, not DONE but: ", err, sqlite.error_string(err))
end

err=sqlite.finalize(db)
if (err ~= sqlite.OK )
then print("Error, not OK but: ", err, sqlite.error_string(err))
end

local function onestep (db,sql)
  local err,len = sqlite.compile(db,sql)
  if (err ~= sqlite.OK )
  then print("exec error ~OK ", err, sqlite.error_string(err))
  else
    if (len ~= string.len(sql))
    then print("exec warning, length: ", len, "~=", string.len(sql))
    end
    err=sqlite.step(db)
    if (err ~= sqlite.DONE )
    then print("exec error ~DONE ", err, sqlite.error_string(err))
    else
      err=sqlite.finalize(db)
      if (err ~= sqlite.OK )
      then print("exec final error ~OK ", err, sqlite.error_string(err))
      end
    end
  end
end

--onestep(db,"PRAGMA SHOW_DATATYPES=ON;")
err,msg=sqlite.exec(db,"PRAGMA SHOW_DATATYPES=ON;")
if (err ~= sqlite.OK )
then print("Error, exec pragma not OK but: ", err, " and ", msg)
end

onestep(db,"create table baz(x integer primary key, y integer, z text)")

print(string.format("Changes: %d", sqlite.changes(db)))

onestep(db,"insert into bar values(1,2,3)")

print(string.format("Changes: %d", sqlite.changes(db)))
print(string.format("Last RID: %d", sqlite.last_insert_rowid(db)))

onestep(db,"insert into bar values(5,7,9)")

print(string.format("Changes: %d", sqlite.changes(db)))
print(string.format("Last RID: %d", sqlite.last_insert_rowid(db)))

sql="select * from bar"
err,len=sqlite.compile(db,sql)
if (err ~= sqlite.OK)
then do print("Error, compile select returned: ", sqlite.error_string(err))
           break
	end
end

if (len ~= string.len(sql))
then print("Error, compile select length: ", len, "~=", string.len(sql))
end

for i = 1 , 2 do
err=sqlite.step(db)
if (err ~= sqlite.ROW )
then print("Error, not ROW but: ", err, sqlite.error_string(err))
else
  print"----------- data ------------"
  local row=sqlite.row_data(db)
  for n,v in pairs(row) do print(string.format("%s %s", n, v)) end
  print"----------- type ------------"
  local typ=sqlite.row_type(db)
  for n,v in pairs(typ) do print(string.format("%s %s", n, v)) end
  print"---------- idata ------------"
  local irow=sqlite.row_idata(db)
  for n,v in ipairs(irow) do print(string.format("%d %s", n, v)) end
  print"---------- iname ------------"
  local inam=sqlite.row_iname(db)
  for n,v in ipairs(inam) do print(string.format("%d %s", n, v)) end
  print"---------- itype ------------"
  local ityp=sqlite.row_itype(db)
  for n,v in ipairs(ityp) do print(string.format("%d %s", n, v)) end
end
end -- for
err=sqlite.step(db)
if (err ~= sqlite.DONE )
then print("Error, not DONE but: ", err, sqlite.error_string(err))
end
err=sqlite.finalize(db)
if (err ~= sqlite.OK)
then print("Error, select finalize returned: ", sqlite.error_string(err))
end
print"-----------------------------"

local function allrows(db,sql)
  local err,len = sqlite.compile(db,sql)
  if (err ~= sqlite.OK )
  then print("allrows error ~OK ", err, sqlite.error_string(err))
  else
    if (len ~= string.len(sql))
    then print("allrows warning, length: ", len, "~=", string.len(sql))
    end
    repeat
      err=sqlite.step(db)
      if (err == sqlite.ROW)
      then
        local row=sqlite.row_data(db)
        for n,v in pairs(row) do print(string.format("%s %s", n, v)) end
	print"-----"
      end
    until (err ~= sqlite.ROW)
    if (err ~= sqlite.DONE )
    then  if( err == sqlite.OK )
	    then print("allrows Sqlite 2.8.0 annoyance: OK returned instead of DONE")
	    else print("allrows error ~DONE ", err, sqlite.error_string(err))
	    end
    end
    err=sqlite.finalize(db)
    if (err ~= sqlite.OK )
    then print("allrows final error ~OK ", err, sqlite.error_string(err))
    end
  end
end

allrows(db,"select * from bar")
allrows(db,"explain select * from bar")

print"====="
sqlite.compile(db,"explain select * from bar")
sqlite.step(db)
local ityp=sqlite.row_itype(db)
for n,v in ipairs(ityp) do print(string.format("%d %s", n, v)) end
sqlite.finalize(db)
print"====="

-- err,len=sqlite.compile(db,"begin")
-- err,len=sqlite.compile(db,"rollback")
-- err,len=sqlite.compile(db,"commit")

print(string.format("Changes: %d", sqlite.changes(db)))

sqlite.busy_timeout(db,100) -- no result, hard to test; at least it can be called
sqlite.interrupt(db) -- no result, hard to test; at least it can be called

print("Closing: ", dbname)
sqlite.close(db)
print("Testing complete, no major errors encountered.")
--print("Deleting: ", dbname)
--os.remove(dbname)
print(string.format("You may want to: os.remove(\"%s\")", dbname))

until true -- module
print"=============================="

