/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <string.h>

#include "xen_internal.h"
#include <xen/api/xen_vm_operations.h>
#include "xen_vm_operations_internal.h"


/*
 * Maintain this in the same order as the enum declaration!
 */
static const char *lookup_table[] =
{
    "snapshot",
    "clone",
    "copy",
    "create_template",
    "revert",
    "checkpoint",
    "snapshot_with_quiesce",
    "provision",
    "start",
    "start_on",
    "pause",
    "unpause",
    "clean_shutdown",
    "clean_reboot",
    "hard_shutdown",
    "power_state_reset",
    "hard_reboot",
    "suspend",
    "csvm",
    "resume",
    "resume_on",
    "pool_migrate",
    "migrate",
    "get_boot_record",
    "send_sysrq",
    "send_trigger",
    "changing_memory_live",
    "awaiting_memory_live",
    "changing_dynamic_range",
    "changing_static_range",
    "changing_memory_limits",
    "get_cooperative",
    "changing_shadow_memory",
    "changing_shadow_memory_live",
    "changing_VCPUs",
    "changing_VCPUs_live",
    "assert_operation_valid",
    "data_source_op",
    "update_allowed_operations",
    "make_into_template",
    "import",
    "export",
    "metadata_export",
    "reverting",
    "destroy",
    "undefined"
};


extern xen_vm_operations_set *
xen_vm_operations_set_alloc(size_t size)
{
    return calloc(1, sizeof(xen_vm_operations_set) +
                  size * sizeof(enum xen_vm_operations));
}


extern void
xen_vm_operations_set_free(xen_vm_operations_set *set)
{
    free(set);
}


const char *
xen_vm_operations_to_string(enum xen_vm_operations val)
{
    return lookup_table[val];
}


extern enum xen_vm_operations
xen_vm_operations_from_string(xen_session *session, const char *str)
{
    (void)session;
    return ENUM_LOOKUP(str, lookup_table);
}


const abstract_type xen_vm_operations_abstract_type_ =
    {
        .typename = ENUM,
        .enum_marshaller =
             (const char *(*)(int))&xen_vm_operations_to_string,
        .enum_demarshaller =
             (int (*)(xen_session *, const char *))&xen_vm_operations_from_string
    };


const abstract_type xen_vm_operations_set_abstract_type_ =
    {
        .typename = SET,
        .child = &xen_vm_operations_abstract_type_
    };


