/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#include <stddef.h>
#include <stdlib.h>

#include "xen_internal.h"
#include <xen/api/xen_auth.h>
#include <xen/api/xen_common.h>
#include <xen/api/xen_string_string_map.h>


XEN_FREE(xen_auth)
XEN_SET_ALLOC_FREE(xen_auth)
XEN_ALLOC(xen_auth_record)
XEN_SET_ALLOC_FREE(xen_auth_record)
XEN_ALLOC(xen_auth_record_opt)
XEN_RECORD_OPT_FREE(xen_auth)
XEN_SET_ALLOC_FREE(xen_auth_record_opt)


static const struct_member xen_auth_record_struct_members[] =
    {
        
    };

const abstract_type xen_auth_record_abstract_type_ =
    {
       .typename = STRUCT,
       .struct_size = sizeof(xen_auth_record),
       .member_count =
           sizeof(xen_auth_record_struct_members) / sizeof(struct_member),
       .members = xen_auth_record_struct_members
    };


void
xen_auth_record_free(xen_auth_record *record)
{
    if (record == NULL)
    {
        return;
    }
    free(record->handle);
    
    free(record);
}


bool
xen_auth_get_subject_identifier(xen_session *session, char **result, char *subject_name)
{
    abstract_value param_values[] =
        {
            { .type = &abstract_type_string,
              .u.string_val = subject_name }
        };

    abstract_type result_type = abstract_type_string;

    *result = NULL;
    XEN_CALL_("auth.get_subject_identifier");
    return session->ok;
}


bool
xen_auth_get_subject_information_from_identifier(xen_session *session, xen_string_string_map **result, char *subject_identifier)
{
    abstract_value param_values[] =
        {
            { .type = &abstract_type_string,
              .u.string_val = subject_identifier }
        };

    abstract_type result_type = abstract_type_string_string_map;

    *result = NULL;
    XEN_CALL_("auth.get_subject_information_from_identifier");
    return session->ok;
}


bool
xen_auth_get_group_membership(xen_session *session, struct xen_string_set **result, char *subject_identifier)
{
    abstract_value param_values[] =
        {
            { .type = &abstract_type_string,
              .u.string_val = subject_identifier }
        };

    abstract_type result_type = abstract_type_string_set;

    *result = NULL;
    XEN_CALL_("auth.get_group_membership");
    return session->ok;
}
