/*
 * Copyright (c) 2006-2010 Citrix Systems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef XEN_VDI_OPERATIONS_H
#define XEN_VDI_OPERATIONS_H


#include <xen/api/xen_common.h>


enum xen_vdi_operations
{
    /**
     * Scanning backends for new or deleted VDIs
     */
    XEN_VDI_OPERATIONS_SCAN,

    /**
     * Cloning the VDI
     */
    XEN_VDI_OPERATIONS_CLONE,

    /**
     * Copying the VDI
     */
    XEN_VDI_OPERATIONS_COPY,

    /**
     * Resizing the VDI
     */
    XEN_VDI_OPERATIONS_RESIZE,

    /**
     * Resizing the VDI which may or may not be online
     */
    XEN_VDI_OPERATIONS_RESIZE_ONLINE,

    /**
     * Snapshotting the VDI
     */
    XEN_VDI_OPERATIONS_SNAPSHOT,

    /**
     * Destroying the VDI
     */
    XEN_VDI_OPERATIONS_DESTROY,

    /**
     * Forget about the VDI
     */
    XEN_VDI_OPERATIONS_FORGET,

    /**
     * Refreshing the fields of the VDI
     */
    XEN_VDI_OPERATIONS_UPDATE,

    /**
     * Forcibly unlocking the VDI
     */
    XEN_VDI_OPERATIONS_FORCE_UNLOCK,

    /**
     * Generating static configuration
     */
    XEN_VDI_OPERATIONS_GENERATE_CONFIG,

    /**
     * Operations on this VDI are temporarily blocked
     */
    XEN_VDI_OPERATIONS_BLOCKED,

    /**
     * Unknown to this version of the bindings.
     */
    XEN_VDI_OPERATIONS_UNDEFINED
};


typedef struct xen_vdi_operations_set
{
    size_t size;
    enum xen_vdi_operations contents[];
} xen_vdi_operations_set;

/**
 * Allocate a xen_vdi_operations_set of the given size.
 */
extern xen_vdi_operations_set *
xen_vdi_operations_set_alloc(size_t size);

/**
 * Free the given xen_vdi_operations_set.  The given set must have been
 * allocated by this library.
 */
extern void
xen_vdi_operations_set_free(xen_vdi_operations_set *set);


/**
 * Return the name corresponding to the given code.  This string must
 * not be modified or freed.
 */
extern const char *
xen_vdi_operations_to_string(enum xen_vdi_operations val);


/**
 * Return the correct code for the given string, or set the session
 * object to failure and return an undefined value if the given string does
 * not match a known code.
 */
extern enum xen_vdi_operations
xen_vdi_operations_from_string(xen_session *session, const char *str);


#endif
