/* * 
 *  $Id:check_status.c 267 2006-01-12 17:19:45Z shawill $
 *  
 *  This file is part of NeMeSI
 *
 *  NeMeSI -- NEtwork MEdia Streamer I
 *
 *  Copyright (C) 2001 by
 *  	
 *  	Giampaolo "mancho" Mancini - manchoz@inwind.it
 *	Francesco "shawill" Varano - shawill@infinto.it
 *
 *  NeMeSI is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  NeMeSI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with NeMeSI; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  
 * */

#include <nemesi/rtsp.h>
#include <nemesi/methods.h>
#include <nemesi/utils.h>

/*!
 * \brief scan status code of an RTSP reply
 *
 * \param status_line the status line in the reply
 * \return reply status code or -1 on error
 */
int check_status(char *status_line, rtsp_thread * rtsp_th)
{
	char ver[32];
	unsigned short res_state;
	char *reason_phrase;
	char *location = NULL;
	// string tokenizers
	char *tkn, *prev_tkn;

	if (sscanf(status_line, "%s %hu ", ver, &res_state) < 2) {
		nms_printf(NMSML_ERR,
			   "invalid Status-Line in DESCRIBE Response\n");
		return -1;
	}
	reason_phrase = strchr(strchr(status_line, ' ') + 1, ' ') + 1;

	if (RTSP_IS_SUCCESS(res_state))
		return res_state;
	else if (RTSP_IS_REDIRECT(res_state)) { // (res_state>=300) && (res_state<400)
		nms_printf(NMSML_NORM,
			   "WARNING: Redirection. reply was: %hu %s\n",
			   res_state, reason_phrase);
		switch (res_state) {
		case RTSP_FOUND:
			if ((prev_tkn =
			     strtok((rtsp_th->in_buffer).data +
				    strlen(status_line) + 1, "\n")) == NULL) {
				nms_printf(NMSML_ERR,
					   "Could not find \"Location\" so... were I'll redirect you?\n");
				return -1;
			}
			while (((tkn = strtok(NULL, "\n")) != NULL)
			       && ((tkn - prev_tkn) > 1)) {
				if (((tkn - prev_tkn) == 2)
				    && (*prev_tkn == '\r'))
					break;
				if (!strncmpcase(prev_tkn, "Location", 8)) {
					prev_tkn += 8;
					while ((*(prev_tkn) == ' ')
					       || (*(prev_tkn) == ':'))
						prev_tkn++;
					location = strdup(prev_tkn);
					// sscanf(prev_tkn,"%d",&location);
				}
				prev_tkn = tkn;
			}
			if (location) {
				nms_printf(NMSML_NORM, "Redirecting to %s\n",
					   location);
				// XXX:proving
				pthread_mutex_lock(&(rtsp_th->comm_mutex));
				rtsp_th->comm->opcode = OPEN;
				write(rtsp_th->pipefd[1], "o", 1);
				strncpy(rtsp_th->comm->arg, location,
					sizeof(rtsp_th->comm->arg));
				pthread_mutex_unlock(&(rtsp_th->comm_mutex));
				///// XXX: end proving
			} else
				return -nms_printf(NMSML_ERR,
						   "No location string\n");
			// rtsp_th->status=INIT;
		}
	} else if (RTSP_IS_CLIENT_ERROR(res_state)) // (res_state>=400) && (res_state<500)
		nms_printf(NMSML_ERR, "Client error. Reply was: %hu %s\n",
			   res_state, reason_phrase);
	else if (RTSP_IS_SERVER_ERROR(res_state)) // res_state>=500
		nms_printf(NMSML_ERR, "Server error. Reply was: %hu %s\n",
			   res_state, reason_phrase);
	return -1;
}
