

ir_node *new_rd_Abs(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_op;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Abs, mode, 1, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Abs(ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_Abs(NULL, irg, block, irn_op, mode);
}

ir_node *new_d_Abs(dbg_info *db, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Abs(db, current_ir_graph, current_ir_graph->current_block, irn_op, mode);
	
	return res;
}

ir_node *new_Abs(ir_node * irn_op, ir_mode * mode)
{
	return new_d_Abs(NULL, irn_op, mode);
}

ir_node *new_rd_Add(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Add, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Add(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Add(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Add(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Add(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Add(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Add(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Alloc(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_mem;
	in[1] = irn_size;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Alloc, mode_T, 2, in);
	res->attr.alloc.type = type;
		
	res->attr.alloc.where = where;
		
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Alloc(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	return new_rd_Alloc(NULL, irg, block, irn_mem, irn_size, type, where);
}

ir_node *new_d_Alloc(dbg_info *db, ir_node * irn_mem, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	ir_node *res;
	
	res = new_rd_Alloc(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_size, type, where);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Alloc, &res->attr.alloc.exc.frag_arr);
	#endif
	
	return res;
}

ir_node *new_Alloc(ir_node * irn_mem, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	return new_d_Alloc(NULL, irn_mem, irn_size, type, where);
}

ir_node *new_rd_And(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_And, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_And(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_And(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_And(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_And(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_And(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_And(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Block(dbg_info *db, ir_graph *irg, int arity, ir_node ** in)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, NULL, op_Block, mode_BB, arity, in);
	
	/* macroblock header */
	res->in[0] = res;

	res->attr.block.is_dead     = 0;
	res->attr.block.is_mb_head  = 1;
	res->attr.block.has_label   = 0;
	res->attr.block.irg         = irg;
	res->attr.block.backedge    = new_backedge_arr(irg->obst, arity);
	res->attr.block.in_cg       = NULL;
	res->attr.block.cg_backedge = NULL;
	res->attr.block.extblk      = NULL;
	res->attr.block.mb_depth    = 0;
	res->attr.block.label       = 0;

	set_Block_matured(res, 1);
	set_Block_block_visited(res, 0);	
	
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Block(ir_graph *irg, int arity, ir_node ** in)
{
	return new_rd_Block(NULL, irg, arity, in);
}

ir_node *new_d_Block(dbg_info *db, int arity, ir_node ** in)
{
	ir_node *res;
	
	int i;
	int has_unknown = 0;
	
	res = new_rd_Block(db, current_ir_graph, arity, in);
	
	/* Create and initialize array for Phi-node construction. */
	if (get_irg_phase_state(current_ir_graph) == phase_building) {
		res->attr.block.graph_arr = NEW_ARR_D(ir_node *, current_ir_graph->obst,
		                                      current_ir_graph->n_loc);
		memset(res->attr.block.graph_arr, 0, sizeof(ir_node *)*current_ir_graph->n_loc);
	}

	for (i = arity - 1; i >= 0; i--)
		if (is_Unknown(in[i])) {
			has_unknown = 1;
			break;
		}

	if (!has_unknown) res = optimize_node(res);

	current_ir_graph->current_block = res;

	IRN_VRFY_IRG(res, current_ir_graph);
	
	return res;
}

ir_node *new_Block(int arity, ir_node ** in)
{
	return new_d_Block(NULL, arity, in);
}

ir_node *new_rd_Borrow(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Borrow, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Borrow(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Borrow(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Borrow(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Borrow(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Borrow(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Borrow(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Bound(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[4];
	in[0] = irn_mem;
	in[1] = irn_index;
	in[2] = irn_lower;
	in[3] = irn_upper;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Bound, mode_T, 4, in);
	res->attr.bound.exc.pin_state = op_pin_state_pinned;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Bound(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	return new_rd_Bound(NULL, irg, block, irn_mem, irn_index, irn_lower, irn_upper);
}

ir_node *new_d_Bound(dbg_info *db, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	ir_node *res;
	
	res = new_rd_Bound(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_index, irn_lower, irn_upper);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Bound, &res->attr.bound.exc.frag_arr);
	#endif
	
	return res;
}

ir_node *new_Bound(ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper)
{
	return new_d_Bound(NULL, irn_mem, irn_index, irn_lower, irn_upper);
}

ir_node *new_rd_Break(dbg_info *db, ir_graph *irg, ir_node *block)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Break, mode_X, 0, NULL);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Break(ir_graph *irg, ir_node *block)
{
	return new_rd_Break(NULL, irg, block);
}

ir_node *new_d_Break(dbg_info *db)
{
	ir_node *res;
	
	res = new_rd_Break(db, current_ir_graph, current_ir_graph->current_block);
	
	return res;
}

ir_node *new_Break(void)
{
	return new_d_Break(NULL);
}

ir_node *new_rd_Builtin(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, int arity, ir_node ** in, ir_builtin_kind kind, ir_type* type)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	int r_arity = arity + 1;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	memcpy(&r_in[1], in, sizeof(ir_node *) * arity);
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Builtin, mode_T, r_arity, r_in);
	res->attr.builtin.kind = kind;
		
	res->attr.builtin.type = type;
		
	res->attr.builtin.exc.pin_state = op_pin_state_pinned;
	assert((get_unknown_type() == type) || is_Method_type(type));
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Builtin(ir_graph *irg, ir_node *block, ir_node * irn_mem, int arity, ir_node ** in, ir_builtin_kind kind, ir_type* type)
{
	return new_rd_Builtin(NULL, irg, block, irn_mem, arity, in, kind, type);
}

ir_node *new_d_Builtin(dbg_info *db, ir_node * irn_mem, int arity, ir_node ** in, ir_builtin_kind kind, ir_type* type)
{
	ir_node *res;
	
	res = new_rd_Builtin(db, current_ir_graph, current_ir_graph->current_block, irn_mem, arity, in, kind, type);
	
	return res;
}

ir_node *new_Builtin(ir_node * irn_mem, int arity, ir_node ** in, ir_builtin_kind kind, ir_type* type)
{
	return new_d_Builtin(NULL, irn_mem, arity, in, kind, type);
}

ir_node *new_rd_Call(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_type* type)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	int r_arity = arity + 2;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	r_in[1] = irn_ptr;
	memcpy(&r_in[2], in, sizeof(ir_node *) * arity);
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Call, mode_T, r_arity, r_in);
	res->attr.call.type = type;
		
	res->attr.call.exc.pin_state = op_pin_state_pinned;
	assert((get_unknown_type() == type) || is_Method_type(type));
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Call(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_type* type)
{
	return new_rd_Call(NULL, irg, block, irn_mem, irn_ptr, arity, in, type);
}

ir_node *new_d_Call(dbg_info *db, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_type* type)
{
	ir_node *res;
	
	res = new_rd_Call(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_ptr, arity, in, type);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Call, &res->attr.call.exc.frag_arr);
	#endif
	
	return res;
}

ir_node *new_Call(ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_type* type)
{
	return new_d_Call(NULL, irn_mem, irn_ptr, arity, in, type);
}

ir_node *new_rd_CallBegin(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_ptr, ir_node* call)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_ptr;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_CallBegin, mode_T, 1, in);
	res->attr.callbegin.call = call;
		
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_CallBegin(ir_graph *irg, ir_node *block, ir_node * irn_ptr, ir_node* call)
{
	return new_rd_CallBegin(NULL, irg, block, irn_ptr, call);
}

ir_node *new_d_CallBegin(dbg_info *db, ir_node * irn_ptr, ir_node* call)
{
	ir_node *res;
	
	res = new_rd_CallBegin(db, current_ir_graph, current_ir_graph->current_block, irn_ptr, call);
	
	return res;
}

ir_node *new_CallBegin(ir_node * irn_ptr, ir_node* call)
{
	return new_d_CallBegin(NULL, irn_ptr, call);
}

ir_node *new_rd_Carry(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Carry, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Carry(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Carry(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Carry(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Carry(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Carry(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Carry(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Cast(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_op, ir_type* type)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_op;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Cast, get_irn_mode(irn_op), 1, in);
	res->attr.cast.type = type;
		
	assert(is_atomic_type(type));
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Cast(ir_graph *irg, ir_node *block, ir_node * irn_op, ir_type* type)
{
	return new_rd_Cast(NULL, irg, block, irn_op, type);
}

ir_node *new_d_Cast(dbg_info *db, ir_node * irn_op, ir_type* type)
{
	ir_node *res;
	
	res = new_rd_Cast(db, current_ir_graph, current_ir_graph->current_block, irn_op, type);
	
	return res;
}

ir_node *new_Cast(ir_node * irn_op, ir_type* type)
{
	return new_d_Cast(NULL, irn_op, type);
}

ir_node *new_rd_Cmp(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Cmp, mode_T, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Cmp(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right)
{
	return new_rd_Cmp(NULL, irg, block, irn_left, irn_right);
}

ir_node *new_d_Cmp(dbg_info *db, ir_node * irn_left, ir_node * irn_right)
{
	ir_node *res;
	
	res = new_rd_Cmp(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right);
	
	return res;
}

ir_node *new_Cmp(ir_node * irn_left, ir_node * irn_right)
{
	return new_d_Cmp(NULL, irn_left, irn_right);
}

ir_node *new_rd_Cond(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_selector)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_selector;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Cond, mode_T, 1, in);
	res->attr.cond.kind = dense;
	res->attr.cond.default_proj = 0;
	res->attr.cond.jmp_pred = COND_JMP_PRED_NONE;
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Cond(ir_graph *irg, ir_node *block, ir_node * irn_selector)
{
	return new_rd_Cond(NULL, irg, block, irn_selector);
}

ir_node *new_d_Cond(dbg_info *db, ir_node * irn_selector)
{
	ir_node *res;
	
	res = new_rd_Cond(db, current_ir_graph, current_ir_graph->current_block, irn_selector);
	
	return res;
}

ir_node *new_Cond(ir_node * irn_selector)
{
	return new_d_Cond(NULL, irn_selector);
}

ir_node *new_rd_Confirm(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_value, ir_node * irn_bound, pn_Cmp cmp)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_value;
	in[1] = irn_bound;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Confirm, get_irn_mode(irn_value), 2, in);
	res->attr.confirm.cmp = cmp;
		
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Confirm(ir_graph *irg, ir_node *block, ir_node * irn_value, ir_node * irn_bound, pn_Cmp cmp)
{
	return new_rd_Confirm(NULL, irg, block, irn_value, irn_bound, cmp);
}

ir_node *new_d_Confirm(dbg_info *db, ir_node * irn_value, ir_node * irn_bound, pn_Cmp cmp)
{
	ir_node *res;
	
	res = new_rd_Confirm(db, current_ir_graph, current_ir_graph->current_block, irn_value, irn_bound, cmp);
	
	return res;
}

ir_node *new_Confirm(ir_node * irn_value, ir_node * irn_bound, pn_Cmp cmp)
{
	return new_d_Confirm(NULL, irn_value, irn_bound, cmp);
}

ir_node *new_rd_Conv(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_op;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Conv, mode, 1, in);
	res->attr.conv.strict = 0;
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Conv(ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_Conv(NULL, irg, block, irn_op, mode);
}

ir_node *new_d_Conv(dbg_info *db, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Conv(db, current_ir_graph, current_ir_graph->current_block, irn_op, mode);
	
	return res;
}

ir_node *new_Conv(ir_node * irn_op, ir_mode * mode)
{
	return new_d_Conv(NULL, irn_op, mode);
}

ir_node *new_rd_strictConv(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_op;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Conv, mode, 1, in);
	res->attr.conv.strict = 1;
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_strictConv(ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_strictConv(NULL, irg, block, irn_op, mode);
}

ir_node *new_d_strictConv(dbg_info *db, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_strictConv(db, current_ir_graph, current_ir_graph->current_block, irn_op, mode);
	
	return res;
}

ir_node *new_strictConv(ir_node * irn_op, ir_mode * mode)
{
	return new_d_strictConv(NULL, irn_op, mode);
}

ir_node *new_rd_CopyB(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_dst;
	in[2] = irn_src;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_CopyB, mode_T, 3, in);
	res->attr.copyb.type = type;
		
	res->attr.copyb.exc.pin_state = op_pin_state_pinned;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_CopyB(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	return new_rd_CopyB(NULL, irg, block, irn_mem, irn_dst, irn_src, type);
}

ir_node *new_d_CopyB(dbg_info *db, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	ir_node *res;
	
	res = new_rd_CopyB(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_dst, irn_src, type);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_CopyB, &res->attr.copyb.exc.frag_arr);
	#endif
	
	return res;
}

ir_node *new_CopyB(ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type)
{
	return new_d_CopyB(NULL, irn_mem, irn_dst, irn_src, type);
}

ir_node *new_rd_Div(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_left;
	in[2] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Div, mode_T, 3, in);
	res->attr.divmod.resmode = resmode;
		
	res->attr.divmod.no_remainder = 0;
	res->attr.divmod.exc.pin_state = pin_state;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Div(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_rd_Div(NULL, irg, block, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_d_Div(dbg_info *db, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	
	res = new_rd_Div(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_left, irn_right, resmode, pin_state);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Div, &res->attr.except.frag_arr);
	#endif
	
	return res;
}

ir_node *new_Div(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_d_Div(NULL, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_rd_DivRL(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_left;
	in[2] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Div, mode_T, 3, in);
	res->attr.divmod.resmode = resmode;
		
	res->attr.divmod.no_remainder = 1;
	res->attr.divmod.exc.pin_state = pin_state;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_DivRL(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_rd_DivRL(NULL, irg, block, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_d_DivRL(dbg_info *db, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	
	res = new_rd_DivRL(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_left, irn_right, resmode, pin_state);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Div, &res->attr.except.frag_arr);
	#endif
	
	return res;
}

ir_node *new_DivRL(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_d_DivRL(NULL, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_rd_DivMod(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_left;
	in[2] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_DivMod, mode_T, 3, in);
	res->attr.divmod.resmode = resmode;
		
	res->attr.divmod.exc.pin_state = pin_state;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_DivMod(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_rd_DivMod(NULL, irg, block, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_d_DivMod(dbg_info *db, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	
	res = new_rd_DivMod(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_left, irn_right, resmode, pin_state);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_DivMod, &res->attr.except.frag_arr);
	#endif
	
	return res;
}

ir_node *new_DivMod(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_d_DivMod(NULL, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_rd_Dummy(dbg_info *db, ir_graph *irg, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, get_irg_start_block(irg), op_Dummy, mode, 0, NULL);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Dummy(ir_graph *irg, ir_mode * mode)
{
	return new_rd_Dummy(NULL, irg, mode);
}

ir_node *new_d_Dummy(dbg_info *db, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Dummy(db, current_ir_graph, mode);
	
	return res;
}

ir_node *new_Dummy(ir_mode * mode)
{
	return new_d_Dummy(NULL, mode);
}

ir_node *new_rd_Eor(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Eor, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Eor(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Eor(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Eor(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Eor(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Eor(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Eor(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Filter(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_pred, ir_mode * mode, long proj)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_pred;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Filter, mode, 1, in);
	res->attr.filter.proj = proj;
		
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Filter(ir_graph *irg, ir_node *block, ir_node * irn_pred, ir_mode * mode, long proj)
{
	return new_rd_Filter(NULL, irg, block, irn_pred, mode, proj);
}

ir_node *new_d_Filter(dbg_info *db, ir_node * irn_pred, ir_mode * mode, long proj)
{
	ir_node *res;
	
	res = new_rd_Filter(db, current_ir_graph, current_ir_graph->current_block, irn_pred, mode, proj);
	
	return res;
}

ir_node *new_Filter(ir_node * irn_pred, ir_mode * mode, long proj)
{
	return new_d_Filter(NULL, irn_pred, mode, proj);
}

ir_node *new_rd_Free(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_ptr;
	in[2] = irn_size;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Free, mode_M, 3, in);
	res->attr.free.type = type;
		
	res->attr.free.where = where;
		
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Free(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	return new_rd_Free(NULL, irg, block, irn_mem, irn_ptr, irn_size, type, where);
}

ir_node *new_d_Free(dbg_info *db, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	ir_node *res;
	
	res = new_rd_Free(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_ptr, irn_size, type, where);
	
	return res;
}

ir_node *new_Free(ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_size, ir_type* type, ir_where_alloc where)
{
	return new_d_Free(NULL, irn_mem, irn_ptr, irn_size, type, where);
}

ir_node *new_rd_Id(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_pred, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_pred;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Id, mode, 1, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Id(ir_graph *irg, ir_node *block, ir_node * irn_pred, ir_mode * mode)
{
	return new_rd_Id(NULL, irg, block, irn_pred, mode);
}

ir_node *new_d_Id(dbg_info *db, ir_node * irn_pred, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Id(db, current_ir_graph, current_ir_graph->current_block, irn_pred, mode);
	
	return res;
}

ir_node *new_Id(ir_node * irn_pred, ir_mode * mode)
{
	return new_d_Id(NULL, irn_pred, mode);
}

ir_node *new_rd_IJmp(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_target)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_target;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_IJmp, mode_X, 1, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_IJmp(ir_graph *irg, ir_node *block, ir_node * irn_target)
{
	return new_rd_IJmp(NULL, irg, block, irn_target);
}

ir_node *new_d_IJmp(dbg_info *db, ir_node * irn_target)
{
	ir_node *res;
	
	res = new_rd_IJmp(db, current_ir_graph, current_ir_graph->current_block, irn_target);
	
	return res;
}

ir_node *new_IJmp(ir_node * irn_target)
{
	return new_d_IJmp(NULL, irn_target);
}

ir_node *new_rd_InstOf(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_store;
	in[1] = irn_obj;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_InstOf, mode_T, 2, in);
	res->attr.instof.type = type;
		
	res->attr.instof.exc.pin_state = op_pin_state_floats;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_InstOf(ir_graph *irg, ir_node *block, ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	return new_rd_InstOf(NULL, irg, block, irn_store, irn_obj, type);
}

ir_node *new_d_InstOf(dbg_info *db, ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	ir_node *res;
	
	res = new_rd_InstOf(db, current_ir_graph, current_ir_graph->current_block, irn_store, irn_obj, type);
	
	return res;
}

ir_node *new_InstOf(ir_node * irn_store, ir_node * irn_obj, ir_type* type)
{
	return new_d_InstOf(NULL, irn_store, irn_obj, type);
}

ir_node *new_rd_Jmp(dbg_info *db, ir_graph *irg, ir_node *block)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Jmp, mode_X, 0, NULL);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Jmp(ir_graph *irg, ir_node *block)
{
	return new_rd_Jmp(NULL, irg, block);
}

ir_node *new_d_Jmp(dbg_info *db)
{
	ir_node *res;
	
	res = new_rd_Jmp(db, current_ir_graph, current_ir_graph->current_block);
	
	return res;
}

ir_node *new_Jmp(void)
{
	return new_d_Jmp(NULL);
}

ir_node *new_rd_Load(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_mem;
	in[1] = irn_ptr;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Load, mode_T, 2, in);
	res->attr.load.mode = mode;
		
	res->attr.load.exc.pin_state = flags & cons_floats ? op_pin_state_floats : op_pin_state_pinned;res->attr.load.exc.pin_state = flags & cons_floats ? op_pin_state_floats : op_pin_state_pinned;res->attr.load.volatility = flags & cons_volatile ? volatility_is_volatile : volatility_non_volatile;res->attr.load.aligned = flags & cons_unaligned ? align_non_aligned : align_is_aligned;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Load(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	return new_rd_Load(NULL, irg, block, irn_mem, irn_ptr, mode, flags);
}

ir_node *new_d_Load(dbg_info *db, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	ir_node *res;
	
	res = new_rd_Load(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_ptr, mode, flags);
	
#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Load, &res->attr.load.exc.frag_arr);
#endif
	
	return res;
}

ir_node *new_Load(ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags)
{
	return new_d_Load(NULL, irn_mem, irn_ptr, mode, flags);
}

ir_node *new_rd_Minus(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_op;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Minus, mode, 1, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Minus(ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_Minus(NULL, irg, block, irn_op, mode);
}

ir_node *new_d_Minus(dbg_info *db, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Minus(db, current_ir_graph, current_ir_graph->current_block, irn_op, mode);
	
	return res;
}

ir_node *new_Minus(ir_node * irn_op, ir_mode * mode)
{
	return new_d_Minus(NULL, irn_op, mode);
}

ir_node *new_rd_Mod(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_left;
	in[2] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Mod, mode_T, 3, in);
	res->attr.divmod.resmode = resmode;
		
	res->attr.divmod.exc.pin_state = pin_state;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Mod(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_rd_Mod(NULL, irg, block, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_d_Mod(dbg_info *db, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	
	res = new_rd_Mod(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_left, irn_right, resmode, pin_state);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Mod, &res->attr.except.frag_arr);
	#endif
	
	return res;
}

ir_node *new_Mod(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_d_Mod(NULL, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_rd_Mul(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Mul, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Mul(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Mul(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Mul(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Mul(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Mul(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Mul(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Mulh(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Mulh, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Mulh(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Mulh(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Mulh(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Mulh(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Mulh(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Mulh(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Mux(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_sel;
	in[1] = irn_false;
	in[2] = irn_true;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Mux, mode, 3, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Mux(ir_graph *irg, ir_node *block, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	return new_rd_Mux(NULL, irg, block, irn_sel, irn_false, irn_true, mode);
}

ir_node *new_d_Mux(dbg_info *db, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Mux(db, current_ir_graph, current_ir_graph->current_block, irn_sel, irn_false, irn_true, mode);
	
	return res;
}

ir_node *new_Mux(ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode)
{
	return new_d_Mux(NULL, irn_sel, irn_false, irn_true, mode);
}

ir_node *new_rd_Not(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_op;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Not, mode, 1, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Not(ir_graph *irg, ir_node *block, ir_node * irn_op, ir_mode * mode)
{
	return new_rd_Not(NULL, irg, block, irn_op, mode);
}

ir_node *new_d_Not(dbg_info *db, ir_node * irn_op, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Not(db, current_ir_graph, current_ir_graph->current_block, irn_op, mode);
	
	return res;
}

ir_node *new_Not(ir_node * irn_op, ir_mode * mode)
{
	return new_d_Not(NULL, irn_op, mode);
}

ir_node *new_rd_Or(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Or, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Or(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Or(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Or(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Or(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Or(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Or(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Pin(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_op)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_op;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Pin, get_irn_mode(irn_op), 1, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Pin(ir_graph *irg, ir_node *block, ir_node * irn_op)
{
	return new_rd_Pin(NULL, irg, block, irn_op);
}

ir_node *new_d_Pin(dbg_info *db, ir_node * irn_op)
{
	ir_node *res;
	
	res = new_rd_Pin(db, current_ir_graph, current_ir_graph->current_block, irn_op);
	
	return res;
}

ir_node *new_Pin(ir_node * irn_op)
{
	return new_d_Pin(NULL, irn_op);
}

ir_node *new_rd_Proj(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_pred, ir_mode * mode, long proj)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[1];
	in[0] = irn_pred;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Proj, mode, 1, in);
	res->attr.proj = proj;
		
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Proj(ir_graph *irg, ir_node *block, ir_node * irn_pred, ir_mode * mode, long proj)
{
	return new_rd_Proj(NULL, irg, block, irn_pred, mode, proj);
}

ir_node *new_d_Proj(dbg_info *db, ir_node * irn_pred, ir_mode * mode, long proj)
{
	ir_node *res;
	
	res = new_rd_Proj(db, current_ir_graph, current_ir_graph->current_block, irn_pred, mode, proj);
	
	return res;
}

ir_node *new_Proj(ir_node * irn_pred, ir_mode * mode, long proj)
{
	return new_d_Proj(NULL, irn_pred, mode, proj);
}

ir_node *new_rd_Quot(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_left;
	in[2] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Quot, mode_T, 3, in);
	res->attr.divmod.resmode = resmode;
		
	res->attr.divmod.exc.pin_state = pin_state;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Quot(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_rd_Quot(NULL, irg, block, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_d_Quot(dbg_info *db, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	ir_node *res;
	
	res = new_rd_Quot(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_left, irn_right, resmode, pin_state);
	
	#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Quot, &res->attr.except.frag_arr);
	#endif
	
	return res;
}

ir_node *new_Quot(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state)
{
	return new_d_Quot(NULL, irn_mem, irn_left, irn_right, resmode, pin_state);
}

ir_node *new_rd_Raise(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_mem;
	in[1] = irn_exo_ptr;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Raise, mode_T, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Raise(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	return new_rd_Raise(NULL, irg, block, irn_mem, irn_exo_ptr);
}

ir_node *new_d_Raise(dbg_info *db, ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	ir_node *res;
	
	res = new_rd_Raise(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_exo_ptr);
	
	return res;
}

ir_node *new_Raise(ir_node * irn_mem, ir_node * irn_exo_ptr)
{
	return new_d_Raise(NULL, irn_mem, irn_exo_ptr);
}

ir_node *new_rd_Return(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, int arity, ir_node ** in)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	int r_arity = arity + 1;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	memcpy(&r_in[1], in, sizeof(ir_node *) * arity);
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Return, mode_X, r_arity, r_in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Return(ir_graph *irg, ir_node *block, ir_node * irn_mem, int arity, ir_node ** in)
{
	return new_rd_Return(NULL, irg, block, irn_mem, arity, in);
}

ir_node *new_d_Return(dbg_info *db, ir_node * irn_mem, int arity, ir_node ** in)
{
	ir_node *res;
	
	res = new_rd_Return(db, current_ir_graph, current_ir_graph->current_block, irn_mem, arity, in);
	
	return res;
}

ir_node *new_Return(ir_node * irn_mem, int arity, ir_node ** in)
{
	return new_d_Return(NULL, irn_mem, arity, in);
}

ir_node *new_rd_Rotl(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Rotl, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Rotl(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Rotl(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Rotl(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Rotl(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Rotl(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Rotl(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Sel(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_entity* entity)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	int r_arity = arity + 2;
	ir_node **r_in;
	NEW_ARR_A(ir_node *, r_in, r_arity);
	r_in[0] = irn_mem;
	r_in[1] = irn_ptr;
	memcpy(&r_in[2], in, sizeof(ir_node *) * arity);
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Sel, is_Method_type(get_entity_type(entity)) ? mode_P_code : mode_P_data, r_arity, r_in);
	res->attr.sel.entity = entity;
		
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Sel(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_entity* entity)
{
	return new_rd_Sel(NULL, irg, block, irn_mem, irn_ptr, arity, in, entity);
}

ir_node *new_d_Sel(dbg_info *db, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_entity* entity)
{
	ir_node *res;
	
	res = new_rd_Sel(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_ptr, arity, in, entity);
	
	return res;
}

ir_node *new_Sel(ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node ** in, ir_entity* entity)
{
	return new_d_Sel(NULL, irn_mem, irn_ptr, arity, in, entity);
}

ir_node *new_rd_Shl(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Shl, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Shl(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Shl(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Shl(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Shl(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Shl(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Shl(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Shr(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Shr, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Shr(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Shr(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Shr(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Shr(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Shr(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Shr(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Shrs(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Shrs, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Shrs(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Shrs(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Shrs(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Shrs(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Shrs(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Shrs(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Store(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[3];
	in[0] = irn_mem;
	in[1] = irn_ptr;
	in[2] = irn_value;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Store, mode_T, 3, in);
	res->attr.store.exc.pin_state = flags & cons_floats ? op_pin_state_floats : op_pin_state_pinned;res->attr.store.exc.pin_state = flags & cons_floats ? op_pin_state_floats : op_pin_state_pinned;res->attr.store.volatility = flags & cons_volatile ? volatility_is_volatile : volatility_non_volatile;res->attr.store.aligned = flags & cons_unaligned ? align_non_aligned : align_is_aligned;
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Store(ir_graph *irg, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	return new_rd_Store(NULL, irg, block, irn_mem, irn_ptr, irn_value, flags);
}

ir_node *new_d_Store(dbg_info *db, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	ir_node *res;
	
	res = new_rd_Store(db, current_ir_graph, current_ir_graph->current_block, irn_mem, irn_ptr, irn_value, flags);
	
#if PRECISE_EXC_CONTEXT
	firm_alloc_frag_arr(res, op_Store, &res->attr.store.exc.frag_arr);
#endif
	
	return res;
}

ir_node *new_Store(ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags)
{
	return new_d_Store(NULL, irn_mem, irn_ptr, irn_value, flags);
}

ir_node *new_rd_Sub(dbg_info *db, ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	ir_node *in[2];
	in[0] = irn_left;
	in[1] = irn_right;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Sub, mode, 2, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Sub(ir_graph *irg, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_rd_Sub(NULL, irg, block, irn_left, irn_right, mode);
}

ir_node *new_d_Sub(dbg_info *db, ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Sub(db, current_ir_graph, current_ir_graph->current_block, irn_left, irn_right, mode);
	
	return res;
}

ir_node *new_Sub(ir_node * irn_left, ir_node * irn_right, ir_mode * mode)
{
	return new_d_Sub(NULL, irn_left, irn_right, mode);
}

ir_node *new_rd_Tuple(dbg_info *db, ir_graph *irg, ir_node *block, int arity, ir_node ** in)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, block, op_Tuple, mode_T, arity, in);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Tuple(ir_graph *irg, ir_node *block, int arity, ir_node ** in)
{
	return new_rd_Tuple(NULL, irg, block, arity, in);
}

ir_node *new_d_Tuple(dbg_info *db, int arity, ir_node ** in)
{
	ir_node *res;
	
	res = new_rd_Tuple(db, current_ir_graph, current_ir_graph->current_block, arity, in);
	
	return res;
}

ir_node *new_Tuple(int arity, ir_node ** in)
{
	return new_d_Tuple(NULL, arity, in);
}

ir_node *new_rd_Unknown(dbg_info *db, ir_graph *irg, ir_mode * mode)
{
	ir_node *res;
	ir_graph *rem = current_ir_graph;
	
	current_ir_graph = irg;
	res = new_ir_node(db, irg, get_irg_start_block(irg), op_Unknown, mode, 0, NULL);
	
	res = optimize_node(res);
	IRN_VRFY_IRG(res, irg);
	current_ir_graph = rem;
	return res;
}

ir_node *new_r_Unknown(ir_graph *irg, ir_mode * mode)
{
	return new_rd_Unknown(NULL, irg, mode);
}

ir_node *new_d_Unknown(dbg_info *db, ir_mode * mode)
{
	ir_node *res;
	
	res = new_rd_Unknown(db, current_ir_graph, mode);
	
	return res;
}

ir_node *new_Unknown(ir_mode * mode)
{
	return new_d_Unknown(NULL, mode);
}
