/**
 * @file
 * @brief Contains additional external requirements defs for external includes.
 * @note   DO NOT EDIT THIS FILE, your changes will be lost.
 *         Edit libfirm/ir/be/ppc32/ppc32_spec.pl instead.
 *         created by: libfirm/ir/be/scripts/generate_regalloc_if.pl libfirm/ir/be/ppc32/ppc32_spec.pl libfirm/ir/be/ppc32
 * @date   Tue Jan 20 10:57:59 2009
 */
#ifndef FIRM_BE_PPC32_GEN_PPC32_REGALLOC_IF_H
#define FIRM_BE_PPC32_GEN_PPC32_REGALLOC_IF_H

#include "../bearch.h"
#include "ppc32_nodes_attr.h"

enum reg_ppc32_link_indices {
	REG_LR,
	N_ppc32_link_REGS = 1
};

enum reg_ppc32_count_indices {
	REG_CTR,
	N_ppc32_count_REGS = 1
};

enum reg_ppc32_gp_indices {
	REG_R0,
	REG_R2,
	REG_R3,
	REG_R4,
	REG_R5,
	REG_R6,
	REG_R7,
	REG_R8,
	REG_R9,
	REG_R10,
	REG_R13,
	REG_R14,
	REG_R15,
	REG_R31,
	REG_R1,
	N_ppc32_gp_REGS = 15
};

enum reg_ppc32_fp_indices {
	REG_F1,
	REG_F2,
	REG_F3,
	REG_F4,
	REG_F5,
	REG_F6,
	REG_F7,
	REG_F8,
	REG_F9,
	REG_F10,
	REG_F11,
	REG_F12,
	REG_F13,
	REG_F14,
	REG_F15,
	REG_F16,
	N_ppc32_fp_REGS = 16
};

enum reg_ppc32_condition_indices {
	REG_CR0,
	REG_CR1,
	REG_CR2,
	REG_CR3,
	REG_CR4,
	REG_CR5,
	REG_CR6,
	N_ppc32_condition_REGS = 7
};


enum reg_classes {
	CLASS_ppc32_link = 0,
	CLASS_ppc32_count = 1,
	CLASS_ppc32_gp = 2,
	CLASS_ppc32_fp = 3,
	CLASS_ppc32_condition = 4,
	N_CLASSES = 5
};


extern const arch_register_t ppc32_link_regs[N_ppc32_link_REGS];
extern const arch_register_t ppc32_count_regs[N_ppc32_count_REGS];
extern const arch_register_t ppc32_gp_regs[N_ppc32_gp_REGS];
extern const arch_register_t ppc32_fp_regs[N_ppc32_fp_REGS];
extern const arch_register_t ppc32_condition_regs[N_ppc32_condition_REGS];

extern arch_register_class_t ppc32_reg_classes[N_CLASSES];

void ppc32_register_init(void);



#endif
