/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit libfirm/ir/be/ppc32/ppc32_spec.pl instead.
 *            created by: libfirm/ir/be/scripts/generate_emitter.pl libfirm/ir/be/ppc32/ppc32_spec.pl libfirm/ir/be/ppc32
 * @date      Tue Jan 20 10:57:59 2009
 */
#include "config.h"

#include <stdio.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"

#include "gen_ppc32_emitter.h"
#include "ppc32_new_nodes.h"
#include "ppc32_emitter.h"

static void emit_ppc32_fMul(const ir_node *node) {
	be_emit_cstring("\tfmul ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fDivs(const ir_node *node) {
	be_emit_cstring("\tfdivs ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fSubs(const ir_node *node) {
	be_emit_cstring("\tfsubs ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Addis_zero(const ir_node *node) {
	be_emit_cstring("\taddis ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", 0, ");
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Cmpli(const ir_node *node) {
	be_emit_cstring("\tcmpli ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", 0, ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Cmp(const ir_node *node) {
	be_emit_cstring("\tcmp ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", 0, ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Sraw(const ir_node *node) {
	be_emit_cstring("\tsraw ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Slw(const ir_node *node) {
	be_emit_cstring("\tslw ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Lfd(const ir_node *node) {
	be_emit_cstring("\tlfd ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Addi(const ir_node *node) {
	be_emit_cstring("\taddi    ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_cUnknown(const ir_node *node) {
	be_emit_cstring("\t\t\t /* use ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(" as uninitialized value */");
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Stb(const ir_node *node) {
	be_emit_cstring("\tstb ");
	ppc32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Mullw(const ir_node *node) {
	be_emit_cstring("\tmullw   ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Lfs(const ir_node *node) {
	be_emit_cstring("\tlfs ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Sth(const ir_node *node) {
	be_emit_cstring("\tsth ");
	ppc32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fDiv(const ir_node *node) {
	be_emit_cstring("\tfdiv ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Divw(const ir_node *node) {
	be_emit_cstring("\tdivw ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Rlwnm(const ir_node *node) {
	be_emit_cstring("\trlwnm ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Sub(const ir_node *node) {
	be_emit_cstring("\tsub ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fCmpu(const ir_node *node) {
	be_emit_cstring("\tfcmpu ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Srawi(const ir_node *node) {
	be_emit_cstring("\tsraw ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Cmpi(const ir_node *node) {
	be_emit_cstring("\tcmpi ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", 0, ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Lhz(const ir_node *node) {
	be_emit_cstring("\tlhz ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Stw(const ir_node *node) {
	be_emit_cstring("\tstw ");
	ppc32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Cmpl(const ir_node *node) {
	be_emit_cstring("\tcmpl ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", 0, ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fMinus(const ir_node *node) {
	be_emit_cstring("\tfneg ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fMax(const ir_node *node) {
	be_emit_cstring("\tfmax ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ppc32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Lwz(const ir_node *node) {
	be_emit_cstring("\tlwz ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Stfs(const ir_node *node) {
	be_emit_cstring("\tstfs ");
	ppc32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Andi_dot(const ir_node *node) {
	be_emit_cstring("\tandi. ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_char(',');
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fSub(const ir_node *node) {
	be_emit_cstring("\tfsub ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Lha(const ir_node *node) {
	be_emit_cstring("\tlha ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fAdds(const ir_node *node) {
	be_emit_cstring("\tfadds ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Lbz(const ir_node *node) {
	be_emit_cstring("\tlbz ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Xor(const ir_node *node) {
	be_emit_cstring("\txor     ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Or(const ir_node *node) {
	be_emit_cstring("\tor      ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Rlwinm(const ir_node *node) {
	be_emit_cstring("\trlwinm ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_rlwimi_helper(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fAdd(const ir_node *node) {
	be_emit_cstring("\tfadd ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Lwzu(const ir_node *node) {
	be_emit_cstring("\tlwzu ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Add(const ir_node *node) {
	be_emit_cstring("\tadd     ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Mulhwu(const ir_node *node) {
	be_emit_cstring("\tmulhwu  ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Addi_zero(const ir_node *node) {
	be_emit_cstring("\taddi    ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", 0, ");
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fMin(const ir_node *node) {
	be_emit_cstring("\tfmin ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ppc32_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Unknown(const ir_node *node) {
	be_emit_cstring("\t\t\t /* use ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(" as uninitialized value */");
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Ori(const ir_node *node) {
	be_emit_cstring("\tori ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fMuls(const ir_node *node) {
	be_emit_cstring("\tfmuls ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fAbs(const ir_node *node) {
	be_emit_cstring("\tfabs ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Extsh(const ir_node *node) {
	be_emit_cstring("\textsh ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Extsb(const ir_node *node) {
	be_emit_cstring("\textsb ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fRsp(const ir_node *node) {
	be_emit_cstring("\tfrsp ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Srw(const ir_node *node) {
	be_emit_cstring("\tsrw     ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Neg(const ir_node *node) {
	be_emit_cstring("\tneg ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fCtiw(const ir_node *node) {
	be_emit_cstring("\tfctiw ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Divwu(const ir_node *node) {
	be_emit_cstring("\tdivwu ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fNeg(const ir_node *node) {
	be_emit_cstring("\tfneg ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Not(const ir_node *node) {
	be_emit_cstring("\tnor ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Mtctr(const ir_node *node) {
	be_emit_cstring("\tmtctr ");
	ppc32_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_fUnknown(const ir_node *node) {
	be_emit_cstring("\t\t\t /* use ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(" as uninitialized value */");
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_And(const ir_node *node) {
	be_emit_cstring("\tand     ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Mulhw(const ir_node *node) {
	be_emit_cstring("\tmulhw   ");
	ppc32_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 0);
	be_emit_cstring(", ");
	ppc32_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_ppc32_Stfd(const ir_node *node) {
	be_emit_cstring("\tstfd ");
	ppc32_emit_source_register(node, 1);
	be_emit_cstring(", ");
	ppc32_emit_offset(node);
	be_emit_char('(');
	ppc32_emit_source_register(node, 0);
	be_emit_char(')');
	be_emit_finish_line_gas(node);
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void ppc32_register_spec_emitters(void) {

#define BE_EMIT(a) op_ppc32_##a->ops.generic = (op_func)emit_ppc32_##a

  /* generated emitter functions */
  BE_EMIT(fMul);
  BE_EMIT(fDivs);
  BE_EMIT(fSubs);
  BE_EMIT(Addis_zero);
  BE_EMIT(Cmpli);
  BE_EMIT(Cmp);
  BE_EMIT(Sraw);
  BE_EMIT(Slw);
  BE_EMIT(Lfd);
  BE_EMIT(Addi);
  BE_EMIT(cUnknown);
  BE_EMIT(Stb);
  BE_EMIT(Mullw);
  BE_EMIT(Lfs);
  BE_EMIT(Sth);
  BE_EMIT(fDiv);
  BE_EMIT(Divw);
  BE_EMIT(Rlwnm);
  BE_EMIT(Sub);
  BE_EMIT(fCmpu);
  BE_EMIT(Srawi);
  BE_EMIT(Cmpi);
  BE_EMIT(Lhz);
  BE_EMIT(Stw);
  BE_EMIT(Cmpl);
  BE_EMIT(fMinus);
  BE_EMIT(fMax);
  BE_EMIT(Lwz);
  BE_EMIT(Stfs);
  BE_EMIT(Andi_dot);
  BE_EMIT(fSub);
  BE_EMIT(Lha);
  BE_EMIT(fAdds);
  BE_EMIT(Lbz);
  BE_EMIT(Xor);
  BE_EMIT(Or);
  BE_EMIT(Rlwinm);
  BE_EMIT(fAdd);
  BE_EMIT(Lwzu);
  BE_EMIT(Add);
  BE_EMIT(Mulhwu);
  BE_EMIT(Addi_zero);
  BE_EMIT(fMin);
  BE_EMIT(Unknown);
  BE_EMIT(Ori);
  BE_EMIT(fMuls);
  BE_EMIT(fAbs);
  BE_EMIT(Extsh);
  BE_EMIT(Extsb);
  BE_EMIT(fRsp);
  BE_EMIT(Srw);
  BE_EMIT(Neg);
  BE_EMIT(fCtiw);
  BE_EMIT(Divwu);
  BE_EMIT(fNeg);
  BE_EMIT(Not);
  BE_EMIT(Mtctr);
  BE_EMIT(fUnknown);
  BE_EMIT(And);
  BE_EMIT(Mulhw);
  BE_EMIT(Stfd);

#undef BE_EMIT
}

