/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit libfirm/ir/be/mips/mips_spec.pl instead.
 *          created by: libfirm/ir/be/scripts/generate_regalloc_if.pl libfirm/ir/be/mips/mips_spec.pl libfirm/ir/be/mips
 * $date    Tue Jan 20 10:57:57 2009
 */
#include "config.h"

#include "gen_mips_regalloc_if.h"
#include "gen_mips_machine.h"
#include "bearch_mips_t.h"
#include "mips_map_regs.h"
#include "irmode.h"

arch_register_class_t mips_reg_classes[] = {
	{ 0, "mips_gp", N_mips_gp_REGS, NULL, mips_gp_regs, 0 }
};

const arch_register_t mips_gp_regs[N_mips_gp_REGS] = {
	{
		"zero",
		&mips_reg_classes[CLASS_mips_gp],
		REG_ZERO,
		arch_register_type_ignore
	},
	{
		"at",
		&mips_reg_classes[CLASS_mips_gp],
		REG_AT,
		arch_register_type_ignore
	},
	{
		"2",
		&mips_reg_classes[CLASS_mips_gp],
		REG_V0,
		arch_register_type_caller_save
	},
	{
		"3",
		&mips_reg_classes[CLASS_mips_gp],
		REG_V1,
		arch_register_type_caller_save
	},
	{
		"4",
		&mips_reg_classes[CLASS_mips_gp],
		REG_A0,
		arch_register_type_caller_save
	},
	{
		"5",
		&mips_reg_classes[CLASS_mips_gp],
		REG_A1,
		arch_register_type_caller_save
	},
	{
		"6",
		&mips_reg_classes[CLASS_mips_gp],
		REG_A2,
		arch_register_type_caller_save
	},
	{
		"7",
		&mips_reg_classes[CLASS_mips_gp],
		REG_A3,
		arch_register_type_caller_save
	},
	{
		"8",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T0,
		arch_register_type_caller_save
	},
	{
		"9",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T1,
		arch_register_type_caller_save
	},
	{
		"10",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T2,
		arch_register_type_caller_save
	},
	{
		"11",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T3,
		arch_register_type_caller_save
	},
	{
		"12",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T4,
		arch_register_type_caller_save
	},
	{
		"13",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T5,
		arch_register_type_caller_save
	},
	{
		"14",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T6,
		arch_register_type_caller_save
	},
	{
		"15",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T7,
		arch_register_type_caller_save
	},
	{
		"16",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S0,
		arch_register_type_callee_save
	},
	{
		"17",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S1,
		arch_register_type_callee_save
	},
	{
		"18",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S2,
		arch_register_type_callee_save
	},
	{
		"19",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S3,
		arch_register_type_callee_save
	},
	{
		"20",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S4,
		arch_register_type_callee_save
	},
	{
		"21",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S5,
		arch_register_type_callee_save
	},
	{
		"22",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S6,
		arch_register_type_callee_save
	},
	{
		"23",
		&mips_reg_classes[CLASS_mips_gp],
		REG_S7,
		arch_register_type_callee_save
	},
	{
		"24",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T8,
		arch_register_type_caller_save
	},
	{
		"25",
		&mips_reg_classes[CLASS_mips_gp],
		REG_T9,
		arch_register_type_caller_save
	},
	{
		"kt0",
		&mips_reg_classes[CLASS_mips_gp],
		REG_KT0,
		arch_register_type_ignore
	},
	{
		"kt1",
		&mips_reg_classes[CLASS_mips_gp],
		REG_KT1,
		arch_register_type_ignore
	},
	{
		"gp",
		&mips_reg_classes[CLASS_mips_gp],
		REG_GP,
		arch_register_type_ignore
	},
	{
		"sp",
		&mips_reg_classes[CLASS_mips_gp],
		REG_SP,
		arch_register_type_ignore
	},
	{
		"fp",
		&mips_reg_classes[CLASS_mips_gp],
		REG_FP,
		arch_register_type_ignore
	},
	{
		"ra",
		&mips_reg_classes[CLASS_mips_gp],
		REG_RA,
		arch_register_type_caller_save | arch_register_type_callee_save
	},
	{
		"!NOREG_INVALID!",
		&mips_reg_classes[CLASS_mips_gp],
		REG_GP_NOREG,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
};

void mips_register_init(void) {
	/* set largest possible mode for 'mips_gp' */
	mips_reg_classes[CLASS_mips_gp].mode = mode_Iu;

}

