/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit libfirm/ir/be/mips/mips_spec.pl instead.
 *        created by: libfirm/ir/be/scripts/generate_new_opcodes.pl libfirm/ir/be/mips/mips_spec.pl libfirm/ir/be/mips
 * @date  Tue Jan 20 10:57:57 2009
 */
#ifndef FIRM_BE_MIPS_GEN_MIPS_NEW_NODES_H
#define FIRM_BE_MIPS_GEN_MIPS_NEW_NODES_H

typedef enum _mips_opcodes {
	iro_mips_sw,
	iro_mips_lbu,
	iro_mips_SwitchJump,
	iro_mips_Immediate,
	iro_mips_seb,
	iro_mips_lhu,
	iro_mips_or,
	iro_mips_mfhi,
	iro_mips_srl,
	iro_mips_sh,
	iro_mips_lb,
	iro_mips_sra,
	iro_mips_beq,
	iro_mips_b,
	iro_mips_sll,
	iro_mips_lw,
	iro_mips_jr,
	iro_mips_mult,
	iro_mips_and,
	iro_mips_seh,
	iro_mips_lh,
	iro_mips_div,
	iro_mips_nop,
	iro_mips_sltu,
	iro_mips_bne,
	iro_mips_subu,
	iro_mips_nor,
	iro_mips_multu,
	iro_mips_blez,
	iro_mips_addu,
	iro_mips_mflo,
	iro_mips_zero,
	iro_mips_sb,
	iro_mips_slt,
	iro_mips_bgtz,
	iro_mips_xor,
	iro_mips_lui,
	iro_mips_divu,
	iro_mips_last_generated,
	iro_mips_last = iro_mips_last_generated
} mips_opcodes;

int is_mips_irn(const ir_node *node);

int get_mips_opcode_first(void);
int get_mips_opcode_last(void);
int get_mips_irn_opcode(const ir_node *node);
void mips_create_opcodes(const arch_irn_ops_t *be_ops);
extern ir_op *op_mips_sw;
ir_op *get_op_mips_sw(void);
int is_mips_sw(const ir_node *n);
/**
 * construct sw node
 */
ir_node *new_bd_mips_sw(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_lbu;
ir_op *get_op_mips_lbu(void);
int is_mips_lbu(const ir_node *n);
/**
 * construct lbu node
 */
ir_node *new_bd_mips_lbu(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_SwitchJump;
ir_op *get_op_mips_SwitchJump(void);
int is_mips_SwitchJump(const ir_node *n);
/**
 * construct SwitchJump node
 */
ir_node *new_bd_mips_SwitchJump(dbg_info *db, ir_node *block, ir_node *op0, ir_mode *mode);

extern ir_op *op_mips_Immediate;
ir_op *get_op_mips_Immediate(void);
int is_mips_Immediate(const ir_node *n);
/**
 * construct Immediate node
 */
ir_node *new_bd_mips_Immediate(dbg_info *db, ir_node *block, mips_immediate_type_t imm_type, ir_entity *entity, long val);

extern ir_op *op_mips_seb;
ir_op *get_op_mips_seb(void);
int is_mips_seb(const ir_node *n);
/**
 * construct seb node
 */
ir_node *new_bd_mips_seb(dbg_info *db, ir_node *block, ir_node *val);

extern ir_op *op_mips_lhu;
ir_op *get_op_mips_lhu(void);
int is_mips_lhu(const ir_node *n);
/**
 * construct lhu node
 */
ir_node *new_bd_mips_lhu(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_or;
ir_op *get_op_mips_or(void);
int is_mips_or(const ir_node *n);
/**
 * construct or node
 */
ir_node *new_bd_mips_or(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_mfhi;
ir_op *get_op_mips_mfhi(void);
int is_mips_mfhi(const ir_node *n);
/**
 * construct mfhi node
 */
ir_node *new_bd_mips_mfhi(dbg_info *db, ir_node *block, ir_node *lohi);

extern ir_op *op_mips_srl;
ir_op *get_op_mips_srl(void);
int is_mips_srl(const ir_node *n);
/**
 * construct srl node
 */
ir_node *new_bd_mips_srl(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_sh;
ir_op *get_op_mips_sh(void);
int is_mips_sh(const ir_node *n);
/**
 * construct sh node
 */
ir_node *new_bd_mips_sh(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_lb;
ir_op *get_op_mips_lb(void);
int is_mips_lb(const ir_node *n);
/**
 * construct lb node
 */
ir_node *new_bd_mips_lb(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_sra;
ir_op *get_op_mips_sra(void);
int is_mips_sra(const ir_node *n);
/**
 * construct sra node
 */
ir_node *new_bd_mips_sra(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_beq;
ir_op *get_op_mips_beq(void);
int is_mips_beq(const ir_node *n);
/**
 * construct beq node
 */
ir_node *new_bd_mips_beq(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_mips_b;
ir_op *get_op_mips_b(void);
int is_mips_b(const ir_node *n);
/**
 * construct b node
 */
ir_node *new_bd_mips_b(dbg_info *db, ir_node *block);

extern ir_op *op_mips_sll;
ir_op *get_op_mips_sll(void);
int is_mips_sll(const ir_node *n);
/**
 * construct sll node
 */
ir_node *new_bd_mips_sll(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_lw;
ir_op *get_op_mips_lw(void);
int is_mips_lw(const ir_node *n);
/**
 * construct lw node
 */
ir_node *new_bd_mips_lw(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_jr;
ir_op *get_op_mips_jr(void);
int is_mips_jr(const ir_node *n);
/**
 * construct jr node
 */
ir_node *new_bd_mips_jr(dbg_info *db, ir_node *block, ir_node *op0);

extern ir_op *op_mips_mult;
ir_op *get_op_mips_mult(void);
int is_mips_mult(const ir_node *n);
/**
 * construct mult node
 */
ir_node *new_bd_mips_mult(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_and;
ir_op *get_op_mips_and(void);
int is_mips_and(const ir_node *n);
/**
 * construct and node
 */
ir_node *new_bd_mips_and(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_seh;
ir_op *get_op_mips_seh(void);
int is_mips_seh(const ir_node *n);
/**
 * construct seh node
 */
ir_node *new_bd_mips_seh(dbg_info *db, ir_node *block, ir_node *val);

extern ir_op *op_mips_lh;
ir_op *get_op_mips_lh(void);
int is_mips_lh(const ir_node *n);
/**
 * construct lh node
 */
ir_node *new_bd_mips_lh(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_div;
ir_op *get_op_mips_div(void);
int is_mips_div(const ir_node *n);
/**
 * construct div node
 */
ir_node *new_bd_mips_div(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_nop;
ir_op *get_op_mips_nop(void);
int is_mips_nop(const ir_node *n);
/**
 * construct nop node
 */
ir_node *new_bd_mips_nop(dbg_info *db, ir_node *block, ir_mode *mode);

extern ir_op *op_mips_sltu;
ir_op *get_op_mips_sltu(void);
int is_mips_sltu(const ir_node *n);
/**
 * construct sltu node
 */
ir_node *new_bd_mips_sltu(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_mips_bne;
ir_op *get_op_mips_bne(void);
int is_mips_bne(const ir_node *n);
/**
 * construct bne node
 */
ir_node *new_bd_mips_bne(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_mips_subu;
ir_op *get_op_mips_subu(void);
int is_mips_subu(const ir_node *n);
/**
 * construct subu node
 */
ir_node *new_bd_mips_subu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_nor;
ir_op *get_op_mips_nor(void);
int is_mips_nor(const ir_node *n);
/**
 * construct nor node
 */
ir_node *new_bd_mips_nor(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_mips_multu;
ir_op *get_op_mips_multu(void);
int is_mips_multu(const ir_node *n);
/**
 * construct multu node
 */
ir_node *new_bd_mips_multu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_blez;
ir_op *get_op_mips_blez(void);
int is_mips_blez(const ir_node *n);
/**
 * construct blez node
 */
ir_node *new_bd_mips_blez(dbg_info *db, ir_node *block, ir_node *op0);

extern ir_op *op_mips_addu;
ir_op *get_op_mips_addu(void);
int is_mips_addu(const ir_node *n);
/**
 * construct addu node
 */
ir_node *new_bd_mips_addu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_mflo;
ir_op *get_op_mips_mflo(void);
int is_mips_mflo(const ir_node *n);
/**
 * construct mflo node
 */
ir_node *new_bd_mips_mflo(dbg_info *db, ir_node *block, ir_node *lohi);

extern ir_op *op_mips_zero;
ir_op *get_op_mips_zero(void);
int is_mips_zero(const ir_node *n);
/**
 * construct zero node
 */
ir_node *new_bd_mips_zero(dbg_info *db, ir_node *block);

extern ir_op *op_mips_sb;
ir_op *get_op_mips_sb(void);
int is_mips_sb(const ir_node *n);
/**
 * construct sb node
 */
ir_node *new_bd_mips_sb(dbg_info *db, ir_node *block, ir_node *ptr, ir_node *val, ir_node *mem, ir_entity *entity, long offset);

extern ir_op *op_mips_slt;
ir_op *get_op_mips_slt(void);
int is_mips_slt(const ir_node *n);
/**
 * construct slt node
 */
ir_node *new_bd_mips_slt(dbg_info *db, ir_node *block, ir_node *op0, ir_node *op1);

extern ir_op *op_mips_bgtz;
ir_op *get_op_mips_bgtz(void);
int is_mips_bgtz(const ir_node *n);
/**
 * construct bgtz node
 */
ir_node *new_bd_mips_bgtz(dbg_info *db, ir_node *block, ir_node *op0);

extern ir_op *op_mips_xor;
ir_op *get_op_mips_xor(void);
int is_mips_xor(const ir_node *n);
/**
 * construct xor node
 */
ir_node *new_bd_mips_xor(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_mips_lui;
ir_op *get_op_mips_lui(void);
int is_mips_lui(const ir_node *n);
/**
 * construct lui node
 */
ir_node *new_bd_mips_lui(dbg_info *db, ir_node *block, mips_immediate_type_t imm_type, ir_entity *entity, long val);

extern ir_op *op_mips_divu;
ir_op *get_op_mips_divu(void);
int is_mips_divu(const ir_node *n);
/**
 * construct divu node
 */
ir_node *new_bd_mips_divu(dbg_info *db, ir_node *block, ir_node *left, ir_node *right);


enum n_mips_sw {
	n_mips_sw_ptr = 0,
	n_mips_sw_val = 1,
	n_mips_sw_mem = 2,
};

enum pn_mips_lbu {
	pn_mips_lbu_res = 0,
	pn_mips_lbu_M = 1,
};

enum n_mips_lbu {
	n_mips_lbu_ptr = 0,
	n_mips_lbu_mem = 1,
};

enum n_mips_seb {
	n_mips_seb_val = 0,
};

enum pn_mips_lhu {
	pn_mips_lhu_res = 0,
	pn_mips_lhu_M = 1,
};

enum n_mips_lhu {
	n_mips_lhu_ptr = 0,
	n_mips_lhu_mem = 1,
};

enum n_mips_or {
	n_mips_or_left = 0,
	n_mips_or_right = 1,
};

enum n_mips_mfhi {
	n_mips_mfhi_lohi = 0,
};

enum n_mips_srl {
	n_mips_srl_left = 0,
	n_mips_srl_right = 1,
};

enum n_mips_sh {
	n_mips_sh_ptr = 0,
	n_mips_sh_val = 1,
	n_mips_sh_mem = 2,
};

enum pn_mips_lb {
	pn_mips_lb_res = 0,
	pn_mips_lb_M = 1,
};

enum n_mips_lb {
	n_mips_lb_ptr = 0,
	n_mips_lb_mem = 1,
};

enum n_mips_sra {
	n_mips_sra_left = 0,
	n_mips_sra_right = 1,
};

enum pn_mips_beq {
	pn_mips_beq_false = 0,
	pn_mips_beq_true = 1,
};

enum n_mips_sll {
	n_mips_sll_left = 0,
	n_mips_sll_right = 1,
};

enum pn_mips_lw {
	pn_mips_lw_res = 0,
	pn_mips_lw_M = 1,
};

enum n_mips_lw {
	n_mips_lw_ptr = 0,
	n_mips_lw_mem = 1,
};

enum n_mips_mult {
	n_mips_mult_left = 0,
	n_mips_mult_right = 1,
};

enum n_mips_and {
	n_mips_and_left = 0,
	n_mips_and_right = 1,
};

enum n_mips_seh {
	n_mips_seh_val = 0,
};

enum pn_mips_lh {
	pn_mips_lh_res = 0,
	pn_mips_lh_M = 1,
};

enum n_mips_lh {
	n_mips_lh_ptr = 0,
	n_mips_lh_mem = 1,
};

enum pn_mips_div {
	pn_mips_div_lohi = 0,
	pn_mips_div_M = 1,
};

enum n_mips_div {
	n_mips_div_left = 0,
	n_mips_div_right = 1,
};

enum pn_mips_bne {
	pn_mips_bne_false = 0,
	pn_mips_bne_true = 1,
};

enum n_mips_subu {
	n_mips_subu_left = 0,
	n_mips_subu_right = 1,
};

enum n_mips_multu {
	n_mips_multu_left = 0,
	n_mips_multu_right = 1,
};

enum pn_mips_blez {
	pn_mips_blez_false = 0,
	pn_mips_blez_true = 1,
};

enum n_mips_addu {
	n_mips_addu_left = 0,
	n_mips_addu_right = 1,
};

enum n_mips_mflo {
	n_mips_mflo_lohi = 0,
};

enum n_mips_sb {
	n_mips_sb_ptr = 0,
	n_mips_sb_val = 1,
	n_mips_sb_mem = 2,
};

enum pn_mips_bgtz {
	pn_mips_bgtz_false = 0,
	pn_mips_bgtz_true = 1,
};

enum n_mips_xor {
	n_mips_xor_left = 0,
	n_mips_xor_right = 1,
};

enum pn_mips_divu {
	pn_mips_divu_lohi = 0,
	pn_mips_divu_M = 1,
};

enum n_mips_divu {
	n_mips_divu_left = 0,
	n_mips_divu_right = 1,
};
#endif
