/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit libfirm/ir/be/mips/mips_spec.pl instead.
 *            created by: libfirm/ir/be/scripts/generate_emitter.pl libfirm/ir/be/mips/mips_spec.pl libfirm/ir/be/mips
 * @date      Tue Jan 20 10:57:57 2009
 */
#include "config.h"

#include <stdio.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"

#include "gen_mips_emitter.h"
#include "mips_new_nodes.h"
#include "mips_emitter.h"

static void emit_mips_sw(const ir_node *node) {
	be_emit_cstring("\tsw ");
	mips_emit_source_register(node, 1);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_lbu(const ir_node *node) {
	be_emit_cstring("\tlbu ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_SwitchJump(const ir_node *node) {
	be_emit_cstring("\tjr ");
	mips_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_seb(const ir_node *node) {
	be_emit_cstring("\tseb ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_lhu(const ir_node *node) {
	be_emit_cstring("\tlhu ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_or(const ir_node *node) {
	be_emit_cstring("\tor");
	mips_emit_immediate_suffix(node, 1);
	be_emit_char(' ');
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_mfhi(const ir_node *node) {
	be_emit_cstring("\tmfhi ");
	mips_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_srl(const ir_node *node) {
	be_emit_cstring("\tsrl ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_sh(const ir_node *node) {
	be_emit_cstring("\tsh ");
	mips_emit_source_register(node, 1);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_lb(const ir_node *node) {
	be_emit_cstring("\tlb ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_sra(const ir_node *node) {
	be_emit_cstring("\tsra ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_beq(const ir_node *node) {
	be_emit_cstring("\tbeq ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 1);
	be_emit_cstring(", ");
	mips_emit_jump_target_proj(node, 1);
	be_emit_finish_line_gas(node);
		             be_emit_cstring("\t");
		             mips_emit_jump_or_fallthrough(node, 0);
		             be_emit_finish_line_gas(node);
}

static void emit_mips_b(const ir_node *node) {
	be_emit_cstring("\tb ");
	mips_emit_jump_target(node);
	be_emit_finish_line_gas(node);
}

static void emit_mips_sll(const ir_node *node) {
	be_emit_cstring("\tsll ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_lw(const ir_node *node) {
	be_emit_cstring("\tlw ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_jr(const ir_node *node) {
	be_emit_cstring("\tjr ");
	mips_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_mult(const ir_node *node) {
	be_emit_cstring("\tmult ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_and(const ir_node *node) {
	be_emit_cstring("\tand");
	mips_emit_immediate_suffix(node, 1);
	be_emit_char(' ');
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_seh(const ir_node *node) {
	be_emit_cstring("\tseh ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_lh(const ir_node *node) {
	be_emit_cstring("\tlh ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_div(const ir_node *node) {
	be_emit_cstring("\tdiv ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_nop(const ir_node *node) {
	be_emit_cstring("\tnop");
	be_emit_finish_line_gas(node);
}

static void emit_mips_sltu(const ir_node *node) {
	be_emit_cstring("\tslt");
	mips_emit_immediate_suffix(node, 1);
	be_emit_cstring("u ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_bne(const ir_node *node) {
	be_emit_cstring("\tbne ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 1);
	be_emit_cstring(", ");
	mips_emit_jump_target_proj(node, 1);
	be_emit_finish_line_gas(node);
		             be_emit_cstring("\t");
		             mips_emit_jump_or_fallthrough(node, 0);
		             be_emit_finish_line_gas(node);
}

static void emit_mips_subu(const ir_node *node) {
	be_emit_cstring("\tsubu ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_nor(const ir_node *node) {
	be_emit_cstring("\tnor");
	mips_emit_immediate_suffix(node, 1);
	be_emit_char(' ');
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_multu(const ir_node *node) {
	be_emit_cstring("\tmultu ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_blez(const ir_node *node) {
	be_emit_cstring("\tblez ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_jump_target_proj(node, 1);
	be_emit_finish_line_gas(node);
		             be_emit_cstring("\t");
		             mips_emit_jump_or_fallthrough(node, 0);
		             be_emit_finish_line_gas(node);
}

static void emit_mips_addu(const ir_node *node) {
	be_emit_cstring("\tadd");
	mips_emit_immediate_suffix(node, 1);
	be_emit_cstring("u ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_mflo(const ir_node *node) {
	be_emit_cstring("\tmflo ");
	mips_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_zero(const ir_node *node) {
	(void) node;
}

static void emit_mips_sb(const ir_node *node) {
	be_emit_cstring("\tsb ");
	mips_emit_source_register(node, 1);
	be_emit_cstring(", ");
	mips_emit_load_store_address(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_mips_slt(const ir_node *node) {
	be_emit_cstring("\tslt");
	mips_emit_immediate_suffix(node, 1);
	be_emit_char(' ');
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_bgtz(const ir_node *node) {
	be_emit_cstring("\tbgtz ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_jump_target_proj(node, 1);
	be_emit_finish_line_gas(node);
		             be_emit_cstring("\t");
		             mips_emit_jump_or_fallthrough(node, 0);
		             be_emit_finish_line_gas(node);
}

static void emit_mips_xor(const ir_node *node) {
	be_emit_cstring("\txor");
	mips_emit_immediate_suffix(node, 1);
	be_emit_char(' ');
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register_or_immediate(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_mips_lui(const ir_node *node) {
	be_emit_cstring("\tlui ");
	mips_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_mips_divu(const ir_node *node) {
	be_emit_cstring("\tdivu ");
	mips_emit_source_register(node, 0);
	be_emit_cstring(", ");
	mips_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void mips_register_spec_emitters(void) {

#define BE_EMIT(a) op_mips_##a->ops.generic = (op_func)emit_mips_##a

  /* generated emitter functions */
  BE_EMIT(sw);
  BE_EMIT(lbu);
  BE_EMIT(SwitchJump);
  BE_EMIT(seb);
  BE_EMIT(lhu);
  BE_EMIT(or);
  BE_EMIT(mfhi);
  BE_EMIT(srl);
  BE_EMIT(sh);
  BE_EMIT(lb);
  BE_EMIT(sra);
  BE_EMIT(beq);
  BE_EMIT(b);
  BE_EMIT(sll);
  BE_EMIT(lw);
  BE_EMIT(jr);
  BE_EMIT(mult);
  BE_EMIT(and);
  BE_EMIT(seh);
  BE_EMIT(lh);
  BE_EMIT(div);
  BE_EMIT(nop);
  BE_EMIT(sltu);
  BE_EMIT(bne);
  BE_EMIT(subu);
  BE_EMIT(nor);
  BE_EMIT(multu);
  BE_EMIT(blez);
  BE_EMIT(addu);
  BE_EMIT(mflo);
  BE_EMIT(zero);
  BE_EMIT(sb);
  BE_EMIT(slt);
  BE_EMIT(bgtz);
  BE_EMIT(xor);
  BE_EMIT(lui);
  BE_EMIT(divu);

#undef BE_EMIT
}

