/**
 * @file
 * @brief     Generated functions for machine description interface.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit libfirm/ir/be/ia32/ia32_spec.pl instead.
 *            created by: libfirm/ir/be/scripts/generate_machine.pl libfirm/ir/be/ia32/ia32_spec.pl libfirm/ir/be/ia32
 * @date      Mon Mar  2 12:22:14 2009
 */
#include "config.h"

#include "gen_ia32_machine.h"

be_execution_unit_t ia32_execution_units_BRANCH[2];
be_execution_unit_t ia32_execution_units_VFP[8];
be_execution_unit_t ia32_execution_units_SSE[8];
be_execution_unit_t ia32_execution_units_GP[7];

be_execution_unit_type_t ia32_execution_unit_types[] = {
	{ 2, 1, "BRANCH", ia32_execution_units_BRANCH },
	{ 8, 1, "VFP", ia32_execution_units_VFP },
	{ 8, 1, "SSE", ia32_execution_units_SSE },
	{ 7, 1, "GP", ia32_execution_units_GP },
};

be_machine_t ia32_cpu = {
	1,
	1,
	4,
	ia32_execution_unit_types
};

/**
 * Returns the ia32 machines description
 */
const be_machine_t *ia32_init_machine_description(void) {
	static int initialized = 0;

	if (! initialized) {
		be_execution_unit_type_t *cur_unit_tp;
		(void) cur_unit_tp; /* avoid warning */

		be_machine_init_dummy_unit();

		/* init of execution unit type IA32_EXECUNIT_TP_BRANCH */
		cur_unit_tp = &ia32_execution_unit_types[IA32_EXECUNIT_TP_BRANCH];
		(void) cur_unit_tp; /* avoid warning */
		ia32_execution_units_BRANCH[IA32_EXECUNIT_TP_BRANCH_BRANCH1].tp   = cur_unit_tp;
		ia32_execution_units_BRANCH[IA32_EXECUNIT_TP_BRANCH_BRANCH1].name = "BRANCH1";
		ia32_execution_units_BRANCH[IA32_EXECUNIT_TP_BRANCH_BRANCH2].tp   = cur_unit_tp;
		ia32_execution_units_BRANCH[IA32_EXECUNIT_TP_BRANCH_BRANCH2].name = "BRANCH2";

		/* init of execution unit type IA32_EXECUNIT_TP_VFP */
		cur_unit_tp = &ia32_execution_unit_types[IA32_EXECUNIT_TP_VFP];
		(void) cur_unit_tp; /* avoid warning */
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF0].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF0].name = "VFP_VF0";
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF1].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF1].name = "VFP_VF1";
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF2].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF2].name = "VFP_VF2";
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF3].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF3].name = "VFP_VF3";
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF4].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF4].name = "VFP_VF4";
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF5].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF5].name = "VFP_VF5";
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF6].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF6].name = "VFP_VF6";
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF7].tp   = cur_unit_tp;
		ia32_execution_units_VFP[IA32_EXECUNIT_TP_VFP_VFP_VF7].name = "VFP_VF7";

		/* init of execution unit type IA32_EXECUNIT_TP_SSE */
		cur_unit_tp = &ia32_execution_unit_types[IA32_EXECUNIT_TP_SSE];
		(void) cur_unit_tp; /* avoid warning */
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM0].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM0].name = "SSE_XMM0";
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM1].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM1].name = "SSE_XMM1";
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM2].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM2].name = "SSE_XMM2";
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM3].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM3].name = "SSE_XMM3";
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM4].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM4].name = "SSE_XMM4";
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM5].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM5].name = "SSE_XMM5";
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM6].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM6].name = "SSE_XMM6";
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM7].tp   = cur_unit_tp;
		ia32_execution_units_SSE[IA32_EXECUNIT_TP_SSE_SSE_XMM7].name = "SSE_XMM7";

		/* init of execution unit type IA32_EXECUNIT_TP_GP */
		cur_unit_tp = &ia32_execution_unit_types[IA32_EXECUNIT_TP_GP];
		(void) cur_unit_tp; /* avoid warning */
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EAX].tp   = cur_unit_tp;
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EAX].name = "GP_EAX";
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EBX].tp   = cur_unit_tp;
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EBX].name = "GP_EBX";
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_ECX].tp   = cur_unit_tp;
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_ECX].name = "GP_ECX";
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EDX].tp   = cur_unit_tp;
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EDX].name = "GP_EDX";
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_ESI].tp   = cur_unit_tp;
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_ESI].name = "GP_ESI";
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EDI].tp   = cur_unit_tp;
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EDI].name = "GP_EDI";
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EBP].tp   = cur_unit_tp;
		ia32_execution_units_GP[IA32_EXECUNIT_TP_GP_GP_EBP].name = "GP_EBP";

		initialized = 1;
	}

	return &ia32_cpu;
}

