/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit libfirm/ir/be/arm/arm_spec.pl instead.
 *          created by: libfirm/ir/be/scripts/generate_regalloc_if.pl libfirm/ir/be/arm/arm_spec.pl libfirm/ir/be/arm
 * $date    Tue Jan 20 10:57:58 2009
 */
#include "config.h"

#include "gen_arm_regalloc_if.h"
#include "gen_arm_machine.h"
#include "bearch_arm_t.h"
#include "arm_map_regs.h"
#include "irmode.h"

arch_register_class_t arm_reg_classes[] = {
	{ 0, "arm_gp", N_arm_gp_REGS, NULL, arm_gp_regs, 0 },
	{ 1, "arm_fpa", N_arm_fpa_REGS, NULL, arm_fpa_regs, 0 }
};

const arch_register_t arm_gp_regs[N_arm_gp_REGS] = {
	{
		"r0",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R0,
		arch_register_type_caller_save
	},
	{
		"r1",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R1,
		arch_register_type_caller_save
	},
	{
		"r2",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R2,
		arch_register_type_caller_save
	},
	{
		"r3",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R3,
		arch_register_type_caller_save
	},
	{
		"r4",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R4,
		arch_register_type_callee_save
	},
	{
		"r5",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R5,
		arch_register_type_callee_save
	},
	{
		"r6",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R6,
		arch_register_type_callee_save
	},
	{
		"r7",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R7,
		arch_register_type_callee_save
	},
	{
		"r8",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R8,
		arch_register_type_callee_save
	},
	{
		"r9",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R9,
		arch_register_type_callee_save
	},
	{
		"r10",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R10,
		arch_register_type_callee_save
	},
	{
		"r11",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R11,
		arch_register_type_callee_save
	},
	{
		"r12",
		&arm_reg_classes[CLASS_arm_gp],
		REG_R12,
		arch_register_type_callee_save | arch_register_type_ignore
	},
	{
		"sp",
		&arm_reg_classes[CLASS_arm_gp],
		REG_SP,
		arch_register_type_callee_save | arch_register_type_ignore
	},
	{
		"lr",
		&arm_reg_classes[CLASS_arm_gp],
		REG_LR,
		arch_register_type_caller_save | arch_register_type_callee_save
	},
	{
		"pc",
		&arm_reg_classes[CLASS_arm_gp],
		REG_PC,
		arch_register_type_callee_save | arch_register_type_ignore
	},
	{
		"gp_UKNWN",
		&arm_reg_classes[CLASS_arm_gp],
		REG_GP_UKNWN,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
};
const arch_register_t arm_fpa_regs[N_arm_fpa_REGS] = {
	{
		"f0",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F0,
		arch_register_type_caller_save
	},
	{
		"f1",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F1,
		arch_register_type_caller_save
	},
	{
		"f2",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F2,
		arch_register_type_caller_save
	},
	{
		"f3",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F3,
		arch_register_type_caller_save
	},
	{
		"f4",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F4,
		arch_register_type_caller_save
	},
	{
		"f5",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F5,
		arch_register_type_caller_save
	},
	{
		"f6",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F6,
		arch_register_type_caller_save
	},
	{
		"f7",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_F7,
		arch_register_type_caller_save
	},
	{
		"fpa_UKNWN",
		&arm_reg_classes[CLASS_arm_fpa],
		REG_FPA_UKNWN,
		arch_register_type_ignore | arch_register_type_joker | arch_register_type_virtual
	},
};

void arm_register_init(void) {
	/* set largest possible mode for 'arm_gp' */
	arm_reg_classes[CLASS_arm_gp].mode = mode_Iu;

	/* set largest possible mode for 'arm_fpa' */
	arm_reg_classes[CLASS_arm_fpa].mode = mode_E;

}

