/**
 * @file
 * @brief     Generated functions to emit code for assembler ir nodes.
 * @note      DO NOT EDIT THIS FILE, your changes will be lost.
 *            Edit libfirm/ir/be/arm/arm_spec.pl instead.
 *            created by: libfirm/ir/be/scripts/generate_emitter.pl libfirm/ir/be/arm/arm_spec.pl libfirm/ir/be/arm
 * @date      Tue Jan 20 10:57:58 2009
 */
#include "config.h"

#include <stdio.h>

#include "irnode.h"
#include "irop_t.h"
#include "irprog_t.h"

#include "gen_arm_emitter.h"
#include "arm_new_nodes.h"
#include "arm_emitter.h"

static void emit_arm_Unknown_GP(const ir_node *node) {
	(void) node;
}

static void emit_arm_Mla(const ir_node *node) {
	be_emit_cstring("\tmla ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 2);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMin(const ir_node *node) {
	be_emit_cstring("\tfmin ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaFrd(const ir_node *node) {
	be_emit_cstring("\tfrd");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Mov(const ir_node *node) {
	be_emit_cstring("\tmov ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_SubSPandCopy(const ir_node *node) {
	be_emit_cstring("\tsub ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
	be_emit_cstring("\tmov sp, ");
	arm_emit_dest_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_EmptyReg(const ir_node *node) {
	be_emit_cstring("\t/* ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(" now available for calculations */");
	be_emit_finish_line_gas(node);
}

static void emit_arm_And_i(const ir_node *node) {
	be_emit_cstring("\tand ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaRdf(const ir_node *node) {
	be_emit_cstring("\trdf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Add_i(const ir_node *node) {
	be_emit_cstring("\tadd ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaFix(const ir_node *node) {
	be_emit_cstring("\tfix ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMvf(const ir_node *node) {
	be_emit_cstring("\tmvf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Abs(const ir_node *node) {
	be_emit_cstring("\tmovs ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0");
	be_emit_finish_line_gas(node);
	be_emit_cstring("\trsbmi ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0");
	be_emit_finish_line_gas(node);
}

static void emit_arm_Mvn(const ir_node *node) {
	be_emit_cstring("\tmvn ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaFdv_i(const ir_node *node) {
	be_emit_cstring("\tfdv");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Unknown_FPA(const ir_node *node) {
	(void) node;
}

static void emit_arm_fpaFrd_i(const ir_node *node) {
	be_emit_cstring("\tfrd");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Or_i(const ir_node *node) {
	be_emit_cstring("\torr ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Umull(const ir_node *node) {
	be_emit_cstring("\tumull ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 1);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Sub(const ir_node *node) {
	be_emit_cstring("\tsub ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Sub_i(const ir_node *node) {
	be_emit_cstring("\tsub ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Storeh(const ir_node *node) {
	be_emit_cstring("\tstrh ");
	arm_emit_source_register(node, 1);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_Shr(const ir_node *node) {
	be_emit_cstring("\tmov ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", lsr ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Loadbs(const ir_node *node) {
	be_emit_cstring("\tldrsb ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_Shrs(const ir_node *node) {
	be_emit_cstring("\tmov ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", asr ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaRdf_i(const ir_node *node) {
	be_emit_cstring("\trdf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaSuf(const ir_node *node) {
	be_emit_cstring("\tsuf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaFml(const ir_node *node) {
	be_emit_cstring("\tfml");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Eor_i(const ir_node *node) {
	be_emit_cstring("\teor ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_AddSP(const ir_node *node) {
	be_emit_cstring("\tadd ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaAdf(const ir_node *node) {
	be_emit_cstring("\tadf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaDvf(const ir_node *node) {
	be_emit_cstring("\tdvf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaDvf_i(const ir_node *node) {
	be_emit_cstring("\tdvf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Mvn_i(const ir_node *node) {
	be_emit_cstring("\tmvn ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_StoreStackM4Inc(const ir_node *node) {
	be_emit_cstring("\tstmfd ");
	arm_emit_source_register(node, 0);
	be_emit_cstring("!, {");
	arm_emit_source_register(node, 1);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 2);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 3);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 4);
	be_emit_char('}');
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMuf(const ir_node *node) {
	be_emit_cstring("\tmuf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Mov_i(const ir_node *node) {
	be_emit_cstring("\tmov ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Eor(const ir_node *node) {
	be_emit_cstring("\teor ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Loadb(const ir_node *node) {
	be_emit_cstring("\tldrb ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_Rsb(const ir_node *node) {
	be_emit_cstring("\trsb ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Loadh(const ir_node *node) {
	be_emit_cstring("\tldrh ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaLdf(const ir_node *node) {
	be_emit_cstring("\tldf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_char(']');
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaAbs(const ir_node *node) {
	be_emit_cstring("\tabs");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMuf_i(const ir_node *node) {
	be_emit_cstring("\tmuf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaFdv(const ir_node *node) {
	be_emit_cstring("\tfdv");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Or(const ir_node *node) {
	be_emit_cstring("\torr ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMnf_i(const ir_node *node) {
	be_emit_cstring("\tmnf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMax(const ir_node *node) {
	be_emit_cstring("\tfmax ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Ror(const ir_node *node) {
	be_emit_cstring("\tmov ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ror ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Smull(const ir_node *node) {
	be_emit_cstring("\tsmull ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 1);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Shl(const ir_node *node) {
	be_emit_cstring("\tmov ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", lsl ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Add(const ir_node *node) {
	be_emit_cstring("\tadd ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaSuf_i(const ir_node *node) {
	be_emit_cstring("\tsuf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_LoadStackM3Epilogue(const ir_node *node) {
	be_emit_cstring("\tldmfd ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", {");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 1);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 2);
	be_emit_char('}');
	be_emit_finish_line_gas(node);
}

static void emit_arm_Storeb(const ir_node *node) {
	be_emit_cstring("\tstrb ");
	arm_emit_source_register(node, 1);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_Bic(const ir_node *node) {
	be_emit_cstring("\tbic ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Mul(const ir_node *node) {
	be_emit_cstring("\tmul ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaRsf_i(const ir_node *node) {
	be_emit_cstring("\trsf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaRsf(const ir_node *node) {
	be_emit_cstring("\trsf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMnf(const ir_node *node) {
	be_emit_cstring("\tmnf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_dest_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Bic_i(const ir_node *node) {
	be_emit_cstring("\tbic ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Rsb_i(const ir_node *node) {
	be_emit_cstring("\trsb ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaMvf_i(const ir_node *node) {
	be_emit_cstring("\tmvf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaStf(const ir_node *node) {
	be_emit_cstring("\tstf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_source_register(node, 1);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_char(']');
	be_emit_finish_line_gas(node);
}

static void emit_arm_Store(const ir_node *node) {
	be_emit_cstring("\tstr ");
	arm_emit_source_register(node, 1);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_And(const ir_node *node) {
	be_emit_cstring("\tand ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 1);
	arm_emit_shift(node);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Loadhs(const ir_node *node) {
	be_emit_cstring("\tldrsh ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaFlt(const ir_node *node) {
	be_emit_cstring("\tflt");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_finish_line_gas(node);
}

static void emit_arm_Load(const ir_node *node) {
	be_emit_cstring("\tldr ");
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", [");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", #0]");
	be_emit_finish_line_gas(node);
}

static void emit_arm_fpaAdf_i(const ir_node *node) {
	be_emit_cstring("\tadf");
	arm_emit_mode(node);
	be_emit_char(' ');
	arm_emit_dest_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_source_register(node, 0);
	be_emit_cstring(", ");
	arm_emit_immediate(node);
	be_emit_finish_line_gas(node);
}

/**
 * Enters the emitter functions for handled nodes into the generic
 * pointer of an opcode.
 */
void arm_register_spec_emitters(void) {

#define BE_EMIT(a) op_arm_##a->ops.generic = (op_func)emit_arm_##a

  /* generated emitter functions */
  BE_EMIT(Unknown_GP);
  BE_EMIT(Mla);
  BE_EMIT(fpaMin);
  BE_EMIT(fpaFrd);
  BE_EMIT(Mov);
  BE_EMIT(SubSPandCopy);
  BE_EMIT(EmptyReg);
  BE_EMIT(And_i);
  BE_EMIT(fpaRdf);
  BE_EMIT(Add_i);
  BE_EMIT(fpaFix);
  BE_EMIT(fpaMvf);
  BE_EMIT(Abs);
  BE_EMIT(Mvn);
  BE_EMIT(fpaFdv_i);
  BE_EMIT(Unknown_FPA);
  BE_EMIT(fpaFrd_i);
  BE_EMIT(Or_i);
  BE_EMIT(Umull);
  BE_EMIT(Sub);
  BE_EMIT(Sub_i);
  BE_EMIT(Storeh);
  BE_EMIT(Shr);
  BE_EMIT(Loadbs);
  BE_EMIT(Shrs);
  BE_EMIT(fpaRdf_i);
  BE_EMIT(fpaSuf);
  BE_EMIT(fpaFml);
  BE_EMIT(Eor_i);
  BE_EMIT(AddSP);
  BE_EMIT(fpaAdf);
  BE_EMIT(fpaDvf);
  BE_EMIT(fpaDvf_i);
  BE_EMIT(Mvn_i);
  BE_EMIT(StoreStackM4Inc);
  BE_EMIT(fpaMuf);
  BE_EMIT(Mov_i);
  BE_EMIT(Eor);
  BE_EMIT(Loadb);
  BE_EMIT(Rsb);
  BE_EMIT(Loadh);
  BE_EMIT(fpaLdf);
  BE_EMIT(fpaAbs);
  BE_EMIT(fpaMuf_i);
  BE_EMIT(fpaFdv);
  BE_EMIT(Or);
  BE_EMIT(fpaMnf_i);
  BE_EMIT(fpaMax);
  BE_EMIT(Ror);
  BE_EMIT(Smull);
  BE_EMIT(Shl);
  BE_EMIT(Add);
  BE_EMIT(fpaSuf_i);
  BE_EMIT(LoadStackM3Epilogue);
  BE_EMIT(Storeb);
  BE_EMIT(Bic);
  BE_EMIT(Mul);
  BE_EMIT(fpaRsf_i);
  BE_EMIT(fpaRsf);
  BE_EMIT(fpaMnf);
  BE_EMIT(Bic_i);
  BE_EMIT(Rsb_i);
  BE_EMIT(fpaMvf_i);
  BE_EMIT(fpaStf);
  BE_EMIT(Store);
  BE_EMIT(And);
  BE_EMIT(Loadhs);
  BE_EMIT(fpaFlt);
  BE_EMIT(Load);
  BE_EMIT(fpaAdf_i);

#undef BE_EMIT
}

