/**
 * @file header.h CPIO header
 * 
 * $Id: header.h,v 1.4 2003/01/01 06:22:32 chipx86 Exp $
 *
 * @Copyright (C) 1999-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _CPIO_HEADER_H_
#define _CPIO_HEADER_H_

/** @name Magic Values */
#define CPIO_MAGICN_ASCII  0x070701   /**< ASCII header magic number.      */
#define CPIO_MAGICN_BIN    070707     /**< Binary header magic number.     */
#define CPIO_MAGICN_BBS    0143561    /**< Byte-swap header magic number.  */
#define CPIO_MAGICS_ASCII  "070701"   /**< ASCII header magic string.      */
#define CPIO_MAGICS_CRC    "070702"   /**< CRC header magic string.        */
#define CPIO_MAGICS_CHR    "070707"   /**< CHR (-c) header magic string.   */

#define TCPIO_MAGICN_SEC   0x070703   /**< TCPIO TI/E header magic number. */
#define TCPIO_MAGICS_SEC   "070703"   /**< TCPIO TI/E header magic string. */

#define CPIO_MAGICS_LEN    6          /**< Magic string length.            */

/**
 * @name Header Sizes
 *
 * The lengths below are the header sizes minus the filename fields.
 */
#define CPIO_CHR_SIZE       76        /**< -c header size.                 */
#define CPIO_ASCII_SIZE    110        /**< ASCII and CRC header size.      */

#define CPIO_LARGEST_SIZE  CPIO_ASCII_SIZE /**< Largest header size.       */

/** @name Field Lengths */
#define CPIO_NAME_LEN      256        /**< Maximum filename length for
                                           binary and -c headers.          */
#define CPIO_EXPNAME_LEN  1024        /**< Maximum filename length for
                                           ASCII and CRC headers.          */
#define CPIO_TIME_LEN        2        /**< Length of mod time field.       */
#define CPIO_SIZE_LEN        2        /**< Length of file size field.      */

/**
 * @name Misc. definitions
 */
#define CPIO_TRAILER    "TRAILER!!!"  /**< The end of archive marker.      */

typedef enum
{
	BLOCK_STILL_UNREAD,  /**< For when cxCpioReadHeader has not been called */
	BLOCK_SUCCESS,       /**< Header successfully read and checksummed.     */
	BLOCK_ZERO_BLOCK,    /**< Zero block where header expected.             */
	BLOCK_END_OF_FILE,   /**< True end of file while header expected.       */
	BLOCK_FAILED         /**< Ill-formed header, or bad checksum.           */

} CpioReadStatus;

/**
 * Old CPIO header definition
 */
typedef struct
{
	unsigned short magic;          /**< Magic number.                  */
	short dev;                     /**< File system of file.           */
	unsigned short inode;          /**< Inode of file.                 */
	unsigned short mode;           /**< Modes of file.                 */
	unsigned short uid;            /**< UID of file.                   */
	unsigned short gid;            /**< GID of file.                   */
	unsigned short nlink;          /**< Number of links to file.       */
	short rdev;                    /**< Major/minor numbers.           */
	unsigned short mtimes[2];      /**< Modification time of file.     */
	unsigned short nameSize;       /**< Length of filename.            */
	unsigned short fileSizes[2];   /**< Size of file.                  */
	unsigned long mtime;           /**< Long-aligned copy of mtime     */
	unsigned long fileSize;        /**< Long-aligned copy of fileSizes */
	char *filename;                /**< Filename.                      */

} CpioOldHeader;

/**
 * New CPIO header definition
 */
typedef struct
{
	unsigned short magic;          /**< Magic number.                  */
	unsigned long  inode;          /**< Inode of file.                 */
	unsigned long  mode;           /**< Modes of file.                 */
	unsigned long  uid;            /**< UID of file.                   */
	unsigned long  gid;            /**< GID of file.                   */
	unsigned long  nlink;          /**< Number of links to file.       */
	unsigned long  mtime;          /**< Modification time.             */
	unsigned long  fileSize;       /**< File size.                     */
	long devMajor;                 /**< Device major number.           */
	long devMinor;                 /**< Device minor number.           */
	long rDevMajor;                /**< Remote device major number.    */
	long rDevMinor;                /**< Remote device minor number.    */
	unsigned long nameSize;        /**< Length of filename.            */
	unsigned long checksum;        /**< CRC checksum.                  */
	char *filename;                /**< Filename.                      */
	char *cpioLinkName;            /**< CPIO link name.                */

} CpioNewHeader;

CxStatus cxCpioReadHeader(CxFP *fp, CxArchive *archive);

#endif /* _CPIO_HEADER_H_ */

