/**
 * @file ar.h AR module include file
 *
 * $Id: ar.h,v 1.6 2003/01/01 06:22:31 chipx86 Exp $
 *
 * @Copyright (C) 2001-2003 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#ifndef _MOD_AR_H_
#define _MOD_AR_H_

#include <libcomprex/internal.h>
#include <ctype.h>

#define AR_MAGIC     "!<arch>\n"
#define AR_MAGIC_LEN 8
#define AR_FMAG      "`\n"

#define AR_HEADER_LEN 60

typedef struct
{
	long startPos;
	long lastPos;

} CxArFileData;

typedef struct
{
	char name[16];
	char date[12];
	char uid[6];
	char gid[6];
	char mode[8];
	char size[10];
	char fmag[2];

} CxArHeader;

CxStatus cxArValidateMagic(CxFP *fp);
CxStatus cxArReadHeader(CxFP *fp, CxArHeader *header);

int cxArOctalToInt(const char *oct);
int cxArDecToInt(const char *dec);

#endif /* _MOD_AR_H_ */

