'\"-
'\" Copyright (c)1997-2005 Hartmut Brandt.
'\" All rights reserved.
'\"
'\" Author: Harti Brandt <harti@freebsd.org>
'\"
'\" Redistribution and use in source and binary forms, with or without
'\" modification, are permitted provided that the following conditions
'\" are met:
'\" 1. Redistributions of source code must retain the above copyright
'\"    notice, this list of conditions and the following disclaimer.
'\" 2. Redistributions in binary form must reproduce the above copyright
'\"    notice, this list of conditions and the following disclaimer in the
'\"    documentation and/or other materials provided with the distribution.
'\"
'\" THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
'\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
'\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
'\" ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
'\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
'\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
'\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
'\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
'\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
'\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
'\" SUCH DAMAGE.
'\"
'\" $Begemot: libbegemot/readline.man,v 1.4 2005/06/01 07:51:03 brandt_h Exp $
'\"
.TH readline l "30 Aug 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
readline - read line of arbitrary size from file
.SH SYNOPSIS
.nf
.LP
.B "# include <stdio.h>"
.B "# include <begemot.h>"
.LP
.BR "char * readline(FILE * " "fp" ");"
.LP
.B int readlinecnt;
.fi
.SH DESCRIPTION
This function allows you to read lines of arbitrary length from an input file. It
thus overcomes the problem of ``how large should I allocate the input buffer?'' in many
programs. It handles the convention of signaling line continuation with a backslash
in the last position, i.e. it silently removes sequences of ``\e\e\en'' from input.
.LP
The variable
.B readlinecnt
contains the number of input lines which where folded together for the last line
returned by
.BR readline .
.SH "RETURN VALUE"
The function returnes a pointer to a
.BR malloc (3C)ed
area on success. If end of file or an error is encountered before any character is
transfered to the buffer, NULL is returned.
.BR readline (l)
uses
.BR xrealloc (l)
to allocate the buffer and thus exists with
.BR panic (l)
in the case of insufficient memory.
.SH "SEE ALSO"
.BR panic (l),
.BR xrealloc (l)
