/*-
 * Copyright (c)1997-2005 by Hartmut Brandt
 * 	All rights reserved.
 *
 * Author: Harti Brandt <harti@freebsd.org>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Begemot: libbegemot/readline.c,v 1.5 2005/06/01 07:51:02 brandt_h Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include <string.h>

# include "begemot.h"

# define CHUNK		512
# define REQ		80

int readlinecnt;

char *
readline(FILE *fp)
{
	char *buf;
	size_t len, alloc;

	buf = 0;
	len = alloc = 0;
	readlinecnt = 0;
	for(;;) {
		if(alloc - len < REQ) {
			alloc += CHUNK;
			buf = xrealloc(buf, alloc);
		}
		if(fgets(&buf[len], alloc - len, fp) == NULL) {
			if(len == 0) {
				free(buf);
				return NULL;
			}
			return buf;
		}
		len = strlen(buf);
		if(buf[len - 1] == '\n') {
			readlinecnt++;
			if(len > 1 && buf[len - 2] == '\\') {
				len -= 2;
				buf[len] = '\0';
			} else
				break;
		}
	}

	return buf;
}

# ifdef TEST

int
main(int argc, char *argv[])
{
	char *line;

	while(putchar('>'), (line = readline(stdin)) != NULL) {
		printf("%d, %d: '%s'\n", readlinecnt, strlen(line), line);
		free(line);
	}
	if(ferror(stdin))
		printf("ERROR\n");
	if(feof(stdin))
		printf("EOF\n");
	return 0;
}

# endif
