/*-
 * Copyright (c)1997-2005 by Hartmut Brandt
 * 	All rights reserved.
 *
 * Author: Harti Brandt <harti@freebsd.org>
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Begemot: libbegemot/_common_err.c,v 1.8 2005/06/01 07:50:29 brandt_h Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include <stdarg.h>
# include <string.h>
# include <time.h>
# include <sys/time.h>
# include <unistd.h>
# include "begemot.h"
# include "private.h"


# define MODE	"BEGEMOT_ERR"

static int mode = -1;
static char *argv0;

void
set_errmode(int m)
{
	char *e;

	if((e = getenv(MODE)) != NULL)
		mode = strtol(e, NULL, 0);
	else
		mode = m;
	if(mode < 0)
		mode = -mode;
}

void
set_argv0(char *a)
{
	argv0 = a;
}

void
begemot_common_err(const char *prefix, const char *suffix, const char *fmt, va_list ap)
{
	char tbuf[100];

	if(mode == -1)
		set_errmode(0);
	if(mode) {
		if(mode > 1) {
			double secs;
# if defined(HAVE_GETHRTIME)
			secs = gethrtime() / 1000000000.0;
# elif defined(HAVE_CLOCK_GETTIME)
			struct timespec tp;

			clock_gettime(CLOCK_REALTIME, &tp);
			secs = tp.tv_sec + tp.tv_nsec / 1000000000.0;
# else
			struct timeval tv;

			gettimeofday(&tv, NULL);
			secs = tv.tv_sec + tv.tv_usec / 1000000.0;
# endif
			sprintf(tbuf, "%.3f", secs);
		} else {
			time_t clk;
			struct tm *tm;

			time(&clk);
			tm = localtime(&clk);
			strftime(tbuf, sizeof(tbuf), "%H:%M:%S", tm);
		}
		fprintf(stderr, "%s(%u)-%s%s%s: ",
			  (argv0 == NULL) ? ""
			: (mode == 1 && strrchr(argv0, '/') != NULL) ? (strrchr(argv0, '/') + 1)
			: argv0,
			(u_int)getpid(), tbuf, prefix ? "-" : "",
			prefix ? prefix : "");
	} else {
		fprintf(stderr, "%s: ", prefix);
	}
	vfprintf(stderr, fmt, ap);
	if(suffix)
		fprintf(stderr, suffix);
}
