#ifndef _text_h_
#define _text_h_

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Here's a struct for a piece of displayable text.  This is an obvious variant *
* of the conventional C "string" structure with a few extra fields.            *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define Text struct __Text__
Text {
	char* t;	/* The text string */
	int   l;	/* Length */
	int   m;	/* Allocated */
	int   p;	/* Position (pitch) code */
	float x;	/* X position relative to left staff edge */
	float y;	/* Y position relative to bottom staff line */
};

extern char* TextStr(Text*tp);
extern int   TextAppend(Text*tp,char*st);
extern int   TextInit(Text**tpp,int len);
extern void  zapText(Text*tp,char*dsc);


#endif
