# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Set the verbosity from various environment variables. The value may #
# be  a  verbose  level (1 digit), plus an optional output file name. #
# The file V is opened to the file, if any, or STDERR by default. The #
# default  value  for the verbosity level is 1, which generally means #
# to produce only serious error messages.                             #
#                                                                     #
# Here's how this routine is typically called:                        #
#    ($me = $0) =~ s'.*/'' unless defined($me);                       #
#    &Vopt($ENV{"V_$me"} || $ENV{"D_$me"} || $ENV{"T_$me"} || '1');   #
# You may not want to check for all of these, of course.              #
#                                                                     #
#AUTHOR:                                                              #
#  John Chambers <jc@trillian.mit.edu> http://trillian.mit.edu/~jc/   #
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #

sub Vopt {
	$Vopt = shift;
	print "<br>Vopt: Vopt=\"$Vopt\"<br>\n" if $D>1;
	if ($Vopt =~ /^(\d+)(.+)$/) {
		$V = $1;
		$Vfil = $2;
		if (!open(V,">>$Vfil")) {
			print V "Vopt: Can't write \"$Vfil\" ($!)\n" if $V>0;
			open(V,">>&STDERR");
		}
	} else {
		$V = $Vopt;
		open(V,">>&STDERR");
	}
	select V; $| = 1; select STDOUT; $| = 1;
	$esep = '=' x 70;
	$hsep = '-' x 70;
	print V "\nVopt $esep\n" if $V>1;
	print V "Vopt started with V=$V ", `date` if $V>1;
}

1;
