# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Here are some translation tables to produce HTML encoded chars:
%Huml = (
	'A' => '&Auml;', 'a' => '&auml;',
	'E' => '&Euml;', 'e' => '&euml;',
	'I' => '&Iuml;', 'i' => '&iuml;',
	'O' => '&Ouml;', 'o' => '&ouml;',
	'U' => '&Uuml;', 'u' => '&uuml;',
);
%Hacu = (
	'A' => '&Aacute;', 'a' => '&aacute;',
	'E' => '&Eacute;', 'e' => '&eacute;',
	'I' => '&Iacute;', 'i' => '&iacute;',
	'O' => '&Oacute;', 'o' => '&oacute;',
	'U' => '&Uacute;', 'u' => '&uacute;',
);
%Hgra = (
	'A' => '&Agrave;', 'a' => '&agrave;',
	'E' => '&Egrave;', 'e' => '&egrave;',
	'I' => '&Igrave;', 'i' => '&igrave;',
	'O' => '&Ograve;', 'o' => '&ograve;',
	'U' => '&Ugrave;', 'u' => '&ugrave;',
);
%Hcir = (
	'A' => '&Acirc;', 'a' => '&acirc;',
	'E' => '&Ecirc;', 'e' => '&ecirc;',
	'I' => '&Icirc;', 'i' => '&icirc;',
	'O' => '&Ocirc;', 'o' => '&ocirc;',
	'U' => '&Ucirc;', 'u' => '&ucirc;',
);
%Hrin = (
	'A' => '&Aring;', 'a' => '&aring;',
);
%Hsla = (
	'C' => '&Ccedil;', 'c' => '&ccedil;',
	'O' => '&Oslash;', 'o' => '&oslash;',
);

sub abc2html {
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Convert all the escape sequences in an ABC string to their HTML  encodings.
# This is only done to title strings at present.
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	local($s) = @_;
	$s =~ s#(\\)(["'`^])([aeiou])#&htmlenc($1,$2,$3)#ieg;	# Marked vowels.
	$s =~ s#(\\)([co])#&htmlenc($1,'/',$2)#ieg;		# C-cedille and o-slash.
	$s =~ s#(\\)(a)(a)#&htmlenc($1,$2,$3)#ieg;		# Scand \aa notation.
#	$s =~ s#([aeiou])/#&htmlenc('',"'",$1)#ieg;		# Gaelic V/ notation.
	return $s;
}

sub htmlenc {
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
# Convert one escape sequence to its corresponging HTML encoding. If we can't
# identify it, we return the original string.
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	local(
		$c1,	# Escape char, used only when we fail.
		$c2,	# The mark char, used to select a translate table.
		$c3)	# The char to mark, used to select a table entry..
		= @_;
	return($Huml{$c3} || "$c1$c2$c3") if ($c2 eq '"');
	return($Hacu{$c3} || "$c1$c2$c3") if ($c2 eq "'");
	return($Hgra{$c3} || "$c1$c2$c3") if ($c2 eq '`');
	return($Hcir{$c3} || "$c1$c2$c3") if ($c2 eq '^');
	return($Hrin{$c3} || "$c1$c2$c3") if ($c2 eq 'a' || $c2 eq 'A');
	return($Hsla{$c3} || "$c1$c2$c3") if ($c2 eq '/');
	return("$c1$c2$c3");
}

1;
